<?php
    class PenerimaanSetoranTunaiDBResponder extends DBResponder {
        public function command($command) {
            if (
                $command != "export_xls" && 
                $command != "export_pdf" && 
                $command != "print_jurnal" &&
                $command != "pending" &&
                $command != "accept"
            )
                return parent::command($command);
            if ($command == "export_pdf")
                return $this->exportPDF();
            else if ($command == "export_xls") {
                $this->exportXLS();
                return;
            } else if ($command == "print_jurnal")
                return $this->printJurnal();
            else if ($command == "pending")
                return $this->pending();
            else if ($command == "accept")
                return $this->accept();
        }

        private function exportXLS() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");

            require_once("smis-libs-out/php-excel/PHPExcel.php");

            $file = new PHPExcel();
            $file->getProperties()->setCreator("PT. Inovasi Ide Utama");
            $file->getProperties()->setTitle("Setoran Tunai Kasir");
            $file->getProperties()->setSubject("Setoran Tunai Kasir");
            $file->getProperties()->setDescription("Setoran Tunai Kasir - SIMRS");
            $file->getProperties()->setKeywords("Setoran Tunai Kasir");
            $file->getProperties()->setCategory("Setoran Tunai Kasir");

            $sheet = $file->getActiveSheet();
            $sheet->setTitle("Setoran Tunai Kasir");
            $i = 1;

            $sheet->mergeCells("A" . $i . ":E" . $i)->setCellValue("A" . $i, "SETORAN TUNAI KASIR");
            $sheet->getStyle("A" . $i . ":E" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Dari Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_dari));
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Sampai Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_sampai));
            $i = $i + 2;

            $border_start = $i;
            $col = "A";
            $head = array('No.', 'No. Jurnal', 'Tgl. Jurnal', 'Uraian', 'Nilai');
            foreach ($head as $h)
                $sheet->setCellValue($col++ . $i, $h);
            $sheet->getStyle("A" . $i . ":E" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i . ":E" . $i)->getFont()->setBold(true);
            $i = $i + 1;

            $data = $this->dbtable->get_result("
                SELECT
                    nomor, tanggal, keterangan uraian, nilai
                FROM
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    prop = ''
                        AND DATE(tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(tanggal) <= '" . $tanggal_sampai . "'
                ORDER BY
                    tanggal ASC, id ASC
            ");
            if (count($data) > 0) {
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $sheet->setCellValue("A" . $i, $nomor++);
                    $sheet->setCellValue("B" . $i, $d->nomor);
                    $sheet->setCellValue("C" . $i, ArrayAdapter::format("date d-m-Y", $d->tanggal));
                    $sheet->setCellValue("D" . $i, $d->uraian);
                    $sheet->setCellValue("E" . $i, $d->nilai);
                    $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $total += $d->nilai;
                    $i = $i + 1;
                }
                $sheet->mergeCells("A" . $i . ":D" . $i)->setCellValue("A" . $i, "Total");
                $sheet->getStyle("A" . $i . ":D" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $sheet->setCellValue("E" . $i, $total);
                $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                $sheet->getStyle("A" . $i . ":E" . $i)->getFont()->setBold(true);
            }

            $thin = array();
            $thin['borders'] = array();
            $thin['borders']['allborders'] = array();
            $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
            $sheet->getStyle("A" . $border_start . ":E" . $i)->applyFromArray($thin);

            foreach (range('A', 'E') as $columnID)
                $sheet->getColumnDimension($columnID)->setAutoSize(true);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Setoran Tunai Kasir.xls"');
            header('Cache-Control: max-age=0');
            $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
            $writer->save('php://output');
            return;
        } 
        
        private function exportPDF() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            require_once("finance/class/template/pdf.php");
			$fpdf = new PDF("L", "mm", "A4");
			$fpdf->SetMargins(5, 5);
		
            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "SETORAN TUNAI KASIR", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(25, 5, "Dari Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_dari), 0, 1);
            $fpdf->Cell(25, 5, "Sampai Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_sampai), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(15, 5, "No.", 1, 0, "C");
            $fpdf->Cell(40, 5, "No. Jurnal", 1, 0, "C");
            $fpdf->Cell(25, 5, "Tgl. Jurnal", 1, 0, "C");
            $fpdf->Cell(165, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Nilai", 1, 1, "C");
            $data = $this->dbtable->get_result("
                SELECT
                    nomor, tanggal, keterangan uraian, nilai
                FROM
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    prop = ''
                        AND DATE(tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(tanggal) <= '" . $tanggal_sampai . "'
                ORDER BY
                    tanggal ASC, id ASC
            ");
            if (count($data) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $fpdf->Cell(15, 5, $nomor++, 1, 0);
                    $fpdf->Cell(40, 5, $d->nomor, 1, 0);
                    $fpdf->Cell(25, 5, ArrayAdapter::format("date d-m-Y", $d->tanggal), 1, 0);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(165, 5, $d->uraian, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(245, 5, "", 0, 0, "");
                    $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $d->nilai), 1, 1, "R");
                    $total += $d->nilai;
                }
                $fpdf->SetFont("Arial", "B", 9);
                $fpdf->Cell(245, 5, "Total", 1, 0, "R");
                $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $total), 1, 1, "R");
            }

			global $user;
		    $md5 = md5(date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "setoran_tunai_kasir.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        } 
        
        private function printJurnal() {
            $id = $_POST['id'];
            $header_jurnal = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    id = '" . $id . "'
            ");

            require_once("finance/class/template/pdf.php");
            $fpdf = new PDF("L", "mm", "A4");
            $fpdf->SetMargins(5, 5);

            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "JURNAL SETORAN TUNAI KASIR", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Nomor", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->nomor, 0, 1);
            $fpdf->Cell(25, 5, "Tanggal", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1);

            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(100, 5, "No. - Nama Akun", 1, 0, "C");
            $fpdf->Cell(105, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Debit", 1, 0, "C");
            $fpdf->Cell(40, 5, "Kredit", 1, 1, "C");

            $fpdf->SetFont("Arial", "", 9);
            $f_debet = $header_jurnal->nilai == 0 ? "0,00" : ArrayAdapter::format("only-money", $header_jurnal->nilai);
            $f_kredit = "0,00";
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->MultiCell(100, 5, $header_jurnal->tujuan_nomor_akun . " - " . $header_jurnal->tujuan_nama_akun, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->Cell(100, 5, "", 0, 0, "");
            $fpdf->MultiCell(105, 5, $header_jurnal->keterangan, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $fpdf->Cell(205, 5, "", 0, 0, "");
            $fpdf->Cell(40, 5, $f_debet, 1, 0, "R");
            $fpdf->Cell(40, 5, $f_kredit, 1, 1, "R");

            $f_debet = "0,00";
            $f_kredit = $header_jurnal->nilai == 0 ? "0,00" : ArrayAdapter::format("only-money", $header_jurnal->nilai);
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->MultiCell(100, 5, $header_jurnal->asal_nomor_akun . " - " . $header_jurnal->asal_nama_akun, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->Cell(100, 5, "", 0, 0, "");
            $fpdf->MultiCell(105, 5, $header_jurnal->keterangan, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $fpdf->Cell(205, 5, "", 0, 0, "");
            $fpdf->Cell(40, 5, $f_debet, 1, 0, "R");
            $fpdf->Cell(40, 5, $f_kredit, 1, 1, "R");

            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Deintrikan oleh", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->operator, 0, 1);
            $fpdf->Cell(25, 5, "Dientrikan pada", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal_entri), 0, 1);

            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(90, 5, "Disiapkan Oleh", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "Direvisi Oleh", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "Disetujui Oleh", 0, 1, "C");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(90, 5, "_______________", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "_______________", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "_______________", 0, 1, "C");

            global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "jurnal_setoran_tunai_kasir.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        }

        private function pending() {
            $id = $_POST['id'];
            $status = 3;
            return $this->updateStatus($id, $status);
        }

        private function accept() {
            $id = $_POST['id'];
            $status = 2;
            
            require_once("accounting/function/new_transaksi_harian.php");
            $nomor = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "JST");
            $this->dbtable->query("
                UPDATE
                    smis_fnc_setoran_tunai_kasir
                SET
                    nomor = '" . $nomor . "'
                WHERE
                    id = '" . $id . "'
            ");

            $this->postJournal($id);
            return $this->updateStatus($id, $status);
        }

        private function postJournal($id_transaksi) {
            $transaksi = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    id = '" . $id_transaksi . "'
            ");

            $j_jurnal = "Setoran Tunai";
            global $user;
            $operator = $user->getNameOnly();
            $tanggal_input = date("Y-m-d H:i:s");
            $tanggal = ArrayAdapter::format("date Y-m-d", $transaksi->tanggal);
            $nomor = $transaksi->nomor;
            $keterangan = $transaksi->keterangan;
            $nilai = $transaksi->nilai;

            $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
            $jurnal_data = array(
                'j_jurnal'      => $j_jurnal,
                'operator'      => $operator,
                'tanggal_input' => $tanggal_input,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor,
                'keterangan'    => $keterangan,
                'nilai'         => $nilai
            );
            $jurnal_dbtable->insert($jurnal_data);
            $id_jurnal = $jurnal_dbtable->get_inserted_id();

            $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");

            $id_akun = 0;
            $id_tipeakun = 0;
            $nama_tipeakun = "";
            $coa_row = $this->dbtable->get_row("
                SELECT
                    id id_akun,
                    tipe id_tipeakun,
                    nama_tipe nama_tipeakun
                FROM
                    smis_ac_account
                WHERE
                    nomor LIKE '" . $transaksi->tujuan_nomor_akun . "'
                        AND prop = ''
                ORDER BY
                    id DESC
                LIMIT 
                    0, 1
            ");
            if ($coa_row != null) {
                $id_akun = $coa_row->id_akun;
                $id_tipeakun = $coa_row->id_tipeakun;
                $nama_tipeakun = $coa_row->nama_tipeakun;
            }
            $detail_jurnal_data = array(
                'id_transaksi'  => $id_jurnal,
                'nomor_account' => $transaksi->tujuan_nomor_akun,
                'nama_account'  => $transaksi->tujuan_nama_akun,
                'keterangan'    => $keterangan,
                'debet'         => $nilai,
                'kredit'        => 0,
                'id_akun'       => $id_akun,
                'nomor'         => $nomor,
                'id_tipeakun'   => $id_tipeakun,
                'nama_tipeakun' => $nama_tipeakun,
                'tanggal'       => $tanggal,
                'j_jurnal'      => $j_jurnal
            );
            $detail_jurnal_dbtable->insert($detail_jurnal_data);

            $id_akun = 0;
            $id_tipeakun = 0;
            $nama_tipeakun = "";
            $coa_row = $this->dbtable->get_row("
                SELECT
                    id id_akun,
                    tipe id_tipeakun,
                    nama_tipe nama_tipeakun
                FROM
                    smis_ac_account
                WHERE
                    nomor LIKE '" . $transaksi->asal_nomor_akun . "'
                        AND prop = ''
                ORDER BY
                    id DESC
                LIMIT 
                    0, 1
            ");
            if ($coa_row != null) {
                $id_akun = $coa_row->id_akun;
                $id_tipeakun = $coa_row->id_tipeakun;
                $nama_tipeakun = $coa_row->nama_tipeakun;
            }
            $detail_jurnal_data = array(
                'id_transaksi'  => $id_jurnal,
                'nomor_account' => $transaksi->asal_nomor_akun,
                'nama_account'  => $transaksi->asal_nama_akun,
                'keterangan'    => $keterangan,
                'debet'         => 0,
                'kredit'        => $nilai,
                'id_akun'       => $id_akun,
                'nomor'         => $nomor,
                'id_tipeakun'   => $id_tipeakun,
                'nama_tipeakun' => $nama_tipeakun,
                'tanggal'       => $tanggal,
                'j_jurnal'      => $j_jurnal
            );
            $detail_jurnal_dbtable->insert($detail_jurnal_data);
        }

        private function updateStatus($id, $status) {
            $identifier['id'] = $id;
            $jurnal_data['status'] = $status;

            $result = $this->dbtable->update($jurnal_data, $identifier);

            $data = array(
                'result' => $result,
                'id'     => $id
            );
            return $data;
        }

        public function edit() {
            $id = $_POST['id'];
            $data = $this->dbtable->get_row("
                SELECT 
                    *
                FROM 
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    id = '" . $id . "'
            ");
            if ($data != null) {
                $data->tanggal = ArrayAdapter::format("date d-m-Y H:i", $data->tanggal);
                $data->tanggal_entri = ArrayAdapter::format("date d-m-Y H:i", $data->tanggal_entri);
            }
            return $data;
        }
    }
?>