<?php
class LapTindDokterResponder extends ServiceResponder{
    
    private $reset_key = array();
    private $excel_column = array();
    private $sum_col = array();
    private $col_total = "A";
    
    private $title = "";
    private $fname = "";

    public function command($command){
		$pack=new ResponsePackage();
		$content=NULL;
		$status='not-command';	//not-authorized, not-command, fail, success
		$alert=array();
	
		if($command=="list"){
			$content=$this->view();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=='save'){
			$content=$this->save();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			$pack->setAlertVisible(true);
			$pack->setAlertContent("Data Saved", "Your Data Had Been Saved", ResponsePackage::$TIPE_INFO);
		}else if($command=="del"){
			$content=$this->delete();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			$pack->setAlertVisible(true);
			$pack->setAlertContent("Data Removed", "Your Data Had Been Removed", ResponsePackage::$TIPE_INFO);
		}else if($command=="edit"){
			$content=$this->edit();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=="select"){
			$content=$this->select();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=="print-element"){
			$content=$this->printing("print-element");
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=="printing"){
			$content=$this->printing();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=="excel"){
			$this->excel();
			return NULL;
		}
		return $pack->getPackage();
	}

    public function setSummary($tname,$col){
        $this->col_total = $tname;
        $this->sum_col = $col;
        return $this;
    }

    public function setTitle($t){
        $this->title = $t;
        return $t;
    }

    public function setFileName($nm){
        $this->fname = $nm;
        return $this;
    }

    public function addResetMoney($column,$name,$dbname){
        $this->reset_key[$column] = array("name"=>$name,"key"=>$dbname);
        return $this;
    }

    public function addColumn($col,$name){
        $this->excel_column[$col]=$name;
        return $this;
    }

    public function view(){   
        global $db;
        $datapost = $this->getData();
        unset($datapost['dari']);
        unset($datapost['sampai']);
        $proto = array();
        if($_POST['ruangan']==""){
            $proto = getAllActivePrototypeOf($db,"rawat");
        }else{
            $proto[$_POST['ruangan']] = $_POST['ruangan'];
        }



        $query = "SELECT id,uri,carabayar FROM smis_rg_layananpasien WHERE 1 ";
        if($_POST['asuransi']!=""){
            $query .= " AND smis_rg_layananpasien.asuransi = '".$_POST['asuransi']."' ";
        }
        if($_POST['perusahaan']!=""){
            $query .= " AND smis_rg_layananpasien.nama_perusahaan = '".$_POST['perusahaan']."' ";
        }
        if($_POST['carabayar']!=""){
            $query .= " AND smis_rg_layananpasien.carabayar = '".$_POST['carabayar']."' ";
        }
        if($_POST['uri']!=""){
            $query .= " AND smis_rg_layananpasien.uri = '".$_POST['uri']."' ";
        }
        if($_POST['status']!=""){
            $query .= " AND smis_rg_layananpasien.selesai = '".$_POST['status']."' ";
        }
        if($_POST['nama_pasien']!=""){
            $query .= " AND smis_rg_layananpasien.nama_pasien = '".$_POST['nama_pasien']."' ";
        }
        if($_POST['nrm_pasien']!=""){
            $query .= " AND smis_rg_layananpasien.nrm = '".$_POST['nrm_pasien']."' ";
        }

        $keluarmasuk  = $_POST['keluar_masuk']=="Tanggal Masuk"?"tanggal":"tanggal_pulang";

        if($_POST['dari']!=""){
            $query .= " AND DATE(smis_rg_layananpasien.".$keluarmasuk.") >= '".$_POST['dari']."' ";
        }

        if($_POST['sampai']!=""){
            $query .= " AND DATE(smis_rg_layananpasien.".$keluarmasuk.") <= '".$_POST['sampai']."' ";
        }

        $query .= " AND smis_rg_layananpasien.carapulang != 'Tidak Datang' ";

        global $db;
        global $querylog;
        $querylog->addMessage($query);

    

        $pasien = $db->get_result($query);
        $noreg = array();
        $carabayar = array();

        $listnoreg = array();
        foreach($pasien as $p){
            $noreg[$p->id] = $p->uri;
            $carabayar[$p->id] = $p->carabayar;
            $listnoreg[] = $p->id;
        }
        $noregin = implode(",",$listnoreg);

        $filtereddata = array();
        foreach($proto as $p=>$ruangan){
            $qtinddokter = "SELECT * FROM smis_rwt_tindakan_dokter_".$p." WHERE prop!='del' ";
            $qkonsuldokter = "SELECT id,prop,nama_pasien,noreg_pasien,nrm_pasien,nama_konsul as nama_tindakan, carabayar, harga as total, nama_dokter, waktu, jasa_dokter_nilai as operator_nilai FROM smis_rwt_konsul_dokter_".$p." WHERE prop!='del' ";
            $operatorok = "SELECT id,prop,nama_pasien,noreg_pasien,nrm_pasien, concat(nama_tindakan,' - Dokter Operator') as nama_tindakan, carabayar, harga_tindakan as total, nama_operator_satu as nama_dokter, waktu, harga_operator_satu  as operator_nilai FROM smis_rwt_ok_".$p." WHERE prop!='del' ";
            $anastesiok = "SELECT id,prop,nama_pasien,noreg_pasien,nrm_pasien,  concat(nama_tindakan,' - Dokter Anastesi') as nama_tindakan, carabayar, harga_tindakan as total, nama_anastesi  as nama_dokter, waktu, harga_anastesi  as operator_nilai FROM smis_rwt_ok_".$p." WHERE prop!='del' ";
            
            
            if($_POST['nama_pasien']!=""){
                $qtinddokter .= " AND nama_pasien = '".$_POST['nama_pasien']."' ";
                $qkonsuldokter .= " AND nama_pasien = '".$_POST['nama_pasien']."' ";
                $operatorok .= " AND nama_pasien = '".$_POST['nama_pasien']."' ";
                $anastesiok .= " AND nama_pasien = '".$_POST['nama_pasien']."' ";
            }
            if($_POST['nrm_pasien']!=""){
                $qtinddokter .= " AND nrm_pasien = '".$_POST['nrm_pasien']."' ";
                $qkonsuldokter .= " AND nrm_pasien = '".$_POST['nrm_pasien']."' ";
                $operatorok .= " AND nrm_pasien = '".$_POST['nrm_pasien']."' ";
                $anastesiok .= " AND nrm_pasien = '".$_POST['nrm_pasien']."' ";
            }

            if($_POST['dokter']!=""){
                $qtinddokter .= " AND id_dokter = '".$_POST['id_dokter']."' ";
                $qkonsuldokter .= " AND id_dokter = '".$_POST['id_dokter']."' ";
                $operatorok .= " AND id_operator_satu = '".$_POST['id_dokter']."' ";
                $anastesiok .= " AND id_anastesi = '".$_POST['id_dokter']."' ";
            }

            $qtinddokter .= " AND noreg_pasien IN (".$noregin.") ";
            $onruangan = $db->get_result($qtinddokter,false);
            foreach($onruangan as $o){
                if(isset($noreg[$o['noreg_pasien']])){
                    $o['uri'] = $noreg[$o['noreg_pasien']];
                    $o['carabayar'] = $carabayar[$o['noreg_pasien']];
                    $o['ruangan'] = $ruangan;
                    $filtereddata[] = $o;
                }
            }

            $qkonsuldokter .= " AND noreg_pasien IN (".$noregin.") ";
            $onruangan = $db->get_result($qkonsuldokter,false);
            foreach($onruangan as $o){
                if(isset($noreg[$o['noreg_pasien']])){
                    $o['uri'] = $noreg[$o['noreg_pasien']];
                    $o['carabayar'] = $carabayar[$o['noreg_pasien']];
                    $o['ruangan'] = $ruangan;
                    $filtereddata[] = $o;
                }
            }

            $operatorok .= " AND noreg_pasien IN (".$noregin.") ";
            $onruangan = $db->get_result($operatorok,false);
            foreach($onruangan as $o){
                if(isset($noreg[$o['noreg_pasien']])){
                    $o['uri'] = $noreg[$o['noreg_pasien']];
                    $o['carabayar'] = $carabayar[$o['noreg_pasien']];
                    $o['ruangan'] = $ruangan;
                    $filtereddata[] = $o;
                }
            }

            $anastesiok .= " AND noreg_pasien IN (".$noregin.") ";
            $onruangan = $db->get_result($anastesiok,false);
            foreach($onruangan as $o){
                if(isset($noreg[$o['noreg_pasien']])){
                    $o['uri'] = $noreg[$o['noreg_pasien']];
                    $o['carabayar'] = $carabayar[$o['noreg_pasien']];
                    $o['ruangan'] = $ruangan;
                    $filtereddata[] = $o;
                }
            }
            
           
        }	


		$uidata=$this->getAdapter()->getContent($filtereddata);
		$this->getUITable()->setContent($uidata);
		$list=$this->getUITable()->getBodyContent();
		//$pagination=$this->getUITable()->getPagination($page,5,$max_page);
	
		$json['list']=$list;
		$json['pagination']="";
		$json['number']=1;
		$json['data']=$filtereddata;
		$json['number_p']=isset($_POST['number'])?$_POST['number']:"0";
		return $json;
	}


    public function excel(){
		global $user;
		loadLibrary("smis-libs-function-export");
        $dlist = $this->view("","");    
        $result = $dlist['data'];
        $this->getAdapter()->setNumber(0);
        $adapter = $this->getAdapter();
        foreach($this->reset_key as $x){
            $adapter ->add($x['name'],$x['key']);
        }
      
        $uidata = $this->getAdapter()->getContent($result);

        require_once "smis-libs-out/php-excel/PHPExcel.php";
		$file = new PHPExcel ();
		
		$fillcabang=array();
		$fillcabang['borders']=array();
		$fillcabang['borders']['allborders']=array();
		$fillcabang['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
		
		$file->setActiveSheetIndex ( 0 );
		$sheet = $file->getActiveSheet ( 0 );
        $sheet->setTitle ($this->title);
        $last_column = PHPExcel_Cell::stringFromColumnIndex(count($this->excel_column) - 1);

        $sheet->mergeCells("A1:".$last_column."1")->setCellValue ( "A" . 1, $this->title." - ".ArrayAdapter::format("date d M Y",$_POST['dari'])." - ".ArrayAdapter::format("date d M Y",$_POST['sampai']));
        $sheet->setCellValue ( "A2","Keluar/ Masuk");
        $sheet->setCellValue ( "B2",":");
        $sheet->setCellValue ( "C2",$_POST['keluar_masuk']);
        $sheet->setCellValue ( "D2","Dari");
        $sheet->setCellValue ( "E2",":");
        $sheet->setCellValue ( "F2",ArrayAdapter::format("date d M Y",$_POST['dari']));
        $sheet->setCellValue ( "G2","Sampai");
        $sheet->setCellValue ( "H2",":");
        $sheet->setCellValue ( "I2",ArrayAdapter::format("date d M Y",$_POST['sampai']));
        $sheet->setCellValue ( "J2","Cara Bayar");
        $sheet->setCellValue ( "K2",":");
        $sheet->setCellValue ( "L2",ArrayAdapter::format("unslug",$_POST['carabayar']));

        $sheet->setCellValue ( "A3","Asuransi");
        $sheet->setCellValue ( "B3",":");
        $sheet->setCellValue ( "C3",$_POST['nama_asuransi']);
        $sheet->setCellValue ( "D3","Perusahaan");
        $sheet->setCellValue ( "E3",":");
        $sheet->setCellValue ( "F3",$_POST['perusahaan']);
        $sheet->setCellValue ( "G3","Jenis");
        $sheet->setCellValue ( "H3",":");
        $sheet->setCellValue ( "I3",$_POST['jenis']);
        $sheet->setCellValue ( "J3","Ruangan");
        $sheet->setCellValue ( "K3",":");
        $sheet->setCellValue ( "L3",$_POST['nama_ruangan']);

        $sheet->setCellValue ( "A4","Status");
        $sheet->setCellValue ( "B4",":");
        $sheet->setCellValue ( "C4",$_POST['nama_status']);
        $sheet->setCellValue ( "D4","Dokter");
        $sheet->setCellValue ( "E4",":");
        $sheet->setCellValue ( "F4",$_POST['dokter']);
        $sheet->setCellValue ( "G4","Nama Pasien");
        $sheet->setCellValue ( "H4",":");
        $sheet->setCellValue ( "I4",$_POST['nama_pasien']);
        $sheet->setCellValue ( "J4","No. RM");
        $sheet->setCellValue ( "K4",":");
        $sheet->setCellValue ( "L4"," '".$_POST['nrm_pasien']);

        foreach($this->excel_column as $col=>$name){
            $sheet->setCellValue ( $col."6", $name);        
        }
        
        $index=6;
		$no=0;
        $sheet->getStyle ( "A1:".$last_column."1")->getFont ()->setBold ( true );
        $sheet->getStyle ( "A6:".$last_column."6")->getFont ()->setBold ( true );
        
        $sheet->getStyle ( "A2:A4")->getFont ()->setBold ( true );
        $sheet->getStyle ( "D2:D4")->getFont ()->setBold ( true );
        $sheet->getStyle ( "G2:G4")->getFont ()->setBold ( true );
        $sheet->getStyle ( "J2:J4")->getFont ()->setBold ( true );

		foreach($uidata as $x){
			$no++;
            $index++;
            
            foreach($this->excel_column as $col=>$name){
                $sheet->setCellValue ( $col.$index, $x[$name]);
            }
        }
        //$index++;
        $sheet->setCellValue ( $this->col_total . $index, "Total" );
        foreach($this->sum_col as $colx){
            $sheet->setCellValue ( $colx . $index, "=sum(".$colx."6:".$colx.($index-1).")" );
        }
        $sheet->getStyle ( 'A6:'.$last_column.$index )->applyFromArray ( $fillcabang );
        $sheet->getStyle ( "A".$index.":L".$index)->getFont ()->setBold ( true );
        foreach($this->reset_key as $col=>$x){
            $sheet->getStyle($col.'6:'.$col.$index)->getNumberFormat()->setFormatCode('#,##0.00');
        }

        foreach(range('A','L') as $columnID) {
            $sheet->getColumnDimension($columnID)
                ->setAutoSize(true);
        }

		header ( 'Content-Type: application/vnd.ms-excel' );
		header ( 'Content-Disposition: attachment;filename="'.$this->fname.'.xls"' );
		header ( 'Cache-Control: max-age=0' );
		$writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
		$writer->save ( 'php://output' );

		return;
	}
}