<?php
    class KBUangMukaFakturDBResponder extends DBResponder {
        public function save() {
            $result = true;
            $id = $_POST['id'];

            $uang_muka_dbtable = new DBTable($this->dbtable->get_db(), "smis_fnc_uang_muka");

            if ($id == "") {
                /// Insert Uang Muka Faktur :
                $this->dbtable->insert([
                    'id_uang_muka' => $_POST['id_uang_muka'],
                    'id_opl' => $_POST['id_opl'],
                    'unit' => $_POST['id_opl'],
                    'nomor_opl' => $_POST['nomor_opl'],
                    'uraian' => $_POST['uraian'],
                    'nomor_jurnal' => $_POST['nomor_jurnal'],
                    'tanggal_jurnal' => $_POST['tanggal_jurnal'],
                    'pic' => $_POST['pic'],
                    'nilai' => $_POST['nilai'],
                    'id_faktur' => $_POST['id_faktur'],
                    'asal_faktur' => $_POST['asal_faktur']
                ]);
                $id = $this->dbtable->get_inserted_id();

                $this->postJournal($id, $_POST['asal_faktur']);
                
                /// Update Uang Muka's diakui :
                $uang_muka_dbtable->update([
                    'diakui' => 1
                ], [
                    'id' => $_POST['id_uang_muka']
                ]);
            } else {
                $this->revertJournal($id, $_POST['asal_faktur']);

                /// Update Uang Muka Faktur :
                $this->dbtable->update([
                    'id_uang_muka' => $_POST['id_uang_muka'],
                    'id_opl' => $_POST['id_opl'],
                    'unit' => $_POST['id_opl'],
                    'nomor_opl' => $_POST['nomor_opl'],
                    'uraian' => $_POST['uraian'],
                    'nomor_jurnal' => $_POST['nomor_jurnal'],
                    'tanggal_jurnal' => $_POST['tanggal_jurnal'],
                    'pic' => $_POST['pic'],
                    'nilai' => $_POST['nilai'],
                    'id_faktur' => $_POST['id_faktur'],
                    'asal_faktur' => $_POST['asal_faktur']
                ], [
                    'id' => $id
                ]);

                $this->postJournal($id, $_POST['asal_faktur']);
            }

            $sisa_tagihan = $this->updateInvoice($_POST['id_faktur'], $_POST['asal_faktur']);
            $sisa_tagihan = $sisa_tagihan == 0 ? "0,00" : ArrayAdapter::format("only-money", $sisa_tagihan);

            return [
                'result'        => $result,
                'id'            => $id,
                'sisa_tagihan'  => $sisa_tagihan,
                'success'       => "1"
            ];
        }

        private function updateInvoice($id_faktur, $asal_faktur) {
            $total_bayar = $this->dbtable->get_var("
                SELECT
                    SUM(nilai) nilai
                FROM
                    smis_fnc_bayar
                WHERE
                    prop = ''
                        AND id_faktur = '" . $id_faktur . "'
                        AND asal_faktur = '" . $asal_faktur . "'
            ");
            if ($total_bayar == null || $total_bayar == "") {
                $total_bayar = 0;
            }
            $total_uang_muka = $this->dbtable->get_var("
                SELECT
                    SUM(nilai) nilai
                FROM
                    smis_fnc_uang_muka_faktur
                WHERE
                    prop = ''
                        AND id_faktur = '" . $id_faktur . "'
                        AND asal_faktur = '" . $asal_faktur . "'
            ");
            if ($total_uang_muka == null || $total_uang_muka == "") {
                $total_uang_muka = 0;
            }
            $total_dibayar = $total_bayar + $total_uang_muka;
            $sisa_tagihan = 0;
            if ($asal_faktur == "gudang_farmasi") {
                $faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_masuk");
                $faktur_dbtable->update([
                    'total_dibayar' => $total_dibayar
                ], [
                    'id' => $id_faktur
                ]);
                $data = $this->dbtable->get_row("
                    SELECT
                        total_tagihan
                    FROM
                        smis_fr_obat_masuk
                    WHERE
                        id = '" . $id_faktur . "'
                ");
                $sisa_tagihan = $data->total_tagihan - $total_dibayar;
            } else if ($asal_faktur == "gudang_umum") {
                $faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_gu_barang_masuk");
                $faktur_dbtable->update([
                    'total_dibayar' => $total_dibayar
                ], [
                    'id' => $id_faktur
                ]);
                $data = $this->dbtable->get_row("
                    SELECT
                        total_tagihan
                    FROM
                        smis_gu_barang_masuk
                    WHERE
                        id = '" . $id_faktur . "'
                ");
                $sisa_tagihan = $data->total_tagihan - $total_dibayar;
            }
            return $sisa_tagihan;
        }

        private function postJournal($id, $asal_faktur) {
            if ($id == 0 || $id == "") {
                return;
            }

            $uang_muka_faktur = $this->dbtable->select($id);
            $nomor_akun_hutang_vendor = "";
            $nama_akun_hutang_vendor = "";
            $id_akun_hutang_vendor = 0;
            $id_tipeakun_hutang_vendor = 0;
            $nama_tipe_akun_hutang_vendor = "";
            require_once("accounting/function/get_akun_pendapatan.php");
            if ($uang_muka_faktur != null) {
                $nomor_faktur = "";
                $nomor_um = $uang_muka_faktur->nomor_jurnal;
                if ($asal_faktur == "gudang_farmasi") {
                    $nomor_faktur = $this->dbtable->get_var("
                        SELECT
                            no_faktur
                        FROM
                            smis_fr_obat_masuk
                        WHERE
                            id = '" . $uang_muka_faktur->id_faktur . "'
                    ");
                    $nomor_akun_hutang_vendor = get_akun_pendapatan($this->dbtable->get_db(), "akun-hutang-vendor-medis-nonaccruel");
                } else if ($asal_faktur == "gudang_umum") {
                    $nomor_faktur = $this->dbtable->get_var("
                        SELECT
                            no_faktur
                        FROM
                            smis_gu_barang_masuk
                        WHERE
                            id = '" . $uang_muka_faktur->id_faktur . "'
                    ");
                    $nomor_akun_hutang_vendor = get_akun_pendapatan($this->dbtable->get_db(), "akun-hutang-vendor-nonmedis-nonaccruel");
                }
                $akun_row = $this->dbtable->get_row("
                    SELECT
                        id, nama, tipe, nama_tipe
                    FROM 
                        smis_ac_account
                    WHERE
                        nomor = '" . $nomor_akun_hutang_vendor . "'
                    ORDER BY
                        prop ASC,
                            id ASC
                    LIMIT 
                        0, 1
                ");
                if ($akun_row != null) {
                    $nama_akun_hutang_vendor = $akun_row->nama;
                    $id_akun_hutang_vendor = $akun_row->id;
                    $id_tipeakun_hutang_vendor = $akun_row->tipe;
                    $nama_tipe_akun_hutang_vendor = $akun_row->nama_tipe;
                }

                $j_jurnal = "Match UM";
                global $user;
                $operator = $user->getNameOnly();
                $tanggal_input = date("Y-m-d H:i:s");
                $tanggal = date("Y-m-d H:i:s");
                require_once("accounting/function/new_transaksi_harian.php");
                $nomor = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "MUM");
                $keterangan = "Utang Usaha Atas Uang Muka yang Telah Dibayarkan - " . $nomor_faktur . " - " . $nomor_um . " - Create";
                $nilai = $uang_muka_faktur->nilai;
                $jurnal_data = array(
                    'j_jurnal'      => $j_jurnal,
                    'operator'      => $operator,
                    'tanggal_input' => $tanggal_input,
                    'tanggal'       => $tanggal,
                    'nomor'         => $nomor,
                    'keterangan'    => $keterangan,
                    'nilai'         => $nilai
                );
                $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
                $jurnal_dbtable->insert($jurnal_data);
                $id_header = $jurnal_dbtable->get_inserted_id();

                $id_uang_muka = $uang_muka_faktur->id_uang_muka;
                $id_transaksi = $this->dbtable->get_var("
                    SELECT
                        id_transaksi
                    FROM
                        smis_fnc_uang_muka
                    WHERE
                        id = '" . $id_uang_muka . "'
                ");
                $detail = $this->dbtable->get_result("
                    SELECT
                        *
                    FROM
                        smis_ac_transaksi_detail
                    WHERE
                        prop = ''
                            AND id_transaksi = '" . $id_transaksi . "'
                    ORDER BY
                        id DESC
                ");
                if ($detail != null) {
                    $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
                    foreach ($detail as $d) {
                        $detail_jurnal_data = array();
                        if ($d->debet > $d->kredit) {
                            $detail_jurnal_data = array(
                                'id_transaksi'  => $id_header,
                                'nomor_account' => $d->nomor_account,
                                'nama_account'  => $d->nama_account,
                                'keterangan'    => $keterangan,
                                'debet'         => 0,
                                'kredit'        => $nilai,
                                'id_akun'       => $d->id_akun,
                                'nomor'         => $nomor,
                                'id_tipeakun'   => $d->id_tipeakun,
                                'nama_tipeakun' => $d->nama_tipeakun,
                                'tanggal'       => $tanggal,
                                'j_jurnal'      => $j_jurnal
                            );
                        } else {
                            $detail_jurnal_data = array(
                                'id_transaksi'  => $id_header,
                                'nomor_account' => $nomor_akun_hutang_vendor,
                                'nama_account'  => $nama_akun_hutang_vendor,
                                'keterangan'    => $keterangan,
                                'debet'         => $nilai,
                                'kredit'        => 0,
                                'id_akun'       => $id_akun_hutang_vendor,
                                'nomor'         => $nomor,
                                'id_tipeakun'   => $id_tipeakun_hutang_vendor,
                                'nama_tipeakun' => $nama_tipe_akun_hutang_vendor,
                                'tanggal'       => $tanggal,
                                'j_jurnal'      => $j_jurnal
                            );
                            
                        }
                        $detail_jurnal_dbtable->insert($detail_jurnal_data);
                    }
                }
            }
        }

        private function revertJournal($id, $asal_faktur) {
            if ($id == 0 || $id == "") {
                return;
            }
            
            $uang_muka_faktur = $this->dbtable->select($id);
            $nomor_akun_hutang_vendor = "";
            $nama_akun_hutang_vendor = "";
            $id_akun_hutang_vendor = 0;
            $id_tipeakun_hutang_vendor = 0;
            $nama_tipe_akun_hutang_vendor = "";
            require_once("accounting/function/get_akun_pendapatan.php");
            if ($uang_muka_faktur != null) {
                $nomor_faktur = "";
                $nomor_um = $uang_muka_faktur->nomor_jurnal;
                if ($asal_faktur == "gudang_farmasi") {
                    $nomor_faktur = $this->dbtable->get_var("
                        SELECT
                            no_faktur
                        FROM
                            smis_fr_obat_masuk
                        WHERE
                            id = '" . $uang_muka_faktur->id_faktur . "'
                    ");
                    $nomor_akun_hutang_vendor = get_akun_pendapatan($this->dbtable->get_db(), "akun-hutang-vendor-medis-nonaccruel");
                } else if ($asal_faktur == "gudang_umum") {
                    $nomor_faktur = $this->dbtable->get_var("
                        SELECT
                            no_faktur
                        FROM
                            smis_gu_barang_masuk
                        WHERE
                            id = '" . $uang_muka_faktur->id_faktur . "'
                    ");
                    $nomor_akun_hutang_vendor = get_akun_pendapatan($this->dbtable->get_db(), "akun-hutang-vendor-nonmedis-nonaccruel");
                }
                $akun_row = $this->dbtable->get_row("
                    SELECT
                        id, nama, tipe, nama_tipe
                    FROM 
                        smis_ac_account
                    WHERE
                        nomor = '" . $nomor_akun_hutang_vendor . "'
                    ORDER BY
                        prop ASC,
                            id ASC
                    LIMIT 
                        0, 1
                ");
                if ($akun_row != null) {
                    $nama_akun_hutang_vendor = $akun_row->nama;
                    $id_akun_hutang_vendor = $akun_row->id;
                    $id_tipeakun_hutang_vendor = $akun_row->tipe;
                    $nama_tipe_akun_hutang_vendor = $akun_row->nama_tipe;
                }

                $j_jurnal = "Match UM";
                global $user;
                $operator = $user->getNameOnly();
                $tanggal_input = date("Y-m-d H:i:s");
                $tanggal = date("Y-m-d H:i:s");
                require_once("accounting/function/new_transaksi_harian.php");
                $nomor = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "MUM");
                $keterangan = "Utang Usaha Atas Uang Muka yang Telah Dibayarkan - " . $nomor_faktur . " - " . $nomor_um . " - Batal";
                $nilai = $uang_muka_faktur->nilai;
                $jurnal_data = array(
                    'j_jurnal'      => $j_jurnal,
                    'operator'      => $operator,
                    'tanggal_input' => $tanggal_input,
                    'tanggal'       => $tanggal,
                    'nomor'         => $nomor,
                    'keterangan'    => $keterangan,
                    'nilai'         => $nilai * (-1)
                );
                $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
                $jurnal_dbtable->insert($jurnal_data);
                $id_header = $jurnal_dbtable->get_inserted_id();

                $id_uang_muka = $uang_muka_faktur->id_uang_muka;
                $id_transaksi = $this->dbtable->get_var("
                    SELECT
                        id_transaksi
                    FROM
                        smis_fnc_uang_muka
                    WHERE
                        id = '" . $id_uang_muka . "'
                ");
                $detail = $this->dbtable->get_result("
                    SELECT
                        *
                    FROM
                        smis_ac_transaksi_detail
                    WHERE
                        prop = ''
                            AND id_transaksi = '" . $id_transaksi . "'
                    ORDER BY
                        id ASC
                ");
                if ($detail != null) {
                    $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
                    foreach ($detail as $d) {
                        $detail_jurnal_data = array();
                        if ($d->debet > $d->kredit) {
                            $detail_jurnal_data = array(
                                'id_transaksi'  => $id_header,
                                'nomor_account' => $d->nomor_account,
                                'nama_account'  => $d->nama_account,
                                'keterangan'    => $keterangan,
                                'debet'         => $nilai,
                                'kredit'        => 0,
                                'id_akun'       => $d->id_akun,
                                'nomor'         => $nomor,
                                'id_tipeakun'   => $d->id_tipeakun,
                                'nama_tipeakun' => $d->nama_tipeakun,
                                'tanggal'       => $tanggal,
                                'j_jurnal'      => $j_jurnal
                            );
                        } else {
                            $detail_jurnal_data = array(
                                'id_transaksi'  => $id_header,
                                'nomor_account' => $nomor_akun_hutang_vendor,
                                'nama_account'  => $nama_akun_hutang_vendor,
                                'keterangan'    => $keterangan,
                                'debet'         => 0,
                                'kredit'        => $nilai,
                                'id_akun'       => $id_akun_hutang_vendor,
                                'nomor'         => $nomor,
                                'id_tipeakun'   => $id_tipeakun_hutang_vendor,
                                'nama_tipeakun' => $nama_tipe_akun_hutang_vendor,
                                'tanggal'       => $tanggal,
                                'j_jurnal'      => $j_jurnal
                            );
                            
                        }
                        $detail_jurnal_dbtable->insert($detail_jurnal_data);
                    }
                }
            }
        }

        public function delete() {
            $id['id'] = $_POST['id'];
            $row = $this->dbtable->select($id);

            /// Update Uang Muka's diakui :
            $uang_muka_dbtable = new DBTable($this->dbtable->get_db(), "smis_fnc_uang_muka");
            $uang_muka_dbtable->update([
                'diakui' => 0
            ], [
                'id' => $row->id_uang_muka
            ]);

            $this->revertJournal($_POST['id'], $row->asal_faktur);
            
            if ($this->dbtable->isRealDelete()) {
                $result = $this->dbtable->delete($id['id']);
            } else {
                $data['prop'] = "del";
                $result = $this->dbtable->update($data, $id);
            }
            
            $sisa_tagihan = $this->updateInvoice($row->id_faktur, $row->asal_faktur);

            $response['success'] = 1;
            $response['sisa_tagihan'] = $sisa_tagihan == 0 ? "0,00" : ArrayAdapter::format("only-money", $sisa_tagihan);
            if ($result === 'false') {
                $response['success'] = 0;
            }
            return $response;
        }
    }
?>