<?php
    class KBPengeluaranDBResponder extends DBResponder {
        public function command($command) {
            if (
                $command != "export_xls" && 
                $command != "export_pdf" && 
                $command != "print_jurnal" &&
                $command != "new_row" &&
                $command != "save" &&
                $command != "lock_draft" &&
                $command != "post_journal"
            )
                return parent::command($command);
            if ($command == "export_pdf")
                return $this->exportPDF();
            else if ($command == "export_xls") {
                $this->exportXLS();
                return;
            } else if ($command == "print_jurnal")
                return $this->printJurnal();
            else if ($command == "new_row")
                return $this->newRow();
            else if ($command == "save")
                return $this->save();
            else if ($command == "lock_draft")
                return $this->lockDraft();
            else if ($command == "post_journal")
                return $this->postJournal();

        }

        private function newRow() {
            $row_num = $_POST['row_num'];
            $akun_rows = $this->dbtable->get_result("
                SELECT 
                    *
                FROM
                    smis_ac_account
                WHERE
                    prop = '' 
                        AND id_parent <> 0
                        AND have_child = 0
                        AND nama_tipe NOT LIKE 'Kas & Setara Kas'
                ORDER BY
                    nomor ASC
            ");
            $akun_option = new OptionBuilder();
            $akun_option->add("", "", "1");
            if ($akun_rows != null)
                foreach ($akun_rows as $akun_row)
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
            $akun_select = new Select("kb_pengeluaran_detail_akun", "kb_pengeluaran_detail_akun", $akun_option->getContent());
            $akun_select->setClass("detail_select2");
            $keterangan_textarea = new TextArea("kb_pengeluaran_detail_keterangan", "kb_pengeluaran_detail_keterangan", "");
            $keterangan_textarea->setLine(1);
            $keterangan_textarea->setClass("detail_textarea");
            $debet_text = new Text("kb_pengeluaran_detail_debet", "kb_pengeluaran_detail_debet", "0,00");
            $debet_text->setTypical("money");
            $debet_text->setClass("detail_money");
            $debet_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
            $delete_button_html = "<a href='#' onclick='kb_pengeluaran.deleteDetail(\"detail_" . $row_num . "\")' id='' class='input btn btn btn-danger'><i class='fa fa-trash'></i></a>";
            $html =     "<tr id='detail_" . $row_num . "'>" .
                            "<td id='detail_id' style='display: none;'></td>" .
                            "<td id='detail_nomor'></td>" .
                            "<td id='detail_akun'>" . $akun_select->getHtml() . "</td>" .
                            "<td id='detail_uraian'>" . $keterangan_textarea->getHtml() . "</td>" .
                            "<td id='detail_debet'>" . $debet_text->getHtml() . "</td>" .
                            "<td>" . $delete_button_html . "</td>" .
                        "</tr>";
            $data = array(
                'html'      => $html,
                'id_row'    => "detail_" . $row_num
            );
            return $data;
        } 

        public function lockDraft() {
            $identifier = [
                'id' => $_POST['id']
            ];
            $data = [
                'lock_draft' => 1
            ];
            $result = $this->dbtable->update($data, $identifier);
            return [
                'result'    => $result,
                'id'        => $_POST['id']
            ];
        }
        
        public function save() {
            $result = true;

            $j_jurnal = "Pengeluaran";
            global $user;
            $operator = $user->getNameOnly();
            $tanggal_input = date("Y-m-d H:i:s");
            $id = $_POST['id'];            
            $tanggal_part = explode(" ", $_POST['tanggal']);
            $tanggal = DateTime::createFromFormat("d-m-Y", $tanggal_part[0])->format("Y-m-d") . " " . $tanggal_part[1];
            $nomor = $_POST['nomor'];
            $keterangan = $_POST['keterangan'];
            $nilai = $_POST['kredit'];

            $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_draft_jurnal");
            $jurnal_data = array(
                'j_jurnal'      => $j_jurnal,
                'operator'      => $operator,
                'tanggal_input' => $tanggal_input,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor,
                'keterangan'    => $keterangan,
                'nilai'         => $nilai,
                'id_jurnal'     => 0,
                'lock_draft'    => 0,
                'lock_acc'      => 0
            );
            if ($id == "" || $id == 0) {
                $result = $jurnal_dbtable->insert($jurnal_data);
                $id = $jurnal_dbtable->get_inserted_id();
            } else {
                $identifier['id'] = $id;
                $result = $jurnal_dbtable->update($jurnal_data, $identifier);
            }

            $id_detail = $_POST['id_detail'];
            $akun_part = explode(" - ", $_POST['akun']);
            $kode_akun = $akun_part[0];
            $id_akun = 0;
            $id_tipeakun = 0;
            $nama_tipeakun = "";
            $nama_akun = "";
            $coa_row = $this->dbtable->get_row("
                SELECT
                    id id_akun,
                    tipe id_tipeakun,
                    nama_tipe nama_tipeakun,
                    nama nama_akun
                FROM
                    smis_ac_account
                WHERE
                    nomor LIKE '" . $kode_akun . "'
                        AND prop = ''
                ORDER BY
                    id DESC
                LIMIT 
                    0, 1
            ");
            if ($coa_row != null) {
                $id_akun = $coa_row->id_akun;
                $id_tipeakun = $coa_row->id_tipeakun;
                $nama_tipeakun = $coa_row->nama_tipeakun;
                $nama_akun = $coa_row->nama_akun;
            }
            $uraian = $_POST['keterangan'];
            $debet = 0;
            $kredit = $_POST['kredit'];

            $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_detail_draft_jurnal");
            $detail_jurnal_data = array(
                'id_draft_jurnal'   => $id,
                'nomor_account'     => $kode_akun,
                'nama_account'      => $nama_akun,
                'keterangan'        => $uraian,
                'debet'             => $debet,
                'kredit'            => $kredit,
                'id_akun'           => $id_akun,
                'nomor'             => $nomor,
                'id_tipeakun'       => $id_tipeakun,
                'nama_tipeakun'     => $nama_tipeakun,
                'tanggal'           => $tanggal,
                'j_jurnal'          => $j_jurnal
            );
            if ($id_detail == "" || $id_detail == 0) {
                $result = $detail_jurnal_dbtable->insert($detail_jurnal_data);
            } else {
                $identifier['id'] = $id_detail;
                $detail_jurnal_dbtable->update($detail_jurnal_data, $identifier);
            }

            $detail = json_decode($_POST['detail'], true);
            if (count($detail) > 0) {
                foreach ($detail as $d) {
                    $deleted = $d['deleted'];
                    $id_detail = $d['id'];
                    $akun_part = explode(" - ", $d['akun']);
                    $kode_akun = $akun_part[0];
                    $id_akun = 0;
                    $id_tipeakun = 0;
                    $nama_tipeakun = "";
                    $coa_row = $this->dbtable->get_row("
                        SELECT
                            id id_akun,
                            tipe id_tipeakun,
                            nama_tipe nama_tipeakun,
                            nama nama_akun
                        FROM
                            smis_ac_account
                        WHERE
                            nomor LIKE '" . $kode_akun . "'
                                AND prop = ''
                        ORDER BY
                            id DESC
                        LIMIT 
                            0, 1
                    ");
                    if ($coa_row != null) {
                        $id_akun = $coa_row->id_akun;
                        $id_tipeakun = $coa_row->id_tipeakun;
                        $nama_tipeakun = $coa_row->nama_tipeakun;
                        $nama_akun = $coa_row->nama_akun;
                    }
                    $uraian = $d['keterangan'];
                    $debet = $d['debet'];
                    $kredit = 0;

                    $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_detail_draft_jurnal");
                    $detail_jurnal_data = array(
                        'id_draft_jurnal'   => $id,
                        'nomor_account'     => $kode_akun,
                        'nama_account'      => $nama_akun,
                        'keterangan'        => $uraian,
                        'debet'             => $debet,
                        'kredit'            => $kredit,
                        'id_akun'           => $id_akun,
                        'nomor'             => $nomor,
                        'id_tipeakun'       => $id_tipeakun,
                        'nama_tipeakun'     => $nama_tipeakun,
                        'tanggal'           => $tanggal,
                        'j_jurnal'          => $j_jurnal
                    );
                    if ($id_detail == "" || $id_detail == 0) {
                        $result = $detail_jurnal_dbtable->insert($detail_jurnal_data);
                    } else {
                        $identifier['id'] = $id_detail;
                        if ($deleted == 1) {
                            $detail_jurnal_data = array(
                                'prop' => "del"
                            );
                        }                            
                        $detail_jurnal_dbtable->update($detail_jurnal_data, $identifier);
                    }
                }
            }

            $data = array(
                'result' => $result,
                'id'     => $id
            );
            return $data;
        }

        private function postJournal() {
            $id = $_POST['id'];
            $result = true;

            $draft_jurnal_row = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_draft_jurnal
                WHERE
                    id = '" . $id . "'
            ");

            $j_jurnal = $draft_jurnal_row->j_jurnal;
            $operator = $draft_jurnal_row->operator;
            $tanggal_input = $draft_jurnal_row->tanggal_input;        
            $tanggal = $draft_jurnal_row->tanggal;
            require_once("accounting/function/new_transaksi_harian.php");
            $nomor = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "JKK");
            $keterangan = $draft_jurnal_row->keterangan;
            $nilai = $draft_jurnal_row->nilai;

            $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
            $jurnal_data = array(
                'j_jurnal'      => $j_jurnal,
                'operator'      => $operator,
                'tanggal_input' => $tanggal_input,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor,
                'keterangan'    => $keterangan,
                'nilai'         => $nilai,
            );
            $result = $jurnal_dbtable->insert($jurnal_data);
            $id_jurnal = $jurnal_dbtable->get_inserted_id();

            $detail = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = ''
                        AND id_draft_jurnal = '" . $id . "'
                ORDER BY
                    id DESC
            ");
            if ($detail != null) {
                foreach ($detail as $d) {
                    $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
                    $detail_jurnal_data = array(
                        'id_transaksi'      => $id_jurnal,
                        'nomor_account'     => $d->nomor_account,
                        'nama_account'      => $d->nama_account,
                        'keterangan'        => $d->keterangan,
                        'debet'             => $d->debet,
                        'kredit'            => $d->kredit,
                        'id_akun'           => $d->id_akun,
                        'nomor'             => $d->nomor,
                        'id_tipeakun'       => $d->id_tipeakun,
                        'nama_tipeakun'     => $d->nama_tipeakun,
                        'tanggal'           => $d->tanggal,
                        'j_jurnal'          => $d->j_jurnal
                    );
                    $result = $detail_jurnal_dbtable->insert($detail_jurnal_data);
                }
            }

            $draft_jurnal_data = [
                'id_jurnal' => $id_jurnal,
                'nomor'     => $nomor
            ];
            $draft_jurnal_identifier = [
                'id' => $id
            ];
            $this->dbtable->update($draft_jurnal_data, $draft_jurnal_identifier);

            return array(
                'result' => $result,
                'id'     => $id
            );
        }

        private function exportXLS() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            $kode_akun = $_POST['kode_akun'];
            $nama_akun = $_POST['nama_akun'];
            $akun = $_POST['akun'];
            $filter_akun = "";
            if ($kode_akun != "") {
                $filter_akun = "AND c.nomor = '" . $kode_akun . "' AND c.nama = '" . $nama_akun . "'";
            }

            require_once("smis-libs-out/php-excel/PHPExcel.php");

            $file = new PHPExcel();
            $file->getProperties()->setCreator("PT. Inovasi Ide Utama");
            $file->getProperties()->setTitle("Pengeluaran");
            $file->getProperties()->setSubject("Pengeluaran");
            $file->getProperties()->setDescription("Pengeluaran - SIMRS");
            $file->getProperties()->setKeywords("Pengeluaran");
            $file->getProperties()->setCategory("Pengeluaran");

            $sheet = $file->getActiveSheet();
            $sheet->setTitle("Pengeluaran");
            $i = 1;

            $sheet->mergeCells("A" . $i . ":E" . $i)->setCellValue("A" . $i, "PENGELUARAN");
            $sheet->getStyle("A" . $i . ":E" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Dari Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_dari));
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Sampai Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_sampai));
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Akun Kas Bank");
            $sheet->setCellValue("B" . $i, ": " . $akun);
            $i = $i + 2;

            $border_start = $i;
            $col = "A";
            $head = array('No.', 'No. Jurnal', 'Tgl. Jurnal', 'Uraian', 'Nilai');
            foreach ($head as $h)
                $sheet->setCellValue($col++ . $i, $h);
            $sheet->getStyle("A" . $i . ":E" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i . ":E" . $i)->getFont()->setBold(true);
            $i = $i + 1;

            $data = $this->dbtable->get_result("
                SELECT
                    b.id, b.nomor, b.tanggal, CONCAT(a.nomor_account, ' - ', a.nama_account) akun, a.keterangan uraian, a.kredit nilai
                FROM
                    smis_ac_detail_draft_jurnal a
                        LEFT JOIN smis_ac_draft_jurnal b ON a.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_account c ON a.nomor_account = c.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND c.nama_tipe LIKE 'Kas & Setara Kas'
                        AND a.kredit > a.debet
                        AND a.kredit > 0
                        AND b.j_jurnal LIKE 'Pengeluaran'
                        " . $filter_akun . "
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ");
            $saldo_akhir = 0;
            if (count($data) > 0) {
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $sheet->setCellValue("A" . $i, $nomor++);
                    $sheet->setCellValue("B" . $i, $d->nomor);
                    $sheet->setCellValue("C" . $i, ArrayAdapter::format("date d-m-Y", $d->tanggal));
                    $sheet->setCellValue("D" . $i, $d->uraian);
                    $sheet->setCellValue("E" . $i, $d->nilai);
                    $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $total += $d->nilai;
                    $i = $i + 1;
                }
                $sheet->mergeCells("A" . $i . ":D" . $i)->setCellValue("A" . $i, "Total");
                $sheet->getStyle("A" . $i . ":D" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $sheet->setCellValue("E" . $i, $total);
                $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                $sheet->getStyle("A" . $i . ":E" . $i)->getFont()->setBold(true);
            }

            $thin = array();
            $thin['borders'] = array();
            $thin['borders']['allborders'] = array();
            $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
            $sheet->getStyle("A" . $border_start . ":E" . $i)->applyFromArray($thin);

            foreach (range('A', 'E') as $columnID)
                $sheet->getColumnDimension($columnID)->setAutoSize(true);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Pengeluaran.xls"');
            header('Cache-Control: max-age=0');
            $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
            $writer->save('php://output');
            return;
        } 
        
        private function exportPDF() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            $kode_akun = $_POST['kode_akun'];
            $nama_akun = $_POST['nama_akun'];
            $akun = $_POST['akun'];
            $filter_akun = "";
            if ($kode_akun != "") {
                $filter_akun = "AND c.nomor = '" . $kode_akun . "' AND c.nama = '" . $nama_akun . "'";
            }
            require_once("finance/class/template/pdf.php");
			$fpdf = new PDF("L", "mm", "A4");
			$fpdf->SetMargins(5, 5);
		
            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "PENGELUARAN", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(25, 5, "Dari Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_dari), 0, 1);
            $fpdf->Cell(25, 5, "Sampai Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_sampai), 0, 1);
            $fpdf->Cell(25, 5, "Akun Kas Bank", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $akun, 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(15, 5, "No.", 1, 0, "C");
            $fpdf->Cell(40, 5, "No. Jurnal", 1, 0, "C");
            $fpdf->Cell(25, 5, "Tgl. Jurnal", 1, 0, "C");
            $fpdf->Cell(165, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Nilai", 1, 1, "C");
            $data = $this->dbtable->get_result("
                SELECT
                    b.id, b.nomor, b.tanggal, CONCAT(a.nomor_account, ' - ', a.nama_account) akun, a.keterangan uraian, a.kredit nilai
                FROM
                    smis_ac_detail_draft_jurnal a
                        LEFT JOIN smis_ac_draft_jurnal b ON a.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_account c ON a.nomor_account = c.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND c.nama_tipe LIKE 'Kas & Setara Kas'
                        AND a.kredit > a.debet
                        AND a.kredit > 0
                        AND b.j_jurnal LIKE 'Pengeluaran'
                        " . $filter_akun . "
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ");
            if (count($data) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $fpdf->Cell(15, 5, $nomor++, 1, 0);
                    $fpdf->Cell(40, 5, $d->nomor, 1, 0);
                    $fpdf->Cell(25, 5, ArrayAdapter::format("date d-m-Y", $d->tanggal), 1, 0);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(165, 5, $d->uraian, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(245, 5, "", 0, 0, "");
                    $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $d->nilai), 1, 1, "R");
                    $total += $d->nilai;
                }
                $fpdf->SetFont("Arial", "B", 9);
                $fpdf->Cell(245, 5, "Total", 1, 0, "R");
                $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $total), 1, 1, "R");
            }

			global $user;
		    $md5 = md5(date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "pengeluaran.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        } 
        
        private function printJurnal() {
            $id = $_POST['id'];
            $header_jurnal = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_draft_jurnal
                WHERE
                    id = '" . $id . "'
            ");
            $detail_jurnal = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = '' 
                        AND id_draft_jurnal = '" . $id . "'
                ORDER BY
                    debet DESC, id ASC
            ");

            require_once("finance/class/template/pdf.php");
            $fpdf = new PDF("L", "mm", "A4");
            $fpdf->SetMargins(5, 5);

            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "JURNAL PENGELUARAN", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Nomor", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->nomor, 0, 1);
            $fpdf->Cell(25, 5, "Tanggal", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1);

            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(100, 5, "No. - Nama Akun", 1, 0, "C");
            $fpdf->Cell(105, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Debit", 1, 0, "C");
            $fpdf->Cell(40, 5, "Kredit", 1, 1, "C");

            if (count($detail_jurnal) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                foreach ($detail_jurnal as $d) {
                    $f_debet = $d->debet == 0 ? "0,00" : ArrayAdapter::format("only-money", $d->debet);
                    $f_kredit = $d->kredit == 0 ? "0,00" : ArrayAdapter::format("only-money", $d->kredit);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(100, 5, $d->nomor_account . " - " . $d->nama_account, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->Cell(100, 5, "", 0, 0, "");
                    $fpdf->MultiCell(105, 5, $d->keterangan, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(205, 5, "", 0, 0, "");
                    $fpdf->Cell(40, 5, $f_debet, 1, 0, "R");
                    $fpdf->Cell(40, 5, $f_kredit, 1, 1, "R");
                }
            }

            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Deintrikan oleh", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->operator, 0, 1);
            $fpdf->Cell(25, 5, "Dientrikan pada", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal_input), 0, 1);

            global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "jurnal_penerimaan.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        } 
        
        public function edit() {
            $id = $_POST['id'];
            $header_data = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_draft_jurnal
                WHERE
                    id = '" . $id . "'
            ");
            $debet_row = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = ''
                        AND id_draft_jurnal = '" . $id . "'
                        AND kredit > 0
                        AND debet = 0
                ORDER BY
                    id DESC
                LIMIT
                    0, 1
            ");
            $header_data->tanggal = ArrayAdapter::format("date d-m-Y H:i", $header_data->tanggal);
            $header_data->tanggal_input = ArrayAdapter::format("date d-m-Y H:i", $header_data->tanggal_input);
            $header_data->id_detail = "";
            $header_data->no_akun = "";
            $header_data->nama_akun = "";
            if ($debet_row != null) {
                $header_data->id_detail = $debet_row->id;
                $header_data->no_akun = $debet_row->nomor_account;
                $header_data->nama_akun = $debet_row->nama_account;
            }
            $detail_data = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = ''
                        AND id_draft_jurnal = '" . $id . "'
                        AND kredit = 0
                        AND debet > 0
                ORDER BY
                    id ASC
            ");
            $data = array(
                'header'    => $header_data,
                'detail'    => $detail_data
            );
            return $data;
        }

        public function delete() {
            $response = parent::delete();

            if ($response['success'] == 1) {
                $id_transaksi = $_POST['id'];
                $transaksi_detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_detail_draft_jurnal");
                $data_transaksi_detail = array(
                    'prop'  => "del"
                );
                $identifier = array(
                    'id_draft_jurnal'    => $id_transaksi
                );
                $result = $transaksi_detail_dbtable->update($data_transaksi_detail, $identifier);
                if ($result === false)
                    $response['success'] = 0;
            }

            return $response;
        }
    }
?>