<?php
    class KBPembayaranRekapFakturDBResponder extends DBResponder {
        public function save() {
            $id_rekap_faktur = $_POST['id'];
            if ($_POST['id'] == "" || $_POST['id'] == 0) {
                // Do Insert Header :
                global $user;
                $data_rekap_faktur = array(
                    'id_vendor' => $_POST['id_vendor'],
                    'nama_vendor' => $_POST['nama_vendor'],
                    'medis' => $_POST['medis'],
                    'tanggal' => DateTime::createFromFormat("d-m-Y", $_POST['tanggal'])->format("Y-m-d"),
                    'nomor' => $this->getTransactionAutoNumber(),
                    'total_tagihan' => $_POST['total_tagihan'],
                    'total_dibayar' => $_POST['total_dibayar'],
                    'sisa_tagihan' => $_POST['sisa_tagihan'],
                    'operator' => $user->getNameOnly()
                );
                $this->dbtable->insert($data_rekap_faktur);
                $id_rekap_faktur = $this->dbtable->get_inserted_id();

                // Do Insert Detail Rekap Faktur :
                $detail_rekap_faktur = json_decode($_POST['detail_rekap_faktur'], true);
                if (count($detail_rekap_faktur) > 0) {
                    $detail_rekap_faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_fnc_detail_rekap_faktur");
                    $bbm_fr_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_masuk");
                    $bbm_gu_dbtable = new DBTable($this->dbtable->get_db(), "smis_gu_barang_masuk");
                    $total_bayar = $_POST['total_dibayar'];
                    foreach ($detail_rekap_faktur as $d) {
                        $data_detail_rekap_faktur = array(
                            'id_rekap_faktur' => $id_rekap_faktur,
                            'id_bbm' => $d['id_bbm'],
                            'unit' => $d['unit'],
                            'id_vendor' => $_POST['id_vendor'],
                            'nama_vendor' => $_POST['nama_vendor'],
                            'tanggal_faktur' => DateTime::createFromFormat("d-m-Y", $d['tanggal_faktur'])->format("Y-m-d"),
                            'tanggal_jatuh_tempo' => DateTime::createFromFormat("d-m-Y", $d['tanggal_jatuh_tempo'])->format("Y-m-d"),
                            'nomor_faktur' => $d['nomor_faktur'],
                            'nomor_bbm' => $d['nomor_bbm'],
                            'total_tagihan' => $d['total_tagihan'],
                            'prop' => $d['prop']
                        );
                        $detail_rekap_faktur_dbtable->insert($data_detail_rekap_faktur);

                        // Do Update BBM Payment Info :
                        $nominal_dibayar = 0;
                        if ($d['total_tagihan'] > $total_bayar) {
                            $nominal_dibayar = $total_bayar;
                            $total_bayar = 0;
                        } else {
                            $total_bayar = $total_bayar - $d['total_tagihan'];
                            $nominal_dibayar = $d['total_tagihan'];
                        }
                        $data_bbm = [
                            'total_dibayar' => $nominal_dibayar,
                            'sudah_direkap' => 1
                        ];
                        $identifier_bbm = [
                            'id' => $d['id_bbm']
                        ];
                        if ($d['unit'] == "GUDANG FARMASI") {
                            $bbm_fr_dbtable->update($data_bbm, $identifier_bbm);
                        } else if ($d['unit'] == "GUDANG UMUM") {
                            $bbm_gu_dbtable->update($data_bbm, $identifier_bbm);
                        }
                    }
                }
            } else {
                $id_rekap_faktur = $_POST['id'];
                // Do Update Header :
                global $user;
                $data_rekap_faktur = array(
                    'id_vendor' => $_POST['id_vendor'],
                    'nama_vendor' => $_POST['nama_vendor'],
                    'medis' => $_POST['medis'],
                    'tanggal' => DateTime::createFromFormat("d-m-Y", $_POST['tanggal'])->format("Y-m-d"),
                    'total_tagihan' => $_POST['total_tagihan'],
                    'total_dibayar' => $_POST['total_dibayar'],
                    'sisa_tagihan' => $_POST['sisa_tagihan'],
                    'operator' => $user->getNameOnly()
                );
                $identifier_rekap_faktur = [
                    'id' => $id_rekap_faktur
                ];
                $this->dbtable->update($data_rekap_faktur, $identifier_rekap_faktur);

                // Do Update Detail Rekap Faktur :
                $detail_rekap_faktur = json_decode($_POST['detail_rekap_faktur'], true);
                if (count($detail_rekap_faktur) > 0) {
                    $detail_rekap_faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_fnc_detail_rekap_faktur");
                    $bbm_fr_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_masuk");
                    $bbm_gu_dbtable = new DBTable($this->dbtable->get_db(), "smis_gu_barang_masuk");
                    $this->resetBBMPaymentInfo($_POST['id'], $bbm_fr_dbtable, $bbm_gu_dbtable);
                    $total_bayar = $_POST['total_dibayar'];
                    foreach ($detail_rekap_faktur as $d) {
                        if ($d['id'] != "" && $d['id'] > 0) {
                            // Do Update :
                            $data_detail_rekap_faktur = array(
                                'id_bbm' => $d['id_bbm'],
                                'unit' => $d['unit'],
                                'id_vendor' => $_POST['id_vendor'],
                                'nama_vendor' => $_POST['nama_vendor'],
                                'tanggal_faktur' => DateTime::createFromFormat("d-m-Y", $d['tanggal_faktur'])->format("Y-m-d"),
                                'tanggal_jatuh_tempo' => DateTime::createFromFormat("d-m-Y", $d['tanggal_jatuh_tempo'])->format("Y-m-d"),
                                'nomor_faktur' => $d['nomor_faktur'],
                                'nomor_bbm' => $d['nomor_bbm'],
                                'total_tagihan' => $d['total_tagihan'],
                                'prop' => $d['prop']
                            );
                            $identifier_detail_rekap_faktur = [
                                'id' => $d['id']
                            ];
                            $detail_rekap_faktur_dbtable->update($data_detail_rekap_faktur, $identifier_detail_rekap_faktur);
                        } else {
                            // Do Inseert :
                             $data_detail_rekap_faktur = array(
                                'id_rekap_faktur' => $id_rekap_faktur,
                                'id_bbm' => $d['id_bbm'],
                                'unit' => $d['unit'],
                                'id_vendor' => $_POST['id_vendor'],
                                'nama_vendor' => $_POST['nama_vendor'],
                                'tanggal_faktur' => DateTime::createFromFormat("d-m-Y", $d['tanggal_faktur'])->format("Y-m-d"),
                                'tanggal_jatuh_tempo' => DateTime::createFromFormat("d-m-Y", $d['tanggal_jatuh_tempo'])->format("Y-m-d"),
                                'nomor_faktur' => $d['nomor_faktur'],
                                'nomor_bbm' => $d['nomor_bbm'],
                                'total_tagihan' => $d['total_tagihan'],
                                'prop' => $d['prop']
                            );
                            $detail_rekap_faktur_dbtable->insert($data_detail_rekap_faktur);
                        }

                        if ($d['prop'] == "") {
                            // Do Update BBM Payment Info :
                            $nominal_dibayar = 0;
                            if ($d['total_tagihan'] > $total_bayar) {
                                $nominal_dibayar = $total_bayar;
                                $total_bayar = 0;
                            } else {
                                $total_bayar = $total_bayar - $d['total_tagihan'];
                                $nominal_dibayar = $d['total_tagihan'];
                            }
                            $data_bbm = [
                                'total_dibayar' => $nominal_dibayar,
                                'sudah_direkap' => 1
                            ];
                            $identifier_bbm = [
                                'id' => $d['id_bbm']
                            ];
                            if ($d['unit'] == "GUDANG FARMASI") {
                                $bbm_fr_dbtable->update($data_bbm, $identifier_bbm);
                            } else if ($d['unit'] == "GUDANG UMUM") {
                                $bbm_gu_dbtable->update($data_bbm, $identifier_bbm);
                            }
                        }
                    }
                }
            }
            
            $response['id'] = $id_rekap_faktur;
			$response['success'] = 1;
			return $response;
        }

        private function getTransactionAutoNumber() {
            $incrementNumber = getSettings($this->dbtable->get_db(), "nomor-rekap_faktur-" . date("Y") . "-" . date("m"), 0) + 1;
            setSettings($this->dbtable->get_db(), "nomor-rekap_faktur-" . date("Y") . "-" . date("m"), $incrementNumber);
            return date("Y") . "/" . date("m") . "/" . ArrayAdapter::format("only-digit4", $incrementNumber);
        }

        private function resetBBMPaymentInfo($id_rekap_faktur, $bbm_fr_dbtable, $bbm_gu_dbtable) {
            $detail_rekap_faktur_rows = $this->dbtable->get_result("
                SELECT
                    id_bbm, unit
                FROM
                    smis_fnc_detail_rekap_faktur
                WHERE
                    prop = ''
                        AND id_rekap_faktur = '" . $id_rekap_faktur . "'
            ");
            if ($detail_rekap_faktur_rows != null) {
                foreach ($detail_rekap_faktur_rows as $d) {
                    $data_bbm = [
                        'total_dibayar' => 0,
                        'sudah_direkap' => 0
                    ];
                    $identifier_bbm = [
                        'id' => $d->id_bbm
                    ];
                    if ($d->unit == "GUDANG FARMASI") {
                        $bbm_fr_dbtable->update($data_bbm, $identifier_bbm);
                    } else if ($d->unit == "GUDANG UMUM") {
                        $bbm_gu_dbtable->update($data_bbm, $identifier_bbm);
                    }
                }
            }
        }

        public function edit() {
            $id['id'] = $_POST['id'];
            $header_row = $this->dbtable->select($id);

            $html_rekap_faktur = "<tr id='info_rekap_faktur_temp'><td colspan='8'><center>Tidak terdapat daftar info faktur.</center></td></tr>";
            $r_num_rekap_faktur = 0;
            $rekap_faktur_rows = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_fnc_detail_rekap_faktur
                WHERE
                    prop = ''
                        AND id_rekap_faktur = '" . $id['id'] . "'
            ");
            if ($rekap_faktur_rows != null) {
                $html_rekap_faktur = "";
                foreach ($rekap_faktur_rows as $r) {
                    $html_rekap_faktur .=   "<tr id='faktur_" . $r_num_rekap_faktur . "' class='data_faktur'>" .
                                                "<td id='faktur_id' style='display: none;'>" . $r->id . "</td>" .
                                                "<td id='faktur_id_rekap_faktur' style='display: none;'></td>" .
                                                "<td id='faktur_id_bbm' style='display: none;'>" . $r->id_bbm . "</td>" .
                                                "<td id='faktur_prop' style='display: none;'></td>" .
                                                "<td id='faktur_nomor'>" . ($r_num_rekap_faktur + 1) . "</td>" .
                                                "<td id='faktur_unit'>" . $r->unit . "</td>" .
                                                "<td id='faktur_nomor_faktur'>" . $r->nomor_faktur . "</td>" .
                                                "<td id='faktur_nomor_bbm'>" . $r->nomor_bbm . "</td>" .
                                                "<td id='faktur_tanggal_faktur'>" . ArrayAdapter::format("date d-m-Y", $r->tanggal_faktur) . "</td>" .
                                                "<td id='faktur_tanggal_jatuh_tempo'>" . ArrayAdapter::format("date d-m-Y", $r->tanggal_jatuh_tempo) . "</td>" .
                                                "<td id='faktur_total_tagihan'><div align='right'>" . ArrayAdapter::format("only-money", $r->total_tagihan) . "</div></td>" .
                                                "<td>" .
                                                    "<div class='btn-group noprint'>" .
                                                        "<a href='#' onclick='info_rekap_faktur.detail(" . $r_num_rekap_faktur . ")' data-content='Lihat' data-toggle='popover' class='input btn btn-success'>" . 
                                                            "<i class='icon-eye-open icon-white'></i>" .  
                                                        "</a>" .
                                                        "<a href='#' onclick='info_rekap_faktur.delete(" . $r_num_rekap_faktur++ . ")' data-content='Batal' data-toggle='popover' class='input btn btn-danger'>" .
                                                            "<i class='fa fa-times'></i>" .
                                                        "</a>" .
                                                    "</div>" .
                                                "</td>" .
                                            "</tr>";
                }
                $html_rekap_faktur .=   "<tr id='footer_info_rekap_faktur'>" .
                                            "<td colspan='6'><div align='right'><b>Total</b></div></td>" .
                                            "<td id='faktur_total_tagihan'><div align='right'><b>" . ArrayAdapter::format("only-money", $header_row->total_tagihan) . "</div></div></td>" .
                                            "<td></td>" .
                                        "</tr>";
            }

            return [
                'header' => $header_row,
                'detail' => [
                    'rekap_faktur' => [
                        'html' => $html_rekap_faktur,
                        'r_num' => $r_num_rekap_faktur
                    ],
                    'uang_muka' => [
                        'html' => '',
                        'r_num' => ''
                    ],
                    'pembayaran' => [
                        'html' => '',
                        'r_num' => ''
                    ]
                ]
            ];
        }
    }
?>