<?php
    class KBPembayaranFakturDBResponder extends DBResponder {
        public function command($command) {
            if ($command != "print_invoice")
                return parent::command($command);
            if ($command == "print_invoice")
                return $this->printInvoice();
        }

        public function save() {
            if (isset($_POST['waktu']))
                $_POST['waktu'] = DateTime::createFromFormat("d-m-Y", $_POST['waktu'])->format("Y-m-d");
            $result = parent::save();
            $sisa_tagihan = $this->updateInvoice($result['id']);
            $result['sisa_tagihan'] = $sisa_tagihan == 0 ? "0,00" : ArrayAdapter::format("only-money", $sisa_tagihan);
            $this->postPaymentJournal($result['id']);
            return $result;
        }

        public function edit() {
            $id = $_POST['id'];
            $data = $this->dbtable->get_row("
                SELECT
                    a.*, b.nomor
                FROM
                    smis_fnc_bayar a
                        INNER JOIN smis_ac_transaksi b ON a.id_jurnal = b.id
                WHERE
                    a.id = '" . $id . "'
            ");
            if ($data != null) {
                $data->waktu = ArrayAdapter::format("date d-m-Y", $data->waktu);
                $data->kredit = $data->kredit == 0 ? "0,00" : ArrayAdapter::format("only-money", $data->kredit);
            }
            return $data;
        }

        public function delete() {
            $result = parent::delete();
            $sisa_tagihan = $this->updateInvoice($_POST['id']);
            $result['sisa_tagihan'] = $sisa_tagihan == 0 ? "0,00" : ArrayAdapter::format("only-money", $sisa_tagihan);
            $this->revertPaymentJournal($_POST['id']);
            return $result;
        }

        private function updateInvoice($id) {
            $sisa_tagihan = 0;
            $data = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_bayar
                WHERE
                    id = '" . $id . "'
            ");
            if ($data != null) {
                $id_faktur = $data->id_faktur;
                $asal_faktur = $data->asal_faktur;

                $data = $this->dbtable->get_row("
                    SELECT
                        SUM(kredit) total_dibayar
                    FROM
                        smis_fnc_bayar
                    WHERE
                        prop = ''
                            AND asal_faktur LIKE '" . $asal_faktur . "'
                            AND id_faktur = '" . $id_faktur . "'
                ");
                $total_dibayar = 0;
                if ($data != null)
                    $total_dibayar = $data->total_dibayar;
                $total_uang_muka = $this->dbtable->get_var("
                    SELECT
                        SUM(nilai) nilai
                    FROM
                        smis_fnc_uang_muka_faktur
                    WHERE
                        prop = ''
                            AND id_faktur = '" . $id_faktur . "'
                            AND asal_faktur = '" . $asal_faktur . "'
                ");
                if ($total_uang_muka == null) {
                    $total_uang_muka = 0;
                }
                $total_dibayar += $total_uang_muka;
                if ($asal_faktur == "gudang_farmasi") {
                    $faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_masuk");
                    $identifier['id'] = $id_faktur;
                    $data_faktur['total_dibayar'] = $total_dibayar;
                    $faktur_dbtable->update($data_faktur, $identifier);

                    $data = $this->dbtable->get_row("
                        SELECT
                            total_tagihan
                        FROM
                            smis_fr_obat_masuk
                        WHERE
                            id = '" . $id_faktur . "'
                    ");
                    $sisa_tagihan = $data->total_tagihan - $total_dibayar;
                } else if ($asal_faktur == "gudang_umum") {
                    $faktur_dbtable = new DBTable($this->dbtable->get_db(), "smis_gu_barang_masuk");
                    $identifier['id'] = $id_faktur;
                    $data_faktur['total_dibayar'] = $total_dibayar;
                    $faktur_dbtable->update($data_faktur, $identifier);

                    $data = $this->dbtable->get_row("
                        SELECT
                            total_tagihan
                        FROM
                            smis_gu_barang_masuk
                        WHERE
                            id = '" . $id_faktur . "'
                    ");
                    $sisa_tagihan = $data->total_tagihan - $total_dibayar;
                }
            }
            return $sisa_tagihan;
        }

        private function postPaymentJournal($id) {
            if ($id == "" || $id == 0)
                return;

            $data_pembayaran = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_bayar
                WHERE
                    id = '" . $id . "'
            ");

            $data_faktur = null;
            if ($data_pembayaran->asal_faktur == "gudang_farmasi") {
                $data_faktur = $this->dbtable->get_row("
                    SELECT
                        *
                    FROM
                        smis_fr_obat_masuk
                    WHERE
                        id = '" . $data_pembayaran->id_faktur . "'
                ");
            } else if ($data_pembayaran->asal_faktur == "gudang_umum") {
                $data_faktur = $this->dbtable->get_row("
                    SELECT
                        *
                    FROM
                        smis_gu_barang_masuk
                    WHERE
                        id = '" . $data_pembayaran->id_faktur . "'
                ");
            }

            /// Header Jurnal :
            $transaksi_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
            global $user;
            require_once("accounting/function/new_transaksi_harian.php");
            $tanggal = date("Y-m-d H:i:s");
            $nomor_jurnal = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "JPB");
            $keterangan = "Pembayaran Hutang Faktur No: " . $data_faktur->no_faktur . " - " . $data_pembayaran->nama_vendor . " atas " . $data_pembayaran->nama_dompet;
            $data_transaksi = array(
                'j_jurnal'      => "Pembayaran",
                'operator'      => $user->getNameOnly(),
                'tanggal_input' => $tanggal,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor_jurnal,
                'keterangan'    => $keterangan,
                'nilai'         => $data_pembayaran->kredit
            );
            $id_transaksi = $data_pembayaran->id_jurnal;
            if ($data_pembayaran->id_jurnal == 0) {
                $transaksi_dbtable->insert($data_transaksi);
                $id_transaksi = $transaksi_dbtable->get_inserted_id();
            } else {
                $identifier = array(
                    'id'    => $id_transaksi
                );
                $transaksi_dbtable->update($data_transaksi, $identifier);
            }

            $transaksi_detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
            
            /// Detail Jurnal Debit :
            $nama_map = "akun-hutang-vendor-nonmedis-nonaccruel";
            if ($data_pembayaran->asal_faktur == "gudang_farmasi")
                $nama_map = "akun-hutang-vendor-medis-nonaccruel";
            $data_akun_hutang_vendor = $this->dbtable->get_row("
                SELECT
                    a.nomor_akun, a.nama_akun, b.id id_akun, c.id id_tipeakun, c.tipe nama_tipeakun
                FROM
                    smis_ac_map_akun a 
                        INNER JOIN smis_ac_account b ON a.nomor_akun = b.nomor
                        INNER JOIN smis_ac_tipe_account c ON b.tipe = c.id
                WHERE
                    a.nama_map LIKE '" . $nama_map . "'
                        AND a.prop = ''
                ORDER BY
                    a.id DESC
                LIMIT 
                    0,1
            ");
            $id_akun = "";
            $nomor_akun = "";
            $nama_akun = "";
            $id_tipeakun = "";
            $nama_tipeakun = "";
            if ($data_akun_hutang_vendor != null) {
                $id_akun = $data_akun_hutang_vendor->id_akun;
                $nomor_akun = $data_akun_hutang_vendor->nomor_akun;
                $nama_akun = $data_akun_hutang_vendor->nama_akun;
                $id_tipeakun = $data_akun_hutang_vendor->id_tipeakun;
                $nama_tipeakun = $data_akun_hutang_vendor->nama_tipeakun;
            }
            $keterangan = "Pembayaran Hutang Faktur No: " . $data_faktur->no_faktur . " - " . $data_pembayaran->nama_vendor;
            $data_transaksi_detail_debit = array(
                'id_transaksi'  => $id_transaksi,
                'nomor_account' => $nomor_akun,
                'nama_account'  => $nama_akun,
                'keterangan'    => $keterangan, 
                'debet'         => $data_pembayaran->kredit,
                'kredit'        => 0,
                'id_akun'       => $id_akun,
                'nomor'         => $nomor_jurnal,
                'id_tipeakun'   => $id_tipeakun,
                'nama_tipeakun' => $nama_tipeakun,
                'tanggal'       => $tanggal,
                'j_jurnal'      => "Pembayaran"
            );
            if ($data_pembayaran->id_jurnal == 0)
                $transaksi_detail_dbtable->insert($data_transaksi_detail_debit);
            else {
                $transaksi_detail_row = $this->dbtable->get_row("
                    SELECT
                        id
                    FROM
                        smis_ac_transaksi_detail
                    WHERE
                        id_transaksi = '" . $id_transaksi . "'
                            AND debet > 0
                ");
                $identifier = array(
                    'id'  => $transaksi_detail_row->id
                );
                $transaksi_detail_dbtable->update($data_transaksi_detail_debit, $identifier);
            }

            /// Detail Jurnal Kredit :
            $keterangan = "Pembayaran Hutang Faktur No: " . $data_faktur->no_faktur . " - " . $data_pembayaran->nama_vendor . " atas " . $data_pembayaran->nama_dompet;
            $data_akun = $this->dbtable->get_row("
                SELECT
                    a.*, b.id id_tipeakun, b.tipe nama_tipeakun
                FROM
                    smis_ac_account a
                        INNER JOIN smis_ac_tipe_account b ON a.tipe = b.id
                WHERE
                    a.nomor LIKE '" . $data_pembayaran->no_akun . "'
                        AND a.prop = ''
                ORDER BY
                    a.id DESC
                LIMIT
                    0, 1
            ");
            $id_tipeakun = "";
            $nama_tipeakun = "";
            if ($data_akun != null) {
                $id_tipeakun = $data_akun->id_tipeakun;
                $nama_tipeakun = $data_akun->nama_tipeakun;
            }
            $data_transaksi_detail_kredit = array(
                'id_transaksi'  => $id_transaksi,
                'nomor_account' => $data_pembayaran->no_akun,
                'nama_account'  => $data_pembayaran->nama_dompet,
                'keterangan'    => $keterangan, 
                'debet'         => 0,
                'kredit'        => $data_pembayaran->kredit,
                'id_akun'       => $data_pembayaran->id_dompet,
                'nomor'         => $nomor_jurnal,
                'id_tipeakun'   => $id_tipeakun,
                'nama_tipeakun' => $nama_tipeakun,
                'tanggal'       => $tanggal,
                'j_jurnal'      => "Pembayaran"
            );
            if ($data_pembayaran->id_jurnal == 0)
                $transaksi_detail_dbtable->insert($data_transaksi_detail_kredit);
            else {
                $transaksi_detail_row = $this->dbtable->get_row("
                    SELECT
                        id
                    FROM
                        smis_ac_transaksi_detail
                    WHERE
                        id_transaksi = '" . $id_transaksi . "'
                            AND kredit > 0
                ");
                $identifier = array(
                    'id'  => $transaksi_detail_row->id
                );
                $transaksi_detail_dbtable->update($data_transaksi_detail_kredit, $identifier);
            }
            
            $data = array(
                'id_jurnal' => $id_transaksi
            );
            $identifier = array(
                'id'        => $id
            );
            $this->dbtable->update($data, $identifier);
        }

        private function revertPaymentJournal($id) {
            if ($id == "" || $id == 0)
                return;
            
            $data_pembayaran = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_bayar
                WHERE
                    id = '" . $id . "'
            ");

            $id_jurnal = $data_pembayaran->id_jurnal;
            $transaksi_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
            $data_transaksi = array(
                'prop'  => "del"
            );
            $identifier = array(
                'id'    => $id_jurnal
            );
            $transaksi_dbtable->update($data_transaksi, $identifier);
            $transaksi_detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
            $data_transaksi_detail = array(
                'prop'  => "del"
            );
            $identifier = array(
                "id_transaksi"  => $id_jurnal    
            );
            $transaksi_detail_dbtable->update($data_transaksi_detail, $identifier);
        }

        private function printInvoice() {
            $id = $_POST['id'];
            $data = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_bayar
                WHERE
                    id = '" . $id . "'
            ");

            $data_faktur = null;
            if ($data->asal_faktur == "gudang_farmasi") {
                $data_faktur = $this->dbtable->get_row("
                    SELECT
                        *
                    FROM
                        smis_fr_obat_masuk
                    WHERE
                        id = '" . $data->id_faktur . "'
                ");
            } else if ($data->asal_faktur == "gudang_umum") {
                $data_faktur = $this->dbtable->get_row("
                    SELECT
                        *
                    FROM
                        smis_gu_barang_masuk
                    WHERE
                        id = '" . $data->id_faktur . "'
                ");
            }

            require_once("finance/class/template/pdf.php");
            $fpdf = new PDF("L", "mm", "A4");
            $fpdf->SetMargins(5, 5);

            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "BUKTI PEMBAYARAN FAKTUR", 0, 1, "C");
            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "Nomor ID", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, $id, 0, 0);
            $fpdf->Cell(5, 5, "", 0, 0, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "No. Ref.", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, $data->noref, 0, 1);
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "Tanggal Bayar", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, ArrayAdapter::format("date d-m-Y", $data->waktu), 0, 0);
            $fpdf->Cell(5, 5, "", 0, 0, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "Penerima", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, $data->penerima, 0, 1);
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "Jenis Bayar", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, $data->jenis, 0, 0);
            $fpdf->Cell(5, 5, "", 0, 0, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(25, 5, "Nilai", 0, 0);
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(105, 5, ArrayAdapter::format("only-money", $data->kredit), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(285, 5, "Keterangan", 0, 1);
            $fpdf->SetFont("Arial", "", 10);
            if ($data_faktur != null) {
                $keterangan = "Pembayaran Hutang Faktur No: " . $data_faktur->no_faktur . " - " . $data->nama_vendor . " atas " . $data->nama_dompet . ".";
                $fpdf->Cell(285, 5, $keterangan, 0, 1);
            } else
                $fpdf->Cell(285, 5, "Tidak ada.", 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1);

            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(120, 5, "No. - Nama Akun", 1, 0, "C");
            $fpdf->Cell(125, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Kredit", 1, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->MultiCell(120, 5, $data->no_akun . " - " . $data->nama_dompet, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $lastX = $fpdf->GetX();
            $lastY = $fpdf->GetY();
            $fpdf->Cell(120, 5, "", 0, 0, "");
            $fpdf->MultiCell(125, 5, $data->keterangan, 1, "J", false, 1);
            $fpdf->SetX($lastX);
            $fpdf->SetY($lastY);
            $fpdf->Cell(245, 5, "", 0, 0, "");
            $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $data->kredit), 1, 1, "R");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(245, 5, "Total", 1, 0, "R");
            $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $data->kredit), 1, 1, "R");

            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(285, 5, "Terbilang", 0, 1, "");
            $fpdf->SetFont("Arial", "I", 10);
			loadLibrary("smis-libs-function-math");
            $fpdf->Cell(285, 5, numbertell($data->kredit) . " Rupiah", 0, 1, "");

            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(90, 5, "Disiapkan Oleh", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "Direvisi Oleh", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "Disetujui Oleh", 0, 1, "C");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(285, 5, "", 0, 1, "");
            $fpdf->Cell(90, 5, "_______________", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "_______________", 0, 0, "C");
            $fpdf->Cell(7.5, 5, "", 0, 0, "");
            $fpdf->Cell(90, 5, "_______________", 0, 1, "C");

            global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "bukti_pembayaran_faktur.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        }
    }
?>