<?php
    class KBPFFakturDBResponder extends DBResponder {
        public function edit() {
            $parts = explode("|", $_POST['id']);
            $gudang = $parts[0];
            $id = $parts[1];
            $data = array(
                'header' => null,
                'detail' => null,
                'footer' => null
            );
            
            if ($gudang == "gudang_farmasi") {
                $header_row = $this->dbtable->get_row("
                    SELECT
                        id,
                        id_po,
                        no_faktur nomor_faktur,
                        no_bbm,
                        tanggal tanggal_faktur,
                        tanggal_tempo jatuh_tempo,
                        id_vendor id_rekanan,
                        nama_vendor nama_rekanan,
                        total_tagihan,
                        (total_tagihan - total_dibayar) sisa_tagihan,
                        diskon diskon_global,
                        t_diskon t_diskon_global,
                        materai,
                        use_ppn
                    FROM
                        smis_fr_obat_masuk
                    WHERE
                        prop = ''
                            AND id = '" . $id . "'
                ");
                if ($header_row != null) {
                    $data['header']['id'] = $header_row->id;
                    $data['header']['id_opl'] = $header_row->id_po;
                    $data['header']['asal_faktur'] = "gudang_farmasi";
                    $data['header']['nomor_faktur'] = $header_row->nomor_faktur;
                    $data['header']['no_bbm'] = $header_row->no_bbm;
                    $data['header']['tanggal_faktur'] = ArrayAdapter::format("date d-m-Y", $header_row->tanggal_faktur);
                    $data['header']['jatuh_tempo'] = ArrayAdapter::format("date d-m-Y", $header_row->jatuh_tempo);
                    $data['header']['id_rekanan'] = $header_row->id_rekanan;
                    $data['header']['nama_rekanan'] = $header_row->nama_rekanan;
                    $data['header']['total_tagihan'] = ArrayAdapter::format("only-money", $header_row->total_tagihan);
                    $data['header']['sisa_tagihan'] = ArrayAdapter::format("only-money", $header_row->sisa_tagihan);

                    $detail_rows = $this->dbtable->get_result("
                        SELECT
                            kode_obat kode,
                            nama_obat barang,
                            nama_jenis_obat jenis,
                            jumlah,
                            satuan,
                            hna harga,
                            diskon diskon_detail,
                            t_diskon t_diskon_detail
                        FROM
                            smis_fr_dobat_masuk
                        WHERE
                            id_obat_masuk = '" . $id . "'
                                AND prop = ''
                    ");
                    $total_1 = 0;
                    $html = "";
                    $nomor = 1;
                    if ($detail_rows != null) {
                        foreach ($detail_rows as $dr) {
                            $harga = $dr->harga;
                            if ($header_row->use_ppn == 1)
                                $harga = $dr->harga / 1.1;
                            $subtotal = $dr->jumlah * $harga;
                            $diskon = $dr->diskon_detail;
                            $f_diskon = ArrayAdapter::format("only-money", $dr->diskon_detail);
                            if ($dr->t_diskon_detail == "persen") {
                                $diskon = $dr->diskon_detail * $subtotal / 100;
                                $f_diskon = $dr->diskon_detail . " %";
                            }
                            $subtotal = $subtotal - $diskon;
                            $total_1 += $subtotal;

                            $html .=    "<tr>";
                            $html .=        "<td>" . $nomor++ . "</td>";
                            $html .=        "<td>" . $dr->kode . "</td>";
                            $html .=        "<td>" . $dr->barang . "</td>";
                            $html .=        "<td>" . $dr->jenis . "</td>";
                            $html .=        "<td><div align='right'>" . $dr->jumlah . "</div></td>";
                            $html .=        "<td>" . $dr->satuan . "</td>";
                            $html .=        "<td><div align='right'>" . ArrayAdapter::format("only-money", $harga) . "</div></td>";
                            $html .=        "<td><div align='right'>" . $f_diskon . "</div></td>";
                            $html .=        "<td><div align='right'>" . ArrayAdapter::format("only-money", $subtotal) . "</div></td>";
                            $html .=    "</tr>";
                        }
                        $data['detail'] = $html;
                    }
                    $data['footer']['total_1'] = $total_1 == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_1);
                    $diskon = $header_row->diskon_global;
                    if ($header_row->t_diskon_global == "persen")
                        $diskon = $total_1 * $header_row->diskon_global / 100;
                    $data['footer']['diskon'] = $diskon == 0 ? "0,00" : ArrayAdapter::format("only-money", $diskon);
                    $total_2 = $total_1 - $diskon;
                    $data['footer']['total_2'] = $total_2 == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_2);
                    $ppn = 0;
                    if ($header_row->use_ppn == 1)
                        $ppn = $total_2 * 0.1;
                    $data['footer']['ppn'] = $ppn == 0 ? "0,00" : ArrayAdapter::format("only-money", $ppn);
                    $materai = $header_row->materai;
                    $data['footer']['materai'] = $materai == 0 ? "0,00" : ArrayAdapter::format("only-money", $materai);
                    $data['footer']['tagihan'] = ArrayAdapter::format("only-money", $header_row->total_tagihan);
                }
            } else if ($gudang == "gudang_umum") {
                $header_row = $this->dbtable->get_row("
                    SELECT
                        id,
                        id_po,
                        no_faktur nomor_faktur,
                        no_bbm,
                        tanggal tanggal_faktur,
                        tanggal_tempo jatuh_tempo,
                        id_vendor id_rekanan,
                        nama_vendor nama_rekanan,
                        total_tagihan,
                        (total_tagihan - total_dibayar) sisa_tagihan,
                        diskon diskon_global,
                        t_diskon t_diskon_global,
                        materai,
                        use_ppn
                    FROM
                        smis_gu_barang_masuk
                    WHERE
                        prop = ''
                            AND id = '" . $id . "'
                ");
                if ($header_row != null) {
                    $data['header']['id'] = $header_row->id;
                    $data['header']['id_opl'] = $header_row->id_po;
                    $data['header']['asal_faktur'] = "gudang_umum";
                    $data['header']['nomor_faktur'] = $header_row->nomor_faktur;
                    $data['header']['no_bbm'] = $header_row->no_bbm;
                    $data['header']['tanggal_faktur'] = ArrayAdapter::format("date d-m-Y", $header_row->tanggal_faktur);
                    $data['header']['jatuh_tempo'] = ArrayAdapter::format("date d-m-Y", $header_row->jatuh_tempo);
                    $data['header']['id_rekanan'] = $header_row->id_rekanan;
                    $data['header']['nama_rekanan'] = $header_row->nama_rekanan;
                    $data['header']['total_tagihan'] = ArrayAdapter::format("only-money", $header_row->total_tagihan);
                    $data['header']['sisa_tagihan'] = ArrayAdapter::format("only-money", $header_row->sisa_tagihan);

                    $detail_rows = $this->dbtable->get_result("
                        SELECT
                            kode_barang kode,
                            nama_barang barang,
                            nama_jenis_barang jenis,
                            jumlah,
                            satuan,
                            hna harga,
                            diskon diskon_detail,
                            t_diskon t_diskon_detail
                        FROM
                            smis_gu_dbarang_masuk
                        WHERE
                            id_barang_masuk = '" . $id . "'
                                AND prop = ''
                    ");
                    $total_1 = 0;
                    $html = "";
                    $nomor = 1;
                    if ($detail_rows != null) {
                        foreach ($detail_rows as $dr) {
                            $harga = $dr->harga;
                            if ($header_row->use_ppn == 1)
                                $harga = $dr->harga / 1.1;
                            $subtotal = $dr->jumlah * $harga;
                            $diskon = $dr->diskon_detail;
                            $f_diskon = ArrayAdapter::format("only-money", $dr->diskon);
                            if ($dr->t_diskon_detail == "persen") {
                                $diskon = $dr->diskon_detail * $subtotal / 100;
                                $f_diskon = $dr->diskon_detail . " %";
                            }
                            $subtotal = $subtotal - $diskon;
                            $total_1 += $subtotal;

                            $html .=    "<tr>";
                            $html .=        "<td>" . $nomor++ . "</td>";
                            $html .=        "<td>" . $dr->kode . "</td>";
                            $html .=        "<td>" . $dr->barang . "</td>";
                            $html .=        "<td>" . $dr->jenis . "</td>";
                            $html .=        "<td><div align='right'>" . $dr->jumlah . "</div></td>";
                            $html .=        "<td>" . $dr->satuan . "</td>";
                            $html .=        "<td><div align='right'>" . ArrayAdapter::format("only-money", $harga) . "</div></td>";
                            $html .=        "<td><div align='right'>" . $f_diskon . "</div></td>";
                            $html .=        "<td><div align='right'>" . ArrayAdapter::format("only-money", $subtotal) . "</div></td>";
                            $html .=    "</tr>";
                        }
                        $data['detail'] = $html;
                    }
                    $data['footer']['total_1'] = $total_1 == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_1);
                    $diskon = $header_row->diskon_global;
                    if ($header_row->t_diskon_global == "persen")
                        $diskon = $total_1 * $header_row->diskon_global / 100;
                    $data['footer']['diskon'] = $diskon == 0 ? "0,00" : ArrayAdapter::format("only-money", $diskon);
                    $total_2 = $total_1 - $diskon;
                    $data['footer']['total_2'] = $total_2 == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_2);
                    $ppn = 0;
                    if ($header_row->use_ppn == 1)
                        $ppn = $total_2 * 0.1;
                    $data['footer']['ppn'] = $ppn == 0 ? "0,00" : ArrayAdapter::format("only-money", $ppn);
                    $materai = $header_row->materai;
                    $data['footer']['materai'] = $materai == 0 ? "0,00" : ArrayAdapter::format("only-money", $materai);
                    $data['footer']['tagihan'] = ArrayAdapter::format("only-money", $header_row->total_tagihan);
                }
            }

            return (object) $data;
        }
    }
?>