<?php
    class KBMutasiAntarKasBankDBResponder extends DBResponder {
        public function command($command) {
            if (
                $command != "export_xls" && 
                $command != "export_pdf" && 
                $command != "print_jurnal" &&
                $command != "new_row" &&
                $command != "save" &&
                $command != "lock_draft" &&
                $command != "post_journal"
            )
                return parent::command($command);
            if ($command == "export_pdf")
                return $this->exportPDF();
            else if ($command == "export_xls") {
                $this->exportXLS();
                return;
            } else if ($command == "print_jurnal")
                return $this->printJurnal();
            else if ($command == "new_row")
                return $this->newRow();
            else if ($command == "save")
                return $this->save();
            else if ($command == "lock_draft")
                return $this->lockDraft();
            else if ($command == "post_journal")
                return $this->postJournal();
        }

        public function newRow() {
            $row_num = $_POST['row_num'];
            $akun_rows = $this->dbtable->get_result("
                SELECT 
                    *
                FROM
                    smis_ac_account
                WHERE
                    prop = '' 
                        AND id_parent <> 0
                        AND have_child = 0
                        AND nama_tipe NOT LIKE 'Kas & Setara Kas'
                ORDER BY
                    nomor ASC
            ");
            $akun_option = new OptionBuilder();
            $akun_option->add("", "", "1");
            if ($akun_rows != null)
                foreach ($akun_rows as $akun_row)
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
            $akun_select = new Select("kb_mutasi_antar_kas_bank_detail_akun", "kb_mutasi_antar_kas_bank_detail_akun", $akun_option->getContent());
            $akun_select->setClass("detail_select2");
            $keterangan_textarea = new TextArea("kb_mutasi_antar_kas_bank_detail_keterangan", "kb_mutasi_antar_kas_bank_detail_keterangan", "");
            $keterangan_textarea->setLine(1);
            $keterangan_textarea->setClass("detail_textarea");
            $kredit_text = new Text("kb_mutasi_antar_kas_bank_detail_kredit", "kb_mutasi_antar_kas_bank_detail_kredit", "0,00");
            $kredit_text->setTypical("money");
            $kredit_text->setClass("detail_money");
            $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
            $delete_button_html = "<a href='#' onclick='kb_mutasi_antar_kas_bank.deleteDetail(\"detail_" . $row_num . "\")' id='' class='input btn btn btn-danger'><i class='fa fa-trash'></i></a>";
            $html =     "<tr id='detail_" . $row_num . "'>" .
                            "<td id='detail_id' style='display: none;'></td>" .
                            "<td id='detail_nomor'></td>" .
                            "<td id='detail_akun'>" . $akun_select->getHtml() . "</td>" .
                            "<td id='detail_uraian'>" . $keterangan_textarea->getHtml() . "</td>" .
                            "<td id='detail_kredit'>" . $kredit_text->getHtml() . "</td>" .
                            "<td>" . $delete_button_html . "</td>" .
                        "</tr>";
            $data = array(
                'html'      => $html,
                'id_row'    => "detail_" . $row_num
            );
            return $data;
        } 

        public function lockDraft() {
            $id_draft_jurnal = $this->dbtable->get_var("
                SELECT
                    id_draft_jurnal
                FROM
                    smis_fnc_mutasi_antar_kas_bank
                WHERE
                    id = '" . $_POST['id'] . "'
            ");
            $identifier = [
                'id' => $id_draft_jurnal
            ];
            $data = [
                'lock_draft' => 1
            ];
            $result = $this->dbtable->update($data, $identifier);
            return [
                'result'    => $result,
                'id'        => $_POST['id']
            ];
        }
        
        public function save() {
            $result = true;

            $j_jurnal = "Mutasi Kas Bank";
            global $user;
            $operator = $user->getNameOnly();
            $tanggal_input = date("Y-m-d H:i:s");
            $id = $_POST['id'];    
            $id_draft_jurnal = $_POST['id_draft_jurnal'];       
            $tanggal_part = explode(" ", $_POST['tanggal']);
            $tanggal = DateTime::createFromFormat("d-m-Y", $tanggal_part[0])->format("Y-m-d") . " " . $tanggal_part[1];
            $nomor = $_POST['nomor'];
            $keterangan = $_POST['keterangan'];
            $asal_akun_part = explode(" - ", $_POST['asal_akun'], 2);
            $asal_nomor_akun = $asal_akun_part[0];
            $asal_nama_akun = $asal_akun_part[1];
            $tujuan_akun_part = explode(" - ", $_POST['tujuan_akun'], 2);
            $tujuan_nomor_akun = $tujuan_akun_part[0];
            $tujuan_nama_akun = $tujuan_akun_part[1];
            $nilai = $_POST['kredit'];

            $mutasi_antar_kas_bank_dbtable = new DBTable($this->dbtable->get_db(), "smis_fnc_mutasi_antar_kas_bank");
            $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_draft_jurnal");
            $jurnal_data = array(
                'j_jurnal'      => $j_jurnal,
                'operator'      => $operator,
                'tanggal_input' => $tanggal_input,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor,
                'keterangan'    => $keterangan,
                'nilai'         => $nilai,
                'id_jurnal'     => 0,
                'lock_draft'    => 0,
                'lock_acc'      => 0
            );
            $mutasi_antar_kas_bank_data = array(
                'id_draft_jurnal'       => $id_draft_jurnal,
                'operator'              => $operator,
                'tanggal_entri'         => $tanggal_input,
                'tanggal'               => $tanggal,
                'nomor'                 => $nomor,
                'keterangan'            => $keterangan,
                'asal_nomor_akun'       => $asal_nomor_akun,
                'asal_nama_akun'        => $asal_nama_akun,
                'tujuan_nomor_akun'     => $tujuan_nomor_akun,
                'tujuan_nama_akun'      => $tujuan_nama_akun,
                'nilai'                 => $nilai
            );

            if ($id_draft_jurnal == "" || $id_draft_jurnal == 0) {
                $jurnal_dbtable->insert($jurnal_data);
                $id_draft_jurnal = $jurnal_dbtable->get_inserted_id();
                $mutasi_antar_kas_bank_data['id_draft_jurnal'] = $id_draft_jurnal;
                $result = $mutasi_antar_kas_bank_dbtable->insert($mutasi_antar_kas_bank_data);
                $id = $mutasi_antar_kas_bank_dbtable->get_inserted_id();
            } else {
                $identifier['id'] = $id_draft_jurnal;
                $jurnal_dbtable->update($jurnal_data, $identifier);
                $identifier['id'] = $id;
                $result = $mutasi_antar_kas_bank_dbtable->update($mutasi_antar_kas_bank_data, $identifier);
            }

            $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_detail_draft_jurnal");
            $detail_rows = $detail_jurnal_dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    id_draft_jurnal = '" . $id_draft_jurnal . "'
            ");
            if ($detail_rows != null) {
                foreach ($detail_rows as $detail_row) {
                    if ($detail_row->debet > $detail_row->kredit) {
                        $id_akun = 0;
                        $id_tipeakun = 0;
                        $nama_tipeakun = "";
                        $coa_row = $this->dbtable->get_row("
                            SELECT
                                id id_akun,
                                tipe id_tipeakun,
                                nama_tipe nama_tipeakun
                            FROM
                                smis_ac_account
                            WHERE
                                nomor LIKE '" . $tujuan_nomor_akun . "'
                                    AND prop = ''
                            ORDER BY
                                id DESC
                            LIMIT 
                                0, 1
                        ");
                        if ($coa_row != null) {
                            $id_akun = $coa_row->id_akun;
                            $id_tipeakun = $coa_row->id_tipeakun;
                            $nama_tipeakun = $coa_row->nama_tipeakun;
                        }
                        $detail_jurnal_data = array(
                            'id_draft_jurnal'   => $id_draft_jurnal,
                            'nomor_account'     => $tujuan_nomor_akun,
                            'nama_account'      => $tujuan_nama_akun,
                            'keterangan'        => $keterangan,
                            'debet'             => $nilai,
                            'kredit'            => 0,
                            'id_akun'           => $id_akun,
                            'nomor'             => $nomor,
                            'id_tipeakun'       => $id_tipeakun,
                            'nama_tipeakun'     => $nama_tipeakun,
                            'tanggal'           => $tanggal,
                            'j_jurnal'          => $j_jurnal
                        );
                        $identifier['id'] = $detail_row->id;
                        $detail_jurnal_dbtable->update($detail_jurnal_data, $identifier);
                    } else {
                        $id_akun = 0;
                        $id_tipeakun = 0;
                        $nama_tipeakun = "";
                        $coa_row = $this->dbtable->get_row("
                            SELECT
                                id id_akun,
                                tipe id_tipeakun,
                                nama_tipe nama_tipeakun
                            FROM
                                smis_ac_account
                            WHERE
                                nomor LIKE '" . $asal_nomor_akun . "'
                                    AND prop = ''
                            ORDER BY
                                id DESC
                            LIMIT 
                                0, 1
                        ");
                        if ($coa_row != null) {
                            $id_akun = $coa_row->id_akun;
                            $id_tipeakun = $coa_row->id_tipeakun;
                            $nama_tipeakun = $coa_row->nama_tipeakun;
                        }
                        $detail_jurnal_data = array(
                            'id_draft_jurnal'   => $id_draft_jurnal,
                            'nomor_account'     => $asal_nomor_akun,
                            'nama_account'      => $asal_nama_akun,
                            'keterangan'        => $keterangan,
                            'debet'             => 0,
                            'kredit'            => $nilai,
                            'id_akun'           => $id_akun,
                            'nomor'             => $nomor,
                            'id_tipeakun'       => $id_tipeakun,
                            'nama_tipeakun'     => $nama_tipeakun,
                            'tanggal'           => $tanggal,
                            'j_jurnal'          => $j_jurnal
                        );
                        $identifier['id'] = $detail_row->id;
                        $detail_jurnal_dbtable->update($detail_jurnal_data, $identifier);
                    }
                }
            } else {
                $id_akun = 0;
                $id_tipeakun = 0;
                $nama_tipeakun = "";
                $coa_row = $this->dbtable->get_row("
                    SELECT
                        id id_akun,
                        tipe id_tipeakun,
                        nama_tipe nama_tipeakun
                    FROM
                        smis_ac_account
                    WHERE
                        nomor LIKE '" . $tujuan_nomor_akun . "'
                            AND prop = ''
                    ORDER BY
                        id DESC
                    LIMIT 
                        0, 1
                ");
                if ($coa_row != null) {
                    $id_akun = $coa_row->id_akun;
                    $id_tipeakun = $coa_row->id_tipeakun;
                    $nama_tipeakun = $coa_row->nama_tipeakun;
                }
                $detail_jurnal_data = array(
                    'id_draft_jurnal'   => $id_draft_jurnal,
                    'nomor_account'     => $tujuan_nomor_akun,
                    'nama_account'      => $tujuan_nama_akun,
                    'keterangan'        => $keterangan,
                    'debet'             => $nilai,
                    'kredit'            => 0,
                    'id_akun'           => $id_akun,
                    'nomor'             => $nomor,
                    'id_tipeakun'       => $id_tipeakun,
                    'nama_tipeakun'     => $nama_tipeakun,
                    'tanggal'           => $tanggal,
                    'j_jurnal'          => $j_jurnal
                );
                $detail_jurnal_dbtable->insert($detail_jurnal_data);

                $id_akun = 0;
                $id_tipeakun = 0;
                $nama_tipeakun = "";
                $coa_row = $this->dbtable->get_row("
                    SELECT
                        id id_akun,
                        tipe id_tipeakun,
                        nama_tipe nama_tipeakun
                    FROM
                        smis_ac_account
                    WHERE
                        nomor LIKE '" . $asal_nomor_akun . "'
                            AND prop = ''
                    ORDER BY
                        id DESC
                    LIMIT 
                        0, 1
                ");
                if ($coa_row != null) {
                    $id_akun = $coa_row->id_akun;
                    $id_tipeakun = $coa_row->id_tipeakun;
                    $nama_tipeakun = $coa_row->nama_tipeakun;
                }
                $detail_jurnal_data = array(
                    'id_draft_jurnal'   => $id_draft_jurnal,
                    'nomor_account'     => $asal_nomor_akun,
                    'nama_account'      => $asal_nama_akun,
                    'keterangan'        => $keterangan,
                    'debet'             => 0,
                    'kredit'            => $nilai,
                    'id_akun'           => $id_akun,
                    'nomor'             => $nomor,
                    'id_tipeakun'       => $id_tipeakun,
                    'nama_tipeakun'     => $nama_tipeakun,
                    'tanggal'           => $tanggal,
                    'j_jurnal'          => $j_jurnal
                );
                $detail_jurnal_dbtable->insert($detail_jurnal_data);
            }

            $data = array(
                'result' => $result,
                'id'     => $id
            );
            return $data;
        }

        private function postJournal() {
            $id_draft_jurnal = $this->dbtable->get_var("
                SELECT
                    id_draft_jurnal
                FROM
                    smis_fnc_mutasi_antar_kas_bank
                WHERE
                    id = '" . $_POST['id'] . "'
            ");
            $result = true;

            $draft_jurnal_row = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_draft_jurnal
                WHERE
                    id = '" . $id_draft_jurnal . "'
            ");

            $j_jurnal = $draft_jurnal_row->j_jurnal;
            $operator = $draft_jurnal_row->operator;
            $tanggal_input = $draft_jurnal_row->tanggal_input;        
            $tanggal = $draft_jurnal_row->tanggal;
            require_once("accounting/function/new_transaksi_harian.php");
            $nomor = new_transaksi_harian_automatic($this->dbtable->get_db(), date("Y-m-d"), "MUT");
            $keterangan = $draft_jurnal_row->keterangan;
            $nilai = $draft_jurnal_row->nilai;

            $jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi");
            $jurnal_data = array(
                'j_jurnal'      => $j_jurnal,
                'operator'      => $operator,
                'tanggal_input' => $tanggal_input,
                'tanggal'       => $tanggal,
                'nomor'         => $nomor,
                'keterangan'    => $keterangan,
                'nilai'         => $nilai,
            );
            $result = $jurnal_dbtable->insert($jurnal_data);
            $id_jurnal = $jurnal_dbtable->get_inserted_id();

            $detail = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = ''
                        AND id_draft_jurnal = '" . $id_draft_jurnal . "'
                ORDER BY
                    id ASC
            ");
            if ($detail != null) {
                foreach ($detail as $d) {
                    $detail_jurnal_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_transaksi_detail");
                    $detail_jurnal_data = array(
                        'id_transaksi'      => $id_jurnal,
                        'nomor_account'     => $d->nomor_account,
                        'nama_account'      => $d->nama_account,
                        'keterangan'        => $d->keterangan,
                        'debet'             => $d->debet,
                        'kredit'            => $d->kredit,
                        'id_akun'           => $d->id_akun,
                        'nomor'             => $d->nomor,
                        'id_tipeakun'       => $d->id_tipeakun,
                        'nama_tipeakun'     => $d->nama_tipeakun,
                        'tanggal'           => $d->tanggal,
                        'j_jurnal'          => $d->j_jurnal
                    );
                    $result = $detail_jurnal_dbtable->insert($detail_jurnal_data);
                }
            }

            $draft_jurnal_data = [
                'id_jurnal' => $id_jurnal,
                'nomor'     => $nomor
            ];
            $draft_jurnal_identifier = [
                'id' => $id_draft_jurnal
            ];
            $this->dbtable->update($draft_jurnal_data, $draft_jurnal_identifier);

            return array(
                'result' => $result,
                'id'     => $_POST['id']
            );
        }

        private function exportXLS() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            require_once("smis-libs-out/php-excel/PHPExcel.php");

            $file = new PHPExcel();
            $file->getProperties()->setCreator("PT. Inovasi Ide Utama");
            $file->getProperties()->setTitle("Mutasi Antar Kas Bank");
            $file->getProperties()->setSubject("Mutasi Antar Kas Bank");
            $file->getProperties()->setDescription("Mutasi Antar Kas Bank - SIMRS");
            $file->getProperties()->setKeywords("Mutasi Antar Kas Bank");
            $file->getProperties()->setCategory("Mutasi Antar Kas Bank");

            $sheet = $file->getActiveSheet();
            $sheet->setTitle("Mutasi Antar Kas Bank");
            $i = 1;

            $sheet->mergeCells("A" . $i . ":E" . $i)->setCellValue("A" . $i, "MUTASI ANTAR KAS BANK");
            $sheet->getStyle("A" . $i . ":E" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Dari Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_dari));
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Sampai Tgl");
            $sheet->setCellValue("B" . $i, ": " . ArrayAdapter::format("date d-m-Y", $tanggal_sampai));
            $i = $i + 2;

            $border_start = $i;
            $col = "A";
            $head = array('No.', 'No. Jurnal', 'Tgl. Jurnal', 'Uraian', 'Dari', 'Akun Tujuan', 'Nilai');
            foreach ($head as $h)
                $sheet->setCellValue($col++ . $i, $h);
            $sheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i . ":G" . $i)->getFont()->setBold(true);
            $i = $i + 1;

            $data = $this->dbtable->get_result("
                SELECT
                    a.id, a.asal_nama_akun asal, a.tujuan_nama_akun tujuan, b.lock_acc, b.lock_draft, b.id_jurnal, b.nomor, b.tanggal, b.keterangan uraian, b.nilai
                FROM
                    smis_fnc_mutasi_antar_kas_bank a
                        LEFT JOIN smis_ac_draft_jurnal b ON a.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_detail_draft_jurnal c ON c.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_account d ON c.nomor_account = d.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND c.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND d.nama_tipe LIKE 'Kas & Setara Kas'
                        AND c.debet > c.kredit
                        AND c.debet > 0
                        AND b.j_jurnal LIKE 'Mutasi Kas Bank'
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ");
            $saldo_akhir = 0;
            if (count($data) > 0) {
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $sheet->setCellValue("A" . $i, $nomor++);
                    $sheet->setCellValue("B" . $i, $d->nomor);
                    $sheet->setCellValue("C" . $i, ArrayAdapter::format("date d-m-Y", $d->tanggal));
                    $sheet->setCellValue("D" . $i, $d->uraian);
                    $sheet->setCellValue("E" . $i, $d->asal);
                    $sheet->setCellValue("F" . $i, $d->tujuan);
                    $sheet->setCellValue("G" . $i, $d->nilai);
                    $sheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $total += $d->nilai;
                    $i = $i + 1;
                }
                $sheet->mergeCells("A" . $i . ":F" . $i)->setCellValue("A" . $i, "Total");
                $sheet->getStyle("A" . $i . ":F" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $sheet->setCellValue("G" . $i, $total);
                $sheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                $sheet->getStyle("A" . $i . ":G" . $i)->getFont()->setBold(true);
            }

            $thin = array();
            $thin['borders'] = array();
            $thin['borders']['allborders'] = array();
            $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
            $sheet->getStyle("A" . $border_start . ":G" . $i)->applyFromArray($thin);

            foreach (range('A', 'E') as $columnID)
                $sheet->getColumnDimension($columnID)->setAutoSize(true);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Mutasi Antar Kas Bank.xls"');
            header('Cache-Control: max-age=0');
            $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
            $writer->save('php://output');
            return;
        } 
        
        private function exportPDF() {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            require_once("finance/class/template/pdf.php");
			$fpdf = new PDF("L", "mm", "A4");
			$fpdf->SetMargins(5, 5);
		
            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "MUTASI ANTAR KAS BANK", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(25, 5, "Dari Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_dari), 0, 1);
            $fpdf->Cell(25, 5, "Sampai Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_sampai), 0, 1);
            $fpdf->Cell(25, 5, "Akun Kas Bank", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $akun, 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(15, 5, "No.", 1, 0, "C");
            $fpdf->Cell(40, 5, "No. Jurnal", 1, 0, "C");
            $fpdf->Cell(25, 5, "Tgl. Jurnal", 1, 0, "C");
            $fpdf->Cell(105, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(30, 5, "Dari", 1, 0, "C");
            $fpdf->Cell(30, 5, "Akun Tujuan", 1, 0, "C");
            $fpdf->Cell(40, 5, "Nilai", 1, 1, "C");
            $data = $this->dbtable->get_result("
                SELECT
                    a.id, a.asal_nama_akun asal, a.tujuan_nama_akun tujuan, b.lock_acc, b.lock_draft, b.id_jurnal, b.nomor, b.tanggal, b.keterangan uraian, b.nilai
                FROM
                    smis_fnc_mutasi_antar_kas_bank a
                        LEFT JOIN smis_ac_draft_jurnal b ON a.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_detail_draft_jurnal c ON c.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_account d ON c.nomor_account = d.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND c.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND d.nama_tipe LIKE 'Kas & Setara Kas'
                        AND c.debet > c.kredit
                        AND c.debet > 0
                        AND b.j_jurnal LIKE 'Mutasi Kas Bank'
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ");
            if (count($data) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                $nomor = 1;
                $total = 0;
                foreach ($data as $d) {
                    $fpdf->Cell(15, 5, $nomor++, 1, 0);
                    $fpdf->Cell(40, 5, $d->nomor, 1, 0);
                    $fpdf->Cell(25, 5, ArrayAdapter::format("date d-m-Y", $d->tanggal), 1, 0);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(105, 5, $d->uraian, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(185, 5, "", 0, 0, "");
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(30, 5, $d->asal, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(215, 5, "", 0, 0, "");
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(30, 5, $d->tujuan, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(245, 5, "", 0, 0, "");
                    $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $d->nilai), 1, 1, "R");
                    $total += $d->nilai;
                }
                $fpdf->SetFont("Arial", "B", 9);
                $fpdf->Cell(245, 5, "Total", 1, 0, "R");
                $fpdf->Cell(40, 5, ArrayAdapter::format("only-money", $total), 1, 1, "R");
            }

			global $user;
		    $md5 = md5(date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "penerimaan.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        } 
        
        private function printJurnal() {
            $id_draft_jurnal = $this->dbtable->get_var("
                SELECT
                    id_draft_jurnal
                FROM
                    smis_fnc_mutasi_antar_kas_bank
                WHERE
                    id = '" . $_POST['id'] . "'
            ");
            $header_jurnal = $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_ac_draft_jurnal
                WHERE
                    id = '" . $id_draft_jurnal . "'
            ");
            $detail_jurnal = $this->dbtable->get_result("
                SELECT
                    *
                FROM
                    smis_ac_detail_draft_jurnal
                WHERE
                    prop = '' 
                        AND id_draft_jurnal = '" . $id_draft_jurnal . "'
                ORDER BY
                    debet DESC, id ASC
            ");

            require_once("finance/class/template/pdf.php");
            $fpdf = new PDF("L", "mm", "A4");
            $fpdf->SetMargins(5, 5);

            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "JURNAL MUTASI ANTAR KAS BANK", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Nomor", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->nomor, 0, 1);
            $fpdf->Cell(25, 5, "Tanggal", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1);

            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(100, 5, "No. - Nama Akun", 1, 0, "C");
            $fpdf->Cell(105, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(40, 5, "Debit", 1, 0, "C");
            $fpdf->Cell(40, 5, "Kredit", 1, 1, "C");

            if (count($detail_jurnal) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                foreach ($detail_jurnal as $d) {
                    $f_debet = $d->debet == 0 ? "0,00" : ArrayAdapter::format("only-money", $d->debet);
                    $f_kredit = $d->kredit == 0 ? "0,00" : ArrayAdapter::format("only-money", $d->kredit);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(100, 5, $d->nomor_account . " - " . $d->nama_account, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->Cell(100, 5, "", 0, 0, "");
                    $fpdf->MultiCell(105, 5, $d->keterangan, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(205, 5, "", 0, 0, "");
                    $fpdf->Cell(40, 5, $f_debet, 1, 0, "R");
                    $fpdf->Cell(40, 5, $f_kredit, 1, 1, "R");
                }
            }

            $fpdf->Cell(285, 5, "", 0, 1);
            $fpdf->Cell(25, 5, "Deintrikan oleh", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $header_jurnal->operator, 0, 1);
            $fpdf->Cell(25, 5, "Dientrikan pada", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y, H:i", $header_jurnal->tanggal_input), 0, 1);

            global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "jurnal_penerimaan.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
            return $pathfile;
        } 
        
        public function edit() {
            $id = $_POST['id'];
            return $this->dbtable->get_row("
                SELECT
                    *
                FROM
                    smis_fnc_mutasi_antar_kas_bank
                WHERE
                    id = '" . $id . "'
            ");
        }

        public function delete() {
            $response = parent::delete();

            if ($response['success'] == 1) {
                $id_draft_jurnal = $this->dbtable->get_var("
                    SELECT
                        id_draft_jurnal
                    FROM
                        smis_fnc_mutasi_antar_kas_bank
                    WHERE
                        id = '" . $_POST['id'] . "'
                ");
                $transaksi_detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_ac_detail_draft_jurnal");
                $data_transaksi_detail = array(
                    'prop'  => "del"
                );
                $identifier = array(
                    'id_draft_jurnal'    => $id_draft_jurnal
                );
                $result = $transaksi_detail_dbtable->update($data_transaksi_detail, $identifier);
                if ($result === false)
                    $response['success'] = 0;
            }

            return $response;
        }
    }
?>