<?php
	class EResepPDF {
        protected $_db;

		protected $_font_face;
		protected $_paper_size_w;
		protected $_paper_size_h;
		protected $_left_margin;
        protected $_top_margin;
        
        protected $_header_row;
        protected $_detail_rows;

        protected $_nama_user;

		public function __construct($db, $id, $nama_user) {
            $this->_db              = $db; 

			$this->_font_face 	    = "Arial";
			$this->_paper_size_w    = 214;
			$this->_paper_size_h    = 450;
			$this->_left_margin     = 0;
            $this->_top_margin 	    = 0;
            
            $this->_nama_user = $nama_user;

            $this->_header_row = $db->get_row("
            	SELECT
            		*
            	FROM
            		smis_er_resep
            	WHERE
            		id = '" . $id . "'
            ");
            $this->_detail_rows = $db->get_result("
            	SELECT
            		*
            	FROM
            		smis_er_dresep
            	WHERE
            		id_resep = '" . $id . "'
            			AND prop LIKE ''
            ");
		}

		public function Draw() {
			require_once("e_resep/pdf/PDF.php");
			$fpdf = new PDF("P", "mm", "A4");// array($this->_paper_size_w, $this->_paper_size_h));
			$fpdf->SetTopMargin($this->_top_margin);
			$fpdf->SetLeftMargin($this->_left_margin);
			
			$nama_instansi = getSettings($this->_db, "smis_autonomous_title", "RUMAH SAKIT");
			$alamat_instansi = getSettings($this->_db, "smis_autonomous_address", "ALAMAT");
			$kota_instansi = getSettings($this->_db, "smis_autonomous_town", "Kota");
			$img_ttd_url = "";
			if ($this->_header_row->is_doctor_entry) {
				$img_ttd_url = $this->_db->get_var("
					SELECT
						ttd
					FROM
						smis_hrd_employee
					WHERE
						prop LIKE ''
							AND nama LIKE '" . $this->_header_row->nama_dokter . "'
					ORDER BY 
						id DESC
					LIMIT
						0, 1
				");
			}
			$border = 0;

			$fpdf->AddPage();
			$fpdf->SetX(0);
            $fpdf->SetY(0);
			
			$fpdf->Cell($this->_paper_size_w, 2, "", $border, 1);

			$sectionAStartX = $fpdf->GetX();
			$sectionAStartY = $fpdf->GetY();

			$fpdf->SetFont($this->_font_face, "B", 12);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, $nama_instansi, $border, 0, "C");
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->SetFont($this->_font_face, "", 12);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, $alamat_instansi, $border, 0, "C");
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell($this->_paper_size_w, 5.5, "", $border, 1);			

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Dokter", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . $this->_header_row->nama_dokter, $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "SIP", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . $this->_header_row->sip_dokter, $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Unit Pelayanan", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . ArrayAdapter::format("unslug", $this->_header_row->ruangan), $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Catatan Obat Racikan", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ":", $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->MultiCell($this->_paper_size_w - 8, 5.5, $this->_header_row->catatan_obat_racikan, "J", false, 0);

			$sectionAEndX = $fpdf->GetX();
			$sectionAEndY = $fpdf->GetY();

			$sectionAHeight = $sectionAEndY - $sectionAStartY;
			$fpdf->SetXY($sectionAStartX + 2, $sectionAStartY);
			$fpdf->Cell($this->_paper_size_w - 8, $sectionAHeight, "", 1, 1);

			$sectionBStartX = $fpdf->GetX();
			$sectionBStartY = $fpdf->GetY();

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, $kota_instansi . ", " . ArrayAdapter::format("date d-m-Y", $this->_header_row->tanggal), $border, 0, "R");
			$fpdf->Cell(2, 5.5, "", $border, 1);

			if ($this->_detail_rows != null) {
				foreach ($this->_detail_rows as $detail_row) {
					// $aturan_pakai_sehari = $detail_row->jumlah_pakai_sehari > 0 ? $detail_row->jumlah_pakai_sehari . " x SEHARI " . $detail_row->takaran_pakai . " " . $detail_row->satuan_pakai : "-";
					$aturan_pakai_sehari = "S " . $detail_row->signa;

					$fpdf->Cell(2, 5.5, "", $border, 0);
					$fpdf->Cell($this->_paper_size_w - 8, 5.5, "R/", $border, 0);
					$fpdf->Cell(2, 5.5, "", $border, 1);					

					$fpdf->Cell(2, 5.5, "", $border, 0);
					$fpdf->Cell(0.05 * ($this->_paper_size_w - 8), 5.5, "", $border, 0);
					$fpdf->Cell(0.55 * ($this->_paper_size_w - 8), 5.5, $detail_row->nama_obat, $border, 0);
					$fpdf->Cell(0.2 * ($this->_paper_size_w - 8), 5.5, $aturan_pakai_sehari, $border, 0, "R");
					$fpdf->Cell(0.1 * ($this->_paper_size_w - 8), 5.5, "No. " . $detail_row->jumlah, $border, 0, "R");
					$fpdf->Cell(0.1 * ($this->_paper_size_w - 8), 5.5, $detail_row->satuan, $border, 0);
					$fpdf->Cell(2, 5.5, "", $border, 1);					
				}
				$fpdf->Cell(2, 5.5, "", $border, 0);
				$fpdf->Cell($this->_paper_size_w - 8, 5.5, "", $border, 0);
				$fpdf->Cell(2, 5.5, "", $border, 1);									
			}

			$sectionBEndX = $fpdf->GetX();
			$sectionBEndY = $fpdf->GetY();	

			$sectionBHeight = $sectionBEndY - $sectionBStartY;
			$fpdf->SetXY($sectionBStartX + 2, $sectionBStartY);
			$fpdf->Cell($this->_paper_size_w - 8, $sectionBHeight, "", 1, 1);

			$sectionCStartX = $fpdf->GetX();
			$sectionCStartY = $fpdf->GetY();		

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Nama Pasien", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . $this->_header_row->nama_pasien, $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "No. Reg", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . ArrayAdapter::format("only-digit6", $this->_header_row->noreg_pasien), $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "No. RM", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . ArrayAdapter::format("only-digit6", $this->_header_row->nrm_pasien), $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Alamat", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": ", $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->MultiCell($this->_paper_size_w - 8, 5.5, $this->_header_row->alamat_pasien, "J", false, 0);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Jenis Pasien", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . ArrayAdapter::format("unslug", $this->_header_row->jenis), $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);			

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Perusahaan", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . $this->_header_row->perusahaan, $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell(0.3 * ($this->_paper_size_w - 8), 5.5, "Asuransi", $border, 0);
			$fpdf->Cell(0.7 * ($this->_paper_size_w - 8), 5.5, ": " . $this->_header_row->asuransi, $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$sectionCEndX = $fpdf->GetX();
			$sectionCEndY = $fpdf->GetY();		

			$sectionCHeight = $sectionCEndY - $sectionCStartY;
			$fpdf->SetXY($sectionCStartX + 2, $sectionCStartY);
			$fpdf->Cell($this->_paper_size_w - 8, $sectionCHeight, "", 1, 1);

			$sectionDStartX = $fpdf->GetX();
			$sectionDStartY = $fpdf->GetY();	

			if ($img_ttd_url != "") {
				$fpdf->Image("smis-upload/" . $img_ttd_url, $this->_paper_size_w / 2 - 0.5 * 20, $fpdf->GetY(), 20, 20);
			}
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, "", $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, "", $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, "", $border, 0);
			$fpdf->Cell(2, 5.5, "", $border, 1);
			$fpdf->Cell(2, 5.5, "", $border, 0);
			$fpdf->Cell($this->_paper_size_w - 8, 5.5, $this->_header_row->nama_dokter, $border, 0, "C");
			$fpdf->Cell(2, 5.5, "", $border, 1);

			$sectionDEndX = $fpdf->GetX();
			$sectionDEndY = $fpdf->GetY();		

			$sectionDHeight = $sectionDEndY - $sectionDStartY;
			$fpdf->SetXY($sectionDStartX + 2, $sectionDStartY);
			$fpdf->Cell($this->_paper_size_w - 8, $sectionDHeight, "", 1, 1);

		    $md5 = md5(date("Ymd_His") . "_" . $this->_nama_user);
			$filename = "eresep.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			return $pathfile;
		}
	}
?>