function RacikanAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
RacikanAction.prototype.constructor = RacikanAction;
RacikanAction.prototype = new TableAction();
RacikanAction.prototype.hide_form = function() {
	$("#racikan_form_section").hide();
	$("#e_resep_form").show();
};
RacikanAction.prototype.show_form = function() {
	$("#racikan_form_section").show();
	$("#e_resep_form").hide();
};
RacikanAction.prototype.clear = function() {
	$("#racikan_row_num").val("");
	$("#racikan_label").val("");
	$("#racikan_id_apoteker").val("");
	$("#racikan_name_apoteker").val("");
	$("#racikan_nama_apoteker").val("");
	$("#racikan_jumlah_kemasan").val("1");
	$("#dracikan_list").html("");
	$("#subtotal_racikan").html("<small><div align='right'>0,00</div></small>");
	$("#biaya_racik_racikan").html("<small><div align='right'>" + parseFloat($("#resep_biaya_racik_bahan_racikan").val()).formatMoney("2", ".", ",") + "</div></small>");
	$("#total_racikan").html("<small><div align='right'>0,00</div></small>");

	this.resetAturanPakai();
};
RacikanAction.prototype.cancel = function() {
	dracikan.clear();
	dracikan.add_mode();
	this.clear();
	this.hide_form();
};
RacikanAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	$(".error_field").removeClass("error_field");
	var jumlah_bahan = $("#dracikan_list tr").length;
	if (jumlah_bahan == 0) {
		valid = false;
		invalid_msg += "</br><strong>Detail Bahan Racikan</strong> tidak boleh kosong.";
	} 
	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
RacikanAction.prototype.save = function() {
	if (!this.validate())
		return;
	var r_num = $("#racikan_row_num").val();
	var label = $("#racikan_label").val();
	var id_apoteker = $("#racikan_id_apoteker").val();
	var nama_apoteker = $("#racikan_name_apoteker").val();
	var jumlah_kemasan = $("#racikan_jumlah_kemasan").val();

	var obat_luar = $("#racikan_obat_luar").val();
    var tanggal_exp = $("#racikan_tanggal_exp").val();
    var jumlah_pakai_sehari = $("#racikan_jumlah_pakai_sehari").val();
    var satuan_pakai = $("#racikan_satuan_pakai").val();
    var takaran_pakai = $("#racikan_takaran_pakai").val();
    var pemakaian = $("#racikan_pemakaian").val();
    var pemakaian_obat_luar = $("#racikan_pemakaian_obat_luar").val();

	var embalase_racikan = 0;
	var tuslah_racikan = 0;
	var biaya_racik_racikan = parseFloat($("#resep_biaya_racik_bahan_racikan").val()) * parseFloat(jumlah_kemasan);
	var harga_racikan = 0;

	if (r_num == "") {
		var last_racikan_num = 0;
		var num_rows = $("#dresep_list tr").length;
		for (var i = 0; i < num_rows; i++) {
			if ($("#dresep_list tr:eq(" + i + ") td#is_racikan").text() == "1") {
				var racikan_num = parseFloat($("#dresep_list tr:eq(" + i + ") td#nama_racikan").text().replace("RACIKAN #", ""));
				if (racikan_num > last_racikan_num)
					last_racikan_num = racikan_num;
			}
		}
		r_num = num_rows;
		label = "RACIKAN #" + parseFloat(last_racikan_num + 1);

		var dresep_row_num = $("#resep_dresep_row_num").val();
		$("#resep_dresep_row_num").val(parseFloat(dresep_row_num) + 1);
		var row_label = "detail_" + (parseFloat(dresep_row_num) + 1);

		var num_rows = $("#dracikan_list tr").length;
		for (var i = 0; i < num_rows; i++) {
			var id_obat = $("#dracikan_list tr:eq(" + i + ") td#id_obat").text();
			var kode_obat = $("#dracikan_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("#dracikan_list tr:eq(" + i + ") td#nama_obat").text();
			var nama_jenis_obat = $("#dracikan_list tr:eq(" + i + ") td#nama_jenis_obat").text();
			var jumlah = $("#dracikan_list tr:eq(" + i + ") td#jumlah").text();
			var satuan = $("#dracikan_list tr:eq(" + i + ") td#satuan").text();
			var konversi = 1;
			var satuan_konversi = $("#dracikan_list tr:eq(" + i + ") td#satuan").text();
			var harga = $("#dracikan_list tr:eq(" + i + ") td#harga").text();
			var embalase = $("#dracikan_list tr:eq(" + i + ") td#embalase").text();
			var tuslah = $("#dracikan_list tr:eq(" + i + ") td#tuslah").text();

			$("#r_bahan_list").append(
				"<tr class='bahan_" + row_label + "'>" +
					"<td id='id_obat'>" + id_obat + "</td>" +
					"<td id='kode_obat'>" + kode_obat + "</td>" +
					"<td id='nama_obat'>" + nama_obat + "</td>" +
					"<td id='nama_jenis_obat'>" + nama_jenis_obat + "</td>" +
					"<td id='jumlah'>" + jumlah + "</td>" +
					"<td id='satuan'>" + satuan + "</td>" +
					"<td id='konversi'>" + konversi + "</td>" +
					"<td id='satuan_konversi'>" + satuan_konversi + "</td>" +
					"<td id='harga'>" + harga + "</td>" +
					"<td id='embalase'>" + embalase + "</td>" +
					"<td id='tuslah'>" + tuslah + "</td>" +
				"</tr>"
			);
			embalase_racikan = parseFloat(embalase_racikan) + parseFloat(embalase);
			tuslah_racikan = parseFloat(tuslah_racikan) + parseFloat(tuslah);
			harga_racikan = parseFloat(harga_racikan) + parseFloat(jumlah) * parseFloat(harga);
		}
		var subtotal_racikan = parseFloat(harga_racikan) + parseFloat(embalase_racikan) + parseFloat(tuslah_racikan) + parseFloat(biaya_racik_racikan);
		var f_subtotal_racikan = parseFloat(subtotal_racikan).formatMoney("2", ".", ",");
		var f_harga_racikan = parseFloat(harga_racikan).formatMoney("2", ".", ",");
		var f_embalase_racikan = parseFloat(embalase_racikan).formatMoney("2", ".", ",");
		var f_tuslah_racikan = parseFloat(tuslah_racikan).formatMoney("2", ".", ",");
		var f_biaya_racik_racikan = parseFloat(biaya_racik_racikan).formatMoney("2", ".", ",");
		$("#dresep_list").append(
			"<tr class='" + row_label + "'>" +
				"<td id='nomor'></td>" +
				"<td id='is_racikan' style='display: none;'>1</td>" +
				"<td id='kode'><small>-</small></td>" +
				"<td id='nama_racikan'><small>" + label + "</small></td>" +

				"<td id='tanggal_exp' style='display: none;'>" + tanggal_exp + "</td>" +
		        "<td id='obat_luar' style='display: none;'>" + obat_luar + "</td>" +
		        "<td id='jumlah_pakai_sehari' style='display: none;'>" + jumlah_pakai_sehari + "</td>" +
		        "<td id='satuan_pakai' style='display: none;'>" + satuan_pakai + "</td>" +
		        "<td id='takaran_pakai' style='display: none;'>" + takaran_pakai + "</td>" +
		        "<td id='pemakaian' style='display: none;'>" + pemakaian + "</td>" +
		        "<td id='pemakaian_obat_luar' style='display: none;'>" + pemakaian_obat_luar + "</td>" +

				"<td id='jumlah' style='display: none;'>" + jumlah_kemasan + "</td>" +
				"<td id='satuan' style='display: none;'>Kemasan</td>" +
				"<td id='f_jumlah'><small>" + jumlah_kemasan + " Kemasan</small></td>" +
				"<td id='harga' style='display: none;'>" + harga_racikan + "</td>" +
				"<td id='f_harga'><small><div align='right'>" + f_harga_racikan + "</div></small></td>" +
				"<td id='embalase' style='display: none;'>" + embalase_racikan + "</td>" +
				"<td id='f_embalase'><small><div align='right'>" + f_embalase_racikan + "</div></small></td>" +
				"<td id='embalase' style='display: none;'>" + tuslah_racikan + "</td>" +
				"<td id='f_embalase'><small><div align='right'>" + f_tuslah_racikan + "</div></small></td>" +
				"<td id='biaya_racik' style='display: none;'>" + biaya_racik_racikan + "</td>" +
				"<td id='f_biaya_racik'><small><div align='right'>" + f_biaya_racik_racikan + "</div></small></td>" +
				"<td id='subtotal' style='display: none;'>" + subtotal_racikan + "</td>" +
				"<td id='f_subtotal'><small><div align='right'>" + f_subtotal_racikan + "</div></small></td>" +
				"<td class='preview_button'><center>" +
					"<a href='#' id='preview_button' class='input btn btn-info'>" +
						"<i class='icon-eye-open icon-white'></i>" +
					"</a>" +
				"</center></td>" +
				"<td id='id_apoteker' style='display: none;'>" + id_apoteker + "</td>" +
				"<td id='nama_apoteker'><small>" + nama_apoteker + "</small></td>" +
				"<td class='edit_button'></td>" +
				"<td class='del_button'></td>" +
			"</tr>"
		);
	} else {
		var row_label = $("#dresep_list tr:eq(" + r_num + ")").prop("class");
		$("#r_bahan_list tr.bahan_" + row_label).remove();
		var num_rows = $("#dracikan_list tr").length;
		for (var i = 0; i < num_rows; i++) {
			var id_obat = $("#dracikan_list tr:eq(" + i + ") td#id_obat").text();
			var kode_obat = $("#dracikan_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("#dracikan_list tr:eq(" + i + ") td#nama_obat").text();
			var nama_jenis_obat = $("#dracikan_list tr:eq(" + i + ") td#nama_jenis_obat").text();
			var jumlah = $("#dracikan_list tr:eq(" + i + ") td#jumlah").text();
			var satuan = $("#dracikan_list tr:eq(" + i + ") td#satuan").text();
			var konversi = 1;
			var satuan_konversi = $("#dracikan_list tr:eq(" + i + ") td#satuan").text();
			var harga = $("#dracikan_list tr:eq(" + i + ") td#harga").text();
			var embalase = $("#dracikan_list tr:eq(" + i + ") td#embalase").text();
			var tuslah = $("#dracikan_list tr:eq(" + i + ") td#tuslah").text();

			$("#r_bahan_list").append(
				"<tr class='bahan_" + row_label + "'>" +
					"<td id='id_obat'>" + id_obat + "</td>" +
					"<td id='kode_obat'>" + kode_obat + "</td>" +
					"<td id='nama_obat'>" + nama_obat + "</td>" +
					"<td id='nama_jenis_obat'>" + nama_jenis_obat + "</td>" +
					"<td id='jumlah'>" + jumlah + "</td>" +
					"<td id='satuan'>" + satuan + "</td>" +
					"<td id='konversi'>" + konversi + "</td>" +
					"<td id='satuan_konversi'>" + satuan_konversi + "</td>" +
					"<td id='harga'>" + harga + "</td>" +
					"<td id='embalase'>" + embalase + "</td>" +
					"<td id='tuslah'>" + tuslah + "</td>" +
				"</tr>"
			);
			embalase_racikan = parseFloat(embalase_racikan) + parseFloat(embalase);
			tuslah_racikan = parseFloat(tuslah_racikan) + parseFloat(tuslah);
			harga_racikan = parseFloat(harga_racikan) + parseFloat(jumlah) * parseFloat(harga);
		}
		var subtotal_racikan = parseFloat(harga_racikan) + parseFloat(embalase_racikan) + parseFloat(tuslah_racikan) + parseFloat(biaya_racik_racikan);
		var f_subtotal_racikan = parseFloat(subtotal_racikan).formatMoney("2", ".", ",");
		var f_harga_racikan = parseFloat(harga_racikan).formatMoney("2", ".", ",");
		var f_embalase_racikan = parseFloat(embalase_racikan).formatMoney("2", ".", ",");
		var f_tuslah_racikan = parseFloat(tuslah_racikan).formatMoney("2", ".", ",");
		var f_biaya_racik_racikan = parseFloat(biaya_racik_racikan).formatMoney("2", ".", ",");
		$("#dresep_list tr:eq(" + r_num + ") td#harga").html(harga_racikan);
		$("#dresep_list tr:eq(" + r_num + ") td#f_harga").html("<small>" + f_harga_racikan + "</small>");
		$("#dresep_list tr:eq(" + r_num + ") td#embalase").html(embalase_racikan);
		$("#dresep_list tr:eq(" + r_num + ") td#f_embalase").html("<small>" + f_embalase_racikan + "</small>");
		$("#dresep_list tr:eq(" + r_num + ") td#tuslah").html(tuslah_racikan);
		$("#dresep_list tr:eq(" + r_num + ") td#f_tuslah").html("<small>" + f_tuslah_racikan + "</small>");
		$("#dresep_list tr:eq(" + r_num + ") td#biaya_racik").html(biaya_racik_racikan);
		$("#dresep_list tr:eq(" + r_num + ") td#f_biaya_racik").html("<small>" + f_biaya_racik_racikan + "</small>");
		$("#dresep_list tr:eq(" + r_num + ") td#subtotal").html(subtotal_racikan);
		$("#dresep_list tr:eq(" + r_num + ") td#f_subtotal").html("<small>" + f_subtotal_racikan + "</small>");
		
		$("#dresep_list tr:eq(" + r_num + ") td#tanggal_exp").html(tanggal_exp);
        $("#dresep_list tr:eq(" + r_num + ") td#obat_luar").html(obat_luar);
        $("#dresep_list tr:eq(" + r_num + ") td#jumlah_pakai_sehari").html(jumlah_pakai_sehari);
        $("#dresep_list tr:eq(" + r_num + ") td#satuan_pakai").html(satuan_pakai);
        $("#dresep_list tr:eq(" + r_num + ") td#takaran_pakai").html(takaran_pakai);
        $("#dresep_list tr:eq(" + r_num + ") td#pemakaian").html(pemakaian);
        $("#dresep_list tr:eq(" + r_num + ") td#pemakaian_obat_luar").html(pemakaian_obat_luar);

		$("#dresep_list tr:eq(" + r_num + ") td#id_apoteker").html(id_apoteker);
		$("#dresep_list tr:eq(" + r_num + ") td#nama_apoteker").html("<small>" + nama_apoteker + "</small>");
		$("#dresep_list tr:eq(" + r_num + ") td#jumlah").html(jumlah_kemasan);
		$("#dresep_list tr:eq("+ r_num + ") td#f_jumlah").html("<small>" + jumlah_kemasan + " Kemasan</small>");
	}
	this.clear();
	this.hide_form();
	dresep.refreshTotal();
};
RacikanAction.prototype.resetAturanPakai = function() {
	$("#racikan_obat_luar").val("0");
    $("#racikan_tanggal_exp").val("");
    $("#racikan_jumlah_pakai_sehari").val("");
    $("#racikan_satuan_pakai").val("");
    $("#racikan_takaran_pakai").val("");
    $("#racikan_pemakaian").val("");
    $("#racikan_pemakaian_obat_luar").val("");	

    $(".racikan_jumlah_pakai_sehari").show();
    $(".racikan_satuan_pakai").show();
	$(".racikan_takaran_pakai").show();
	$(".racikan_pemakaian").show();
	$(".racikan_pemakaian_obat_luar").hide();
};