<?php 
	global $db;
	require_once("depo_farmasi_tanjung_uncang/library/InventoryLibrary.php");
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("depo_farmasi_tanjung_uncang/class/InlineConfirmControl.php");
	require_once("depo_farmasi_tanjung_uncang/table/PenjualanResepTable.php");
	require_once("depo_farmasi_tanjung_uncang/table/PasienTable.php");
	require_once("depo_farmasi_tanjung_uncang/table/DResepTable.php");
	require_once("depo_farmasi_tanjung_uncang/table/DObatRacikanTable.php");
	require_once("depo_farmasi_tanjung_uncang/table/BahanRacikanTable.php");
	require_once("depo_farmasi_tanjung_uncang/adapter/PenjualanResepAdapter.php");
	require_once("depo_farmasi_tanjung_uncang/adapter/ObatAdapter.php");
	require_once("depo_farmasi_tanjung_uncang/adapter/BahanAdapter.php");
	require_once("depo_farmasi_tanjung_uncang/adapter/PasienAdapter.php");
	require_once("depo_farmasi_tanjung_uncang/responder/PenjualanResepDBResponder.php");
	require_once("depo_farmasi_tanjung_uncang/responder/ObatDBResponder.php");
	require_once("depo_farmasi_tanjung_uncang/responder/BahanDBResponder.php");
	require_once("depo_farmasi_tanjung_uncang/responder/SisaDBResponder.php");
	require_once("hrd/class/responder/EmployeeChooserResponder.php");
	
	$resep_table = new PenjualanResepTable(
		array("No. Penjualan", "No. Resep", "Tanggal/Jam", "Dokter", "No. Registrasi", "NRM", "Pasien", "Alamat", "Kat. Pasien", "Jns. Pasien", "Perusahaan", "Asuransi", "Edukasi", "Status PCare"),
		"Farmasi : Penjualan Obat - Resep (KIUP)"
	);
	$resep_table->setName("resep");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == "resep") {
		if (isset($_POST['command'])) {
			if ($_POST['command'] == "get_current_date") {
				echo json_encode(
					array(
						"tanggal" => date("Y-m-d H:i")
					)
				);
				return;
			} else if ($_POST['command'] == "get_batal_berobat_info") {
				$rows = $db->get_result("
					SELECT noreg_pasien, nrm_pasien, nama_pasien, GROUP_CONCAT(nomor_resep) csv_nomor_resep
					FROM " . InventoryLibrary::$_TBL_PENJUALAN_RESEP . "
					WHERE prop = '' AND dibatalkan = 0 AND batal_berobat = 1 AND tipe = 'resep'
					GROUP BY noreg_pasien
				");
				$html = "";
				$show = 0;
				if ($rows != null) {
					$show = 1;
					$html = "<h4>Pasien Batal Berobat</h4>" .
							"<ul>";
					foreach ($rows as $r) {
						$html .= "<li>";
						$html .= "Pasien <b>" . $r->nama_pasien . " (NRM. " . ArrayAdapter::format("only-digit6", $r->nrm_pasien) . " / No. Reg. " . ArrayAdapter::format("only-digit8", $r->noreg_pasien) . ")</b> telah batal berobat, silakan membatalkan resep nomor : ";
						$nomor_resep_arr = explode(",", $r->csv_nomor_resep);
						if (count($nomor_resep_arr) > 0)
							foreach ($nomor_resep_arr as $nomor_resep)
								$html .= "<span class='badge badge-important'>" . $nomor_resep . "</span> ";	
						$html .= "</li>";
					}
					$html .= "</ul>";
				}
				$data = array(
					"html" 	=> $html,
					"show"	=> $show
				);
				echo json_encode($data);
				return;
			} else if ($_POST['command'] == "get_margin_penjualan") {
				/// mode margin :
				/// 0	=> paten
				/// 1 	=> jenis pasien
				/// 2 	=> obat
				/// 3 	=> obat dan jenis pasien
				$mode_margin = $_POST['mode_margin'];
				$jenis_pasien = $_POST['jenis_pasien'];
				$margin_penjualan = 0;
				if ($mode_margin == 0) {
					$margin_penjualan = getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-margin_penjualan", 0) / 100;
				} else if ($mode_margin == 1) {
					$dbtable = new DBTable($db, InventoryLibrary::$_TBL_MARGIN_JUAL_JENIS_PASIEN);
					$row = $dbtable->get_row("
						SELECT *
						FROM " . InventoryLibrary::$_TBL_MARGIN_JUAL_JENIS_PASIEN . "
						WHERE prop NOT LIKE 'del' AND slug = '" . $jenis_pasien . "'
					");
					if ($row != null)
						$margin_penjualan = $row->margin_jual / 100;
				}
				$data = array(
					"margin_penjualan" => $margin_penjualan
				);
				echo json_encode($data);
				return;
			} else if ($_POST['command'] == "status_pcare") {
				global $user;
				$id = $_POST['id'];
				$header_row = $db->get_row("
					SELECT
						*
					FROM
						" . InventoryLibrary::$_TBL_PENJUALAN_RESEP . "
					WHERE
						id = '" . $id . "'
				");
				$html = "";
				if ($header_row->dibatalkan == 0) {
					$action = "resep.resend_pcare(" . $id . ")";
					$btn = new Button("", "", "Kirim Ulang Data PCare");
					$btn->setAction($action);
					$btn->setClass("btn-inverse");
					$btn->setIcon("fa fa-refresh");
					$btn->setIsButton(Button::$ICONIC_TEXT);
					$detail_status_pcare_rows = $db->get_result("
						SELECT
							*
						FROM
							" . InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT . "
						WHERE
							prop LIKE ''
								AND id_penjualan_resep = '" . $id . "'
					");
					$is_success = true;
					$fail_message = "";
					$success_message = "";
					if ($user->isAdministrator()) {
						$html = "
							<table data-fix-header='n' class='table table-bordered table-hover table-striped table-condensed'>
								<thead>
									<tr class='inverse header_normal'>
										<th>ID Penjualan Resep</th>
										<th>ID Detail</th>
										<th>Racikan</th>
										<th>Request</th>
										<th>Response</th>
										<th>Status Code</th>
										<th>Status Message</th>
									</tr>
								</thead>
								<tbody>
						";
					}
					if ($detail_status_pcare_rows != null) {
						foreach ($detail_status_pcare_rows as $d) {
							if ($user->isAdministrator()) {
								$html .= "
									<tr>
										<td>" . $d->id_penjualan_resep . "</td>
										<td>" . $d->id_detail . "</td>
										<td>" . ($d->racikan == 1 ? "Ya" : "Tidak" ) . "</td>
										<td>" . json_encode(json_decode($d->json_request), JSON_PRETTY_PRINT) . "</td>
										<td>" . json_encode(json_decode($d->json_response), JSON_PRETTY_PRINT) . "</td>
										<td>" . $d->status_code . "</td>
										<td>" . $d->status_message . "</td>
									</tr>
								";
							}
							if ($d->status_code != 201) {
								$is_success = false;
								$fail_message = $d->status_message;
							} else {
								$success_message = $d->status_message;
							}
						}
					} else {
						if ($user->isAdministrator()) {
							$html .= "
								<tr>
									<td colspan='7'><center>Tidak ditemukan riwayat pengiriman data PCare.</center></td>
								</tr>
							";
						}
						$is_success = false;
					}
					if ($user->isAdministrator()) {
						$html .= "
								</tbody>
							</table>
						";
					}

					$html .= 	"<div class='alert alert-block alert-inverse'>" .
								 	"<h4>Status :</h4>" .
								 	"<strong>" . ($is_success ? "SUKSES" : "GAGAL") . "</strong>" .
								 	"<br/>" . ($is_success ? $success_message : $fail_message);

					if (!$is_success)
						$html .= "<br/>" . $btn->getHtml();
					$html .=	"</div>";
				} else if ($header_row->dibatalkan == 1) {
					$action = "resep.resend_cancel_pcare(" . $id . ")";
					$btn = new Button("", "", "Kirim Ulang Data PCare");
					$btn->setAction($action);
					$btn->setClass("btn-inverse");
					$btn->setIcon("fa fa-refresh");
					$btn->setIsButton(Button::$ICONIC_TEXT);
					$detail_status_pcare_rows = $db->get_result("
						SELECT
							*
						FROM
							" . InventoryLibrary::$_TBL_WS_BPJS_DELETE_OBAT . "
						WHERE
							prop LIKE ''
								AND id_penjualan_resep = '" . $id . "'
					");
					$is_success = true;
					$fail_message = "";
					$success_message = "";
					if ($user->isAdministrator()) {
						$html = "
							<table data-fix-header='n' class='table table-bordered table-hover table-striped table-condensed'>
								<thead>
									<tr class='inverse header_normal'>
										<th>ID Penjualan Resep</th>
										<th>ID Detail</th>
										<th>Racikan</th>
										<th>URL</th>
										<th>Status Code</th>
										<th>Status Message</th>
									</tr>
								</thead>
								<tbody>
						";
					}
					if ($detail_status_pcare_rows != null) {
						foreach ($detail_status_pcare_rows as $d) {
							if ($user->isAdministrator()) {
								$html .= "
									<tr>
										<td>" . $d->id_penjualan_resep . "</td>
										<td>" . $d->id_detail . "</td>
										<td>" . ($d->racikan == 1 ? "Ya" : "Tidak" ) . "</td>
										<td>" . $d->url . "</td>
										<td>" . $d->status_code . "</td>
										<td>" . $d->status_message . "</td>
									</tr>
								";
							}
							if ($d->status_code != 200) {
								$is_success = false;
								$fail_message = $d->status_message;
							} else {
								$success_message = $d->status_message;
							}
						}
					} else {
						if ($user->isAdministrator()) {
							$html .= "
								<tr>
									<td colspan='6'><center>Tidak ditemukan riwayat pengiriman data PCare.</center></td>
								</tr>
							";
						}
						$is_success = false;
					}
					if ($user->isAdministrator()) {
						$html .= "
								</tbody>
							</table>
						";
					}

					$html .= 	"<div class='alert alert-block alert-inverse'>" .
								 	"<h4>Status :</h4>" .
								 	"<strong>" . ($is_success ? "SUKSES" : "GAGAL") . "</strong>" .
								 	"<br/>" . ($is_success ? $success_message : $fail_message);

					if (!$is_success)
						$html .= "<br/>" .$btn->getHtml();
					$html .=	"</div>";
				}
				echo json_encode($html);
				return;
			} else if ($_POST['command'] == "resend_pcare") {
				require_once("depo_farmasi_tanjung_uncang/pcare/PCareObat.php");
				$pcare = new PCareObat();
				$pcare->setPCareAuthorization();

				$response = $pcare->resend($_POST['id']);
				echo json_encode($response);
				return;
			} else if ($_POST['command'] == "resend_cancel_pcare") {
				require_once("depo_farmasi_tanjung_uncang/pcare/PCareObatCancel.php");
				$pcare = new PCareObatCancel();
				$pcare->setPCareAuthorization();
				$response = $pcare->resend($_POST['id']);
				echo json_encode($response);
				return;
			}
			$resep_adapter = new PenjualanResepAdapter();
			$resep_dbtable = new DBTable($db, InventoryLibrary::$_TBL_PENJUALAN_RESEP);
			$resep_dbtable->addCustomKriteria("tipe", " LIKE 'resep' ");
			$resep_dbtable->setOrder(" id DESC ");
			$resep_dbresponder = new PenjualanResepDBResponder(
				$resep_dbtable,
				$resep_table,
				$resep_adapter
			);
			$data = $resep_dbresponder->command($_POST['command']);
			if (
				$resep_dbresponder->isSave() && 
				isset($_POST['noreg_pasien']) &&
				isset($_POST['jenis']) && $_POST['jenis'] == "bpjs" &&
				isset($_POST['asuransi']) && $_POST['asuransi'] == "BPJS - KESEHATAN" &&
				isset($data['content']['type']) && $data['content']['type'] == "insert" &&
				isset($data['content']['success']) && $data['content']['success'] == 1 &&
				isset($data['content']['id']) && $data['content']['id'] > 0
			) {
				/// PCare Obat (WS Add Obat) :
				require_once("depo_farmasi_tanjung_uncang/pcare/PCareObat.php");
				$pcare = new PCareObat();
				$pcare->setPCareAuthorization();

				$response = $pcare->proceed($_POST['noreg_pasien'], $data['content']['id']);
				$data['ws_response'] = $response;
				//. End of PCare Obat (WS Add Obat)
			} else if (
				$resep_dbresponder->isSave() && 
				isset($_POST['dibatalkan']) && $_POST['dibatalkan'] == 1 &&
				isset($data['content']['type']) && $data['content']['type'] == "update" &&
				isset($data['content']['success']) && $data['content']['success'] == 1 &&
				isset($data['content']['id']) && $data['content']['id'] > 0
			) {
				/// PCare Obat Cancel (WS Delete Obat) :
				require_once("depo_farmasi_tanjung_uncang/pcare/PCareObatCancel.php");
				$pcare = new PCareObatCancel();
				$pcare->setPCareAuthorization();
				$response = $pcare->proceed($data['content']['id']);
				$data['ws_response'] = $response;
				//. End of PCare Obat Cancel (WS Delete Obat)
			}
			echo json_encode($data);
			return;
		}
		return;
	}
	
	//patient service consumer:
	$pasien_table = new PasienTable(
		array("Tgl. Daftar", "No. BPJS", "NRM", "Nama", "Alamat", "Rawat Inap/Jalan", "Jns. Pasien"),
		"",
		null,
		true
	);
	$pasien_table->setName("pasien");
	$pasien_table->setModel(Table::$SELECT);
	$tanggal_daftar_text = new Text("search_tanggal", "search_tanggal", date("d-m-Y"));
	$tanggal_daftar_text->setAtribute("data-date-format='dd-mm-yyyy'");
	$tanggal_daftar_text->setClass("mydate search search-header-tiny search-text");
	$nobpjs_s_text = new Text("search_nobpjs", "search_nobpjs", "");
	$nobpjs_s_text->setClass("search search-header-tiny search-text");
	$nrm_s_text = new Text("search_nrm", "search_nrm", "");
	$nrm_s_text->addAtribute("autofocus");
	$nrm_s_text->setClass("search search-header-tiny search-text");
	$nama_s_text = new Text("search_nama", "search_nama", "");
	$nama_s_text->setClass("search search-header-med search-text ");
	$alamat_s_text = new Text("search_alamat", "search_alamat", "");
	$alamat_s_text->setClass("search search-header-big search-text");
	$uri_option = new OptionBuilder();
	$uri_option->add("Semua", "%", "1");
	$uri_option->add("Rawat Jalan", "0");
	$uri_option->add("Rawat Inap", "1");
	$uri_s_select = new Select("search_uri", "search_uri", $uri_option->getContent());
	$uri_s_select->setClass("search search-header-med search-combo");
	$carabayar_s_text = new Text("search_carabayar", "search_carabayar", "");
	$carabayar_s_text->setClass("search search-header-tiny search-text");
	$header = "<tr class = 'header_pasien'>" .
					"<td>" . $tanggal_daftar_text->getHtml() . "</td>" .
					"<td>" . $nobpjs_s_text->getHtml() . "</td>" .
					"<td>" . $nrm_s_text->getHtml() . "</td>" .
					"<td>" . $nama_s_text->getHtml() . "</td>" .
					"<td>" . $alamat_s_text->getHtml() . "</td>" .
					"<td>" . $uri_s_select->getHtml() . "</td>" .
					"<td>" . $carabayar_s_text->getHtml() . "</td>" .
			  "</tr>";
	$pasien_table->addHeader("after", $header);
	$pasien_adapter = new PasienAdapter();
	$pasien_service_responder = new ServiceResponder(
		$db,
		$pasien_table,
		$pasien_adapter,
		"get_registered_all"
	);
	if (
		isset($_POST['super_command']) && $_POST['super_command'] == "pasien" && 
		isset($_POST['command']) && $_POST['command'] == "list"
	) {
		$unit_kerja_depo = getSettings($db, "depo_farmasi_tanjung_uncang-misc-unit_kerja", "");
		$pasien_service_responder->addData('unit_kerja', $unit_kerja_depo);
	}
	
	//dokter service consumer:
	$dokter_service_responder = new EmployeeChooserResponder($db, "dokter", "dokter");
	
	//get obat chooser:
	$obat_table = new Table(array("Kode", "Obat", "Jenis", "Stok"));
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatAdapter();
	$obat_dbtable = new DBTable($db, InventoryLibrary::$_TBL_STOK_OBAT);
	$obat_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$jenis_pasien = "";
	if (isset($_POST['jenis_pasien']))
		$jenis_pasien = $_POST['jenis_pasien'];
	$asuransi = "";
	if (isset($_POST['asuransi']))
		$asuransi = $_POST['asuransi'];
	$query_value = "
		SELECT v_stok.*, v_harga.hna, v_harga.markup
		FROM (
			SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
			FROM (
				SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, SUM(sisa) AS 'sisa', satuan, konversi, satuan_konversi, CASE label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
				FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' " . $filter . "
				GROUP BY id_obat, satuan, konversi, satuan_konversi, label
			) v_obat
			GROUP BY id_obat
		) v_stok LEFT JOIN (
			SELECT id_obat, nama_obat, nama_jenis_obat,  MAX(hna) AS 'hna', 0 AS 'markup', satuan, konversi, satuan_konversi
			FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
			WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' " . $filter . "
			GROUP BY id_obat, nama_obat, nama_jenis_obat, satuan, konversi, satuan_konversi
		) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
	";
	if ($jenis_pasien == "bpjs" && $asuransi == "BPJS - KESEHATAN") {
		$query_value .= "
			INNER JOIN (
				SELECT id
				FROM smis_pr_barang
				WHERE bpjs = 1 AND prop = '' AND medis = 1 AND inventaris = 0
			) v_obat_bpjs ON v_stok.id = v_obat_bpjs.id
		";	
	}
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_obat
	";
	$obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$obat_dbresponder = new ObatDBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);
	
	//get sisa, hna, dan markup by id obat, satuan, konversi, satuan_konversi:
	$sisa_table = new Table(array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi"));
	$sisa_table->setName("sisa");
	$sisa_adapter = new SimpleAdapter();
	$sisa_adapter->add("id_obat", "id_obat");
	$sisa_adapter->add("sisa", "sisa");
	$sisa_adapter->add("satuan", "satuan");
	$sisa_adapter->add("konversi", "konversi");
	$sisa_adapter->add("satuan_konversi", "satuan_konversi");
	$columns = array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi");
	$sisa_dbtable = new DBTable(
		$db,
		InventoryLibrary::$_TBL_STOK_OBAT,
		$columns
	);
	$sisa_dbresponder = new SisaDBResponder(
		$sisa_dbtable,
		$sisa_table,
		$sisa_adapter
	);
	
	//apoteker service consumer:
	$apoteker_service_responder = new EmployeeChooserResponder($db, "apoteker", "apoteker");
	
	//bahan chooser:
	$bahan_table = new Table(array("Kode", "Bahan", "Jenis", "Stok"));
	$bahan_table->setName("bahan");
	$bahan_table->setModel(Table::$SELECT);
	$bahan_adapter = new BahanAdapter();
	$bahan_dbtable = new DBTable($db, InventoryLibrary::$_TBL_STOK_OBAT);
	$bahan_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$jenis_pasien = "";
	if (isset($_POST['jenis_pasien']))
		$jenis_pasien = $_POST['jenis_pasien'];
	$asuransi = "";
	if (isset($_POST['asuransi']))
		$asuransi = $_POST['asuransi'];
	$query_value = "
		SELECT v_stok.*, v_harga.hna, v_harga.markup
		FROM (
			SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
			FROM (
				SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, SUM(sisa) AS 'sisa', satuan, konversi, satuan_konversi, CASE label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
				FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' " . $filter . "
				GROUP BY id_obat, satuan, konversi, satuan_konversi, label
			) v_obat
			GROUP BY id_obat
		) v_stok LEFT JOIN (
			SELECT id_obat, nama_obat, nama_jenis_obat,  MAX(hna) AS 'hna', 0 AS 'markup', satuan, konversi, satuan_konversi
			FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
			WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' " . $filter . "
			GROUP BY id_obat, nama_obat, nama_jenis_obat, satuan, konversi, satuan_konversi
		) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
	";
	if ($jenis_pasien == "bpjs" && $asuransi == "BPJS - KESEHATAN") {
		$query_value .= "
			INNER JOIN (
				SELECT id
				FROM smis_pr_barang
				WHERE bpjs = 1 AND prop = '' AND medis = 1 AND inventaris = 0
			) v_obat_bpjs ON v_stok.id = v_obat_bpjs.id
		";	
	}
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_obat
	";
	$bahan_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$bahan_dbresponder = new BahanDBResponder(
		$bahan_dbtable,
		$bahan_table,
		$bahan_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("pasien", $pasien_service_responder);
	$super_command->addResponder("dokter", $dokter_service_responder);
	$super_command->addResponder("obat", $obat_dbresponder);
	$super_command->addResponder("sisa", $sisa_dbresponder);
	$super_command->addResponder("apoteker", $apoteker_service_responder);
	$super_command->addResponder("bahan", $bahan_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$resep_modal = new Modal("resep_add_form", "smis_form_container", "resep");
	$resep_modal->setTitle("Data Penjualan Resep");
	$resep_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("resep_id", "resep_id", "");
	$resep_modal->addElement("", $id_hidden);
	$tanggal_text = new Text("resep_tanggal", "resep_tanggal", date("Y-m-d H:i"));
	$tanggal_text->setClass("mydatetime");
	$tanggal_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$resep_modal->addElement("Tanggal", $tanggal_text);
	$noresep_text = new Text("resep_nomor", "resep_nomor", "");
	$noresep_text->addAtribute("autofocus");
	$resep_modal->addElement("Nomor", $noresep_text);
	$pasien_button = new Button("", "", "Pilih");
	$pasien_button->setClass("btn-info");
	$pasien_button->setIsButton(Button::$ICONIC);
	$pasien_button->setIcon("icon-white ".Button::$icon_list_alt);
	$pasien_button->setAction("pasien.chooser('pasien', 'pasien_button', 'pasien', pasien)");
	$pasien_button->setAtribute("id='pasien_browse'");
	$pasien_text = new Text("resep_nama_pasien", "resep_nama_pasien", "");
	$pasien_text->setAtribute("disabled='disabled'");
	$pasien_text->setClass("smis-one-option-input");
	$pasien_input_group = new InputGroup("");
	$pasien_input_group->addComponent($pasien_text);
	$pasien_input_group->addComponent($pasien_button);
	$resep_modal->addElement("Pasien", $pasien_input_group);
	$noreg_text = new Text("resep_noreg_pasien", "resep_noreg_pasien", "");
	$noreg_text->setAtribute("disabled='disabled'");
	$resep_modal->addElement("No. Registrasi", $noreg_text);
	$nrm_text = new Text("resep_nrm_pasien", "resep_nrm_pasien", "");
	$nrm_text->setAtribute("disabled='disabled'");
	$resep_modal->addElement("NRM Pasien", $nrm_text);
	$alamat_text = new Text("resep_alamat_pasien", "resep_alamat_pasien", "");
	$alamat_text->setAtribute("disabled='disabled'");
	$resep_modal->addElement("Alamat Pasien", $alamat_text);
	if (getSettings($db, "depo_farmasi_tanjung_uncang-resep-change_jenis_pasien", 0) == 0) {
		$jenis_text = new Text("resep_jenis", "resep_jenis", "");
		$jenis_text->setAtribute("disabled='disabled'");
		$resep_modal->addElement("Jns. Pasien", $jenis_text);
	} else {
		$jenis_pasien_service_consumer = new ServiceConsumer($db, "get_jenis_patient", null, "registration");
		$jenis_pasien_service_consumer->execute ();
		$jenis_pasien_option = $jenis_pasien_service_consumer->getContent();
		$jenis_pasien_select = new Select("resep_jenis", "resep_jenis", $jenis_pasien_option);
		$resep_modal->addElement("Jns. Pasien", $jenis_pasien_select);
	}
	$perusahaan_hidden = new Hidden("resep_perusahaan", "resep_perusahaan", "");
	$resep_modal->addElement("", $perusahaan_hidden);
	$asuransi_hidden = new Hidden("resep_asuransi", "resep_asuransi", "");
	$resep_modal->addElement("", $asuransi_hidden);
	if (getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-use_ruangan", 0) == 1) {
		$ruangan_service_consumer = new ServiceConsumer(
			$db, 
			"get_urjip",
			array()
		);
		$ruangan_service_consumer->setMode(ServiceConsumer::$MULTIPLE_MODE);
		$content = $ruangan_service_consumer->execute()->getContent();
		$ruangan_option = new OptionBuilder();
		$num = 0;
		foreach ($content as $autonomous=>$ruang){
			foreach ($ruang as $nama_ruang => $jip){
				if ($jip[$nama_ruang] == "URJ" || $jip[$nama_ruang] == "UP" || $jip[$nama_ruang] == "URJI"){
					if ($num == 0)
						$ruangan_option->add(ArrayAdapter::format("unslug", $nama_ruang), $nama_ruang, "1");
					else
						$ruangan_option->add(ArrayAdapter::format("unslug", $nama_ruang), $nama_ruang);
					$num++;
				}
			}
		
		}
		$ruangan_option->add("-", "");
		$ruangan_select = new Select("resep_ruangan", "resep_ruangan", $ruangan_option->getContent());
		$resep_modal->addElement("Ruangan", $ruangan_select);
	} 
	if (getSettings($db, "depo_farmasi_tanjung_uncang-resep-show_uri", 0) == 0) {
		$uri_hidden = new Hidden("resep_uri", "resep_uri", "");
		$resep_modal->addElement("", $uri_hidden);
	} else {
		$uri_option = new OptionBuilder();
		$uri_option->add("Resep Rawat Jalan", "0", "1");
		$uri_option->add("Resep Rawat Inap", "1");
		$uri_select = new Select("resep_uri", "resep_uri", $uri_option->getContent());
		$resep_modal->addElement("Jns. Resep", $uri_select);
	}
	$id_dokter_hidden = new Hidden("resep_id_dokter", "resep_id_dokter", "");
	$resep_modal->addElement("", $id_dokter_hidden);
	$nama_dokter_hidden = new Hidden("resep_name_dokter", "resep_name_dokter", "");
	$resep_modal->addElement("", $nama_dokter_hidden);
	$dokter_button = new Button("", "", "Pilih");
	$dokter_button->setClass("btn-info");
	$dokter_button->setIsButton(Button::$ICONIC);
	$dokter_button->setIcon("icon-white ".Button::$icon_list_alt);
	$dokter_button->setAction("dokter.chooser('dokter', 'dokter_button', 'dokter', dokter)");
	$dokter_button->setAtribute("id='dokter_browse'");
	$dokter_text = new Text("resep_nama_dokter", "resep_nama_dokter", "");
	$dokter_text->setClass("smis-one-option-input");
	$dokter_input_group = new InputGroup("");
	$dokter_input_group->addComponent($dokter_text);
	$dokter_input_group->addComponent($dokter_button);
	$resep_modal->addElement("Dokter", $dokter_input_group);
	$markup_hidden = new Hidden("resep_markup", "resep_markup", "0");
	$resep_modal->addElement("", $markup_hidden);
	$diskon_text = new Text("resep_diskon", "resep_diskon", "0,00");
	$diskon_text->setTypical("money");
	$diskon_text->setAtribute(" data-thousands=\".\" data-decimal=\",\"  data-precision=\"2\"  " );
	$resep_modal->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	$t_diskon_option->add("Persen (%)", "persen", "1");
	$t_diskon_option->add("Nominal (Rp)", "nominal");
	$t_diskon_option->add("Gratis (100 %)", "gratis");
	$t_diskon_select = new Select("resep_t_diskon", "resep_t_diskon", $t_diskon_option->getContent());
	$resep_modal->addElement("Tipe Diskon", $t_diskon_select);
	$total_text = new Text("resep_total", "resep_total", "");
	$total_text->setTypical("money");
	$total_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$resep_modal->addElement("Total", $total_text);
	$dresep_table = new DResepTable(array("No.", "Nama", "Jumlah", "Harga", "Embalase", "Tuslah", "Biaya Racik", "Subtotal", "Aturan Pakai", "Apoteker"));
	$dresep_table->setName("dresep");
	$dresep_table->setFooterVisible(false);
	$resep_modal->addBody("dresep_table", $dresep_table);
	$resep_button = new Button("", "", "Simpan");
	$resep_button->setClass("btn-success");
	$resep_button->setIcon("fa fa-floppy-o");
	$resep_button->setIsButton(Button::$ICONIC);
	$resep_button->setAtribute("id='resep_save'");
	$resep_modal->addFooter($resep_button);
	$resep_button = new Button("", "", "OK");
	$resep_button->setClass("btn-success");
	$resep_button->setAtribute("id='resep_ok'");
	$resep_button->setAction("$($(this).data('target')).smodal('hide')");
	$resep_modal->addFooter($resep_button);
	$tombol='<a href="#" class="input btn btn-info" ><i class="icon-white icon-list-alt"></i></a>';
	$resep_modal->addHTML("
		<div class='alert alert-block alert-inverse' id='help_resep'>
			<h4>Tips</h4>
			<ul>
				<li>Tombol <kbd>Tab</kbd> : Berpindah Cepat ke Isian Berikutnya (dari Kiri ke Kanan)</li>
				<li>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " pada Isian Dokter / Tombol <kbd>F8</kbd> : Menentukan Nama Dokter</li>
				<li>Tombol " . $tombol . " pada Isian Pasien / Tombol <kbd>F7</kbd> : Menentukan Nama Pasien</li>
				<li>Tombol <kbd>&uarr;</kbd> / <kbd>&darr;</kbd> : Memilih <strong>Persen (%) / Nominal (Rp) / Gratis (100 %)</strong> pada Isian <strong>Tipe Diskon</strong></li>
				<li>Tombol <kbd>F3</kbd> : Tombol Cepat Menambahkan Obat Jadi Baru</li>
				<li>Tombol <kbd>F4</kbd> : Tombol Cepat Menambahkan Obat Racikan Baru</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Cepat Menyimpan Data Resep, Pastikan Semua Obat/Racikan dan Informasi Kepala Resep Sudah Lengkap.</li>
			<ul>
		</div>
	", "after");
				
	//obat jadi modal:
	$obat_jadi_modal = new Modal("obat_jadi_add_form", "smis_form_container", "obat_jadi");
	$obat_jadi_modal->setTitle("Data Obat Jadi");
	$embalase_hidden = new Hidden("obat_jadi_embalase", "obat_jadi_embalase", "");
	$obat_jadi_modal->addElement("", $embalase_hidden);
	$tuslah_hidden = new Hidden("obat_jadi_tuslah", "obat_jadi_tuslah", "");
	$obat_jadi_modal->addElement("", $tuslah_hidden);
	$id_hidden = new Hidden("obat_jadi_id", "obat_jadi_id", "");
	$obat_jadi_modal->addElement("", $id_hidden);
	$id_obat_hidden = new Hidden("obat_jadi_id_obat", "obat_jadi_id_obat", "");
	$obat_jadi_modal->addElement("", $id_obat_hidden);
	$obat_button = new Button("", "", "Pilih");
	$obat_button->setClass("btn-info");
	$obat_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat)");
	$obat_button->setIcon("icon-white icon-list-alt");
	$obat_button->setIsButton(Button::$ICONIC);
	$obat_button->setAtribute("id='obat_jadi_browse'");
	$nama_obat_text = new Text("obat_jadi_nama_obat", "obat_jadi_nama_obat", "");
	$nama_obat_text->setClass("smis-one-option-input");
	$nama_obat_text->addAtribute("autofocus");
	$nama_obat_input_group = new InputGroup("");
	$nama_obat_input_group->addComponent($nama_obat_text);
	$nama_obat_input_group->addComponent($obat_button);
	$obat_jadi_modal->addElement("Obat", $nama_obat_input_group);
	$kode_obat_hidden = new Hidden("obat_jadi_kode_obat", "obat_jadi_kode_obat", "");
	$obat_jadi_modal->addElement("", $kode_obat_hidden);
	$name_obat_hidden = new Hidden("obat_jadi_name_obat", "obat_jadi_name_obat", "");
	$obat_jadi_modal->addElement("", $name_obat_hidden);
	$nama_jenis_obat_hidden = new Hidden("obat_jadi_nama_jenis_obat", "obat_jadi_nama_jenis_obat", "");
	$obat_jadi_modal->addElement("", $nama_jenis_obat_hidden);
	$satuan_select = new Select("obat_jadi_satuan", "obat_jadi_satuan", "");
	$obat_jadi_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("obat_jadi_konversi", "obat_jadi_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("obat_jadi_satuan_konversi", "obat_jadi_satuan_konversi", "");
	$obat_jadi_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("obat_jadi_stok", "obat_jadi_stok", "");
	$obat_jadi_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("obat_jadi_f_stok", "obat_jadi_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("obat_jadi_jumlah_lama", "obat_jadi_jumlah_lama", "");
	$obat_jadi_modal->addElement("", $jumlah_lama_hidden);
	$hna_text = new Text("obat_jadi_hna", "obat_jadi_hna", "");
	$hna_text->setTypical("money");
	$hna_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$obat_jadi_modal->addElement("HJA", $hna_text);
	$tanggal_ed_text = new Text("obat_jadi_tanggal_exp", "obat_jadi_tanggal_exp", "");
	$tanggal_ed_text->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("Tanggal Exp.", $tanggal_ed_text);
	$markup_hidden = new Hidden("obat_jadi_markup", "obat_jadi_markup", "");
	$obat_jadi_modal->addElement("", $markup_hidden);
	$jumlah_text = new Text("obat_jadi_jumlah", "obat_jadi_jumlah", "");
	$obat_jadi_modal->addElement("Jumlah", $jumlah_text);
	$aturan_pakai_text = new Text("obat_jadi_aturan_pakai", "obat_jadi_aturan_pakai", "");
	$obat_jadi_modal->addElement("Aturan Pakai", $aturan_pakai_text);
	$signa1_text = new Text("obat_jadi_signa1", "obat_jadi_signa1", "");
	$obat_jadi_modal->addElement("Signa", $signa1_text);
	$signa2_text = new Text("obat_jadi_signa2", "obat_jadi_signa2", "");
	$obat_jadi_modal->addElement("x", $signa2_text);
	$satuan_pakai_option = new OptionBuilder();
	$satuan_pakai_option->add("", "", 1);
	$satuan_pakai_option->addSingle("ml");
	$satuan_pakai_option->addSingle("tetes");
	$satuan_pakai_option->addSingle("sendok takar");
	$satuan_pakai_option->addSingle("sendok makan");
	$satuan_pakai_select = new Select("obat_jadi_satuan_pakai", "obat_jadi_satuan_pakai", $satuan_pakai_option->getContent());
	$obat_jadi_modal->addElement("Satuan Pakai", $satuan_pakai_select);
	$obat_jadi_button = new Button("", "", "Simpan");
	$obat_jadi_button->setClass("btn-success");
	$obat_jadi_button->setAtribute("id='obat_jadi_save'");
	$obat_jadi_button->setIcon("fa fa-floppy-o");
	$obat_jadi_button->setIsButton(Button::$ICONIC);
	$obat_jadi_modal->addFooter($obat_jadi_button);
	$confirm_control = new InlineConfirmControl("obat_jadi_confirm", "obat_jadi_confirm", "Obat akan kadaluwarsa dalam 90 hari lagi, yakin tetap menjual obat?");
	$obat_jadi_modal->addFooter($confirm_control);
	$obat_jadi_modal->addHTML("
		<div class='alert alert-block alert-inverse'>
			<h4>Tips</h4>
			<ul>
				<li><small>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F2</kbd> : Menentukan Nama Obat</small></li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Resep</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Menyimpan Obat Jadi</li>
			</ul>
		</div>
	", "before");
	
	//obat racikan modal:
	$obat_racikan_modal = new Modal("obat_racikan_add_form", "smis_form_container", "obat_racikan");
	$obat_racikan_modal->setTitle("Data Obat Racikan");
	$obat_racikan_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("obat_racikan_id", "obat_racikan_id", "");
	$obat_racikan_modal->addElement("", $id_hidden);
	$nama_text = new Text("obat_racikan_nama", "obat_racikan_nama", "");
	$nama_text->addAtribute("autofocus");
	$obat_racikan_modal->addElement("Nama Racikan", $nama_text);
	$id_apoteker_hidden = new Hidden("obat_racikan_id_apoteker", "obat_racikan_id_apoteker", "");
	$obat_racikan_modal->addElement("", $id_apoteker_hidden);
	$nama_apoteker_hidden = new Hidden("obat_racikan_name_apoteker", "obat_racikan_name_apoteker", "");
	$obat_racikan_modal->addElement("", $nama_apoteker_hidden);
	$apoteker_button = new Button("", "", "Pilih");
	$apoteker_button->setClass("btn-info");
	$apoteker_button->setIsButton(Button::$ICONIC);
	$apoteker_button->setIcon("icon-white ".Button::$icon_list_alt);
	$apoteker_button->setAction("apoteker.chooser('apoteker', 'apoteker_button', 'apoteker', apoteker)");
	$apoteker_button->setAtribute("id='apoteker_browse'");
	$apoteker_text = new Text("obat_racikan_nama_apoteker", "obat_racikan_nama_apoteker", "");
	$apoteker_text->setClass("smis-one-option-input");
	$apoteker_input_group = new InputGroup("");
	$apoteker_input_group->addComponent($apoteker_text);
	$apoteker_input_group->addComponent($apoteker_button);
	$obat_racikan_modal->addElement("Apoteker", $apoteker_input_group);
	$aturan_pakai_text = new Text("obat_racikan_aturan_pakai", "obat_racikan_aturan_pakai", "");
	$obat_racikan_modal->addElement("Aturan Pakai", $aturan_pakai_text);
	$signa1_text = new Text("obat_racikan_signa1", "obat_racikan_signa1", "");
	$obat_racikan_modal->addElement("Signa", $signa1_text);
	$signa2_text = new Text("obat_racikan_signa2", "obat_racikan_signa2", "");
	$obat_racikan_modal->addElement("x", $signa2_text);
	$satuan_pakai_option = new OptionBuilder();
	$satuan_pakai_option->add("", "", 1);
	$satuan_pakai_option->addSingle("ml");
	$satuan_pakai_option->addSingle("tetes");
	$satuan_pakai_option->addSingle("sendok takar");
	$satuan_pakai_option->addSingle("sendok makan");
	$satuan_pakai_select = new Select("obat_racikan_satuan_pakai", "obat_racikan_satuan_pakai", $satuan_pakai_option->getContent());
	$obat_racikan_modal->addElement("Satuan Pakai", $satuan_pakai_select);
	$biaya_racik_text = new Text("obat_racikan_biaya_racik", "obat_racikan_biaya_racik", "");
	$biaya_racik_text->setAtribute("disabled='disabled'");
	$obat_racikan_modal->addElement("Biaya Racik", $biaya_racik_text);
	$dracikan_table = new DObatRacikanTable(
		array("Bahan", "Harga", "Jumlah", "Embalase", "Tuslah", "Subtotal")
	);
	$dracikan_table->setName("dracikan");
	$dracikan_table->setFooterVisible(false);
	$obat_racikan_modal->addBody("dracikan_table", $dracikan_table);
	$obat_racikan_button = new Button("", "", "Simpan");
	$obat_racikan_button->setClass("btn-success");
	$obat_racikan_button->setIcon("fa fa-floppy-o");
	$obat_racikan_button->setIsButton(Button::$ICONIC);
	$obat_racikan_button->setAtribute("id='racikan_save'");
	$obat_racikan_modal->addFooter($obat_racikan_button);
	$obat_racikan_button = new Button("", "", "OK");
	$obat_racikan_button->setClass("btn-success");
	$obat_racikan_button->setAtribute("id='racikan_ok'");
	$obat_racikan_button->setAction("$($(this).data('target')).smodal('hide')");
	$obat_racikan_modal->addFooter($obat_racikan_button);
	$obat_racikan_modal->addHTML("
		<div class='alert alert-block alert-inverse' id='help_racikan'>
			<h4>Tips</h4>
			<ul>
				<li>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F7</kbd> : Menentukan Nama Apoteker</li>
				<li>Tombol <kbd>F2</kbd> : Tombol Cepat Menambahkan Bahan Baru dari Obat Racikan</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Cepat Menyimpan Obat Racikan</li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Resep</li>
			</ul>
		</div>
	", "after");
	
	//bahan modal:
	$bahan_modal = new Modal("bahan_add_form", "smis_form_container", "bahan");
	$bahan_modal->setTitle("Data Bahan");
	$id_hidden = new Hidden("bahan_id", "bahan_id", "");
	$bahan_modal->addElement("", $id_hidden);
	$id_bahan_hidden = new Hidden("bahan_id_bahan", "bahan_id_bahan", "");
	$bahan_modal->addElement("", $id_bahan_hidden);
	$bahan_button = new Button("", "", "Pilih");
	$bahan_button->setClass("btn-info");
	$bahan_button->setAction("bahan.chooser('bahan', 'bahan_button', 'bahan', bahan)");
	$bahan_button->setIcon("icon-white icon-list-alt");
	$bahan_button->setIsButton(Button::$ICONIC);
	$bahan_button->setAtribute("id='bahan_browse'");
	$nama_bahan_text = new Text("bahan_nama_bahan", "bahan_nama_bahan", "");
	$nama_bahan_text->addAtribute("autofocus");
	$nama_bahan_text->setClass("smis-one-option-input");
	$nama_bahan_input_group = new InputGroup("");
	$nama_bahan_input_group->addComponent($nama_bahan_text);
	$nama_bahan_input_group->addComponent($bahan_button);
	$bahan_modal->addElement("Bahan", $nama_bahan_input_group);
	$kode_bahan_hidden = new Hidden("bahan_kode_bahan", "bahan_kode_bahan", "");
	$bahan_modal->addElement("", $kode_bahan_hidden);
	$name_bahan_hidden = new Hidden("bahan_name_bahan", "bahan_name_bahan", "");
	$bahan_modal->addElement("", $name_bahan_hidden);
	$nama_jenis_bahan_hidden = new Hidden("bahan_nama_jenis_bahan", "bahan_nama_jenis_bahan", "");
	$bahan_modal->addElement("", $nama_jenis_bahan_hidden);
	$satuan_select = new Select("bahan_satuan", "bahan_satuan", "");
	$bahan_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("bahan_konversi", "bahan_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$bahan_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("bahan_satuan_konversi", "bahan_satuan_konversi", "");
	$bahan_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("bahan_stok", "bahan_stok", "");
	$bahan_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("bahan_f_stok", "bahan_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$bahan_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("bahan_jumlah_lama", "bahan_jumlah_lama", "");
	$bahan_modal->addElement("", $jumlah_lama_hidden);
	$hna_text = new Text("bahan_hna", "bahan_hna", "");
	$hna_text->setTypical("money");
	$hna_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$bahan_modal->addElement("HJA", $hna_text);
	$tanggal_ed_text = new Text("bahan_tanggal_exp", "bahan_tanggal_exp", "");
	$tanggal_ed_text->setAtribute("disabled='disabled'");
	$bahan_modal->addElement("Tanggal Exp.", $tanggal_ed_text);
	$markup_hidden = new Hidden("bahan_markup", "bahan_markup", "");
	$bahan_modal->addElement("", $markup_hidden);
	$embalase_hidden = new Hidden("bahan_embalase", "bahan_embalase", "");
	$bahan_modal->addElement("", $embalase_hidden);
	$tuslah_hidden = new Hidden("bahan_tuslah", "bahan_tuslah", "");
	$bahan_modal->addElement("", $tuslah_hidden);
	$jumlah_text = new Text("bahan_jumlah", "bahan_jumlah", "");
	$bahan_modal->addElement("Jumlah", $jumlah_text);
	$bahan_button = new Button("", "", "Simpan");
	$bahan_button->setClass("btn-success");
	$bahan_button->setIcon("fa fa-floppy-o");
	$bahan_button->setIsButton(Button::$ICONIC);
	$bahan_button->setAtribute("id='bahan_save'");
	$bahan_modal->addFooter($bahan_button);
	$confirm_control = new InlineConfirmControl("bahan_confirm", "bahan_confirm", "Obat akan kadaluwarsa dalam 90 hari lagi, yakin tetap menjual obat?");
	$bahan_modal->addFooter($confirm_control);
	$bahan_modal->addHTML("
		<div class='alert alert-block alert-inverse'>
			<h4>Tips</h4>
			<ul>
				<li><small>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F2</kbd> : Menentukan Nama Bahan</small></li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Obat Racikan</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Menyimpan Bahan Racikan</li>
			</ul>
		</div>
	","before");
	
	//invi-table bahan racikan:
	$bahan_racikan_table = new BahanRacikanTable(array("ID", "IDO", "Nama", "Jumlah", "Satuan", "Konversi", "Satuan Konversi", "Harga", "Embalase", "Tuslah", "Label"));
	$bahan_racikan_table->setAction(false);
	$bahan_racikan_table->setName("bahan_racikan");

	$status_pcare_modal = new Modal("status_pcare_add_form", "smis_form_container", "status_pcare");
	$status_pcare_modal->setTitle("Status PCare");
	$status_pcare_modal->setClass(Modal::$HALF_MODEL);
	$status_pcare_modal->addHTML("<div id='status_pcare_content'></div>", "before");
	$status_pcare_button = new Button("", "", "OK");
	$status_pcare_button->setClass("btn-success");
	$status_pcare_button->setAtribute("id='status_pcare_ok'");
	$status_pcare_button->setAction("$($(this).data('target')).smodal('hide')");
	$status_pcare_modal->addFooter($status_pcare_button);
	
	echo "<div class='alert alert-block alert-inverse'>" .
			 "<h4>Tips</h4>" .
			 "Tombol <kbd>F2</kbd> : Menampilkan Formulir Penjualan Resep Baru" .
		 "</div>";
	echo "<div class='alert alert-block alert-danger' id='warning_batal_berobat' style='display: none'>" .
		 "</div>";
	echo $status_pcare_modal->getHtml();
	echo $bahan_modal->getHtml();
	echo $obat_racikan_modal->getHtml();
	echo $obat_jadi_modal->getHtml();
	echo $resep_modal->getHtml();
	echo $resep_table->getHtml();
	echo $bahan_racikan_table->getHtml();
	
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");	
	echo addCSS("framework/bootstrap/css/datepicker.css");	
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("smis-base-js/smis-base-shortcut.js", false);
	echo addCSS("depo_farmasi_tanjung_uncang/css/penjualan_resep.css", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/penjualan_resep_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/dpenjualan_resep_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/obat_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/apoteker_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/dokter_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/pasien_action.js", false);
	echo addJS("depo_farmasi_tanjung_uncang/js/bahan_action.js", false);
	echo addJS("smis-libs-out/webprint/webprint.js", false);
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var embalase_obat_jadi = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-embalase-obat_jadi", 0); ?>;
	var tuslah_obat_jadi = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-tuslah-obat_jadi", 0); ?>;
	var embalase_bahan_racikan = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-embalase-bahan_racikan", 0); ?>;
	var tuslah_bahan_racikan = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-tuslah-bahan_racikan", 0); ?>;
	var jasa_racik = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-jasa_racik", 0); ?>;

	/// mode margin :
	/// 0	=> paten
	/// 1 	=> jenis pasien
	/// 2 	=> obat
	/// 3 	=> obat dan jenis pasien
	var mode_margin = <?php echo getSettings($db, "depo_farmasi_tanjung_uncang-penjualan_resep-mode_margin_penjualan", 0); ?>;
	var need_margin_penjualan_request = 1;

	var dresep_num;
	var racikan_num;
	var dracikan_num;
	var bahan_num;
	var resep;
	var dokter;
	var pasien;
	var dresep;
	var obat;
	var apoteker;
	var bahan;
	$(document).ready(function() {
		$('.modal').on('shown.bs.modal', function() {
			$(this).find('[autofocus]').focus();
		});
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
		$("*").dblclick(function(e) {
			e.preventDefault();
		});
		$("#smis-chooser-modal").on("show", function() {
			if ($("#smis-chooser-modal .modal-header h3").text() == "DOKTER" || 
				$("#smis-chooser-modal .modal-header h3").text() == "PASIEN") {
				$("#smis-chooser-modal").removeClass("half_model");
				$("#smis-chooser-modal").removeClass("full_model");
				$("#smis-chooser-modal").addClass("full_model");
				if ($("#smis-chooser-modal .modal-header h3").text() == "PASIEN") {
					$("table#table_pasien tfoot tr").eq(0).hide();
				} else {
					$("table#table_pasien tfoot tr").eq(0).show();
				}
			} else if ($("#smis-chooser-modal .modal-header h3").text() == "OBAT" || 
					   $("#smis-chooser-modal .modal-header h3").text() == "BAHAN") {
				$("#smis-chooser-modal").removeClass("half_model");
				$("#smis-chooser-modal").removeClass("full_model");
				$("#smis-chooser-modal").addClass("half_model");
			} else {
				$("#smis-chooser-modal").removeClass("half_model");
				$("#smis-chooser-modal").removeClass("full_model");
			}
		});
		$("#smis-chooser-modal").on("hidden", function() {
			$("#smis-chooser-modal").removeClass("half_model");
		});
		$("#resep_add_form").on("show", function() {
			$("ul.typeahead").hide();
		});
		$("#obat_racikan_add_form").on("show", function() {
			$("ul.typeahead").hide();
		});
		$("#resep_t_diskon").on("change", function() {
			var diskon = $("#resep_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
			var t_diskon = $("#resep_t_diskon").val();
			if (diskon > 100 && t_diskon == "persen") {
				$("#modal_alert_resep_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						"<br /><b>Diskon</b> tidak boleh melebihi 100%" +
					"</div>"
				);
				return;
			}
			$("#modal_alert_resep_add_form").html("");
			if ($("#resep_t_diskon").val() == "gratis") {
				$("#resep_diskon").val("100,00");
				$("#resep_diskon").removeAttr("disabled");
				$("#resep_diskon").attr("disabled", "disabled");
			} else {
				$("#resep_diskon").val("0,00");
				$("#resep_diskon").removeAttr("disabled");
			}
			resep.refreshBiayaTotal();
		});
		$("#resep_diskon").on("keyup", function() {
			var diskon = $("#resep_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
			var t_diskon = $("#resep_t_diskon").val();
			if (diskon > 100 && t_diskon == "persen") {
				$("#modal_alert_resep_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						"<br /><b>Diskon</b> tidak boleh melebihi 100%" +
					"</div>"
				);
				return;
			} 
			$("#modal_alert_resep_add_form").html("");
			resep.refreshBiayaTotal();
		});
		$("#resep_diskon").on("change", function() {
			var diskon = $("#resep_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
			if (diskon == "") {
				$("#resep_diskon").val("0,00");
			}
		});
		dokter = new DokterAction(
			"dokter",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			new Array()
		);
		dokter.setSuperCommand("dokter");
		pasien = new PasienAction(
			"pasien",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			new Array()
		);
		pasien.addViewData = function(d) {
			var date_part = $("#search_tanggal").val().split("-");
			var date = "";
			if ($("#search_tanggal").val() != "")
				date = date_part[2] + "-" + date_part[1] + "-" + date_part[0];
			d['tanggal'] = date;
			d['nobpjs'] = $("#search_nobpjs").val();
			d['nrm_pasien'] = $("#search_nrm").val();
			d['nama_pasien'] = $("#search_nama").val();
			d['alamat_pasien'] = $("#search_alamat").val();
			d['uri'] = $("#search_uri").val();
			d['jenis_pasien'] = $("#search_carabayar").val();
			d['perusahaan_pasien'] = $("#search_perusahaan").val();
			d['asuransi_pasien'] = $("#search_asuransi").val();
			d['origin'] = '<?php echo getSettings($db, "smis_autonomous_id", ""); ?>';
			return  d;
		};
		pasien.selected = function(json) {
			PasienAction.prototype.selected.call(this, json);
			$("#modal_alert_resep_add_form").empty();
			$(".error_field").removeClass("error_field");
		}
		pasien.setSuperCommand("pasien");
		obat = new ObatAction(
			"obat",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			new Array()
		);
		obat.addViewData = function(data) {
			data['jenis_pasien'] = $("#resep_jenis").val();
			data['asuransi'] = $("#resep_asuransi").val();
			return data;
		};
		obat.setSuperCommand("obat");
		apoteker = new ApotekerAction(
			"apoteker",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			new Array()
		);
		apoteker.setSuperCommand("apoteker");
		bahan = new BahanAction(
			"bahan",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			new Array()
		);
		bahan.addViewData = function(data) {
			data['jenis_pasien'] = $("#resep_jenis").val();
			data['asuransi'] = $("#resep_asuransi").val();
			return data;
		};
		bahan.setSuperCommand("bahan");
		var dresep_columns = new Array("id", "id_penjualan_resep", "nama", "embalase", "tuslah", "hja", "subtotal");		
		dresep = new DResepAction(
			"dresep",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			dresep_columns
		);
		dresep.show_add_obat_jadi_form = function() {
			var noreg_pasien = $("#resep_noreg_pasien").val();
			$("#modal_alert_resep_add_form").empty();
			$(".error_field").removeClass("error_field");
			if (noreg_pasien.trim().length == 0) {
				$("#modal_alert_resep_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						"</br><strong>Pasien</strong> harus dipilih terlebih dahulu" +
					"</div>"
				);
				$("#resep_nama_pasien").addClass("error_field");
				return;
			}
			DResepAction.prototype.show_add_obat_jadi_form.call(this);
		};
		dresep.show_add_obat_racikan_form = function() {
			var noreg_pasien = $("#resep_noreg_pasien").val();
			$("#modal_alert_resep_add_form").empty();
			$(".error_field").removeClass("error_field");
			if (noreg_pasien.trim().length == 0) {
				$("#modal_alert_resep_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						"</br><strong>Pasien</strong> harus dipilih terlebih dahulu" +
					"</div>"
				);
				$("#resep_nama_pasien").addClass("error_field");
				return;
			}
			DResepAction.prototype.show_add_obat_racikan_form.call(this);
		};
		var resep_columns = new Array("id", "nomor_resep", "tanggal", "id_dokter", "nama_dokter", "noreg_pasien", "nrm_pasien", "nama_pasien", "alamat_pasien", "jenis", "perusahaan", "asuransi", "markup", "uri", "total", "edukasi", "dibatalkan", "embalase", "diskon", "t_diskon");
		resep = new ResepAction(
			"resep",
			"depo_farmasi_tanjung_uncang",
			"penjualan_resep",
			resep_columns
		);
		resep.refreshBiayaTotal = function() {
			ResepAction.prototype.refreshBiayaTotal.call(this);
			var nord = $("tbody#dresep_list").children("tr").length;
			var noreg_pasien = $("#resep_noreg_pasien").val();
			var nomor_resep_disabled = $("#resep_nomor").attr("disabled");
			if (noreg_pasien.trim().length > 0 && nord > 0 && nomor_resep_disabled != "disabled") {
				$("#pasien_browse").removeAttr("onclick");
				$("#pasien_browse").removeClass("btn-info");
				$("#pasien_browse").removeClass("btn-inverse");
				$("#pasien_browse").addClass("btn-inverse");
				$("#modal_alert_resep_add_form").html(
					"<div class='alert alert-block alert-info'>" +
						"<h4>Informasi</h4>" +
						"</br><strong>Pasien</strong> dapat dipilih kembali apabila detail penjualan resep kosong." +
					"</div>"
				);
			} else {
				$("#pasien_browse").removeAttr("onclick");
				$("#pasien_browse").attr("onclick", "pasien.chooser('pasien', 'pasien_button', 'pasien', pasien)");
				$("#pasien_browse").removeClass("btn-info");
				$("#pasien_browse").removeClass("btn-inverse");
				$("#pasien_browse").addClass("btn-info");
				$("#modal_alert_resep_add_form").empty();
			}
		};
		resep.status_pcare = function(id) {
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "status_pcare";
			data['id'] = id;
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					$("#status_pcare_content").html(json);
					$("#status_pcare_add_form").smodal("show");
					dismissLoading();
				}
			);
		};
		resep.refresh_status_pcare = function(id) {
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "status_pcare";
			data['id'] = id;
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					$("#status_pcare_content").html(json);
					dismissLoading();
				}
			);
		};
		resep.resend_pcare = function(id) {
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "resend_pcare";
			data['id'] = id;
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					dismissLoading();
					self.refresh_status_pcare(id);
				}
			);
		};
		resep.resend_cancel_pcare = function(id) {
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "resend_cancel_pcare";
			data['id'] = id;
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					dismissLoading();
					self.refresh_status_pcare(id);
				}
			);
		};
		resep.setSuperCommand("resep");
		resep.view();
		var data_apoteker = apoteker.getViewData();
		$('#obat_racikan_nama_apoteker').typeahead({
			minLength:3,
			source: function (query, process) {
				data_apoteker["kriteria"]=$('#obat_racikan_nama_apoteker').val();
				var $items = new Array;
				$items = [""];	
				$.ajax({
					url: '',
					type: 'POST',
					data: data_apoteker,
					success: function(res) {
						var json = getContent(res);
						var the_data_proses = json.dbtable.data;
						$items = [""];	
						$.map(the_data_proses, function(data) {
							var group;
							group = {
								id: data.id,
								name: data.nama,                            
								toString: function () {
									return JSON.stringify(this);
								},
								toLowerCase: function () {
									return this.name.toLowerCase();
								},
								indexOf: function (string) {
									return String.prototype.indexOf.apply(this.name, arguments);
								},
								replace: function (string) {
									var value = '';
									value +=  this.name;
									if(typeof(this.level) != 'undefined') {
										value += ' <span class="pull-right muted">';
										value += this.level;
										value += '</span>';
									}
									return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
								}
							};
							$items.push(group);
						});
						process($items);
					}
				});
			},
			updater: function (item) {
				var item = JSON.parse(item);
				$("#obat_racikan_id_apoteker").val(item.id);
				$("#obat_racikan_name_apoteker").val(item.name);
				return item.name;
			}
		});
		var data_dokter = dokter.getViewData();	
		$('#resep_nama_dokter').typeahead({
			minLength:3,
			source: function (query, process) {
			data_dokter['kriteria']=$('#resep_nama_dokter').val();
			var $items = new Array;
			$items = [""];                
			$.ajax({
				url: '',
				type: 'POST',
				data: data_dokter,
				success: function(res) {
					var json=getContent(res);
					var the_data_proses=json.dbtable.data;
					$items = [""];      				
					$.map(the_data_proses, function(data) {
						var group;
						group = {
							id: data.id,
							name: data.nama,                            
							toString: function () {
								return JSON.stringify(this);
							},
							toLowerCase: function () {
								return this.name.toLowerCase();
							},
							indexOf: function (string) {
								return String.prototype.indexOf.apply(this.name, arguments);
							},
							replace: function (string) {
								var value = '';
								value +=  this.name;
								if(typeof(this.level) != 'undefined') {
									value += ' <span class="pull-right muted">';
									value += this.level;
									value += '</span>';
								}
								return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
							}
						};
						$items.push(group);
					});
					process($items);
				}
				});
			},
			updater: function (item) {
				var item = JSON.parse(item);
				$("#resep_nama_pasien").focus();
				$("#resep_id_dokter").val(item.id);
				$("#resep_name_dokter").val(item.name);
				return item.name;
			}
		});
		$('#bahan_nama_bahan').typeahead({
			minLength:3,
			source: function (query, process) {
				var $items = new Array;
				$items = [""];   
				var bahan_nama_bahan = bahan.getViewData();             
				bahan_nama_bahan['kriteria']=$('#bahan_nama_bahan').val();
				$.ajax({
					url: '',
					type: 'POST',
					data: bahan_nama_bahan,
					success: function(res) {
						var json=getContent(res);
						var the_data_proses=json.dbtable.data;
						$items = [""];      				
						$.map(the_data_proses, function(data){
							var group;
							group = {
								id: data.id,
								name: data.nama_obat,
								kode: data.kode_obat,                       
								toString: function () {
									return JSON.stringify(this);
								},
								toLowerCase: function () {
									return this.name.toLowerCase();
								},
								indexOf: function (string) {
									return String.prototype.indexOf.apply(this.name, arguments);
								},
								replace: function (string) {
									var value = '';
									value +=  this.kode + " - " + this.name;
									if(typeof(this.level) != 'undefined') {
										value += ' <span class="pull-right muted">';
										value += this.level;
										value += '</span>';
									}
									return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
								}
							};
							$items.push(group);
						});
						process($items);
					}
				});
			},
			updater: function (item) {
				var item = JSON.parse(item);  
				bahan.select(item.id);
				$("#bahan_jumlah").focus();       
				return item.name;
			}
		});
		$('#obat_jadi_nama_obat').typeahead({
			minLength:3,
			source: function (query, process) {
				var $items = new Array;
				$items = [""];    
				var obat_jadi_nama = obat.getViewData();            
				obat_jadi_nama['kriteria']=$('#obat_jadi_nama_obat').val();
				$.ajax({
					url: '',
					type: 'POST',
					data: obat_jadi_nama,
					success: function(res) {
						var json=getContent(res);
						var the_data_proses=json.dbtable.data;
						$items = [""];      				
						$.map(the_data_proses, function(data){
							var group;
							group = {
								id: data.id,
								name: data.nama_obat,
								kode: data.kode_obat,                   
								toString: function () {
									return JSON.stringify(this);
								},
								toLowerCase: function () {
									return this.name.toLowerCase();
								},
								indexOf: function (string) {
									return String.prototype.indexOf.apply(this.name, arguments);
								},
								replace: function (string) {
									var value = '';
									value +=  this.kode + " - " + this.name;
									if(typeof(this.level) != 'undefined') {
										value += ' <span class="pull-right muted">';
										value += this.level;
										value += '</span>';
									}
									return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
								}
							};
							$items.push(group);
						});
						process($items);
					}
				});
			},
			updater: function (item) {
				var item = JSON.parse(item);  
				obat.select(item.id);  
				$("#obat_jadi_jumlah").focus();       
				return item.name;
			}
		});
		$("#bahan_jumlah").keypress(function(e) {
			$("ul.typeahead").html("");
			$("ul.typeahead").hide();
			if(e.which == 13) {
				$('#bahan_save').trigger('click');
			}
		});
		$("#resep_nomor").keypress(function(e) {
			if(e.which == 13) {
				$('#pasien_browse').focus();
			}
		});
		$("#resep_nama_dokter").keypress(function(e) {
			$("ul.typeahead").html("");
			$("ul.typeahead").hide();
			if(e.which == 13) {
				$('#resep_diskon').focus();
			}
		});
		$("#resep_diskon").keypress(function(e) {
			if(e.which == 13) {
				$('#resep_t_diskon').focus();
			}
		});
		$("#obat_jadi_nama_obat").keypress(function(e) {
			if(e.which == 13) {
				$('#obat_jadi_satuan').focus();
			}
		});
		$("#obat_jadi_satuan").keypress(function(e) {
			e.preventDefault();
			if(e.which == 13) {
				$('#obat_jadi_jumlah').focus();
			}
		});
		$("#obat_racikan_nama").keypress(function(e) {
			if(e.which == 13) {
				$('#obat_racikan_nama_apoteker').focus();
			}
		});
		$("#obat_racikan_nama_apoteker").keypress(function(e) {
			$("ul.typeahead").html("");
			$("ul.typeahead").hide();
			if(e.which == 13) {
				$('#obat_racikan_aturan_pakai').focus();
			}
		});
		$("#bahan_nama_bahan").keypress(function(e) {
			if(e.which == 13) {
				$('#bahan_satuan').focus();
			}
		});
		$("#bahan_satuan").keypress(function(e) {
			e.preventDefault();
			if(e.which == 13) {
				$('#bahan_jumlah').focus();
			}
		});
		$("#obat_jadi_jumlah").keypress(function(e) {
			if(e.which == 13) {
				$('#obat_jadi_aturan_pakai').focus();
			}
		});
		$("#obat_jadi_aturan_pakai").keypress(function(e) {
			$("ul.typeahead").html("");
			$("ul.typeahead").hide();
			if(e.which == 13) {
				$('#obat_jadi_save').trigger('click');
			}
		});
		shortcut.add("F2", function() {
			if($('#obat_racikan_add_form').hasClass('in')) {
				 $("#bahan_add").trigger("click");
			} else if(!$('#resep_add_form').hasClass('in') && !$('#obat_jadi_add_form').hasClass('in') && !$('#bahan_add_form').hasClass('in') && !$("#smis-chooser-modal").hasClass('in')) {
				$("#resep_add").trigger("click");
			} else if ($('#obat_jadi_add_form').hasClass('in')) {
				$("#obat_jadi_browse").trigger('click');
			} else if ($('#bahan_add_form').hasClass('in')) {
				$("#bahan_browse").trigger('click');
			}
		});
		shortcut.add("F3", function() {
			if($('#resep_add_form').hasClass('in')) {
				$("#obat_jadi_add").trigger('click');
			}
		});
		shortcut.add("F4", function() {
			if($('#resep_add_form').hasClass('in')) {
				$("#obat_racikan_add").trigger("click");
			}
		});
		shortcut.add("F6", function() {
			if($('#resep_add_form').hasClass('in')) {
				$("#resep_save").trigger('click');
			} else if($('#obat_racikan_add_form').hasClass('in')){
				$('#racikan_save').trigger('click');
			} else if($("#obat_jadi_add_form").hasClass('in')) {
				$("#obat_jadi_save").trigger('click');
			} else if($("#bahan_add_form").hasClass('in')) {
				$("#bahan_save").trigger('click');
			}
		});
		shortcut.add("F7", function() {
			if($('#resep_add_form').hasClass('in')) {
				$("#pasien_browse").trigger("click");
			} else if($("#obat_racikan_add_form").hasClass('in')) {
				$("#apoteker_browse").trigger("click");
			}
		});
		shortcut.add("F8", function() {
			if($('#resep_add_form').hasClass('in')) {
				$("#dokter_browse").trigger("click");
			}
		});
		resep.refreshHargaAndSubtotal();
		$('#smis-chooser-modal').on('shown.bs.modal', function() {
		  	$('.mydate').datepicker().on("changeDate", function (e) {
		    	pasien.view();
			});
		});
	});
</script>
<style type="text/css">
	#obat_jadi_add_form_form > div.normal_model_small_component.obat_jadi_signa2 > label {
		width: 37px !important;
	}
	#obat_jadi_signa1,
	#obat_jadi_signa2 {
		width: 75px !important;
	}

	#obat_racikan_add_form_form > div.full_model_small_component.obat_racikan_signa2 > label {
		width: 37px !important;
	}
	#obat_racikan_signa1,
	#obat_racikan_signa2 {
		width: 75px !important;
	}
</style>