<?php
	require_once("depo_farmasi_tanjung_uncang/library/InventoryLibrary.php");
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$laporan_form = new Form("", "", "Farmasi : Laporan Rekap Obat Narkotika - Psikotropika - Prekursor Farmasi");
	$tanggal_from_text = new Text("lrnpp_tanggal_from", "lrnpp_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrnpp_tanggal_to", "lrnpp_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$jenis_filter_option = new OptionBuilder();
	$jenis_filter_option->add("NARKOTIKA", "narkotika", "1");
	$jenis_filter_option->add("PSIKOTROPIKA", "psikotropika");
	$jenis_filter_option->add("PREKURSOR FARMASI", "prekursor_farmasi");
	$jenis_filter_select = new Select("lrnpp_jenis_filter", "lrnpp_jenis_filter", $jenis_filter_option->getContent());
	$laporan_form->addElement("Jenis Filter", $jenis_filter_select);
	$urutan_option = new OptionBuilder();
	$urutan_option->addSingle("KODE OBAT", "1");
	$urutan_option->addSingle("NAMA OBAT");
	$urutan_select = new Select("lrnpp_urutan", "lrnpp_urutan", $urutan_option->getContent());
	$laporan_form->addElement("Urutan", $urutan_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrnpp.view()");
	$print_button = new Button("", "", "Unduh");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("fa fa-download");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAtribute("id='npp_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);

	$lrnpp_table = new Table(
		array(
			"No.", "ID Obat", "Kode Obat", "Nama Obat", "Satuan", 
			"Stok Awal", "Tanggal", "Vendor", "Jumlah Masuk", "Dokter", 
			"Pasien", "Jumlah Keluar", "Stok Akhir"),
		"",
		null,
		true
	);
	$lrnpp_table->setName("lrnpp");
	$lrnpp_table->setAction(false);
	$lrnpp_table->setFooterVisible(false);
	$lrnpp_table->setHeaderVisible(false);
	$lrnpp_table->addHeader("after", "
		<tr class='inverse'>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>No.</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>ID Obat</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Kode Obat</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Nama Obat</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Satuan</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Saldo Awal</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Tanggal Transaksi</small></center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center><small>Penerimaan</small></center>
			</th>
			<th colspan='3' style='vertical-align: middle !important;'>
				<center><small>Pengeluaran</small></center>
			</th>
			<th style='vertical-align: middle !important;'>
				<center><small>Stok Akhir</small></center>
			</th>
		</tr>
		<tr class='inverse'>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Distributor</small></center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Jumlah</small></center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Dokter</small></center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Pasien</small></center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Jumlah</small></center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center><small>Jumlah</small></center>
			</th>
		</tr>
	");

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_obat") {
			$jenis_filter = $_POST['jenis_filter'];
			$params = array();
			$params['order_by'] = $_POST['urutan'];
			$service = "";
			if ($jenis_filter == "narkotika")
				$service = "get_jumlah_obat_narkotika";
			else if ($jenis_filter == "psikotropika")
				$service = "get_jumlah_obat_psikotropika";
			else if ($jenis_filter == "prekursor_farmasi")
				$service = "get_jumlah_obat_prekursor";
			$consumer_service = new ServiceConsumer(
				$db,
				$service,
				$params,
				"perencanaan"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$jumlah = 0;
			if ($content != null)
				$jumlah = $content[0];
			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_obat_1") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_filter = $_POST['jenis_filter'];
			$num = $_POST['num'];
			$params = array();
			$params['num'] = $_POST['num'];
			$params['order_by'] = $_POST['urutan'];
			$service = "";
			if ($jenis_filter == "narkotika")
				$service = "get_obat_info_narkotika";
			else if ($jenis_filter == "psikotropika")
				$service = "get_obat_info_psikotropika";
			else if ($jenis_filter == "prekursor_farmasi")
				$service = "get_obat_info_prekursor";
			$consumer_service = new ServiceConsumer(
				$db,
				$service,
				$params,
				"perencanaan"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$id_obat = $content[0];
			$kode_obat = $content[1];
			$nama_obat = $content[2];
			$nama_jenis_obat = $content[3];
			$satuan = $content[4];
			$satuan_konversi = $content[5];		

			// Stok Akhir :
			$stok_akhir = 0;
			$saldo_sekarang = InventoryLibrary::getCurrentStock($db, $id_obat, $satuan, 1, $satuan_konversi);
			$jumlah_masuk = InventoryLibrary::getStockIn($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + InventoryLibrary::getPenyesuaianStokPositif($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . "+1 day")), date("Y-m-d"));
			$jumlah_keluar = InventoryLibrary::getStockOut($db, $id_obat, $satuan, 1, $satuan_konversi,date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + InventoryLibrary::getPenyesuaianStokNegatif($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . "+1 day")), date("Y-m-d"));
			$stok_akhir = $saldo_sekarang - $jumlah_masuk + $jumlah_keluar;

			// Penerimaan & Pengeluaran :
			$jumlah_masuk = 0;
			$jumlah_keluar = 0;

			$penerimaan_rows = $db->get_result("
				SELECT a.tanggal, d.id_vendor, d.nama_vendor, SUM(b.jumlah) AS 'jumlah'
				FROM ((" . InventoryLibrary::$_TBL_OBAT_MASUK . " a INNER JOIN " . InventoryLibrary::$_TBL_STOK_OBAT . " b ON a.id = b.id_obat_masuk) LEFT JOIN smis_fr_stok_obat_keluar c ON b.f_id = c.id) INNER JOIN smis_fr_stok_obat d ON c.id_stok_obat = d.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND a.status = 'sudah' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND b.id_obat = '" . $id_obat . "'
				GROUP BY tanggal, id_vendor, nama_vendor
			");

			$pengeluaran_rows = $db->get_result("
				SELECT tanggal, id_dokter, nama_dokter, nrm_pasien, nama_pasien, SUM(jumlah) AS 'jumlah'
				FROM (
					SELECT DATE(a.tanggal) AS 'tanggal', a.id_dokter, a.nama_dokter, a.nrm_pasien, a.nama_pasien, SUM(b.jumlah) AS 'jumlah'
					FROM " . InventoryLibrary::$_TBL_PENJUALAN_RESEP . " a INNER JOIN " . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . " b ON a.id = b.id_penjualan_resep
					WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND a.dibatalkan = '0' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59' AND b.id_obat = '" . $id_obat . "'
					GROUP BY tanggal, id_dokter, nama_dokter, nrm_pasien, nama_pasien
					UNION ALL
					SELECT DATE(a.tanggal) AS 'tanggal', a.id_dokter, a.nama_dokter, a.nrm_pasien, a.nama_pasien, SUM(c.jumlah) AS 'jumlah'
					FROM (" . InventoryLibrary::$_TBL_PENJUALAN_RESEP . " a INNER JOIN " . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . " b ON a.id = b.id_penjualan_resep) INNER JOIN " . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . " c ON b.id = c.id_penjualan_obat_racikan
					WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND a.dibatalkan = '0' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59' AND c.id_obat = '" . $id_obat . "'
					GROUP BY tanggal, id_dokter, nama_dokter, nrm_pasien, nama_pasien
				) v 
				GROUP BY tanggal, id_dokter, nama_dokter, nrm_pasien, nama_pasien
			");

			$transaksi_arr = array();

			if ($penerimaan_rows != null) {
				foreach ($penerimaan_rows as $pr) {
			    	$transaksi_arr[$pr->tanggal]['penerimaan'][] = array(
			        	"vendor"		=> $pr->nama_vendor,
			            "jumlah_masuk"	=> $pr->jumlah
			        );
			    	$jumlah_masuk += $pr->jumlah;
			    }
			}

			if ($pengeluaran_rows != null) {
				foreach ($pengeluaran_rows as $pr) {
			    	$transaksi_arr[$pr->tanggal]['pengeluaran'][] = array(
			        	"dokter"		=> $pr->nama_dokter,
			        	"pasien"		=> $pr->nama_pasien,
			            "jumlah_keluar"	=> $pr->jumlah
			        );
			        $jumlah_keluar += $pr->jumlah;
			    }
			}

		    $stok_awal = $stok_akhir - $jumlah_masuk + $jumlah_keluar;
		    $html = "";

			$first_row = true;
			if (count($transaksi_arr) > 0) {
			    foreach ($transaksi_arr as $tanggal => $transaksi) {	
		    		$limit_baris = isset($transaksi['penerimaan']) ? count($transaksi['penerimaan']) : 0;
		    		if ($limit_baris == 0 && isset($transaksi['pengeluaran']))
		    			$limit_baris = count($transaksi['pengeluaran']);
					if (isset($transaksi['pengeluaran']) && isset($transaksi['penerimaan']) && count($transaksi['pengeluaran']) > count($transaksi['penerimaan']))
					   $limit_baris = count($transaksi['pengeluaran']);
					$previous_date = "";
					for ($i = 0; $i < $limit_baris; $i++) {
						if ($first_row) {
							$html .= "
			    				<tr>
			    					<td id='nomor'><small>" . ($num + 1) . "</small></td>
			    					<td id='id_obat'><small>" . $id_obat . "</small></td>
			    					<td id='kode_obat'><small>" . $kode_obat . "</small></td>
			    					<td id='nama_obat'><small>" . $nama_obat . "</small></td>
			    					<td id='satuan'><small>" . $satuan . "</small></td>
			    					<td id='stok_awal'><small>" . $stok_awal . "</small></td>
			    			";
		    			} else {
		    				$html .= "
			    				<tr>
			    					<td id='nomor'></td>
			    					<td id='id_obat'></td>
			    					<td id='kode_obat'></td>
			    					<td id='nama_obat'></td>
			    					<td id='satuan'></td>
			    					<td id='stok_awal'></td>
			    			";
		    			}
		    			if ($tanggal != $previous_date)
			    			$html .= "<td id='tanggal'><small>" . $tanggal . "</small></td>";
			    		else
			    			$html .= "<td id='tanggal'></td>";
						if (isset($transaksi['penerimaan']) && $i < count($transaksi['penerimaan'])) {
							$html .= "<td id='vendor'><small>" . $transaksi['penerimaan'][$i]['vendor'] . "</small></td>";
							$html .= "<td id='jumlah_masuk'><small>" . $transaksi['penerimaan'][$i]['jumlah_masuk'] . "</small></td>";
						} else {
							$html .= "<td id='vendor'></td>";
							$html .= "<td id='jumlah_masuk'></td>";
						}
						if (isset($transaksi['pengeluaran']) && $i < count($transaksi['pengeluaran'])) {
							$html .= "<td id='dokter'><small>" . $transaksi['pengeluaran'][$i]['dokter'] . "</small></td>";
							$html .= "<td id='pasien'><small>" . $transaksi['pengeluaran'][$i]['pasien'] . "</small></td>";
							$html .= "<td id='jumlah_keluar'><small>" . $transaksi['pengeluaran'][$i]['jumlah_keluar'] . "</small></td>";
						} else {
							$html .= "<td id='dokter'></td>";
							$html .= "<td id='pasien'></td>";
							$html .= "<td id='jumlah_keluar'></td>";
						}
						if ($first_row) {
							$html .= "
			    					<td id='stok_akhir'><small>" . $stok_akhir . "</small></td>
			    				</tr>
			    			";
			    			$first_row = false;
		    			} else {
		    				$html .= "
			    					<td id='stok_akhir'></td>
			    				</tr>
			    			";
		    			}
		    			$previous_date = $tanggal;
					}
				}
			}

		    $data = array();
		    $data['id_obat'] = $id_obat;
		    $data['kode_obat'] = $kode_obat;
		    $data['nama_obat'] = $nama_obat;
		    $data['nama_jenis_obat'] = $nama_jenis_obat;
		    $data['html'] = $html;
		    echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			set_time_limit(0);
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_farmasi/templates/template_rekap_obat_npp.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("REKAP OBAT NPP");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B1", "DATA OBAT " . ArrayAdapter::format("unslug", $_POST['jenis_filter']));
			$objWorksheet->setCellValue("B2", ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "PERIODE : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));
			$data = json_decode($_POST['d_data']);
			$objWorksheet->getStyle("G9")->getNumberFormat()->setFormatCode("#,##0");
			$objWorksheet->getStyle("J9")->getNumberFormat()->setFormatCode("#,##0");
			$objWorksheet->getStyle("L9")->getNumberFormat()->setFormatCode("#,##0");
			$objWorksheet->getStyle("M9")->getNumberFormat()->setFormatCode("#,##0");
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, $_POST['num_rows'] - 2);
			$start_row_num = 7;
			$end_row_num = 7;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id_obat);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->kode_obat);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_obat);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->satuan);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->stok_awal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->tanggal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->vendor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah_masuk);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->dokter);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah_keluar);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->stok_akhir);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nilai_stok_akhir);
				$objWorksheet->getStyle("G" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("J" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("L" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("M" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=REKAP_OBAT_NPP_" . strtoupper($_POST['jenis_filter']) . "_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . "_" . date("Ymd_His") . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}
	$loading_bar = new LoadingBar("npp_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrnpp.cancel()");
	$loading_modal = new Modal("npp_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lrnpp_table->getHtml();
	echo "</div>";
	echo "<div id='npp_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LRNPPAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRNPPAction.prototype.constructor = LRNPPAction;
	LRNPPAction.prototype = new TableAction();
	LRNPPAction.prototype.view = function() {
		if ($("#lrnpp_tanggal_from").val() == "" || $("#lrnpp_tanggal_to").val() == "")
			return;
		var self = this;
		$("#npp_info").empty();
		$("#npp_loading_bar").sload("true", "Harap ditunggu...", 0);
		$("#npp_loading_modal").smodal("show");
		FINISHED = false;
		var data = this.getRegulerData();
		data['command'] = "get_jumlah_obat";
		data['jenis_filter'] = $("#lrnpp_jenis_filter").val();
		data['urutan'] = $("#lrnpp_urutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lrnpp_list").empty();
				self.fillHtml(0, json.jumlah);
			}
		);
	};
	LRNPPAction.prototype.fillHtml = function(num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize();
			} else {
				$("#npp_loading_modal").smodal("hide");
				$("#npp_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#npp_export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info_obat_1";
		data['num'] = num;
		data['tanggal_from'] = $("#lrnpp_tanggal_from").val();
		data['tanggal_to'] = $("#lrnpp_tanggal_to").val();
		data['jenis_filter'] = $("#lrnpp_jenis_filter").val();
		data['urutan'] = $("#lrnpp_urutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#npp_loading_bar").sload("true", json.id_obat + " - " + json.kode_obat + " - " + json.nama_obat + " - " + json.nama_jenis_obat + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				$("tbody#lrnpp_list").append(
					json.html
				);
				self.fillHtml(num + 1, limit);
			}
		);
	};
	LRNPPAction.prototype.finalize = function() {
		var num_rows = $("tbody#lrnpp_list tr").length;
		$("#npp_loading_modal").smodal("hide");
		$("#npp_info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#npp_export_button").removeAttr("onclick");
		$("#npp_export_button").attr("onclick", "lrnpp.export_xls()");
	};
	LRNPPAction.prototype.cancel = function() {
		FINISHED = true;
	};
	LRNPPAction.prototype.export_xls = function() {
		showLoading();
		var num_rows = $("#lrnpp_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#lrnpp_list tr:eq(" + i + ") td#nomor").text();
			var id_obat = $("tbody#lrnpp_list tr:eq(" + i + ") td#id_obat").text();
			var kode_obat = $("tbody#lrnpp_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("tbody#lrnpp_list tr:eq(" + i + ") td#nama_obat").text();
			var satuan = $("tbody#lrnpp_list tr:eq(" + i + ") td#satuan").text();
			var stok_awal = $("tbody#lrnpp_list tr:eq(" + i + ") td#stok_awal").text();
			var tanggal = $("tbody#lrnpp_list tr:eq(" + i + ") td#tanggal").text();
			var vendor = $("tbody#lrnpp_list tr:eq(" + i + ") td#vendor").text();
			var jumlah_masuk = $("tbody#lrnpp_list tr:eq(" + i + ") td#jumlah_masuk").text();
			var dokter = $("tbody#lrnpp_list tr:eq(" + i + ") td#dokter").text();
			var pasien = $("tbody#lrnpp_list tr:eq(" + i + ") td#pasien").text();
			var jumlah_keluar = $("tbody#lrnpp_list tr:eq(" + i + ") td#jumlah_keluar").text();
			var stok_akhir = $("tbody#lrnpp_list tr:eq(" + i + ") td#stok_akhir").text();
			d_data[i] = {
				"nomor" 		: nomor,
				"id_obat" 		: id_obat,
				"kode_obat" 	: kode_obat,
				"nama_obat" 	: nama_obat,
				"satuan" 		: satuan,
				"stok_awal"		: stok_awal,
				"tanggal"		: tanggal,
				"vendor"		: vendor,
				"jumlah_masuk"	: jumlah_masuk,
				"dokter"		: dokter,
				"pasien"		: pasien,
				"jumlah_keluar"	: jumlah_keluar,
				"stok_akhir"	: stok_akhir
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#lrnpp_tanggal_from").val();
		data['tanggal_to'] = $("#lrnpp_tanggal_to").val();
		data['jenis_filter'] = $("#lrnpp_jenis_filter").val();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		postForm(data);
		dismissLoading();
	};

	var lrnpp;
	var FINISHED;
	$(document).ready(function() {
		lrnpp = new LRNPPAction(
			"lrnpp",
			"depo_farmasi_tanjung_uncang",
			"laporan_rekap_obat_npp",
			new Array()
		);
		$("#loading_modal").on("show", function() {
			$("a.close").hide();
		});
		$("#loading_modal").on("hide", function() {
			$("a.close").show();
		});
		$("tbody#lrnpp_list").append(
			"<tr>" +
				"<td colspan='13'><strong><center><small>DATA OBAT NPP BELUM DIPROSES</small></center></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>