function BahanAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
BahanAction.prototype.constructor = BahanAction;
BahanAction.prototype = new TableAction();
BahanAction.prototype.selected = function(json) {
	$("#dracikan_id_bahan").val(json.header.id_obat);
	$("#dracikan_kode_bahan").html(json.header.kode_obat);
	$("#dracikan_name_bahan").val(json.header.nama_obat);
	$("#dracikan_nama_bahan").val(json.header.nama_obat);
	$("#dracikan_nama_jenis_bahan").val(json.header.nama_jenis_obat);
	$("#dracikan_satuan").html(json.satuan_option);
	this.setDetailInfo();
};
BahanAction.prototype.setDetailInfo = function() {
	var part = $("#dracikan_satuan").val().split("_");
	var konversi = part[0];
	var satuan_konversi = part[1];
	var self = this;
	var data = this.getRegulerData();
	data['super_command'] = "";
	data['command'] = "get_current_stock";
	data['id_obat'] = $("#dracikan_id_bahan").val();
	data['kode_obat'] = $("#dracikan_kode_bahan").val();
	if ($("#resep_jenis").length)
		data['jenis_pasien'] = $("#resep_jenis").val();
	if ($("#resep_asuransi").length)
		data['asuransi'] = $("#resep_asuransi").val();
	if ($("#resep_perusahaan").length)
		data['perusahaan'] = $("#resep_perusahaan").val();
	if ($("#resep_uri").length)
		data['uri'] = $("#resep_uri").val();
	data['satuan'] = $("#dracikan_satuan option:selected").text();
	data['konversi'] = konversi;
	data['satuan_konversi'] = satuan_konversi;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			json = JSON.parse(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			$("#dracikan_sisa").val(json.sisa);
			$("#dracikan_harga").val("Rp. " + parseFloat(json.hja).formatMoney("2", ".", ","));
			$("#dracikan_jumlah").focus();
			dismissLoading();
		}
	);
};