<?php
	require_once("depo_farmasi_sekupang/library/InventoryLibrary.php");
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("depo_farmasi_sekupang/table/PenjualanResepTable.php");
	require_once("depo_farmasi_sekupang/adapter/ObatAdapter.php");
	require_once("depo_farmasi_sekupang/adapter/BahanAdapter.php");
	require_once("depo_farmasi_sekupang/adapter/PenjualanResepAdapter.php");
	require_once("depo_farmasi_sekupang/responder/ObatDBResponder.php");
	require_once("depo_farmasi_sekupang/responder/ApotekerServiceResponder.php");
	require_once("depo_farmasi_sekupang/responder/BahanDBResponder.php");
	require_once("depo_farmasi_sekupang/responder/PenjualanResepDBResponder.php");
	global $db;

	$setting_prefix = "depo_farmasi_sekupang";
	$setting_suffix = "depo_farmasi_sekupang";
	$depo_prefix = "frm_sekupang";
	$depo_label = "";

	$obat_table = new Table(array("Obat", "Jenis", "Stok"));
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatAdapter();
	$obat_dbtable = new DBTable($db, "smis_" . $depo_prefix . "_stok_obat");
	$obat_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (a.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%') ";
	}	
	$query_value = "
		SELECT
            id_obat AS id, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(CAST(sisa AS CHAR), ' ', CAST(satuan AS CHAR), ' (', label, ' - ', CAST(kode_obat AS CHAR), ')') ORDER BY kode_obat, satuan, sisa, label ASC SEPARATOR ', ') stok
        FROM (
            SELECT 
                a.id_obat, a.kode_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) AS 'sisa', a.satuan, a.konversi, a.satuan_konversi, 
                CASE a.label WHEN 'reguler' THEN 'R' WHEN 'sito' THEN 'S' ELSE 'K' END AS 'label'
            FROM 
                " . InventoryLibrary::$_TBL_STOK_OBAT . " a 
                    LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id 
            WHERE 
                a.prop NOT LIKE 'del' 
                    AND b.prop NOT LIKE 'del' 
                    AND b.status = 'sudah'
                    " . $filter . "
            GROUP BY 
                id_obat, kode_obat, satuan, konversi, satuan_konversi, label
        ) v
        GROUP BY
            id_obat, nama_obat, nama_jenis_obat
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_obat
	";
	$obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$obat_dbresponder = new ObatDBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);

	$apoteker_table = new Table(array("NIP", "Nama", "Jabatan"));
	$apoteker_table->setName("apoteker");
	$apoteker_table->setModel(Table::$SELECT);
	$apoteker_adapter = new SimpleAdapter();
	$apoteker_adapter->add("NIP", "nip");
	$apoteker_adapter->add("Nama", "nama");
	$apoteker_adapter->add("Jabatan", "nama_jabatan");
	$apoteker_service_responder = new ApotekerServiceResponder(
		$db,
		$apoteker_table,
		$apoteker_adapter,
		"employee"
	);

	$bahan_table = new Table(array("Bahan", "Jenis", "Stok"));
	$bahan_table->setName("bahan");
	$bahan_table->setModel(Table::$SELECT);
	$bahan_adapter = new BahanAdapter();
	$bahan_dbtable = new DBTable($db, "smis_" . $depo_prefix . "_stok_obat");
	$bahan_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (a.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%') ";
	}
	$query_value = "
		SELECT
            id_obat AS id, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(CAST(sisa AS CHAR), ' ', CAST(satuan AS CHAR), ' (', label, ' - ', CAST(kode_obat AS CHAR), ')') ORDER BY kode_obat, satuan, sisa, label ASC SEPARATOR ', ') stok
        FROM (
            SELECT 
                a.id_obat, a.kode_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) AS 'sisa', a.satuan, a.konversi, a.satuan_konversi, 
                CASE a.label WHEN 'reguler' THEN 'R' WHEN 'sito' THEN 'S' ELSE 'K' END AS 'label'
            FROM 
                " . InventoryLibrary::$_TBL_STOK_OBAT . " a 
                    LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id 
            WHERE 
                a.prop NOT LIKE 'del' 
                    AND b.prop NOT LIKE 'del' 
                    AND b.status = 'sudah'
                    " . $filter . "
            GROUP BY 
                id_obat, kode_obat, satuan, konversi, satuan_konversi, label
        ) v
        GROUP BY
            id_obat, nama_obat, nama_jenis_obat
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v
	";
	$bahan_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$bahan_dbresponder = new BahanDBResponder(
		$bahan_dbtable,
		$bahan_table,
		$bahan_adapter
	);

	$super_command = new SuperCommand();
	$super_command->addResponder("obat", $obat_dbresponder);
	$super_command->addResponder("apoteker", $apoteker_service_responder);
	$super_command->addResponder("bahan", $bahan_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_satuan_obat") {
			$id_obat = $_POST['id_obat'];
			$kode_obat = $_POST['kode_obat'];
			$satuan_rows = $db->get_result("
				SELECT 
					satuan, konversi, satuan_konversi 
				FROM (
					SELECT 
						a.satuan, a.konversi, a.satuan_konversi, SUM(a.sisa) AS 't_jumlah'
					FROM 
						" . InventoryLibrary::$_TBL_STOK_OBAT . " a 
							LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
					WHERE 
						a.prop NOT LIKE 'del' 
							AND b.prop NOT LIKE 'del' 
							AND b.status = 'sudah' 
							AND a.id_obat = '" . $id_obat . "' 
							AND a.kode_obat LIKE '" . $kode_obat . "'
					GROUP BY 
						id_obat, satuan, konversi, satuan_konversi
				) v
				ORDER BY 
					t_jumlah DESC
			");
			$satuan_option = "";
			foreach($satuan_rows as $sr) {
				if ($sr->konversi == 1) {
					$satuan_option .= "
						<option value='" . $sr->konversi . "_" . $sr->satuan_konversi . "'>" . $sr->satuan . "</option>
					";
				}
			}
			$data['satuan_option'] = $satuan_option;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_current_stock") {
			$_POST['action'] = "penjualan_resep";
			$sisa_table = new Table(array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi"));
			$sisa_table->setName("sisa");
			$sisa_adapter = new SimpleAdapter();
			$sisa_adapter->add("id_obat", "id_obat");
			$sisa_adapter->add("sisa", "sisa");
			$sisa_adapter->add("satuan", "satuan");
			$sisa_adapter->add("konversi", "konversi");
			$sisa_adapter->add("satuan_konversi", "satuan_konversi");
			$columns = array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi");
			$sisa_dbtable = new DBTable(
				$db,
				InventoryLibrary::$_TBL_STOK_OBAT,
				$columns
			);
			require_once("depo_farmasi_sekupang/responder/SisaDBResponder.php");
			$sisa_dbresponder = new SisaDBResponder(
				$sisa_dbtable,
				$sisa_table,
				$sisa_adapter
			);
			$response = $sisa_dbresponder->command("edit");
			$sisa = 0;
			$hna = 0;
			$margin_jual = 0;
			$tanggal_exp = "";
			if (isset($response['content'])) {
				$sisa = $response['content']->sisa;
				$hna = $response['content']->hna;
				$margin_jual = $response['content']->markup;
				$tanggal_exp = $response['content']->tanggal_exp;
			}
			$data = array(
				"sisa" 			=> $sisa,
				"hja"			=> $hna * (1 + $margin_jual / 100),
				"tanggal_exp"	=> $tanggal_exp
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "check_closing_bill") {
			if (getSettings($db, "depo_farmasi_sekupang-lock_tagihan", "0") == "0") {
	            $result = "0";
	        } else {
		        $service = new ServiceConsumer($db, "cek_tutup_tagihan", null, "registration");
		        $service->addData("noreg_pasien", $_POST['noreg_pasien']);
		        $service->execute();
		        $result = $service->getContent();
	        }
	        $pack = new ResponsePackage();
            $pack->setContent($result);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
	        if ($result == "1") {
                $pack->setAlertVisible(true);
			    $pack->setAlertContent("Peringatan", "<strong>Tagihan Pasien Sudah Ditutup</strong>, </br>Tidak dapat melakukan perubahan tagihan pada pasien. Silakan menghubungi pihak Kasir.",Alert::$DANGER);
            }
			echo json_encode($pack->getPackage());
		} else if ($_POST['command'] == "save_as_penjualan_resep") {
			/* Validasi Detail Resep :
			$detail_resep = $_POST['detail_resep'];
			$valid = true;
			$message = "";
			foreach($detail_resep as $dresep) {
				if ($dresep['tipe'] == "obat_jadi") {
					$id_obat = $dresep['id_obat'];
					$nama_obat = $dresep['nama_obat'];
					$data_stok = $db->get_result("
						SELECT 
							DISTINCT nama_obat 
						FROM 
							" . InventoryLibrary::$_TBL_STOK_OBAT . " 
						WHERE 
							id_obat = '" . $id_obat . "'
					");
					if ($data_stok != null) {
						foreach ($data_stok as $ds) {
							if ($ds->nama_obat != $nama_obat) {
								$valid = false;
								$message .= "<li><b><i>Obat Non-Racikan</i></b> - <b>" . $nama_obat . "</b> (ID Obat : " . $id_obat . ") tidak ditemukan pada Data Stok Depo Farmasi.</li>";
							}
						}
					}
				} else if ($dresep['tipe'] == "obat_racikan") {
					$nama_racikan = $dresep['nama'];
					if (isset($dresep['detail_racikan'])) {
						$detail_racikan = $dresep['detail_racikan'];
						foreach($detail_racikan as $dracikan) {
							$id_obat = $dracikan['id_obat'];
							$nama_obat = $dracikan['nama_obat'];
							$data_stok = $db->get_result("
								SELECT 
									DISTINCT nama_obat 
								FROM 
									" . InventoryLibrary::$_TBL_STOK_OBAT . " 
								WHERE 
									id_obat = '" . $id_obat . "'
							");
							if ($data_stok != null) {
								foreach ($data_stok as $ds) {
									if ($ds->nama_obat != $nama_obat) {
										$valid = false;
										$message .= "<li>Bahan Racikan <b>" . $nama_racikan . "</b> - " . $nama_obat . " (ID Obat : " . $id_obat . ") tidak ditemukan pada Data Stok Depo Farmasi.</li>";
									}
								}
							}
						}
					}
				}
			}
			if (!$valid) {
				$html_tombol = "<a href='#' class='input btn btn-warning'><i class='fa fa-pencil'></i></a>";
				$message = "<ul>" . $message . "</ul><br/>Silakan dipilih kembali obat tersebut menggunakan tombol " . $html_tombol . " supaya transaksi dapat ditindaklanjuti.";
				$pack = new ResponsePackage();
				$pack->setContent(array(
					'success' 	=> 0,
					'message'	=> $message
				));
				$pack->setStatus(ResponsePackage::$STATUS_OK);
				echo json_encode($pack->getPackage());
				return;
			}
			//. End of Validasi Detail Resep */

			$resep_table = new PenjualanResepTable(
				array("No. Penjualan", "No. Resep", "Tanggal/Jam", "Dokter", "No. Registrasi", "NRM", "Pasien", "Alamat", "Kat. Pasien", "Jns. Pasien", "Perusahaan", "Asuransi", "Edukasi"),
				"Farmasi : Penjualan Obat - Resep (KIUP)"
			);
			$resep_adapter = new PenjualanResepAdapter();
			$columns = array("id", "nomor_resep", "tanggal", "id_dokter", "nama_dokter", "noreg_pasien", "nrm_pasien", "nama_pasien", "alamat_pasien", "asuransi", "perusahaan", "ruangan", "uri", "jenis", "markup", "embalase", "tusla", "biaya_racik", "total", "edukasi", "dibatalkan", "diskon", "t_diskon", "keterangan_batal");
			$resep_dbtable = new DBTable(
				$db,
				"smis_" . $depo_prefix . "_penjualan_resep",
				$columns
			);
			$_POST['tanggal'] = date("Y-m-d H:i:s");
			$resep_dbresponder = new PenjualanResepDBResponder(
				$resep_dbtable,
				$resep_table,
				$resep_adapter
			);
			$data = $resep_dbresponder->command("save");
			if (isset($data['content'])) {
				if ($data['content']['type'] == "insert" && $data['content']['id'] > 0) {
					// Update Status E-Resep :
					$id_eresep = trim($_POST['nomor_resep'], "ER-");
					$eresep_dbtable = new DBTable($db, "smis_er_resep");
					global $user;
					$eresep_dbtable->update(
						array(
							'has_transaction' => 1,
							'operator_validasi' => $user->getNameOnly()
						),
						array('id' => $id_eresep)
					);
					//. End of Update Status E-Resep
				}
			}
			echo json_encode($data);
		} else if ($_POST['command'] == "validasi_data_obat") {
			$id_obat = $_POST['id_obat'];
			$nama_obat = $_POST['nama_obat'];
			$data_stok = $db->get_result("
				SELECT 
					DISTINCT nama_obat 
				FROM 
					" . InventoryLibrary::$_TBL_STOK_OBAT . " 
				WHERE 
					id_obat = '" . $id_obat . "'
			");
			$valid = true;
			if ($data_stok != null) {
				foreach ($data_stok as $ds) {
					if ($ds->nama_obat != $nama_obat) {
						$valid = false;
					}
				}
			}
			echo json_encode($valid);
		}
		return;
	}

	$editable = $_POST['editable'];
	$id_e_resep = $_POST['header']['id'];
	$tanggal_e_resep = $_POST['header']['tanggal'];
	$id_dokter = $_POST['header']['id_dokter'];
	$nama_dokter = $_POST['header']['nama_dokter'];
	$noreg_pasien = $_POST['header']['noreg_pasien'];
	$nrm_pasien = $_POST['header']['nrm_pasien'];
	$nama_pasien = $_POST['header']['nama_pasien'];
	$alamat_pasien = $_POST['header']['alamat_pasien'];
	$no_telpon_pasien = $_POST['header']['no_telpon'];
	$jenis_pasien = $_POST['header']['jenis'];
	$perusahaan_pasien = $_POST['header']['perusahaan'];
	$asuransi_pasien = $_POST['header']['asuransi'];
	$ruangan = $_POST['header']['ruangan'];
	$catatan_obat_racikan = $_POST['header']['catatan_obat_racikan'];
	$catatan = $_POST['header']['catatan'];

	$header_form = new Form("", "", "Farmasi : Formulir Tindak Lanjut E-Resep");
	$id_hidden = new Hidden("resep_id", "resep_id", $id_e_resep);
	$header_form->addElement("", $id_hidden);
	$uri_hidden = new Hidden("resep_uri", "resep_uri", "0");
	$header_form->addElement("", $uri_hidden);
	$markup_hidden = new Hidden("resep_markup", "resep_markup", getSettings($db, $setting_prefix . "-penjualan_resep-margin_penjualan", 0.2));
	$header_form->addElement("", $markup_hidden);
	$dresep_row_num_hidden = new Hidden("resep_dresep_row_num", "resep_dresep_row_num", count(json_decode($_POST['details'], true)));
	$header_form->addElement("", $dresep_row_num_hidden);
	$tanggal_text = new Text("resep_tanggal", "resep_tanggal", $tanggal_e_resep);
	$tanggal_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Waktu", $tanggal_text);
	$id_dokter_hidden = new Hidden("resep_id_dokter", "resep_id_dokter", $id_dokter);
	$header_form->addElement("", $id_dokter_hidden);
	$nama_dokter_text = new Text("resep_nama_dokter", "resep_nama_dokter", $nama_dokter);
	$nama_dokter_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Dokter", $nama_dokter_text);
	$noreg_pasien_text = new Text("resep_noreg_pasien", "resep_noreg_pasien", $noreg_pasien);
	$noreg_pasien_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. Reg.", $noreg_pasien_text);
	$nrm_pasien_text = new Text("resep_nrm_pasien", "resep_nrm_pasien", $nrm_pasien);
	$nrm_pasien_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. RM", $nrm_pasien_text);
	$nama_pasien_text = new Text("resep_nama_pasien", "resep_nama_pasien", $nama_pasien);
	$nama_pasien_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Nama Pasien", $nama_pasien_text);
	$alamat_pasien_text = new Text("resep_alamat_pasien", "resep_alamat_pasien", $alamat_pasien);
	$alamat_pasien_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Alamat Pasien", $alamat_pasien_text);
	$no_telpon_text = new Text("resep_no_telpon", "resep_no_telpon", $no_telpon_pasien);
	$no_telpon_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Telp. Pasien", $no_telpon_text);
	$jenis_hidden = new Hidden("resep_jenis", "resep_jenis", $jenis_pasien);
	$header_form->addElement("", $jenis_hidden);
	$f_jenis_text = new Text("resep_f_jenis", "resep_f_jenis", ArrayAdapter::format("unslug", $jenis_pasien));
	$f_jenis_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Jenis Pasien", $f_jenis_text);
	$perusahaan_text = new Text("resep_perusahaan", "resep_perusahaan", $perusahaan_pasien);
	$perusahaan_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Perusahaan", $perusahaan_text);
	$asuransi_text = new Text("resep_asuransi", "resep_asuransi", $asuransi_pasien);
	$asuransi_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Asuransi", $asuransi_text);
	$diskon_text = new Text("resep_diskon", "resep_diskon", "0,00");
	$diskon_text->setTypical("money");
	$diskon_text->setAtribute("data-thousands='.' data-decimal=','  data-precision='2'");
	$header_form->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	$t_diskon_option->add("Persen (%)", "persen", "1");
	$t_diskon_option->add("Nominal (Rp)", "nominal");
	$t_diskon_option->add("Paket Tindakan (100 %)", "gratis");
	$t_diskon_select = new Select("resep_t_diskon", "resep_t_diskon", $t_diskon_option->getContent());
	$header_form->addElement("Tipe Diskon", $t_diskon_select);
	$ruangan_hidden = new Hidden("resep_ruangan", "resep_ruangan", $ruangan);
	$header_form->addElement("", $ruangan_hidden);
	$f_ruangan_text = new Text("resep_f_ruangan", "resep_f_ruangan", ArrayAdapter::format("unslug", $ruangan));
	$f_ruangan_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Ruangan", $f_ruangan_text);
	$catatan_obat_racikan_textarea = new TextArea("resep_catatan_obat_racikan", "resep_catatan_obat_racikan", $catatan_obat_racikan);
	$catatan_obat_racikan_textarea->setLine(3);
	$catatan_obat_racikan_textarea->setAtribute("disabled='disabled'");
	$header_form->addElement("Obat Racikan", $catatan_obat_racikan_textarea);
	$catatan_textarea = new TextArea("resep_catatan", "resep_catatan", $catatan);
	$catatan_textarea->setLine(3);
	$catatan_textarea->setAtribute("disabled='disabled'");
	$header_form->addElement("Catatan", $catatan_textarea);

	$embalase_obat_jadi_hidden = new Hidden("resep_embalase_obat_jadi", "resep_embalase_obat_jadi", getSettings($db, $setting_prefix . "-penjualan_resep-embalase-obat_jadi", 0));
	$header_form->addElement("", $embalase_obat_jadi_hidden);
	$tuslah_obat_jadi_hidden = new Hidden("resep_tuslah_obat_jadi", "resep_tuslah_obat_jadi", getSettings($db, $setting_prefix . "-penjualan_resep-tuslah-obat_jadi", 0));
	$header_form->addElement("", $tuslah_obat_jadi_hidden);
	$biaya_racik_obat_jadi_hidden = new Hidden("resep_biaya_racik_obat_jadi", "resep_biaya_racik_obat_jadi", 0);
	$header_form->addElement("", $biaya_racik_obat_jadi_hidden);

	$embalase_bahan_racikan_hidden = new Hidden("resep_embalase_bahan_racikan", "resep_embalase_bahan_racikan", getSettings($db, $setting_prefix . "-penjualan_resep-embalase-bahan_racikan", 0));
	$header_form->addElement("", $embalase_bahan_racikan_hidden);
	$tuslah_bahan_racikan_hidden = new Hidden("resep_tuslah_bahan_racikan", "resep_tuslah_bahan_racikan", getSettings($db, $setting_prefix . "-penjualan_resep-tuslah-bahan_racikan", 0));
	$header_form->addElement("", $tuslah_bahan_racikan_hidden);
	$biaya_racik_bahan_racikan_hidden = new Hidden("resep_biaya_racik_bahan_racikan", "resep_biaya_racik_bahan_racikan", getSettings($db, $setting_prefix . "-penjualan_resep-jasa_racik", 0));
	$header_form->addElement("", $biaya_racik_bahan_racikan_hidden);

	$bahan_html = "
		<table style='display: none;'>
			<tbody id='r_bahan_list'>
	";
	$detail_html = "<table data-fix-header='n' class='table table-bordered table-hover table-striped table-condensed' id='table_dresep'>
						<thead>
							<tr class='inverse dresep_header_normal'>
								<th>No.</th>
								<th>Kode</th>
								<th>Nama</th>
								<th>Jumlah</th>
								<th>Harga Satuan</th>
								<th>Embalase</th>
								<th>Tuslah</th>
								<th>Biaya Racik</th>
								<th>Subtotal</th>
								<th>Aturan Pakai</th>
								<th>Apoteker</th>
								<th>Ubah</th>
								<th>Hapus</th>
							</tr>
						</thead>
						<tbody id='dresep_list'>";
	$details = json_decode($_POST['details'], true);
	$nomor = 1;
	$row_num = 0;
	$total_biaya = 0;
	$dbtable = new DBTable($db, "smis_" . $depo_prefix . "_penjualan_resep");
	foreach ($details as $d) {
		$params = array(
			"id_obat" 			=> $d['id_obat'],
			"kode_obat"			=> $d['kode_obat'],
			"nama_jenis_obat"	=> $d['nama_jenis_obat'],
			"satuan" 			=> $d['satuan'],
			"konversi" 			=> 1,
			"satuan_konversi" 	=> $d['satuan'],
			"jenis_pasien" 		=> $jenis_pasien,
			"uri" 				=> 0,
			"asuransi" 			=> $asuransi_pasien,
			"perusahaan" 		=> $perusahaan_pasien
		);
		$service_consumer = new ServiceConsumer(
			$db,
			"get_detail_info_obat",
			$params,
			$setting_suffix
		);
		$response = $service_consumer->execute()->getContent();
		$hna = array_key_exists("hna", $response['content']) ? $response['content']['hna'] : 0;
		$markup = array_key_exists("markup", $response['content']) ? $response['content']['markup'] : 0;
		$harga_non_racikan = floatval($hna) * (1 + floatval($markup) / 100);
		$tanggal_exp = array_key_exists("tanggal_exp", $response['content']) ? $response['content']['tanggal_exp'] : "";

		$embalase_non_racikan = getSettings($db, $setting_prefix . "-penjualan_resep-embalase-obat_jadi", 0);
		$tuslah_non_racikan = getSettings($db, $setting_prefix . "-penjualan_resep-tuslah-obat_jadi", 0);
		$biaya_racik_non_racikan = 0;
		$subtotal = $d['jumlah'] * $harga_non_racikan + $embalase_non_racikan + $tuslah_non_racikan + $biaya_racik_non_racikan;
		$total_biaya += $subtotal;

		$edit_button = "<center><a href='#' onclick='dresep.edit_non_racikan(" . $row_num . ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a></center>";
		$delete_button = "<center><a href='#' onclick='dresep.delete_non_racikan(" . $row_num . ")' class='input btn btn-danger'><i class='fa fa-trash-o'></i></a></center>";
		$row_label = "detail_" . $nomor;
		$detail_html .= "
			<tr class='" . $row_label . "'>
				<td id='nomor'><small>" . ($nomor++) . "</small></td>
				<td id='is_racikan' style='display: none;'>" . $d['is_racikan'] . "</td>
				<td id='jenis' style='display: none;'>" . $d['jenis_racikan'] . "</td>
				<td id='tanggal_exp' style='display: none;'>" . $tanggal_exp . "</td>
		        <td id='obat_luar' style='display: none;'>" . $d['obat_luar'] . "</td>
		        <td id='jumlah_pakai_sehari' style='display: none;'>" . $d['jumlah_pakai_sehari'] . "</td>
		        <td id='satuan_pakai' style='display: none;'>" . $d['satuan_pakai'] . "</td>
		        <td id='takaran_pakai' style='display: none;'>" . $d['takaran_pakai'] . "</td>
		        <td id='pemakaian' style='display: none;'>" . $d['pemakaian'] . "</td>
		        <td id='pemakaian_obat_luar' style='display: none;'>" . $d['pemakaian_obat_luar'] . "</td>
		        <td id='signa' style='display: none;'>" . $d['signa'] . "</td>
				<td id='id_obat' style='display: none;'>" . $d['id_obat'] . "</td>
				<td id='kode_obat'><small>" . $d['kode_obat'] . "</small></td>
				<td id='nama_obat'><small>" . $d['nama_obat'] . "</small></td>
				<td id='nama_jenis_obat' style='display: none;'><small>" . $d['nama_jenis_obat'] . "</small></td>
				<td id='jumlah' style='display: none;'>" . $d['jumlah'] .  "</td>
				<td id='satuan' style='display: none;'>" . $d['satuan'] . "</td>
				<td id='konversi' style='display: none;'>" . 1 .  "</td>
				<td id='satuan_konversi' style='display: none;'>" . $d['satuan'] .  "</td>
				<td id='f_jumlah'><small>" . $d['jumlah'] . " " . $d['satuan'] . "</small></td>
				<td id='harga' style='display: none;'>" . $harga_non_racikan . "</td>
				<td id='f_harga'><small><div align='right'>" . ArrayAdapter::format("only-money", $harga_non_racikan) . "</div></small></td>
				<td id='markup' style='display: none;'>" . $markup . "</td>
				<td id='embalase' style='display: none;'>" . $embalase_non_racikan . "</td>
				<td id='f_embalase'><small><div align='right'>" . ArrayAdapter::format("only-money", $embalase_non_racikan) . "</div></small></td>
				<td id='tuslah' style='display: none;'>" . $tuslah_non_racikan . "</td>
				<td id='f_tuslah'><small><div align='right'>" . ArrayAdapter::format("only-money", $tuslah_non_racikan) . "</div></small></td>
				<td id='biaya_racik' style='display: none;'>" . $biaya_racik_non_racikan . "</td>
				<td id='f_biaya_racik'><small><div align='right'>" . ArrayAdapter::format("only-money", $biaya_racik_non_racikan) . "</div></small></td>
				<td id='subtotal' style='display: none;'>" . $subtotal . "</td>
				<td id='f_subtotal'><small><div align='right'>" . ArrayAdapter::format("only-money", $subtotal) . "</div></small></td>
				<td class='preview_button'><center><a id='preview_button' href='#' onclick='dresep.previewAturanPakai(" . $row_num . ")' class='input btn btn-info'><i class='icon-eye-open icon-white'></i></a></center></td>
				<td id='id_apoteker' style='display: none;'></td>
				<td id='nama_apoteker'><small>-</small></td>
				<td class='edit_button'>" . $edit_button . "</td>
				<td class='del_button'>" . $delete_button . "</td>
			</tr>
		";
		$row_num++;
	} 
	$detail_html .= "	</tbody>
						<tfoot>
							<tr>
								<td colspan='8'><strong><small><center>T O T A L</center></small></strong></td>
								<td id='total_resep'><strong><small><div align='right'>" . ArrayAdapter::format("only-money", $total_biaya) . "</div></small></strong></td>
								<td colspan='4'></td>
							</tr>
						</tfoot>
					</table>";
	$bahan_html .= "
			</tbody>
		</table>
	";

	$non_racikan_form = new Form("", "", "<small>Form. Obat Non-Racikan</small>");
	$row_num_hidden = new Hidden("non_racikan_row_num", "non_racikan_row_num", "");
	$non_racikan_form->addElement("", $row_num_hidden);
	$id_obat_hidden = new Hidden("non_racikan_id_obat", "non_racikan_id_obat", "");
	$non_racikan_form->addElement("", $id_obat_hidden);
	$name_obat_hidden = new Hidden("non_racikan_name_obat", "non_racikan_name_obat", "");
	$non_racikan_form->addElement("", $name_obat_hidden);
	$nama_obat_text = new Text("non_racikan_nama_obat", "non_racikan_nama_obat", "");
	$nama_obat_text->setClass("smis-one-option-input");
	$obat_browse_button = new Button("", "", "Pilih");
	$obat_browse_button->setClass("btn-info");
	$obat_browse_button->setIsButton(Button::$ICONIC);
	$obat_browse_button->setIcon("icon-white ".Button::$icon_list_alt);
	$obat_browse_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat)");
	$obat_browse_button->setAtribute("id='obat_browse'");
	$obat_input_group = new InputGroup("");
	$obat_input_group->addComponent($nama_obat_text);
	$obat_input_group->addComponent($obat_browse_button);
	$non_racikan_form->addElement("Nama Obat", $obat_input_group);
	$kode_obat_hidden = new Hidden("non_racikan_kode_obat", "non_racikan_kode_obat", "");
	$non_racikan_form->addElement("", $kode_obat_hidden);
	$nama_jenis_obat_text = new Text("non_racikan_nama_jenis_obat", "non_racikan_nama_jenis_obat", "");
	$nama_jenis_obat_text->setAtribute("disabled='disabled'");
	$non_racikan_form->addElement("Jenis Obat", $nama_jenis_obat_text);
	$sisa_text = new Text("non_racikan_sisa", "non_racikan_sisa", "");
	$sisa_text->setAtribute("disabled='disabled'");
	$non_racikan_form->addElement("Sisa", $sisa_text);
	$jumlah_text = new Text("non_racikan_jumlah", "non_racikan_jumlah", "");
	$non_racikan_form->addElement("Jumlah", $jumlah_text);
	$satuan_select = new Select("non_racikan_satuan", "non_racikan_satuan", "");
	$satuan_select->setAtribute("onchange='obat.setDetailInfo()'");
	$non_racikan_form->addElement("Satuan", $satuan_select);
	$harga_text = new Text("non_racikan_harga", "non_racikan_harga", "");
	$harga_text->setTypical("money");
	$harga_text->setAtribute("data-thousands='.' data-decimal=',' data-prefix='Rp. '  data-precision='2' disabled='disabled'");
	$non_racikan_form->addElement("Harga", $harga_text);

	/// Etiket Obat Jadi :
	$tanggal_exp_text = new Text("non_racikan_tanggal_exp", "non_racikan_tanggal_exp", "");
	$tanggal_exp_text->setAtribute("disabled='disabled' data-date-format='dd-mm-yyyy'");
	$tanggal_exp_text->setClass("mydate");
	$non_racikan_form->addElement("Tgl. Exp.", $tanggal_exp_text);
	$obat_luar_option = new OptionBuilder();
	$obat_luar_option->add("Iya", "1");
	$obat_luar_option->add("Bukan", "0", "1");
	$obat_luar_select = new Select("non_racikan_obat_luar", "non_racikan_obat_luar", $obat_luar_option->getContent());
	$non_racikan_form->addElement("Obat Luar", $obat_luar_select);

	$signa_text = new Text("non_racikan_signa", "non_racikan_signa", "");
	$signa_text->setAtribute("disabled='disabled'");
	$non_racikan_form->addElement("Signa", $signa_text);

	$jumlah_pakai_sehari_text = new Text("non_racikan_jumlah_pakai_sehari", "non_racikan_jumlah_pakai_sehari", "");
	$non_racikan_form->addElement("J. Pakai Sehari", $jumlah_pakai_sehari_text);
	$satuan_pakai_option = new OptionBuilder();
	$satuan_pakai_option->add("", "", 1);
	$satuan_pakai_option->addSingle("ml");
	$satuan_pakai_option->addSingle("tetes");
	$satuan_pakai_option->addSingle("sendok takar");
	$satuan_pakai_option->addSingle("sendok makan");
	$satuan_pakai_select = new Select("non_racikan_satuan_pakai", "non_racikan_satuan_pakai", $satuan_pakai_option->getContent());
	$non_racikan_form->addElement("Satuan Pakai", $satuan_pakai_select);
	$takaran_pakai_text = new Text("non_racikan_takaran_pakai", "non_racikan_takaran_pakai", "");
	$non_racikan_form->addElement("Takaran Pakai", $takaran_pakai_text);
	$pemakaian_option = new OptionBuilder();
	$pemakaian_option->add("", "", "1");
	$pemakaian_option->addSingle("sebelum");
	$pemakaian_option->addSingle("sesudah");
	$pemakaian_option->addSingle("bersama");
	$pemakaian_select = new Select("non_racikan_pemakaian", "non_racikan_pemakaian", $pemakaian_option->getContent());
	$non_racikan_form->addElement("Pemakaian", $pemakaian_select);
	$pemakaian_obat_luar_text = new Text("non_racikan_pemakaian_obat_luar", "non_racikan_pemakaian_obat_luar", "");
	$non_racikan_form->addElement("Pemakaian", $pemakaian_obat_luar_text);
	//. End of Etiket Obat Jadi

	$update_button = new Button("", "", "Perbarui");
	$update_button->setClass("btn-info");
	$update_button->setIsButton(Button::$ICONIC_TEXT);
	$update_button->setIcon("fa fa-chevron-right");
	$update_button->setAction("non_racikan.save()");
	$update_button->setAtribute("id='non_racikan_update'");
	$cancel_button = new Button("", "", "Batal");
	$cancel_button->setClass("btn-danger");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("icon-white icon-remove");
	$cancel_button->setAction("non_racikan.cancel()");
	$cancel_button->setAtribute("id='non_racikan_cancel'");
	$button_group = new ButtonGroup("");
	$button_group->addButton($update_button);
	$button_group->addButton($cancel_button);
	$non_racikan_form->addElement("", $button_group);

	$racikan_form = new Form("", "", "Farmasi " . $depo_label . " : Form. Tindak Lanjut E-Resep - Obat Racikan");
	$row_num_hidden = new Hidden("racikan_row_num", "racikan_row_num", "");
	$racikan_form->addElement("", $row_num_hidden);
	$label_text = new Text("racikan_label", "racikan_label", "");
	$label_text->setAtribute("disabled='disabled'");
	$racikan_form->addElement("Label", $label_text);
	$id_apoteker_hidden = new Hidden("racikan_id_apoteker", "racikan_id_apoteker", "");
	$racikan_form->addElement("", $id_apoteker_hidden);
	$name_apoteker_hidden = new Hidden("racikan_name_apoteker", "racikan_name_apoteker", "");
	$racikan_form->addElement("", $name_apoteker_hidden);
	$nama_apoteker_text = new Text("racikan_nama_apoteker", "racikan_nama_apoteker", "");
	$nama_apoteker_text->setClass("smis-one-option-input");
	$apoteker_browse_button = new Button("", "", "Pilih");
	$apoteker_browse_button->setClass("btn-info");
	$apoteker_browse_button->setIsButton(Button::$ICONIC);
	$apoteker_browse_button->setIcon("icon-white ".Button::$icon_list_alt);
	$apoteker_browse_button->setAction("apoteker.chooser('apoteker', 'apoteker_button', 'apoteker', apoteker)");
	$apoteker_browse_button->setAtribute("id='apoteker_browse'");
	$apoteker_input_group = new InputGroup("");
	$apoteker_input_group->addComponent($nama_apoteker_text);
	$apoteker_input_group->addComponent($apoteker_browse_button);
	$racikan_form->addElement("Apoteker", $apoteker_input_group);
	$jumlah_kemasan_text = new Text("racikan_jumlah_kemasan", "racikan_jumlah_kemasan", "1");
	$racikan_form->addElement("Jml. Kemasan", $jumlah_kemasan_text);

	/// Etiket Obat Racikan :
	$tanggal_exp_text = new Text("racikan_tanggal_exp", "racikan_tanggal_exp", "");
	$tanggal_exp_text->setAtribute("data-date-format='dd-mm-yyyy'");
	$tanggal_exp_text->setClass("mydate");
	$racikan_form->addElement("Tgl. Exp.", $tanggal_exp_text);
	$obat_luar_option = new OptionBuilder();
	$obat_luar_option->add("Iya", "1");
	$obat_luar_option->add("Bukan", "0", "1");
	$obat_luar_select = new Select("racikan_obat_luar", "racikan_obat_luar", $obat_luar_option->getContent());
	$racikan_form->addElement("Obat Luar", $obat_luar_select);
	$jumlah_pakai_sehari_text = new Text("racikan_jumlah_pakai_sehari", "racikan_jumlah_pakai_sehari", "");
	$racikan_form->addElement("J. Pakai Sehari", $jumlah_pakai_sehari_text);
	$satuan_pakai_option = new OptionBuilder();
	$satuan_pakai_option->add("", "", 1);
	$satuan_pakai_option->addSingle("ml");
	$satuan_pakai_option->addSingle("tetes");
	$satuan_pakai_option->addSingle("sendok takar");
	$satuan_pakai_option->addSingle("sendok makan");
	$satuan_pakai_select = new Select("racikan_satuan_pakai", "racikan_satuan_pakai", $satuan_pakai_option->getContent());
	$racikan_form->addElement("Satuan Pakai", $satuan_pakai_select);
	$takaran_pakai_text = new Text("racikan_takaran_pakai", "racikan_takaran_pakai", "");
	$racikan_form->addElement("Takaran Pakai", $takaran_pakai_text);
	$pemakaian_option = new OptionBuilder();
	$pemakaian_option->add("", "", "1");
	$pemakaian_option->addSingle("sebelum");
	$pemakaian_option->addSingle("sesudah");
	$pemakaian_option->addSingle("bersama");
	$pemakaian_select = new Select("racikan_pemakaian", "racikan_pemakaian", $pemakaian_option->getContent());
	$racikan_form->addElement("Pemakaian", $pemakaian_select);
	$pemakaian_obat_luar_text = new Text("racikan_pemakaian_obat_luar", "racikan_pemakaian_obat_luar", "");
	$racikan_form->addElement("Pemakaian", $pemakaian_obat_luar_text);
	//. End of Etiket Obat Racikan

	$catatan_obat_racikan_textarea = new TextArea("racikan_catatan_obat_racikan", "racikan_catatan_obat_racikan", $catatan_obat_racikan);
	$catatan_obat_racikan_textarea->setLine(3);
	$catatan_obat_racikan_textarea->setAtribute("disabled='disabled'");
	$racikan_form->addElement("Catatan", $catatan_obat_racikan_textarea);

	$dracikan_form = new Form("", "", "<small>Form. Bahan Racikan</small>");
	$row_num_hidden = new Hidden("dracikan_row_num", "dracikan_row_num", "");
	$dracikan_form->addElement("", $row_num_hidden);
	$id_bahan_hidden = new Hidden("dracikan_id_bahan", "dracikan_id_bahan", "");
	$dracikan_form->addElement("", $id_bahan_hidden);
	$name_bahan_hidden = new Hidden("dracikan_name_bahan", "dracikan_name_bahan", "");
	$dracikan_form->addElement("", $name_bahan_hidden);
	$nama_bahan_text = new Text("dracikan_nama_bahan", "dracikan_nama_bahan", "");
	$nama_bahan_text->setClass("smis-one-option-input");
	$bahan_browse_button = new Button("", "", "Pilih");
	$bahan_browse_button->setClass("btn-info");
	$bahan_browse_button->setIsButton(Button::$ICONIC);
	$bahan_browse_button->setIcon("icon-white ".Button::$icon_list_alt);
	$bahan_browse_button->setAction("bahan.chooser('bahan', 'bahan_button', 'bahan', bahan)");
	$bahan_browse_button->setAtribute("id='bahan_browse'");
	$bahan_input_group = new InputGroup("");
	$bahan_input_group->addComponent($nama_bahan_text);
	$bahan_input_group->addComponent($bahan_browse_button);
	$dracikan_form->addElement("Nama Bahan", $bahan_input_group);
	$kode_bahan_hidden = new Hidden("dracikan_kode_bahan", "dracikan_kode_bahan", "");
	$dracikan_form->addElement("", $kode_bahan_hidden);
	$nama_jenis_bahan_text = new Text("dracikan_nama_jenis_bahan", "dracikan_nama_jenis_bahan", "");
	$nama_jenis_bahan_text->setAtribute("disabled='disabled'");
	$dracikan_form->addElement("Jenis Bahan", $nama_jenis_bahan_text);
	$sisa_text = new Text("dracikan_sisa", "dracikan_sisa", "");
	$sisa_text->setAtribute("disabled='disabled'");
	$dracikan_form->addElement("Sisa", $sisa_text);
	$jumlah_text = new Text("dracikan_jumlah", "dracikan_jumlah", "");
	$dracikan_form->addElement("Jumlah", $jumlah_text);
	$satuan_select = new Select("dracikan_satuan", "dracikan_satuan", "");
	$satuan_select->setAtribute("onchange", "bahan.setDetailInfo()");
	$dracikan_form->addElement("Satuan", $satuan_select);
	$harga_text = new Text("dracikan_harga", "dracikan_harga", "Rp. 0,00");
	$harga_text->setAtribute("disabled='disabled'");
	$dracikan_form->addElement("Harga", $harga_text);
	$save_button = new Button("", "", "Tambahkan");
	$save_button->setClass("btn-info");
	$save_button->setIsButton(Button::$ICONIC_TEXT);
	$save_button->setIcon("fa fa-chevron-right");
	$save_button->setAction("dracikan.save()");
	$save_button->setAtribute("id='dracikan_save'");
	$update_button = new Button("", "", "Perbarui");
	$update_button->setClass("btn-info");
	$update_button->setIsButton(Button::$ICONIC_TEXT);
	$update_button->setIcon("fa fa-chevron-right");
	$update_button->setAction("dracikan.save()");
	$update_button->setAtribute("id='dracikan_update'");
	$cancel_button = new Button("", "", "Batal");
	$cancel_button->setClass("btn-danger");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("icon-white icon-remove");
	$cancel_button->setAction("dracikan.cancel()");
	$cancel_button->setAtribute("id='dracikan_cancel'");
	$button_group = new ButtonGroup("");
	$button_group->addButton($update_button);
	$button_group->addButton($cancel_button);
	$dracikan_form->addElement("", $save_button);
	$dracikan_form->addElement("", $button_group);

	$dracikan_html = "
		<table data-fix-header='n' class='table table-bordered table-hover table-striped table-condensed' id='table_dracikan'>
			<thead>
				<tr class='inverse dracikan_header_normal'>
					<th>No.</th>
					<th>Kode</th>
					<th>Nama</th>
					<th>Jumlah</th>
					<th>Harga Satuan</th>
					<th>Embalase</th>
					<th>Tuslah</th>
					<th>Subtotal</th>
					<th>Ubah</th>
					<th>Hapus</th>
				</tr>
			</thead>
			<tbody id='dracikan_list'></tbody>
			<tfoot>
				<tr>
					<td colspan='7'><strong><small><div align='right'>Total I</div></small></strong></td>
					<td id='subtotal_racikan'><small><div align='right'>0,00</div></small></td>
					<td colspan='2'></td>
				</tr>
				<tr>
					<td colspan='7'><strong><small><div align='right'>Biaya Racik</div></small></strong></td>
					<td id='biaya_racik_racikan'><small><div align='right'>" . ArrayAdapter::format("only-money", getSettings($db, $setting_prefix . "-penjualan_resep-jasa_racik", 0)) . "</div></small></td>
					<td colspan='2'></td>
				</tr>
				<tr>
					<td colspan='7'><strong><small><div align='right'>Total II</div></small></strong></td>
					<td id='total_racikan'><small><div align='right'>0,00</div></small></td>
					<td colspan='2'></td>
				</tr>
			</tfoot>
		</table>
	";

	$racikan_button_group = new ButtonGroup("");
	$cancel_button = new Button("", "", "Kembali");
	$cancel_button->setClass("btn-inverse");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("fa fa-close");
	$cancel_button->setAction("racikan.cancel()");
	$cancel_button->setAtribute("id='racikan_back'");
	$racikan_button_group->addButton($cancel_button);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setIsButton(Button::$ICONIC_TEXT);
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setAction("racikan.save()");
	$save_button->setAtribute("id='racikan_save'");
	$racikan_button_group->addButton($save_button);

	$resep_button_group = new ButtonGroup("");
	$cancel_button = new Button("", "", "Kembali");
	$cancel_button->setClass("btn-inverse");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("fa fa-close");
	$cancel_button->setAction("resep.cancel()");
	$cancel_button->setAtribute("id='resep_back'");
	$resep_button_group->addButton($cancel_button);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setIsButton(Button::$ICONIC_TEXT);
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setAction("resep.save()");
	$save_button->setAtribute("id='resep_save'");
	$resep_button_group->addButton($save_button);

	$racikan_form_button = new Button("", "", "Obat Racikan");
	$racikan_form_button->setClass("btn-info");
	$racikan_form_button->setIsButton(Button::$ICONIC_TEXT);
	$racikan_form_button->setIcon("fa fa-plus");
	$racikan_form_button->setAction("racikan.show_form()");

	echo "<div id='e_resep_form'>";
	echo 	$header_form->getHtml();
	echo 	"<div id='table_content' class='non_racikan_section'>" .
				"<div class='row-fluid'>";
	echo 			"<div id='non_racikan_form_section' class='span3'>" .
						$non_racikan_form->getHtml() .
					"</div>";
	echo 			"<div id='dresep_table_section' class='span9'>" .
						$detail_html .
					"</div>";
	echo 			"<div class='span3' align='left'>" .
						$racikan_form_button->getHtml() .
					"</div>";
	echo 			"<div class='span6' align='right'>" .
						$resep_button_group->getHtml() .
					"</div>";
	echo 		"</div>";
	echo 	"</div>";
	echo "</div>";
	echo "<div id='racikan_form_section' style='display: none;'>";
	echo 	$racikan_form->getHtml();
	echo 	"<div id='table_content'>" .
				"<div class='row-fluid'>";
	echo 			"<div id='dracikan_form_section' class='span3'>" .
						$dracikan_form->getHtml() .
					"</div>";
	echo 			"<div id='dresep_table_section' class='span9'>" .
						$dracikan_html .
					"</div>";
	echo 			"<div align='right'>" .
						$racikan_button_group->getHtml() .
					"</div>";
	echo 		"</div>";
	echo 	"</div>";
	echo "</div>";
	echo $bahan_html;
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("depo_farmasi_sekupang/js/e_resep_resep_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_dresep_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_non_racikan_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_racikan_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_dracikan_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_obat_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_bahan_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep_apoteker_action.js", false);
	echo addJS("depo_farmasi_sekupang/js/e_resep.js", false);
?>