<?php
	require_once("depo_farmasi_piayu/library/InventoryLibrary.php");
	
	class SisaDBResponder extends DBResponder {
		private function getLastHPPObat($id_obat) {
			$hpp = 0;
			$hpp_gudang_row = $this->dbtable->get_row("
				SELECT 
					a.hna hpp_terakhir
				FROM 
					smis_fr_stok_obat a 
						INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
						INNER JOIN smis_fr_obat_f_masuk c ON b.id_obat_f_masuk = c.id
				WHERE 
					a.prop = '' 
						AND b.prop = '' 
						AND b.id_obat = '" . $id_obat . "' 
				ORDER BY
					c.tanggal_datang DESC, c.id DESC
				LIMIT 
					0, 1
			");
			if ($hpp_gudang_row != null) {
				$hpp = $hpp_gudang_row->hpp_terakhir;
			}
			return $hpp;
		}

		private function getHPPJualObat($id_obat) {
			$hpp = 0;
			$hpp_gudang_row = $this->dbtable->get_row("
				SELECT 
					MAX(a.hna) hpp_tertinggi
				FROM 
					smis_fr_stok_obat a 
						INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
				WHERE 
					a.prop = '' 
						AND b.prop = '' 
						AND b.id_obat = '" . $id_obat . "' 
						AND a.sisa > 0
			");
			if ($hpp_gudang_row != null) {
				$hpp = $hpp_gudang_row->hpp_tertinggi;
				if ($hpp == 0) {
					$hpp = $this->getLastHPPObat($id_obat);
				}
			} else {
				$hpp = $this->getLastHPPObat($id_obat);
			}
			return $hpp;
		}

		public function edit() {
			$id_obat = $_POST['id_obat'];
			$satuan = $_POST['satuan'];
			$konversi = $_POST['konversi'];
			$satuan_konversi = $_POST['satuan_konversi'];
			$default_margin = 0;
			$value_margin = 0;

			$hpp_gudang = $this->getHPPJualObat($id_obat);

			// margin per obat - jenis pasien :
			if (getSettings($this->dbtable->get_db(), "depo_farmasi_piayu-" . $_POST['action'] . "-mode_margin_penjualan", 0) == 3) {
				$jenis_pasien = "";
				if (isset($_POST['jenis_pasien']))
					$jenis_pasien = $_POST['jenis_pasien'];
				$value_margin = "b.margin_jual";
				$data = $this->dbtable->get_row("
					SELECT v_stok_obat.id_obat, " . $hpp_gudang . " AS 'hna', SUM(v_stok_obat.sisa) AS 'sisa', v_stok_obat.satuan, v_stok_obat.konversi, v_stok_obat.satuan_konversi, v_stok_obat.markup, v_ed.ed
					FROM (
						SELECT a.id_obat, a.sisa, a.satuan, a.konversi, a.satuan_konversi, a.hna, CASE WHEN b.margin_jual IS NULL THEN " . $default_margin . " ELSE " . $value_margin . " END AS 'markup'
						FROM (" . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_MARGIN_JUAL_OBAT_JENIS_PASIEN . " b ON a.id_obat = b.id_obat) LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " c ON a.id_obat_masuk = c.id
						WHERE a.prop NOT LIKE 'del' AND c.prop NOR LIKE 'del' AND c.status = 'sudah' AND b.prop NOT LIKE 'del' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND b.slug = '" . $jenis_pasien . "'
					) v_stok_obat LEFT JOIN (
						SELECT a.id_obat, MIN(a.tanggal_exp) ed
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a INNER JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop = '' AND b.prop = '' AND b.status = 'sudah' AND a.sisa > 0
						GROUP BY id_obat
					) v_ed ON v_stok_obat.id_obat = v_ed.id_obat
					GROUP BY id_obat, satuan, konversi, satuan_konversi
				");
				if ($data != null) {
					$data->fix_hja = 0;
					$data->harga_jual = 0;
				}
				return $data;
			}
			// margin per obat :
			if (getSettings($this->dbtable->get_db(), "depo_farmasi_piayu-" . $_POST['action'] . "-mode_margin_penjualan", 0) == 2) {
				$data = $this->dbtable->get_row("
					SELECT v_stok_obat.id_obat, " . $hpp_gudang . " AS 'hna', SUM(v_stok_obat.sisa) AS 'sisa', v_stok_obat.satuan, v_stok_obat.konversi, v_stok_obat.satuan_konversi, 0 markup, v_ed.ed
					FROM (
						SELECT a.id_obat, a.sisa, a.satuan, a.konversi, a.satuan_konversi, a.hna
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " c ON a.id_obat_masuk = c.id
						WHERE a.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND c.status = 'sudah' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "'
					) v_stok_obat LEFT JOIN (
						SELECT a.id_obat, MIN(a.tanggal_exp) ed
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a INNER JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop = '' AND b.prop = '' AND b.status = 'sudah' AND a.sisa > 0
						GROUP BY id_obat
					) v_ed ON v_stok_obat.id_obat = v_ed.id_obat
					GROUP BY id_obat, satuan, konversi, satuan_konversi
				");
				if ($data != null) {
					$data->fix_hja = 0;
					$data->harga_jual = 0;
					$margin_row = $this->dbtable->get_row("
						SELECT
							fix_hja, harga_jual
						FROM
							smis_fr_margin_jual_per_obat
						WHERE
							prop = ''
								AND id_obat = '" . $id_obat . "'
					");
					if ($margin_row != null) {
						$data->fix_hja = $margin_row->fix_hja;
						$data->harga_jual = $margin_row->harga_jual;
					}
				}
				return $data;
			}
			// margin per jenis pasien :
			if (getSettings($this->dbtable->get_db(), "depo_farmasi_piayu-" . $_POST['action'] . "-mode_margin_penjualan", 0) == 1) {
				$jenis_pasien = $_POST['jenis_pasien'];
				$data = $this->dbtable->get_row("
					SELECT *
					FROM " . InventoryLibrary::$_TBL_MARGIN_JUAL_JENIS_PASIEN . "
					WHERE prop NOT LIKE 'del' AND slug = '" . $jenis_pasien . "'
					LIMIT 0, 1
				");
				if ($data != null)
					$value_margin = $data->margin_jual;
				$data = $this->dbtable->get_row("
					SELECT v_stok_obat.*, v_ed.ed
					FROM (
						SELECT a.id_obat, " . $hpp_gudang . " AS 'hna', SUM(a.sisa) AS 'sisa', a.satuan, a.konversi, a.satuan_konversi, " . $value_margin . " AS markup
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "'
						GROUP BY a.id_obat, a.satuan, a.konversi, a.satuan_konversi
					) v_stok_obat LEFT JOIN (
						SELECT a.id_obat, MIN(a.tanggal_exp) ed
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a INNER JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop = '' AND b.prop = '' AND b.status = 'sudah' AND a.sisa > 0
						GROUP BY id_obat
					) v_ed ON v_stok_obat.id_obat = v_ed.id_obat
				");
				if ($data != null) {
					$data->fix_hja = 0;
					$data->harga_jual = 0;
				}
				return $data;
			}
			// margin per jenis transaksi:
			if (getSettings($this->dbtable->get_db(), "depo_farmasi_piayu-" . $_POST['action'] . "-mode_margin_penjualan", 0) == 0) {
				$value_margin = getSettings($this->dbtable->get_db(), "depo_farmasi_piayu-" . $_POST['action'] . "-margin_penjualan", 0);
				$data = $this->dbtable->get_row("
					SELECT v_stok_obat.*, v_ed.ed
					FROM (
						SELECT a.id_obat, " . $hpp_gudang . " AS 'hna', SUM(a.sisa) AS 'sisa', a.satuan, a.konversi, a.satuan_konversi, " . $value_margin . " AS markup
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a LEFT JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND konversi = '" . $konversi . "' AND satuan_konversi = '" . $satuan_konversi . "'
						GROUP BY a.id_obat, a.satuan, a.konversi, a.satuan_konversi
					) v_stok_obat LEFT JOIN (
						SELECT a.id_obat, MIN(a.tanggal_exp) ed
						FROM " . InventoryLibrary::$_TBL_STOK_OBAT . " a INNER JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
						WHERE a.prop = '' AND b.prop = '' AND b.status = 'sudah' AND a.sisa > 0
						GROUP BY id_obat
					) v_ed ON v_stok_obat.id_obat = v_ed.id_obat
				");
				if ($data != null) {
					$data->fix_hja = 0;
					$data->harga_jual = 0;
				}
				return $data;
			}
			return null;
		}
	}
?>