<?php
	class InventoryLibrary {
		public static $_TBL_OBAT_MASUK = "smis_frm_piayu_obat_masuk";
		public static $_TBL_STOK_OBAT = "smis_frm_piayu_stok_obat";
		public static $_TBL_RIWAYAT_STOK_OBAT = "smis_frm_piayu_riwayat_stok_obat";
		public static $_TBL_KARTU_STOK_OBAT = "smis_frm_piayu_kartu_stok_obat";
		public static $_TBL_PENJUALAN_RESEP = "smis_frm_piayu_penjualan_resep";
		public static $_TBL_PENJUALAN_OBAT_JADI = "smis_frm_piayu_penjualan_obat_jadi";
		public static $_TBL_STOK_PAKAI_OBAT_JADI = "smis_frm_piayu_stok_pakai_obat_jadi";
		public static $_TBL_PENJUALAN_OBAT_RACIKAN = "smis_frm_piayu_penjualan_obat_racikan";
		public static $_TBL_BAHAN_PAKAI_OBAT_RACIKAN = "smis_frm_piayu_bahan_pakai_obat_racikan";
		public static $_TBL_STOK_PAKAI_BAHAN = "smis_frm_piayu_stok_pakai_bahan";
		public static $_TBL_RETUR_PENJUALAN_RESEP = "smis_frm_piayu_retur_penjualan_resep";
		public static $_TBL_DRETUR_PENJUALAN_RESEP = "smis_frm_piayu_dretur_penjualan_resep";
		public static $_TBL_RETUR_OBAT = "smis_frm_piayu_retur_obat";
		public static $_TBL_PENYESUAIAN_STOK_OBAT = "smis_frm_piayu_penyesuaian_stok_obat";
		public static $_TBL_PENGGUNAAN_OBAT = "smis_frm_piayu_penggunaan_obat";
		public static $_TBL_INSTANSI_LAIN = "smis_frm_piayu_instansi_lain";
		public static $_TBL_MARGIN_JUAL_OBAT = "smis_frm_piayu_margin_jual_obat";
		public static $_TBL_MARGIN_JUAL_JENIS_PASIEN = "smis_frm_piayu_margin_jual_jenis_pasien";
		public static $_TBL_MARGIN_JUAL_OBAT_JENIS_PASIEN = "smis_frm_piayu_margin_jual_obat_jenis_pasien";
		public static $_TBL_WS_BPJS_ADD_OBAT = "smis_frm_piayu_ws_bpjs_add_obat";
		public static $_TBL_WS_BPJS_DELETE_OBAT = "smis_frm_piayu_ws_bpjs_delete_obat";

		public static function getCurrentStock($db, $id_obat, $satuan, $konversi, $satuan_konversi) {
			$dbtable = new DBTable($db, self::$_TBL_STOK_OBAT);
			$jumlah = 0;
			$row = $dbtable->get_row("
				SELECT SUM(a.sisa) AS 'jumlah'
				FROM " . self::$_TBL_STOK_OBAT . " a LEFT JOIN " . self::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' AND a.id_obat = '" . $id_obat . "'
			");
			$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getLastHPP($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_to) {
			$params = array(
				"id_obat" 		=> $id_obat,
				"tanggal_to"	=> $tanggal_to
			);
			$consumer_service = new ServiceConsumer(
				$db,
				"get_last_hpp_until",
				$params,
				"gudang_farmasi"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$hpp_terakhir = 0;
			if ($content != null)
				$hpp_terakhir = $content[0];
			return $hpp_terakhir;
		}

		public static function getStockIn($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, self::$_TBL_OBAT_MASUK);
			$jumlah = 0;
			// retur penjualan resep:
			$row = $dbtable->get_row("
				SELECT SUM(b.jumlah) AS 'jumlah'
				FROM (" . self::$_TBL_RETUR_PENJUALAN_RESEP . " a LEFT JOIN " . self::$_TBL_DRETUR_PENJUALAN_RESEP . " b ON a.id = b.id_retur_penjualan_resep) LEFT JOIN " . self::$_TBL_STOK_OBAT . " c ON b.id_stok_obat = c.id
				WHERE a.prop NOT LIKE 'del' AND a.dibatalkan = '0' AND c.id_obat = '" . $id_obat . "' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// penerimaan mutasi:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah) AS 'jumlah'
				FROM " . self::$_TBL_STOK_OBAT . " a LEFT JOIN " . self::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del'  AND b.status = 'sudah' AND a.id_obat = '" . $id_obat . "' AND b.tanggal >= '" . $tanggal_from . "' AND b.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getStockOut($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, self::$_TBL_PENJUALAN_RESEP);
			$jumlah = 0;
			// penjualan obat jadi:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah) AS 'jumlah'
				FROM " . self::$_TBL_PENJUALAN_OBAT_JADI . " a LEFT JOIN " . self::$_TBL_PENJUALAN_RESEP . " b ON a.id_penjualan_resep = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND b.tanggal >= '" . $tanggal_from . " 00:00' AND b.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// penjualan racikan:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah) AS 'jumlah'
				FROM (" . self::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . " a LEFT JOIN " . self::$_TBL_PENJUALAN_OBAT_RACIKAN . " b ON a.id_penjualan_obat_racikan = b.id) LEFT JOIN " . self::$_TBL_PENJUALAN_RESEP . " c ON b.id_penjualan_resep = c.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND c.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND c.tanggal >= '" . $tanggal_from . " 00:00' AND c.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// retur gudang:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah) AS 'jumlah'
				FROM " . self::$_TBL_RETUR_OBAT . " a LEFT JOIN " . self::$_TBL_STOK_OBAT . " b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// penggunaan obat:
			$row = $db->get_row("
				SELECT 
					SUM(a.jumlah) AS 'jumlah'
				FROM 
					" . InventoryLibrary::$_TBL_PENGGUNAAN_OBAT . " a 
						LEFT JOIN " . InventoryLibrary::$_TBL_STOK_OBAT . " b ON a.id_stok_obat = b.id
				WHERE 
					a.prop NOT LIKE 'del' 
						AND b.id_obat = '" . $id_obat . "' 
						AND a.tanggal >= '" . $tanggal_from . "' 
						AND a.tanggal <= '" . $tanggal_to . "'
			");
			if ($row != null)
				$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getPenyesuaianStokPositif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, self::$_TBL_PENYESUAIAN_STOK_OBAT);
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah_baru - a.jumlah_lama) AS 'jumlah'
				FROM " . self::$_TBL_PENYESUAIAN_STOK_OBAT . " a LEFT JOIN " . self::$_TBL_STOK_OBAT . " b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru >= a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}

		public static function getPenyesuaianStokNegatif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, self::$_TBL_PENYESUAIAN_STOK_OBAT);
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah_lama - a.jumlah_baru) AS 'jumlah'
				FROM " . self::$_TBL_PENYESUAIAN_STOK_OBAT . " a LEFT JOIN " . self::$_TBL_STOK_OBAT . " b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru < a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}
	}
?>