function DRacikanAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
DRacikanAction.prototype.constructor = DRacikanAction;
DRacikanAction.prototype = new TableAction();
DRacikanAction.prototype.add_mode = function() {
	$("#dracikan_kode_bahan").removeAttr("disabled");
	$("#dracikan_satuan").removeAttr("disabled");
	$("#dracikan_satuan").attr("onchange", "bahan.setDetailInfo()");
	$("#dracikan_nama_bahan").addClass("smis-one-option-input");
	$("#dracikan_nama_bahan").removeAttr("disabled");
	$("#bahan_browse").show();
	$("#dracikan_save").show();
	$("#dracikan_update").hide();
	$("#dracikan_cancel").hide();
};
DRacikanAction.prototype.edit_mode = function() {
	$("#dracikan_kode_bahan").removeAttr("disabled");
	$("#dracikan_kode_bahan").attr("disabled", "disabled");
	$("#dracikan_satuan").removeAttr("disabled");
	$("#dracikan_satuan").attr("disabled", "disabled");
	$("#dracikan_satuan").removeAttr("onchange");
	$("#dracikan_nama_bahan").removeClass("smis-one-option-input");
	$("#dracikan_nama_bahan").attr("disabled", "disabled");
	$("#bahan_browse").hide();
	$("#dracikan_save").hide();
	$("#dracikan_update").show();
	$("#dracikan_cancel").show();
};
DRacikanAction.prototype.clear = function() {
	$("#dracikan_row_num").val("");
	$("#dracikan_id_bahan").val("");
	$("#dracikan_kode_bahan").val("");
	$("#dracikan_name_bahan").val("");
	$("#dracikan_nama_bahan").val("");
	$("#dracikan_nama_jenis_bahan").val("");
	$("#dracikan_sisa").val("");
	$("#dracikan_jumlah").val("");
	$("#dracikan_satuan").html("");
	$("#dracikan_harga").val("Rp. 0,00");
};
DRacikanAction.prototype.refreshTotal = function() {
	var num_rows = $("#dracikan_list tr").length;
	var number = 1;
	var subtotal_racikan = 0;
	for (var i = 0; i < num_rows; i++, number++) {
		$("#dracikan_list tr:eq(" + i + ") td#nomor").html("<small>" + number + "</small>");
		var edit_button = "<center><a href='#' onclick='dracikan.edit(" + i + ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a></center>";
		var delete_button = "<center><a href='#' onclick='dracikan.delete(" + i + ")' class='input btn btn-danger'><i class='fa fa-trash-o'></i></a></center>";
		$("#dracikan_list tr:eq(" + i + ") td.edit_button").html(edit_button);
		$("#dracikan_list tr:eq(" + i + ") td.del_button").html(delete_button);
		var subtotal = parseFloat($("#dracikan_list tr:eq(" + i + ") td#subtotal").text());
		subtotal_racikan += subtotal;
	}
	$("#subtotal_racikan").html("<strong><small><div align='right'>" + subtotal_racikan.formatMoney("2",  ".",  ",") + "</div></small></strong>");
	var total = parseFloat(subtotal_racikan) + parseFloat($("#biaya_racik_racikan").text().replace(/[^0-9-,]/g, '').replace(",", "."));
	$("#total_racikan").html("<strong><small><div align='right'>" + total.formatMoney("2",  ".",  ",") + "</div></small></strong>");

};
DRacikanAction.prototype.edit = function(r_num) {
	var self = this;
	var id_obat = $("#dracikan_list tr:eq(" + r_num + ") td#id_obat").text();
	var kode_obat = $("#dracikan_list tr:eq(" + r_num + ") td#kode_obat").text();
	var nama_obat = $("#dracikan_list tr:eq(" + r_num + ") td#nama_obat").text();
	var nama_jenis_obat = $("#dracikan_list tr:eq(" + r_num + ") td#nama_jenis_obat").text();
	var jumlah = $("#dracikan_list tr:eq(" + r_num + ") td#jumlah").text();
	var satuan = $("#dracikan_list tr:eq(" + r_num + ") td#satuan").text();
	var harga = "Rp. " + parseFloat($("#dracikan_list tr:eq(" + r_num + ") td#harga").text()).formatMoney("2", ".", ",");
	
	var data = this.getRegulerData();
	data['super_command'] = "bahan";
	data['command'] = "edit";
	data['id'] = id_obat;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			dismissLoading();
			$("#dracikan_row_num").val(r_num);
			$("#dracikan_id_bahan").val(id_obat);
			$("#dracikan_kode_bahan").val(kode_obat);
			$("#dracikan_satuan").html(json.satuan_option);
			$("#dracikan_satuan").val("1_" + satuan);
			$("#dracikan_name_bahan").val(nama_obat);
			$("#dracikan_nama_bahan").val(nama_obat);
			$("#dracikan_nama_jenis_bahan").val(nama_jenis_obat);		
			data = self.getRegulerData();
			data['super_command'] = "";
			data['command'] = "get_current_stock";
			data['id_obat'] = id_obat;
			data['kode_obat'] = kode_obat;
			if ($("#resep_jenis").length)
				data['jenis_pasien'] = $("#resep_jenis").val();
			if ($("#resep_asuransi").length)
				data['asuransi'] = $("#resep_asuransi").val();
			if ($("#resep_perusahaan").length)
				data['perusahaan'] = $("#resep_perusahaan").val();
			if ($("#resep_uri").length)
				data['uri'] = $("#resep_uri").val();
			data['satuan'] = satuan;
			data['konversi'] = 1;
			data['satuan_konversi'] = satuan;
			showLoading();
			$.post(
				"",
				data,
				function(response_detail) {
					json_detail = JSON.parse(response_detail);
					if (json_detail == null) {
						dismissLoading();
						return;
					}
					$("#dracikan_sisa").val(json_detail.sisa);
					$("#dracikan_harga").val(harga);
					$("#dracikan_jumlah").val(jumlah);
					$("#dracikan_jumlah").focus();
					dracikan.edit_mode();
					dismissLoading();					
				}
			);
		}
	);
};
DRacikanAction.prototype.cancel = function() {
	this.clear();
	this.add_mode();
};
DRacikanAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	$(".error_field").removeClass("error_field");
	var id_obat = $("#dracikan_id_obat").val();
	var jumlah = $("#dracikan_jumlah").val();
	var sisa = $("#dracikan_sisa").val();
	var satuan = $("#dracikan_satuan option:selected").text();
	if (id_obat == "") {
		valid = false;
		invalid_msg += "</br><strong>Obat</strong> tidak boleh kosong.";
		$("#dracikan_nama_obat").addClass("error_field");
	}
	if (jumlah == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong.";
		$("#dracikan_jumlah").addClass("error_field");
	} else if (!is_numeric(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9).";
		$("#dracikan_jumlah").addClass("error_field");
	} else if (parseFloat(jumlah) > parseFloat(sisa)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> tidak boleh melebihi <strong>Sisa</strong>.";
		$("#dracikan_jumlah").addClass("error_field");
	}
	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
DRacikanAction.prototype.save = function() {
	if (!this.validate())
		return;
	var r_num = $("#dracikan_row_num").val();
	var is_racikan = 1;
	var id_obat = $("#dracikan_id_bahan").val();
	var kode_obat = $("#dracikan_kode_bahan").val();
	var nama_obat = $("#dracikan_nama_bahan").val();
	var nama_jenis_obat = $("#dracikan_nama_jenis_bahan").val();
	var jumlah = $("#dracikan_jumlah").val();
	var satuan = $("#dracikan_satuan option:selected").text();
	var f_jumlah = jumlah + " " + satuan;
	var harga = $("#dracikan_harga").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var f_harga = parseFloat(harga).formatMoney("2", ".", ",");
	var embalase = $("#resep_embalase_bahan_racikan").val();
	var f_embalase = parseFloat(embalase).formatMoney("2", ".", ",");
	var tuslah = $("#resep_tuslah_bahan_racikan").val();
	var f_tuslah = parseFloat(tuslah).formatMoney("2", ".", ",");
	var subtotal = parseFloat(jumlah) * parseFloat(harga) + parseFloat(embalase) + parseFloat(tuslah);
	var f_subtotal = parseFloat(subtotal).formatMoney("2", ".", ",");
	if (r_num == "") {
		$("#dracikan_list").append(
			"<tr>" +
				"<td id='nomor'></td>" +
				"<td id='bahan_r_num' style='display: none;'></td>" +
				"<td id='id_obat' style='display: none;'>" + id_obat + "</td>" +
				"<td id='kode_obat'><small>" + kode_obat + "</small></td>" +
				"<td id='nama_obat'><small>" + nama_obat + "</small></td>" +
				"<td id='nama_jenis_obat' style='display: none;'><small>" + nama_jenis_obat + "</small></td>" +
				"<td id='jumlah' style='display: none;'>" + jumlah + "</td>" +
				"<td id='satuan' style='display: none;'>" + satuan + "</td>" +
				"<td id='f_jumlah'><small>" + f_jumlah + "</small></td>" +
				"<td id='harga' style='display: none;'>" + harga + "</td>" +
				"<td id='f_harga'><small><div align='right'>" + f_harga + "</div></small></td>" +
				"<td id='embalase' style='display: none;'>" + embalase + "</td>" +
				"<td id='f_embalase'><small><div align='right'>" + f_embalase + "</div></small></td>" +
				"<td id='tuslah' style='display: none;'>" + tuslah + "</td>" +
				"<td id='f_tuslah'><small><div align='right'>" + f_tuslah + "</div></small></td>" +
				"<td id='subtotal' style='display: none;'>" + subtotal + "</td>" +
				"<td id='f_subtotal'><small><div align='right'>" + f_subtotal + "</div></small></td>" +
				"<td class='edit_button'></td>" +
				"<td class='del_button'></td>" +
			"</tr>"
		);
		bahan_r_num++;
	} else {
		$("#dracikan_list tr:eq(" + r_num + ") td#id_obat").html(id_obat);
		$("#dracikan_list tr:eq(" + r_num + ") td#kode_obat").html(kode_obat);
		$("#dracikan_list tr:eq(" + r_num + ") td#nama_obat").html("<small>" + nama_obat + "</small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#nama_jenis_obat").html("<small>" + nama_jenis_obat + "</small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#jumlah").html(jumlah);
		$("#dracikan_list tr:eq(" + r_num + ") td#satuan").html(satuan);
		$("#dracikan_list tr:eq(" + r_num + ") td#f_jumlah").html("<small>" + f_jumlah + "</small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#harga").html(harga);
		$("#dracikan_list tr:eq(" + r_num + ") td#hf_arga").html("<small><div align='right'>" + f_harga + "</div></small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#embalase").html(embalase);
		$("#dracikan_list tr:eq(" + r_num + ") td#f_embalase").html("<small><div align='right'>" + f_embalase + "</div></small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#tuslah").html(tuslah);
		$("#dracikan_list tr:eq(" + r_num + ") td#f_tuslah").html("<small><div align='right'>" + f_tuslah + "</div></small>");
		$("#dracikan_list tr:eq(" + r_num + ") td#subtotal").html(subtotal);
		$("#dracikan_list tr:eq(" + r_num + ") td#f_subtotal").html("<small><div align='right'>" + f_subtotal + "</div></small>");
	}
	this.clear();
	this.add_mode();
	this.refreshTotal();
};
DRacikanAction.prototype.delete = function(r_num) {
	$("#dracikan_list tr:eq(" + r_num + ")").remove();
	this.refreshTotal();
	if ($("#dracikan_row_num").val() == r_num)
		this.clear();
};