<?php
	require_once("gudang_farmasi/adapter/PengecekanStokUnitAdapter.php");
	global $db;

	$form = new Form("", "", "Depo Farmasi : Pengecekan Stok Min. - Maks. Obat");
	$unit_option = new OptionBuilder();
	$unit_option->add("Depo Farmasi Batam Centre", "batam_centre");
	$unit_option->add("Depo Farmasi Batu Aji", "batu_aji");
	$unit_option->add("Depo Farmasi Bengkong", "bengkong");
	$unit_option->add("Depo Farmasi Jodoh", "jodoh");
	$unit_option->add("Depo Farmasi Panbil", "panbil", "1");
	$unit_option->add("Depo Farmasi Piayu", "piayu");
	$unit_option->add("Depo Farmasi Sekupang", "sekupang");
	$unit_option->add("Depo Farmasi Tanjung Uncang", "tanjung_uncang");
	$unit_option->add("Depo Farmasi Utama", "utama");
	$unit_select = new Select("pengecekan_stok_unit_unit", "pengecekan_stok_unit_unit", $unit_option->getContent());
	$unit_select->setAtribute("disabled='disabled'");
	$form->addElement("Unit", $unit_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("pengecekan_stok_unit.view()");
	$excel_button = new Button("", "", "Unduh");
	$excel_button->setClass("btn-inverse");
	$excel_button->setIcon("fa fa-download");
	$excel_button->setIsButton(Button::$ICONIC);
	$excel_button->setAction("pengecekan_stok_unit.export_xls()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($excel_button);
	$form->addElement("", $btn_group);

	$table = new Table(
		array("No.", "Obat", "Jenis Obat", "Stok Minimum", "Stok Maksimum", "Stok Aktual", "Satuan"),
		"",
		null,
		true
	);
	$table->setName("pengecekan_stok_unit");
	$table->setAddButtonEnable(false);
	$table->setAction(false);

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			ini_set("memory_limit", "256M");
			set_time_limit(0);

			$prefix = $_POST['unit'];
			$unit_label = $_POST['unit_label'];
			$klinik_label = str_replace("Depo Farmasi ", "", $unit_label);

			$rows = $db->get_result("
				SELECT 
					a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) stok, 
					CASE WHEN c.stok_minimum IS NULL THEN 0 ELSE c.stok_minimum END stok_minimum,
					CASE WHEN c.stok_maksimum IS NULL THEN 0 ELSE c.stok_maksimum END stok_maksimum,
					CASE WHEN c.satuan IS NULL THEN a.satuan ELSE c.satuan END satuan
				FROM 
					(
						smis_frm_" . $prefix . "_stok_obat a INNER JOIN 
						smis_frm_" . $prefix . "_obat_masuk b ON a.id_obat_masuk = b.id
					) LEFT JOIN (
						SELECT *
						FROM smis_fr_stok_obat_min_maks
						WHERE prop = ''
					) c ON a.id_obat = c.id_obat
				WHERE
					a.prop = '' AND b.prop = '' AND b.status = 'sudah'
				GROUP BY
					a.id_obat
			");

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$objPHPExcel = new PHPExcel();
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setTitle("Laporan Stok Min. - Maks.");
			$i = 1;

			$objWorksheet->mergeCells("A" . $i . ":G" . $i)->setCellValue("A" . $i, "Klinik Casa Medical " . $klinik_label);
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":G" . $i)->setCellValue("A" . $i, "Unit : " . $unit_label);
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":G" . $i)->setCellValue("A" . $i, "Laporan Pengecekan Stok Minimum - Maksimum Obat");
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = "A";
			$head = array("No.", "Nama Obat", "Jenis Obat", "Batas Min.", "Batas Maks.", "Stok Aktual", "Satuan");
			foreach ($head as $h)
				$objWorksheet->setCellValue($col++ . $i, $h);
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->getFont()->setBold(true);
			$objWorksheet->getStyle("A" . $i . ":G" . $i)->applyFromArray(
			    array(
			        'fill' => array(
			            'type' => PHPExcel_Style_Fill::FILL_SOLID,
			            'color' => array('rgb' => '808080')
			        )
			    )
			);
			$i = $i + 1;

			$data = json_decode($_POST['d_data']);
			if ($rows != null) {
				$number = 1;
				foreach ($rows as $row) {
					$objWorksheet->setCellValue("A" . $i, $number++);
					$objWorksheet->setCellValue("B" . $i, $row->nama_obat);
					$objWorksheet->setCellValue("C" . $i, $row->nama_jenis_obat);
					$objWorksheet->setCellValue("D" . $i, $row->stok_minimum);
					$objWorksheet->setCellValue("E" . $i, $row->stok_maksimum);
					$objWorksheet->setCellValue("F" . $i, $row->stok);
					if (
						$row->stok > $row->stok_maksimum ||
						$row->stok < $row->stok_minimum ||
						0.8 * $row->stok <= $row->stok_minimum
					) {
						$styleArray = array(
						    'font'  => array(
						        'bold'  => true,
						        'color' => array('rgb' => 'FF0000')
						    )
						);
						$objWorksheet->getStyle("F" . $i)->applyFromArray($styleArray);
					}
					$objWorksheet->setCellValue("G" . $i, $row->satuan);
					$i = $i + 1;
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$objWorksheet->getStyle("A" . $border_start . ":G" . $i)->applyFromArray($thin);

			foreach (range('A', 'G') as $columnID)
		    	$objWorksheet->getColumnDimension($columnID)->setAutoSize(true);

			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=LAPORAN PENGECEKAN STOK MIN MAKS OBAT - " . strtoupper($unit_label) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		$adapter = new PengecekanStokUnitAdapter();
		$dbtable = new DBTable($db, "smis_fr_stok_obat_min_maks");
		if ($_POST['command'] == "list") {
			$prefix = $_POST['unit'];
			$filter = "";
			if (isset($_POST['kriteria']))
				$filter = " AND a.nama_obat LIKE '%" . $_POST['kriteria'] . "%' ";
			$query_value = "
				SELECT 
					a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) stok, 
					CASE WHEN c.stok_minimum IS NULL THEN 0 ELSE c.stok_minimum END stok_minimum,
					CASE WHEN c.stok_maksimum IS NULL THEN 0 ELSE c.stok_maksimum END stok_maksimum,
					CASE WHEN c.satuan IS NULL THEN a.satuan ELSE c.satuan END satuan
				FROM 
					(
						smis_frm_" . $prefix . "_stok_obat a INNER JOIN 
						smis_frm_" . $prefix . "_obat_masuk b ON a.id_obat_masuk = b.id
					) LEFT JOIN (
						SELECT *
						FROM smis_fr_stok_obat_min_maks
						WHERE prop = ''
					) c ON a.id_obat = c.id_obat
				WHERE
					a.prop = '' AND b.prop = '' AND b.status = 'sudah' " . $filter . "
				GROUP BY
					a.id_obat
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (" . $query_value . ") v
			";
			$dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	echo $form->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var pengecekan_stok_unit;
	$(document).ready(function() {
		pengecekan_stok_unit = new TableAction(
			'pengecekan_stok_unit',
			'depo_farmasi_panbil',
			'pengecekan_stok_unit',
			new Array()
		);
		pengecekan_stok_unit.getRegulerData = function() {
			var data = TableAction.prototype.getRegulerData.call(this);
			data['unit'] = $("#pengecekan_stok_unit_unit").val();
			data['unit_label'] = $("#pengecekan_stok_unit_unit option:selected").text();
			return data;
		}
		pengecekan_stok_unit.export_xls = function() {
			showLoading();
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			postForm(data);
			dismissLoading();
		};
		pengecekan_stok_unit.view();
	});
</script>
