function ResepAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
ResepAction.prototype.constructor = ResepAction;
ResepAction.prototype = new TableAction();
ResepAction.prototype.cancel = function() {
	var data = this.getRegulerData();
	data['action'] = "e_resep";
	data['kriteria'] = "";
	data['number'] = 0;
	data['max'] = 5;
	LoadSmisPage(data);
};
ResepAction.prototype.show_penjualan_resep = function() {
	var data = this.getRegulerData();
	data['action'] = "penjualan_resep";
	data['kriteria'] = "";
	data['number'] = 0;
	data['max'] = 5;
	LoadSmisPage(data);	
};
ResepAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	$(".error_field").removeClass("error_field");
	var diskon = parseFloat($("#resep_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var t_diskon = $("#resep_t_diskon").val();
	if (diskon > 100 && t_diskon == "persen") {
		valid = false;
		$("#resep_diskon").addClass("error_field");
		$("#resep_t_diskon").addClass("error_field");
		$("#resep_diskon").focus();
		invalid_msg += "</br><strong>Diskon</strong> tidak boleh melebihi 100%.";
	}
	var dresep_num_rows = $("#dresep_list tr").length;
	if (dresep_num_rows == 0) {
		valid = false;
		invalid_msg += "</br><strong>Detail Resep</strong> tidak boleh kosong.";
	}

	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
ResepAction.prototype.getSaveData = function() {
	var data = this.getRegulerData();
	data['super_command'] == "";
	data['command'] = "save_as_penjualan_resep";
	data['id'] = "";
	data['nomor_resep'] = "ER-" + $("#resep_id").val();
	data['id_dokter'] = $("#resep_id_dokter").val();
	data['nama_dokter'] = $("#resep_nama_dokter").val();
	data['noreg_pasien'] = $("#resep_noreg_pasien").val();
	data['nrm_pasien'] = $("#resep_nrm_pasien").val();
	data['nama_pasien'] = $("#resep_nama_pasien").val();
	data['alamat_pasien'] = $("#resep_alamat_pasien").val();
	data['jenis'] = $("#resep_jenis").val();
	data['perusahaan'] = $("#resep_perusahaan").val();
	data['asuransi'] = $("#resep_asuransi").val();
	data['ruangan'] = $("#resep_ruangan").val();
	data['markup'] = $("#resep_markup").val();
	data['uri'] = $("#resep_uri").val();
	var v_total = parseFloat($("#total_resep").text().replace(/[^0-9-,]/g, '').replace(",", "."));
	data['total'] = v_total;
	data['diskon'] = $("#resep_diskon").val();
	data['t_diskon'] = $("#resep_t_diskon").val();

	var detail_resep = {};
	var nor_dresep =  $("tbody#dresep_list").children("tr").length;
	var pos = 0;
	for(var i = 0; i < nor_dresep; i++) {
		var tipe = $("#dresep_list tr:eq(" + i + ") td#is_racikan").text() == "1" ? "obat_racikan" : "obat_jadi";
		if (tipe == "obat_jadi") {
			var id_obat_jadi = "";
			var id_obat = $("#dresep_list tr:eq(" + i + ") td#id_obat").text();
			var kode_obat = $("#dresep_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("#dresep_list tr:eq(" + i + ") td#nama_obat").text();
			var nama_jenis_obat = $("#dresep_list tr:eq(" + i + ") td#nama_jenis_obat").text();
			var jumlah = $("#dresep_list tr:eq(" + i + ") td#jumlah").text();
			var jumlah_lama = 0;
			var satuan = $("#dresep_list tr:eq(" + i + ") td#satuan").text();
			var konversi = 1;
			var satuan_konversi = $("#dresep_list tr:eq(" + i + ") td#satuan").text();
			var v_harga = parseFloat($("#dresep_list tr:eq(" + i + ") td#harga").text());
			var v_markup = parseFloat($("#dresep_list tr:eq(" + i + ") td#markup").text());
			var v_embalase = parseFloat($("#dresep_list tr:eq(" + i + ") td#embalase").text());
			var v_tusla = parseFloat($("#dresep_list tr:eq(" + i + ") td#tuslah").text());
			var v_biaya_racik = parseFloat($("#dresep_list tr:eq(" + i + ") td#biaya_racik").text());
			var v_subtotal = parseFloat($("#dresep_list tr:eq(" + i + ") td#subtotal").text());

			var obat_luar = $("#dresep_list tr:eq(" + i + ") td#obat_luar").text();
		    var tanggal_exp = $("#dresep_list tr:eq(" + i + ") td#tanggal_exp").text();
		    var jumlah_pakai_sehari = $("#dresep_list tr:eq(" + i + ") td#jumlah_pakai_sehari").text();
		    var satuan_pakai = $("#dresep_list tr:eq(" + i + ") td#satuan_pakai").text();
		    var takaran_pakai = $("#dresep_list tr:eq(" + i + ") td#takaran_pakai").text();
		    var pemakaian = $("#dresep_list tr:eq(" + i + ") td#pemakaian").text();
		    var pemakaian_obat_luar = $("#dresep_list tr:eq(" + i + ") td#pemakaian_obat_luar").text();

			var d_data = {};
			d_data['tipe'] = tipe;
			d_data['id_obat_jadi'] = id_obat_jadi;
			d_data['id_obat'] = id_obat;
			d_data['kode_obat'] = kode_obat;
			d_data['nama_obat'] = nama_obat;
			d_data['nama_jenis_obat'] = nama_jenis_obat;
			d_data['jumlah'] = jumlah;
			d_data['jumlah_lama'] = jumlah_lama;
			d_data['satuan'] = satuan;
			d_data['konversi'] = konversi;
			d_data['satuan_konversi'] = satuan_konversi;
			d_data['harga'] = v_harga;
			d_data['markup'] = v_markup;
			d_data['embalase'] = v_embalase;
			d_data['tusla'] = v_tusla;
			d_data['biaya_racik'] = v_biaya_racik;
			d_data['subtotal'] = v_subtotal;

			d_data['obat_luar'] = obat_luar;
		    d_data['tanggal_exp'] = tanggal_exp;
		    d_data['jumlah_pakai_sehari'] = jumlah_pakai_sehari;
		    d_data['satuan_pakai'] = satuan_pakai;
		    d_data['takaran_pakai'] = takaran_pakai;
		    d_data['pemakaian'] = pemakaian;
		    d_data['pemakaian_obat_luar'] = pemakaian_obat_luar;

		    d_data['aturan_pakai'] = jumlah_pakai_sehari + " x SEHARI ";
			if (obat_luar == 0) {
				d_data['aturan_pakai'] += takaran_pakai + " " + satuan_pakai;
			}

			d_data['pos'] = pos++;
			detail_resep[i] = d_data;
		} else if (tipe == "obat_racikan") {
			var id_obat_racikan = "";
			var nama = $("#dresep_list tr:eq(" + i + ") td#nama_racikan").text();
			var id_apoteker = $("#dresep_list tr:eq(" + i + ") td#id_apoteker").text();
			var nama_apoteker = $("#dresep_list tr:eq(" + i + ") td#nama_apoteker").text();
			var jumlah_racikan = $("#dresep_list tr:eq(" + i + ") td#jumlah").text();
			var v_embalase = parseFloat($("#dresep_list tr:eq(" + i + ") td#embalase").text());
			var v_tusla = parseFloat($("#dresep_list tr:eq(" + i + ") td#tuslah").text());
			var v_biaya_racik = parseFloat($("#dresep_list tr:eq(" + i + ") td#biaya_racik").text());
			var v_harga = parseFloat($("#dresep_list tr:eq(" + i + ") td#harga").text());
			var v_subtotal = parseFloat($("#dresep_list tr:eq(" + i + ") td#subtotal").text());
			
			var obat_luar = $("#dresep_list tr:eq(" + i + ") td#obat_luar").text();
		    var tanggal_exp = $("#dresep_list tr:eq(" + i + ") td#tanggal_exp").text();
		    var jumlah_pakai_sehari = $("#dresep_list tr:eq(" + i + ") td#jumlah_pakai_sehari").text();
		    var satuan_pakai = $("#dresep_list tr:eq(" + i + ") td#satuan_pakai").text();
		    var takaran_pakai = $("#dresep_list tr:eq(" + i + ") td#takaran_pakai").text();
		    var pemakaian = $("#dresep_list tr:eq(" + i + ") td#pemakaian").text();
		    var pemakaian_obat_luar = $("#dresep_list tr:eq(" + i + ") td#pemakaian_obat_luar").text();
		    var jumlah_kemasan = $("#dresep_list tr:eq(" + i + ") td#jumlah").text();

			var detail_racikan = {};
		    var row_label = $("#dresep_list tr:eq(" + i + ")").prop("class");
			var nor_bahan = $("#r_bahan_list tr.bahan_" + row_label).length;
			for(var j = 0; j < nor_bahan; j++) {
				var id_bahan_pakai = "";
				var id_obat = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#id_obat").text();
				var kode_obat = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#kode_obat").text();
				var nama_obat = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#nama_obat").text();
				var nama_jenis_obat = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#nama_jenis_obat").text();
				var jumlah = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#jumlah").text();
				var satuan = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#satuan").text();
				var konversi = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#konversi").text();
				var satuan_konversi = $("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#satuan_konversi").text();
				var harga = parseFloat($("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#harga").text());
				var embalase = parseFloat($("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#embalase").text());
				var tusla = parseFloat($("#r_bahan_list tr.bahan_" + row_label + ":eq(" + j + ") td#tuslah").text());
				var v_markup = parseFloat($("#dresep_list tr.bahan_" + row_label + ":eq(" + i + ") td#markup").text());
				var b_data = {};
				b_data['id'] = id_bahan_pakai;
				b_data['id_obat'] = id_obat;
				b_data['kode_obat'] = kode_obat;
				b_data['nama_obat'] = nama_obat;
				b_data['nama_jenis_obat'] = nama_jenis_obat;
				b_data['jumlah'] = jumlah;
				b_data['satuan'] = satuan;
				b_data['konversi'] = konversi;
				b_data['satuan_konversi'] = satuan_konversi;
				b_data['harga'] = harga;
				b_data['embalase'] = embalase;
				b_data['tusla'] = tusla;
				b_data['markup'] = v_markup;
				detail_racikan[j] = b_data;
			}
			var d_data = {};
			d_data['tipe'] = tipe;
			d_data['nama'] = nama;
			d_data['id_apoteker'] = id_apoteker;
			d_data['nama_apoteker'] = nama_apoteker;
			d_data['jumlah'] = jumlah_racikan;
			d_data['harga'] = v_harga;
			d_data['total_embalase'] = v_embalase;
			d_data['total_tusla'] = v_tusla;
			d_data['biaya_racik'] = v_biaya_racik;
			d_data['subtotal'] = v_subtotal;
			
			d_data['obat_luar'] = obat_luar;
		    d_data['tanggal_exp'] = tanggal_exp;
		    d_data['jumlah_pakai_sehari'] = jumlah_pakai_sehari;
		    d_data['satuan_pakai'] = satuan_pakai;
		    d_data['takaran_pakai'] = takaran_pakai;
		    d_data['pemakaian'] = pemakaian;
		    d_data['pemakaian_obat_luar'] = pemakaian_obat_luar;
		    d_data['jumlah_kemasan'] = jumlah_kemasan;

		    d_data['aturan_pakai'] = jumlah_pakai_sehari + " x SEHARI ";
			if (obat_luar == 0) {
				d_data['aturan_pakai'] += takaran_pakai + " " + satuan_pakai;
			}
			
			d_data['pos'] = pos++;
			d_data['detail_racikan'] = detail_racikan;
			detail_resep[i] = d_data;
		}
	}
	data['detail_resep'] = detail_resep;
	return data;
};
ResepAction.prototype.save = function() {
	if (!this.validate())
		return;
	var self = this;
	showLoading();
	var cb_data = this.getRegulerData();
    cb_data['super_command'] = "";
    cb_data['command'] = "check_closing_bill";
    cb_data['noreg_pasien'] = $("#resep_noreg_pasien").val();
    $.post(
        "",
        cb_data,
        function (response_cb) {
            var json_cb = getContent(response_cb);
            if (json_cb == null) {
                dismissLoading();
                $(".btn").removeAttr("disabled");
                return;
            }
            if (json_cb == "0") {
                var data = self.getSaveData();
				$.post(
					"",
					data,
					function(response) {
						var json = getContent(response);				
						if (json == null || json.success == 0) {
							dismissLoading();
							bootbox.alert(json.message);
						} else {
							dismissLoading();
							self.show_penjualan_resep();
						}
					}
				);
            } else {
                dismissLoading();
                $(".btn").removeAttr("disabled");
            }
        }
    );
};