<?php
	class InlineConfirmControl extends HTML {
		private $_button_group;
		private $_message;

		public function __construct($id, $name, $value) {
			parent::__construct($id, $name, $value);
			
			$this->_button_group = new ButtonGroup("");
			$yes_button = new Button("", "", "Yes");
			$yes_button->setClass("btn-success");
			$yes_button->setAtribute("id='" . $this->id . "_yes'");
			$no_button = new Button("", "", "No");
			$no_button->setClass("btn-danger");
			$no_button->setAtribute("id='" . $this->id . "_no'");
			$this->_button_group->addButton($yes_button);
			$this->_button_group->addButton($no_button);
		}
		
		public function getHtml() {
			$content = "
				<div id='" . $this->id . "' class='" . $this->class . "' name='" . $this->name . "'>
					<div align='left'>" . $this->value . "</div>
					<br/>
					<div align='right'>" . $this->_button_group->getHtml() . "</div>
				</div>
			";
			return $content;
		}
	}
?>