<?php
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$table = new Table(
		array("No.", "No. E-Resep", "Waktu", "Unit Layanan", "Dokter", "No. Reg.", "No. RM", "Pasien", "Jenis", "Perusahaan", "Asuransi", "Operator Unit", "Status"),
		"Farmasi : Riwayat E-Resep",
		null,
		true
	);
	$table->setName("riwayat_e_resep");
	$table->setAddButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setReloadButtonEnable(false);
	$table->setEditButtonEnable(false);
	$table->setDelButtonEnable(false);
	$button = new Button("preview_button", "", "Pratinjau");
	$button->setClass("btn-inverse");
	$button->setIsButton(Button::$ICONIC);
	$button->setIcon("fa fa-file");
	$table->addContentButton("preview", $button);
	$button = new Button("cancel_archieve_button", "", "Batal Arsip");
	$button->setClass("btn-success");
	$button->setIsButton(Button::$ICONIC);
	$button->setIcon("fa fa-archive");
	$table->addContentButton("cancel_archieve", $button);

	if (isset($_POST['super_command']) && $_POST['super_command'] != "") {
		if ($_POST['super_command'] == "riwayat_e_resep" && isset($_POST['command'])) {
			if ($_POST['command'] == "cancel_archieve") {
				$id = $_POST['id'];
				$params = array(
					"id"		=> $id,
					"command"	=> $_POST['command']
				);
				$service_consumer = new ServiceConsumer(
					$db,
					"get_eresep_response_commands",
					$params,
					"e_resep"
				);
				$service_consumer->setMode(ServiceConsumer::$CLEAN_BOTH);
				$service_consumer->execute();
			} else if ($_POST['command'] == "preview") {
				$id = $_POST['id'];
				$params = array(
					"id"		=> $id,
					"command"	=> $_POST['command']
				);
				$service_consumer = new ServiceConsumer(
					$db,
					"get_eresep_response_commands",
					$params,
					"e_resep"
				);
				$service_consumer->setMode(ServiceConsumer::$CLEAN_BOTH);
				$content = $service_consumer->execute()->getContent();
				$data = array(
					"html" => $content[0]
				);
				echo json_encode($data);
			}
			return;
		}
		return;
	}

	if (isset($_POST['command'])) {
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("No. E-Resep", "id", "digit6");
		$adapter->add("Waktu", "tanggal", "date d-m-Y, H:i");
		$adapter->add("Unit Layanan", "ruangan", "unslug");
		$adapter->add("Dokter", "nama_dokter");
		$adapter->add("No. Reg.", "noreg_pasien", "digit6");
		$adapter->add("No. RM", "nrm_pasien", "digit6");
		$adapter->add("Pasien", "nama_pasien");
		$adapter->add("Jenis", "jenis", "unslug");
		$adapter->add("Perusahaan", "perusahaan");
		$adapter->add("Asuransi", "asuransi");
		$adapter->add("Operator Unit", "nama_operator");
		$adapter->add("Status", "has_transaction", "trivial_1_Sudah_Belum");
		if ($_POST['command'] == "list") {
			$_POST['archieve'] = 1;
		}
		$service_responder = new ServiceResponder(
			$db,
			$table,
			$adapter,
			"get_eresep_list"
		);
		$data = $service_responder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$preview_modal = new Modal("preview_modal", "smis_form_container", "preview");
	$preview_modal->setTitle("Pratinjau E-Resep");

	echo $preview_modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function RiwayatEResepAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	RiwayatEResepAction.prototype.constructor = RiwayatEResepAction;
	RiwayatEResepAction.prototype = new TableAction();
	RiwayatEResepAction.prototype.getRegulerData = function() {
		var data = TableAction.prototype.getRegulerData.call(this);
		data['depo'] = "depo_farmasi_jodoh";
		return data;
	};
	RiwayatEResepAction.prototype.preview = function(id) {
		var data = this.getRegulerData();
		data['super_command'] = "riwayat_e_resep";
		data['command'] = "preview";
		data['id'] = id;
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				$("#preview_modal .modal-body").html(json.html);
				$("#preview_modal").smodal("show");
				dismissLoading();
			}			
		);
	};
	RiwayatEResepAction.prototype.cancel_archieve = function(id) {
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "riwayat_e_resep";
		data['command'] = "cancel_archieve";
		data['id'] = id;
		bootbox.confirm(
			"Yakin megembalikan arsip E-Resep ini?",
			function(result) {
				if (result) {
					showLoading();
					$.post(
						"",
						data,
						function() {
							self.view();
							dismissLoading();
						}			
					);
				}
			}
		);
	};

	var riwayat_e_resep;
	$(document).ready(function() {
		riwayat_e_resep = new RiwayatEResepAction(
			"riwayat_e_resep",
			"depo_farmasi_jodoh",
			"riwayat_e_resep",
			new Array()
		);
		riwayat_e_resep.view();
	});
</script>