<?php
	require_once("registration/class/pcare/PCare.php");
	require_once("depo_farmasi_bengkong/library/InventoryLibrary.php");

	class PCareObat extends PCare {
		private $ws_bpjs_add_obat_dbtable;

		private function getNoKunjunganPCare($noreg_pasien) {
			global $db;
			return $db->get_var("
				SELECT
					no_kunjungan_pcare
				FROM
					smis_mr_diagnosa
				WHERE
					prop LIKE ''
						AND noreg_pasien = '" . $noreg_pasien . "'
				ORDER BY
					id DESC
				LIMIT
					0, 1
			");
		}

		private function proceedObatNonRacikan($id_penjualan_resep, $no_kunjungan_pcare) {
			global $db;
			$obat_non_racikan_list = $db->get_result("
				SELECT
					a.*, b.nama_dpho, b.kode_dpho
				FROM
					" . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . " a
						LEFT JOIN smis_pr_barang b ON a.id_obat = b.id
				WHERE
					a.prop LIKE ''
						AND a.id_penjualan_resep = '" . $id_penjualan_resep . "'
			");

			$response = array();
			if ($obat_non_racikan_list != null) {
				foreach ($obat_non_racikan_list as $obat_non_racikan) {
					$kd_obat_sk = 0;
					$kdracikan = null;

					$ws_response = $this->runWSAddObat(
						$kd_obat_sk,
						$no_kunjungan_pcare,
						false,
						$kdracikan,
						$obat_non_racikan->kode_dpho == null || $obat_non_racikan->kode_dpho == "" ? false : true,
						$obat_non_racikan->kode_dpho == null || $obat_non_racikan->kode_dpho == "" ? "0" : $obat_non_racikan->kode_dpho,
						$obat_non_racikan->signa1,
						$obat_non_racikan->signa2,
						$obat_non_racikan->jumlah,
						$obat_non_racikan->signa1,
						$obat_non_racikan->kode_dpho == null || $obat_non_racikan->kode_dpho == "" ? $obat_non_racikan->nama_obat : ""
					);
					// $ws_response = $this->runWSGetDPHO();
					$response[] = $ws_response;

					/// Update kdObatSK Tabel Penjualan Obat Jadi :
					$db->query("
						UPDATE
							" . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . "
						SET
							kd_sk_obat = '" . $ws_response['kdObatSK'] . "'
						WHERE
							id = '" . $obat_non_racikan->id . "'
					");
					//. End of Update kdObatSK Tabel Penjualan Obat Jadi

					$this->saveWSAddObatLog(
						$id_penjualan_resep,
						$obat_non_racikan->id,
						0,
						$ws_response['json_request'],
						$ws_response['json_response'],
						$ws_response['status_code'],
						$ws_response['status_message']
					);
				}
			}
			return $response;
		}

		private function proceedObatRacikan($id_penjualan_resep, $no_kunjungan_pcare) {
			global $db;
			$obat_racikan_list = $db->get_result("
				SELECT
					a.*, b.signa1, b.signa2, c.nama_dpho, c.kode_dpho, b.kode kode_racikan
				FROM
					" . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . " a
						LEFT JOIN " . InventoryLibrary::$_TBL_PENJUALAN_OBAT_RACIKAN . " b ON a.id_penjualan_obat_racikan = b.id
						LEFT JOIN smis_pr_barang c ON a.id_obat = c.id
				WHERE
					a.prop LIKE ''
						AND b.prop LIKE ''
						AND b.id_penjualan_resep = '" . $id_penjualan_resep . "'
			");

			$response = array();
			if ($obat_racikan_list != null) {
				foreach ($obat_racikan_list as $obat_racikan) {
					$kd_obat_sk = 0;
					$kdracikan = $obat_racikan->kode_racikan;

					$ws_response = $this->runWSAddObat(
						$kd_obat_sk,
						$no_kunjungan_pcare,
						true,
						$kdracikan,
						$obat_racikan->kode_dpho == null || $obat_racikan->kode_dpho == "" ? false : true,
						$obat_racikan->kode_dpho == null || $obat_racikan->kode_dpho == "" ? "0" : $obat_racikan->kode_dpho,
						$obat_racikan->signa1,
						$obat_racikan->signa2,
						$obat_racikan->jumlah,
						$obat_racikan->signa1,
						$obat_racikan->kode_dpho == null || $obat_racikan->kode_dpho == "" ? $obat_racikan->nama_obat : ""
					);
					// $ws_response = $this->runWSGetDPHO();
					$response[] = $ws_response;

					/// Update kdObatSK Tabel Bahan Pakai Obat Racikan :
					$db->query("
						UPDATE
							" . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . "
						SET
							kd_sk_obat = '" . $ws_response['kdObatSK'] . "'
						WHERE
							id = '" . $obat_racikan->id . "'
					");
					//. End of Update kdObatSK Bahan Pakai Obat Racikan

					$this->saveWSAddObatLog(
						$id_penjualan_resep,
						$obat_racikan->id,
						1,
						$ws_response['json_request'],
						$ws_response['json_response'],
						$ws_response['status_code'],
						$ws_response['status_message']
					);
				}
			}
			return $response;
		}

		private function runWSGetDPHO() {
			$request = array();

			$this->execute("/obat/dpho/para/0/200", "GET");
	        $response = json_decode($this->getResponse(), true);
	     	
	     	$status_code = "-";
			$status_message = "-";
			if ($response != null) {
				$status_message = $response["metaData"]['message'];
				$status_code = $response["metaData"]['code'];
			} else {
				$status_message = $this->getError();
			}

			return array(
				'json_request' => json_encode($request),
				'json_response' => json_encode($response),
				'status_code' => $status_code,
				'status_message' => $status_message
			);
		}

		private function runWSAddObat(
			$kd_obat_sk,
			$no_kunjungan_pcare,
			$racikan,
			$kdRacikan,
			$obat_dpho,
			$kd_obat,
			$signa1,
			$signa2,
			$jml_obat,
			$jml_permintaan,
			$nmobat_nondpho
		) {
			$request = array();
			$request['kdObatSK'] 		= $kd_obat_sk;
			$request['noKunjungan'] 	= $no_kunjungan_pcare;
			$request['racikan'] 		= $racikan;
			$request['kdRacikan'] 		= $kdRacikan;
			$request['obatDPHO'] 		= $obat_dpho;
			$request['kdObat'] 			= $kd_obat;
			$request['signa1'] 			= intval($signa1);
			$request['signa2'] 			= intval($signa2);
			$request['jmlObat'] 		= intval($jml_obat);
			$request['jmlPermintaan']	= intval($jml_permintaan);
			$request['nmObatNonDPHO'] 	= $nmobat_nondpho;

			$this->execute("obat/kunjungan", "POST", $request);
			$response  = json_decode($this->getResponse(), true);

			$status_code = "-";
			$status_message = "-";
			$kdObatSK = "";
			if ($response != null) {
				$status_message = $response["metaData"]['message'];
				if ($status_message == "CREATED") {
					$status_code = $response["metaData"]['code'];
					if ($response["response"] != null && is_array($response["response"])) {
						$kdObatSK = $response["response"][0]['message'];
					}
				} else {
					if (is_array($response["response"])) {
						$field = $response["response"][0]['field'];
						$status_message = $response["response"][0]['message'];
						$status_message = $field . " " . $status_message;
					} else {
						$status_message = $response["response"];
					}
				}
			} else {
				$status_message = $this->getError();
			}

			return array(
				'json_request' => json_encode($request),
				'json_response' => json_encode($response),
				'status_code' => $status_code,
				'status_message' => $status_message,
				'kdObatSK' => $kdObatSK
			);
		}

		private function saveWSAddObatLog(
			$id_penjualan_resep,
			$id_detail,
			$racikan,
			$json_request,
			$json_response,
			$status_code,
			$status_message
		) {
			global $db;
			$id = $db->get_var("
				SELECT
					id
				FROM
					" . InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT . "
				WHERE
					id_penjualan_resep = '" . $id_penjualan_resep . "'
						AND id_detail = '" . $id_detail . "'
						AND racikan = '" . $racikan . "'
						AND prop LIKE ''
			");
			$data = array(
				'id_penjualan_resep' => $id_penjualan_resep,
				'id_detail' => $id_detail,
				'racikan' => $racikan,
				'json_request' => $json_request,
				'json_response' => $json_response,
				'status_code' => $status_code,
				'status_message' => $status_message
			);
			if ($id != null && $id != "") {
				$identifier = array(
					'id' => $id
				);
				$this->ws_bpjs_add_obat_dbtable->update($data, $identifier);
			} else {
				$this->ws_bpjs_add_obat_dbtable->insert($data);
			}
		}

		public function proceed($noreg_pasien, $id_penjualan_resep) {
			global $db;
			$this->ws_bpjs_add_obat_dbtable = new DBTable(
				$db, 
				InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT,
				array("id", "id_penjualan_resep", "id_detail", "racikan", "json_request", "json_response", "status_code", "status_message")
			);

			$no_kunjungan_pcare = $this->getNoKunjunganPCare($noreg_pasien);
			$response_non_racikan = $this->proceedObatNonRacikan($id_penjualan_resep, $no_kunjungan_pcare);
			$response_racikan = $this->proceedObatRacikan($id_penjualan_resep, $no_kunjungan_pcare);

			return array(
				'no_kunjungan_pcare' => $no_kunjungan_pcare,
				'response_non_racikan' => $response_non_racikan,
				'response_racikan' => $response_racikan
			);
		}

		private function resetNoKunjunganInfo($id_penjualan_resep, $arr_request, $id_log) {
			global $db;
			$noreg_pasien = $db->get_var("
				SELECT
					noreg_pasien
				FROM
					" . InventoryLibrary::$_TBL_PENJUALAN_RESEP . "
				WHERE
					id = '" . $id_penjualan_resep . "'
			");
			if ($noreg_pasien != null && $noreg_pasien != "" && $id_log != null && $id_log != "") {
				$arr_request['noKunjungan'] = $this->getNoKunjunganPCare($noreg_pasien);
				$db->query("
					UPDATE
						" . InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT . "
					SET
						json_request = '" . json_encode($arr_request) . "'
					WHERE
						id = '" . $id_log . "'
				");
			}
			return $arr_request;
		}

		public function resend($id_penjualan_resep) {
			global $db;
			$this->ws_bpjs_add_obat_dbtable = new DBTable(
				$db, 
				InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT,
				array("id", "id_penjualan_resep", "id_detail", "racikan", "json_request", "json_response", "status_code", "status_message")
			);
			
			$detail_list = $db->get_result("
				SELECT
					*
				FROM
					" . InventoryLibrary::$_TBL_WS_BPJS_ADD_OBAT . "
				WHERE
					id_penjualan_resep = '" . $id_penjualan_resep . "'
						AND prop LIKE ''
						AND status_code NOT LIKE '201'
			");
			$result = array();
			if ($detail_list != null) {
				foreach ($detail_list as $detail) {
					if ($detail->status_code == "201") {
						continue;
					}
					$this->execute("obat/kunjungan", "POST", $this->resetNoKunjunganInfo($id_penjualan_resep, json_decode($detail->json_request, true), $detail->id));
					// $this->execute("/obat/dpho/para/0/200", "GET");
			        $response = json_decode($this->getResponse(), true);
			     	
			     	$status_code = "-";
					$status_message = "-";
					if ($response != null) {
						$status_message = $response["metaData"]['message'];
						if ($status_message == "CREATED") {
							$status_code = $response["metaData"]['code'];
							if ($response["response"] != null) {
								foreach ($response["response"] as $key => $value) {
									if ($key == "kdObatSK") {
										/// Update kdObatSK :
										if ($detail->racikan == 1) {
											/// Update kdObatSK Tabel Bahan Pakai Obat Racikan :
											$db->query("
												UPDATE
													" . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . "
												SET
													kd_sk_obat = '" . $key . "'
												WHERE
													id = '" . $detail->id_detail . "'
											");
											//. End of Update kdObatSK Tabel Bahan Pakai Obat Racikan
										} else {
											/// Update kdObatSK Tabel Penjualan Obat Jadi :
											$db->query("
												UPDATE
													" . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . "
												SET
													kd_sk_obat = '" . $key . "'
												WHERE
													id = '" . $detail->id_detail . "'
											");
											//. End of Update kdObatSK Tabel Penjualan Obat Jadi
										}
										//. End of Update kdObatSK
										break;
									}
								}
							}
						} else {
							if (is_array($response["response"])) {
								$field = $response["response"][0]['field'];
								$status_message = $response["response"][0]['message'];
								$status_message = $field . " " . $status_message;
							} else {
								$status_message = $response["response"];
							}
						}
					} else {
						$status_message = $this->getError();
					}
					$result[] = $status_message;

					$identifier = array(
						'id' => $detail->id
					);
					$data = array(
						'json_response' => json_encode($response),
						'status_code' => $status_code,
						'status_message' => $status_message
					);
					$this->ws_bpjs_add_obat_dbtable->update($data, $identifier);
				}
			}
			return $result;
		}

		/// Override Fungsi do_curl Tanpa Fungsi Decrypt
		protected function do_curl($port,$url,$methode,$request){
	        $pcare          = $this->generatePCareAuthorization();
	        $generated      = $this->generateBPJSCode($this->consumer_id,$this->consumer_secret);
	        $devrypt        = $this->consumer_id.$this->consumer_secret.$generated['timestamp'];
	        global $querylog; 
	        $querylog->addMessage(" MELAKUKAN DO CURL ");
	        $querylog->addMessage("Url -> ".$url);
	        $querylog->addMessage("Request : ".json_encode($request) );
	        $querylog->addMessage("Consumer ID : ".$this->consumer_id );
	        $querylog->addMessage("PPK Pelayanan : ".$this->ppk_pelayanan );
	        $querylog->addMessage("Username : ".$this->pcare_username );
	        $querylog->addMessage("Password : ".$this->pcare_password );
	        $querylog->addMessage("x-signature : ".$generated['signature'] );
	        $querylog->addMessage("x-timestamp : ".$generated['timestamp'] );
	        $querylog->addMessage("x-authorization : ".$pcare );
	        $querylog->addMessage("decryptkey : ".$devrypt);
	        $querylog->addMessage("user_key : ".$this->userkey );
	        
	        $curl           = curl_init();
	        $array_object   = array();
	        $array_object[] = "accept: application/json";
	        //$array_object[] = "content-type: application/json";
	        $array_object[] = "X-cons-id: ".$this->consumer_id;
	        $array_object[] = "X-signature: ".$generated['signature'];
	        $array_object[] = "X-timestamp: ".$generated['timestamp'];       
	        $array_object[] = "X-authorization: ".$pcare;
	        $array_object[] = "user_key: ".$this->userkey;
	        
	        if($request==null){
	            $request=array();
	        }
	        curl_setopt_array($curl, array(
	          CURLOPT_PORT => $port,
	          CURLOPT_URL => $url,
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 30,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => $methode,
	          CURLOPT_POSTFIELDS => json_encode($request),
	          CURLOPT_HTTPHEADER =>$array_object,
	        ));
	        
	        $this->response = curl_exec($curl);
	        $this->error    = curl_error($curl);
	        $querylog->addMessage("Raw Response : ". $this->response );
	        $xres = json_decode($this->response,true);
	        $querylog->addMessage("XRes : ".json_encode($xres) );
	        if($xres!=null){
	            if(isset($xres['response'])){
	                if (!is_array($xres['response'])) {
		                require_once "registration/function/vclaim_decrypt.php";
		                $r = stringDecrypt($devrypt,$xres['response']);
		                $querylog->addMessage("Compressed-> : ".$r );
		                $hasil = decompress($r);
		                $querylog->addMessage("Decompress-> : ".$hasil );
		                $x = json_decode($hasil,true);
		                $xres['response'] = $x;
	            	}
	                $this->response = json_encode($xres);
	            }
	        }
	        $querylog->addMessage("Response : ".json_encode($this->response)." - ".json_encode($this->error) );
	        curl_close($curl);
	    }
	    //. End of Override Fungsi do_curl Tanpa Fungsi Decrypt
	}
?>