<?php
	require_once("registration/class/pcare/PCare.php");
	require_once("depo_farmasi_batam_centre/library/InventoryLibrary.php");
	class PCareObatCancel extends PCare {
		private $ws_bpjs_delete_obat_dbtable;
		private function getNoKunjunganPCare($noreg_pasien) {
			global $db;
			return $db->get_var("
				SELECT
					no_kunjungan_pcare
				FROM
					smis_mr_diagnosa
				WHERE
					prop LIKE ''
						AND noreg_pasien = '" . $noreg_pasien . "'
				ORDER BY
					id DESC
				LIMIT
					0, 1
			");
		}
		private function proceedObatNonRacikan($id_penjualan_resep, $no_kunjungan_pcare) {
			global $db;
			$obat_non_racikan_list = $db->get_result("
				SELECT
					*
				FROM
					" . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . "
				WHERE
					prop LIKE ''
						AND id_penjualan_resep = '" . $id_penjualan_resep . "'
			");
			$response = array();
			if ($obat_non_racikan_list != null) {
				foreach ($obat_non_racikan_list as $obat_non_racikan) {
					$ws_response = $this->runWSDeleteObat(
						$obat_non_racikan->kd_sk_obat,
						$no_kunjungan_pcare
					);
					$response[] = $ws_response;
					$url = "obat/" . $obat_non_racikan->kd_sk_obat . "/kunjungan/" . $no_kunjungan_pcare;
					$this->saveWSDeleteObatLog(
						$id_penjualan_resep,
						$obat_non_racikan->id,
						0,
						$ws_response['status_code'],
						$ws_response['status_message'],
						$url
					);
				}
			}
			return $response;
		}
		private function proceedObatRacikan($id_penjualan_resep, $no_kunjungan_pcare) {
			global $db;
			$obat_non_racikan_list = $db->get_result("
				SELECT
					a.*
				FROM
					" . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . " a
						LEFT JOIN " . InventoryLibrary::$_TBL_PENJUALAN_OBAT_RACIKAN . " b ON a.id_penjualan_obat_racikan = b.id
				WHERE
					a.prop LIKE ''
						AND b.prop LIKE ''
						AND b.id_penjualan_resep = '" . $id_penjualan_resep . "'
			");
			$response = array();
			if ($obat_racikan_list != null) {
				foreach ($obat_racikan_list as $obat_racikan) {
					$ws_response = $this->runWSDeleteObat(
						$obat_racikan->kd_sk_obat,
						$no_kunjungan_pcare
					);
					$response[] = $ws_response;
					$url = "obat/" . $obat_racikan->kd_sk_obat . "/kunjungan/" . $no_kunjungan_pcare;
					$this->saveWSDeleteObatLog(
						$id_penjualan_resep,
						$obat_racikan->id,
						1,
						$ws_response['status_code'],
						$ws_response['status_message'],
						$url
					);
				}
			}
			return $response;
		}
		private function runWSDeleteObat(
			$kd_obat_sk,
			$no_kunjungan_pcare
		) {
			$url = "obat/" . $kd_obat_sk . "/kunjungan/" . $no_kunjungan_pcare;
			$this->execute($url, "DELETE", null);
			$response  = json_decode($this->getResponse(), true);
			$status_code = "-";
			$status_message = "-";
			if ($response != null) {
				$status_message = $response["metaData"]['message'];
				if ($status_message == "OK") {
					$status_code = $response["metaData"]['code'];
				} else {
					if (is_array($response["response"])) {
						$field = $response["response"][0]['field'];
						$status_message = $response["response"][0]['message'];
						$status_message = $field . " " . $status_message;
					} else {
						$status_message = $response["response"];
					}
				}
			} else {
				$status_message = $this->getError();
			}
			return array(
				'url' => $url,
				'status_code' => $status_code,
				'status_message' => $status_message
			);
		}
		private function saveWSDeleteObatLog(
			$id_penjualan_resep,
			$id_detail,
			$racikan,
			$status_code,
			$status_message,
			$url
		) {
			global $db;
			$id = $db->get_var("
				SELECT
					id
				FROM
					" . InventoryLibrary::$_TBL_WS_BPJS_DELETE_OBAT . "
				WHERE
					id_penjualan_resep = '" . $id_penjualan_resep . "'
						AND id_detail = '" . $id_detail . "'
						AND racikan = '" . $racikan . "'
						AND prop LIKE ''
			");
			$data = array(
				'id_penjualan_resep' => $id_penjualan_resep,
				'id_detail' => $id_detail,
				'racikan' => $racikan,
				'status_code' => $status_code,
				'status_message' => $status_message,
				'url' => $url
			);
			if ($id != null && $id != "") {
				$identifier = array(
					'id' => $id
				);
				$this->ws_bpjs_delete_obat_dbtable->update($data, $identifier);
			} else {
				$this->ws_bpjs_delete_obat_dbtable->insert($data);
			}
		}
		public function proceed($id_penjualan_resep) {
			global $db;
			$this->ws_bpjs_delete_obat_dbtable = new DBTable(
				$db, 
				InventoryLibrary::$_TBL_WS_BPJS_DELETE_OBAT,
				array("id", "id_penjualan_resep", "id_detail", "racikan", "status_code", "status_message", "url")
			);
			$noreg_pasien = $db->get_var("
				SELECT
					noreg_pasien
				FROM
					" . InventoryLibrary::$_TBL_PENJUALAN_RESEP . "
				WHERE
					id = '" . $id_penjualan_resep . "'
			");
			$no_kunjungan_pcare = $this->getNoKunjunganPCare($noreg_pasien);
			$response_non_racikan = $this->proceedObatNonRacikan($id_penjualan_resep, $no_kunjungan_pcare);
			$response_racikan = $this->proceedObatRacikan($id_penjualan_resep, $no_kunjungan_pcare);
			return array(
				'no_kunjungan_pcare' => $no_kunjungan_pcare,
				'response_non_racikan' => $response_non_racikan,
				'response_racikan' => $response_racikan
			);
		}
		public function resend($id_penjualan_resep) {
			global $db;
			$this->ws_bpjs_delete_obat_dbtable = new DBTable(
				$db, 
				InventoryLibrary::$_TBL_WS_BPJS_DELETE_OBAT,
				array("id", "id_penjualan_resep", "id_detail", "racikan", "status_code", "status_message", "url")
			);
			$no_kunjungan_pcare = $this->getNoKunjunganPCare($db->get_var("
				SELECT
					noreg_pasien
				FROM
					" . InventoryLibrary::$_TBL_PENJUALAN_RESEP . "
				WHERE
					id = '" . $id_penjualan_resep . "'
			")); 
			
			$detail_list = $db->get_result("
				SELECT
					*
				FROM
					" . InventoryLibrary::$_TBL_WS_BPJS_DELETE_OBAT . "
				WHERE
					id_penjualan_resep = '" . $id_penjualan_resep . "'
						AND prop LIKE ''
						AND status_code NOT LIKE '200'
			");
			$result = array();
			if ($detail_list != null) {
				foreach ($detail_list as $detail) {
					if ($detail->status_code == "200") {
						continue;
					}
					$kd_obat_sk = "";
					if ($detail->racikan == 1) {
						$kd_obat_sk = $db->get_var("
							SELECT
								kd_sk_obat
							FROM
								" . InventoryLibrary::$_TBL_BAHAN_PAKAI_OBAT_RACIKAN . "
							WHERE
								id = '" . $detail->id_detail . "'
						");
					} else {
						$kd_obat_sk = $db->get_var("
							SELECT
								kd_sk_obat
							FROM
								" . InventoryLibrary::$_TBL_PENJUALAN_OBAT_JADI . "
							WHERE
								id = '" . $detail->id_detail . "'
						");
					}
					$url = "obat/" . $kd_obat_sk . "/kunjungan/" . $no_kunjungan_pcare;
					$this->execute($url, "DELETE", null);
			        $response = json_decode($this->getResponse(), true);
			     	
			     	$status_code = "-";
					$status_message = "-";
					if ($response != null) {
						$status_message = $response["metaData"]['message'];
						$status_code = $response["metaData"]['code'];
					} else {
						$status_message = $this->getError();
					}
					$result[] = $status_message;
					$identifier = array(
						'id' => $detail->id
					);
					$data = array(
						'status_code' => $status_code,
						'status_message' => $status_message,
						'url' => $url
					);
					$this->ws_bpjs_delete_obat_dbtable->update($data, $identifier);
				}
			}
			return $result;
		}
	}
?>