function ObatAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
ObatAction.prototype.constructor = ObatAction;
ObatAction.prototype = new TableAction();
ObatAction.prototype.selected = function(json) {
	$("#non_racikan_id_obat").val(json.header.id_obat);
	$("#non_racikan_kode_obat").html(json.header.kode_obat);
	$("#non_racikan_name_obat").val(json.header.nama_obat);
	$("#non_racikan_nama_obat").val(json.header.nama_obat);
	$("#non_racikan_nama_jenis_obat").val(json.header.nama_jenis_obat);
    $("#non_racikan_satuan").html(json.satuan_option);
	this.setDetailInfo();
};
ObatAction.prototype.setDetailInfo = function() {
	var part = "";
	var konversi = "";
	var satuan_konversi = "";
	if ($("#non_racikan_satuan").val() != "" && $("#non_racikan_satuan").val() != null) {
		part = $("#non_racikan_satuan").val().split("_");
		konversi = part[0];
		satuan_konversi = part[1];
	}
	var self = this;
	var data = this.getRegulerData();
	data['super_command'] = "";
	data['command'] = "get_current_stock";
	data['id_obat'] = $("#non_racikan_id_obat").val();
	data['kode_obat'] = $("#non_racikan_kode_obat").val();
	if ($("#resep_jenis").length)
		data['jenis_pasien'] = $("#resep_jenis").val();
	if ($("#resep_asuransi").length)
		data['asuransi'] = $("#resep_asuransi").val();
	if ($("#resep_perusahaan").length)
		data['perusahaan'] = $("#resep_perusahaan").val();
	if ($("#resep_uri").length)
		data['uri'] = $("#resep_uri").val();
	data['satuan'] = $("#non_racikan_satuan option:selected").text();
	data['konversi'] = konversi;
	data['satuan_konversi'] = satuan_konversi;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			json = JSON.parse(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			$("#non_racikan_sisa").val(json.sisa);
			$("#non_racikan_harga").val("Rp. " + parseFloat(json.hja).formatMoney("2", ".", ","));
			$("#non_racikan_jumlah").focus();
			dismissLoading();
		}
	);
};