function NonRacikanAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
NonRacikanAction.prototype.constructor = NonRacikanAction;
NonRacikanAction.prototype = new TableAction();
NonRacikanAction.prototype.hide_form = function() {
	$("#non_racikan_form_section").hide();
	$("#dresep_table_section").removeClass("span9");
};
NonRacikanAction.prototype.show_form = function() {
	$("#non_racikan_form_section").show();
	$("#dresep_table_section").addClass("span9");
};
NonRacikanAction.prototype.clear = function() {
	$("#non_racikan_row_num").val("");
	$("#non_racikan_id_obat").val("");
	$("#non_racikan_kode_obat").val("");
	$("#non_racikan_name_obat").val("");
	$("#non_racikan_nama_obat").val("");
	$("#non_racikan_nama_jenis_obat").val("");
	$("#non_racikan_sisa").val("");
	$("#non_racikan_jumlah").val("");
	$("#non_racikan_satuan").html("");
	$("#non_racikan_harga").val("");
	
	this.resetAturanPakai();
};
NonRacikanAction.prototype.add_mode = function() {
	$("#non_racikan_kode_obat").removeAttr("disabled");
	$("#non_racikan_kode_obat").attr("disabled", "disabled");
	$("#non_racikan_satuan").removeAttr("disabled");
	$("#non_racikan_satuan").attr("disabled", "disabled");
	$("#non_racikan_nama_obat").removeClass("smis-one-option-input");
	$("#non_racikan_nama_obat").attr("disabled", "disabled");
	$("#obat_browse").hide();
	$("#non_racikan_update").hide();
	$("#non_racikan_cancel").hide();
};
NonRacikanAction.prototype.edit_mode = function() {
	$("#non_racikan_kode_obat").removeAttr("disabled");
	$("#non_racikan_satuan").removeAttr("disabled");
	$("#non_racikan_nama_obat").removeClass("smis-one-option-input");
	$("#non_racikan_nama_obat").addClass("smis-one-option-input");
	$("#non_racikan_nama_obat").removeAttr("disabled", "disabled");
	$("#obat_browse").show();
	$("#non_racikan_update").show();
	$("#non_racikan_cancel").show();
};
NonRacikanAction.prototype.cancel = function() {
	this.clear();
	this.add_mode();
};
NonRacikanAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	$(".error_field").removeClass("error_field");
	var id_obat = $("#non_racikan_id_obat").val();
	var jumlah = $("#non_racikan_jumlah").val();
	var sisa = $("#non_racikan_sisa").val();
	var satuan = $("#non_racikan_satuan option:selected").text();
	if (id_obat == "") {
		valid = false;
		invalid_msg += "</br><strong>Obat</strong> tidak boleh kosong.";
		$("#non_racikan_nama_obat").addClass("error_field");
	}
	if (jumlah == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong.";
		$("#non_racikan_jumlah").addClass("error_field");
	} else if (!is_numeric(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9).";
		$("#non_racikan_jumlah").addClass("error_field");
	} else if (parseFloat(jumlah) > parseFloat(sisa)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> tidak boleh melebihi <strong>Sisa</strong>.";
		$("#non_racikan_jumlah").addClass("error_field");
	}
	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
NonRacikanAction.prototype.save = function() {
	if (!this.validate())
		return;
	var r_num = $("#non_racikan_row_num").val();
	var is_racikan = 0;
	var id_obat = $("#non_racikan_id_obat").val();
	var kode_obat = $("#non_racikan_kode_obat").val();
	var nama_obat = $("#non_racikan_nama_obat").val();
	var nama_jenis_obat = $("#non_racikan_nama_jenis_obat").val();
	var jumlah = $("#non_racikan_jumlah").val();
	var satuan = $("#non_racikan_satuan option:selected").text();
	var konversi = 1;
	var satuan_konversi = satuan;
	var f_jumlah = jumlah + " " + satuan;
	var harga = $("#non_racikan_harga").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var f_harga = parseFloat(harga).formatMoney("2", ".", ",");
	var embalase = $("#resep_embalase_obat_jadi").val();
	var f_embalase = parseFloat(embalase).formatMoney("2", ".", ",");
	var tuslah = $("#resep_tuslah_obat_jadi").val();
	var f_tuslah = parseFloat(tuslah).formatMoney("2", ".", ",");
	var biaya_racik = 0;
	var f_biaya_racik = parseFloat(biaya_racik).formatMoney("2", ".", ",");
	var subtotal = parseFloat(jumlah) * parseFloat(harga) + parseFloat(embalase) + parseFloat(tuslah) + parseFloat(biaya_racik);
	var f_subtotal = parseFloat(subtotal).formatMoney("2", ".", ",");

	var obat_luar = $("#non_racikan_obat_luar").val();
    var tanggal_exp = $("#non_racikan_tanggal_exp").val();
    var jumlah_pakai_sehari = $("#non_racikan_jumlah_pakai_sehari").val();
    var satuan_pakai = $("#non_racikan_satuan_pakai").val();
    var takaran_pakai = $("#non_racikan_takaran_pakai").val();
    var pemakaian = $("#non_racikan_pemakaian").val();
    var pemakaian_obat_luar = $("#non_racikan_pemakaian_obat_luar").val();	

	var id_apoteker = "";
	var nama_apoteker = "-";
	var self = this;

	var data = self.getRegulerData();
	data['command'] = "validasi_data_obat";
	data['id_obat'] = id_obat;
	data['nama_obat'] = nama_obat;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			dismissLoading();
			if (!json) {
				bootbox.alert("Obat Pilihan tidak ditemukan pada Data Stok Depo Farmasi. Silakan melakukan pemilihan ulang obat.");
				return;
			}
			if (r_num == "") {
				$("#dresep_list").append(
					"<tr>" +
						"<td id='nomor'></td>" +
						"<td id='is_racikan' style='display: none;'>" + is_racikan + "</td>" +

						"<td id='tanggal_exp' style='display: none;'>" + tanggal_exp + "</td>" +
				        "<td id='obat_luar' style='display: none;'>" + obat_luar + "</td>" +
				        "<td id='jumlah_pakai_sehari' style='display: none;'>" + jumlah_pakai_sehari + "</td>" +
				        "<td id='satuan_pakai' style='display: none;'>" + satuan_pakai + "</td>" +
				        "<td id='takaran_pakai' style='display: none;'>" + takaran_pakai + "</td>" +
				        "<td id='pemakaian' style='display: none;'>" + pemakaian + "</td>" +
				        "<td id='pemakaian_obat_luar' style='display: none;'>" + pemakaian_obat_luar + "</td>" +

						"<td id='id_obat' style='display: none;'>" + id_obat + "</td>" +
						"<td id='kode_obat'><small>" + kode_obat + "</small></td>" +
						"<td id='nama_obat'><small>" + nama_obat + "</small></td>" +
						"<td id='nama_jenis_obat' style='display: none;'><small>" + nama_jenis_obat + "</small></td>" +
						"<td id='jumlah' style='display: none;'>" + jumlah + "</td>" +
						"<td id='satuan' style='display: none;'>" + satuan + "</td>" +
						"<td id='konversi' style='display: none;'>" + konversi + "</td>" +
						"<td id='satuan_konversi' style='display: none;'>" + satuan_konversi + "</td>" +
						"<td id='f_jumlah'><small>" + f_jumlah + "</small></td>" +
						"<td id='harga' style='display: none;'>" + harga + "</td>" +
						"<td id='f_harga'><small><div align='right'>" + f_harga + "</div></small></td>" +
						"<td id='embalase' style='display: none;'>" + embalase + "</td>" +
						"<td id='f_embalase'><small><div align='right'>" + f_embalase + "</div></small></td>" +
						"<td id='tuslah' style='display: none;'>" + tuslah + "</td>" +
						"<td id='f_tuslah'><small><div align='right'>" + f_tuslah + "</div></small></td>" +
						"<td id='biaya_racik' style='display: none;'>" + biaya_racik + "</td>" +
						"<td id='f_biaya_racik'><small><div align='right'>" + f_biaya_racik + "</div></small></td>" +
						"<td id='subtotal' style='display: none;'>" + subtotal + "</td>" +
						"<td id='f_subtotal'><small><div align='right'>" + f_subtotal + "</div></small></td>" +
						"<td class='preview_button'><center>" +
							"<a href='#' id='preview_button' class='input btn btn-info'>" +
								"<i class='icon-eye-open icon-white'></i>" +
							"</a>" +
						"</center></td>" +
						"<td id='id_apoteker' style='display: none;'>" + id_apoteker + "</td>" +
						"<td id='nama_apoteker'><small>" + nama_apoteker + "</small></td>" +
						"<td class='edit_button'></td>" +
						"<td class='del_button'></td>" +
					"</tr>"
				);
			} else {
				$("#dresep_list tr:eq(" + r_num + ") td#tanggal_exp").html(tanggal_exp);
		        $("#dresep_list tr:eq(" + r_num + ") td#obat_luar").html(obat_luar);
		        $("#dresep_list tr:eq(" + r_num + ") td#jumlah_pakai_sehari").html(jumlah_pakai_sehari);
		        $("#dresep_list tr:eq(" + r_num + ") td#satuan_pakai").html(satuan_pakai);
		        $("#dresep_list tr:eq(" + r_num + ") td#takaran_pakai").html(takaran_pakai);
		        $("#dresep_list tr:eq(" + r_num + ") td#pemakaian").html(pemakaian);
		        $("#dresep_list tr:eq(" + r_num + ") td#pemakaian_obat_luar").html(pemakaian_obat_luar);

				$("#dresep_list tr:eq(" + r_num + ") td#id_obat").html(id_obat);
				$("#dresep_list tr:eq(" + r_num + ") td#kode_obat").html(kode_obat);
				$("#dresep_list tr:eq(" + r_num + ") td#nama_obat").html("<small>" + nama_obat + "</small>");
				$("#dresep_list tr:eq(" + r_num + ") td#nama_jenis_obat").html("<small>" + nama_jenis_obat + "</small>");
				$("#dresep_list tr:eq(" + r_num + ") td#jumlah").html(jumlah);
				$("#dresep_list tr:eq(" + r_num + ") td#satuan").html(satuan);
				$("#dresep_list tr:eq(" + r_num + ") td#konversi").html(konversi);
				$("#dresep_list tr:eq(" + r_num + ") td#satuan_konversi").html(satuan_konversi);
				$("#dresep_list tr:eq(" + r_num + ") td#f_jumlah").html("<small>" + f_jumlah + "</small>");
				$("#dresep_list tr:eq(" + r_num + ") td#harga").html(harga);
				$("#dresep_list tr:eq(" + r_num + ") td#f_harga").html("<small><div align='right'>" + f_harga + "</div></small>");
				$("#dresep_list tr:eq(" + r_num + ") td#embalase").html(embalase);
				$("#dresep_list tr:eq(" + r_num + ") td#f_embalase").html("<small><div align='right'>" + f_embalase + "</div></small>");
				$("#dresep_list tr:eq(" + r_num + ") td#tuslah").html(tuslah);
				$("#dresep_list tr:eq(" + r_num + ") td#f_tuslah").html("<small><div align='right'>" + f_tuslah + "</div></small>");
				$("#dresep_list tr:eq(" + r_num + ") td#biaya_racik").html(biaya_racik);
				$("#dresep_list tr:eq(" + r_num + ") td#f_biaya_racik").html("<small><div align='right'>" + f_biaya_racik + "</div></small>");
				$("#dresep_list tr:eq(" + r_num + ") td#subtotal").html(subtotal);
				$("#dresep_list tr:eq(" + r_num + ") td#f_subtotal").html("<small><div align='right'>" + f_subtotal + "</div></small>");
			}
			self.clear();
			self.add_mode();
			dresep.refreshTotal();
		}
	);
};
NonRacikanAction.prototype.resetAturanPakai = function() {
	$("#non_racikan_obat_luar").val("0");
    $("#non_racikan_tanggal_exp").val("");
    $("#non_racikan_jumlah_pakai_sehari").val("");
    $("#non_racikan_satuan_pakai").val("");
    $("#non_racikan_takaran_pakai").val("");
    $("#non_racikan_pemakaian").val("");
    $("#non_racikan_pemakaian_obat_luar").val("");	

    $(".non_racikan_jumlah_pakai_sehari").show();
    $(".non_racikan_satuan_pakai").show();
	$(".non_racikan_takaran_pakai").show();
	$(".non_racikan_pemakaian").show();
	$(".non_racikan_pemakaian_obat_luar").hide();
};