<?php
class PembuatanEtiketTable extends Table {
	public function getHeaderButton() {
		$btn_group = new ButtonGroup("noprint");
		$btn_add = new Button("", "", "Etiket Tablet");
		$btn_add->setAtribute("id='etiket_tablet_add'");
		$btn_add->setAction($this->action . ".show_add_etiket_tablet_form()");
		$btn_add->setClass("btn-primary");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		$btn_add = new Button("", "", "Etiket Kosong");
		$btn_add->setAction($this->action . ".show_add_etiket_kosong_form()");
		$btn_add->setAtribute("id='etiket_kosong_add'");
		$btn_add->setClass("btn-info");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		$btn_add = new Button("", "", "Etiket Injeksi");
		$btn_add->setAction($this->action . ".show_add_etiket_injeksi_form()");
		$btn_add->setAtribute("id='etiket_injeksi_add'");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		$btn_add = new Button("", "", "Etiket Syrup/Drop");
		$btn_add->setAction($this->action . ".show_add_etiket_syrup_drop_form()");
		$btn_add->setAtribute("id='etiket_syrup_drop_add'");
		$btn_add->setClass("btn-inverse");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		$btn_add = new Button("", "", "Etiket Obat Luar");
		$btn_add->setAction($this->action . ".show_add_etiket_obat_luar_form()");
		$btn_add->setAtribute("id='etiket_obat_luar_add'");
		$btn_add->setClass("btn-success");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		$btn_add = new Button("", "", "Etiket Obat Racikan");
		$btn_add->setAction($this->action . ".show_add_etiket_obat_racikan_form()");
		$btn_add->setAtribute("id='etiket_obat_racikan_add'");
		$btn_add->setClass("btn-success");
		$btn_add->setIcon("icon-plus icon-white");
		$btn_add->setIsButton(Button::$ICONIC_TEXT);
		$btn_group->addElement($btn_add);
		return $btn_group->getHtml();
	}
	public function getContentButton($id) {
		$btn_group = new ButtonGroup("noprint");
		$btn = new Button("", "", "Lihat");
		$btn->setAction($this->action . ".preview('" . $id . "')");
		$btn->setClass("btn-success");
		$btn->setAtribute("data-content='Lihat' data-toggle='popover'");
		$btn->setIcon("icon-eye-open icon-white");
		$btn->setIsButton(Button::$ICONIC);
		$btn_group->addElement($btn);
		$btn = new Button("", "", "Cetak");
		$btn->setAction($this->action . ".print_etiket('" . $id . "')");
		$btn->setClass("btn-inverse");
		$btn->setAtribute("data-content='Cetak' data-toggle='popover'");
		$btn->setIcon("icon-print icon-white");
		$btn->setIsButton(Button::$ICONIC);
		$btn_group->addElement($btn);
		return $btn_group;
	}
	public function getPrintData($data) {
		$printData = "";
		if ($data->jenis_etiket == "tablet") {
			$printData = $this->getEtiketTabletContent($data);
		} else if ($data->jenis_etiket == "kosongan") {
			$printData = $this->getEtiketKosonganContent($data);
		} else if ($data->jenis_etiket == "injeksi") {
			$printData = $this->getEtiketInjeksiContent($data);
		} else if ($data->jenis_etiket == "syrup_drop") {
			$printData = $this->getEtiketSyrupDropContent($data);
		} else if ($data->jenis_etiket == "obat_luar") {
			$printData = $this->getEtiketObatLuarContent($data);
		} else if ($data->jenis_etiket == "racikan") {
			$printData = $this->getEtiketRacikanContent($data);
		}
		return $printData;
	}
	public function getEtiketTabletContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Obat</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_obat), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Jumlah Obat</td>";
							$content .= "<td colspan='3'>: " . strtoupper($data->tablet_jumlah_obat) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Pagi</td>";
							$content .= "<td colspan='1'>";
								$content .= "<table border='1' class='etiket_content'><tr><td width='30px' align='center'>" . $data->tablet_jumlah_konsumsi_pagi . "</td></tr></table>";
							$content .= "</td>";
							$content .= "<td colspan='2'>&nbsp;</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Siang&Tab;x</td>";
							$content .= "<td colspan='1'>";
								$content .= "<table border='1' class='etiket_content'><tr><td width='30px' align='center'>" . $data->tablet_jumlah_konsumsi_siang . "</td></tr></table>";
							$content .= "</td>";
		$jenis_obat = "";
		if ($data->tablet_satuan_konsumsi == "tablet") {
			$jenis_obat = "Tablet / <strike>Kapsul</strike> / <strike>Bungkus</strike>";
		} else if ($data->tablet_satuan_konsumsi == "capsul") {
			$jenis_obat = "<strike>Tablet</strike> / Kapsul / <strike>Bungkus</strike>";
		} else if ($data->tablet_satuan_konsumsi == "bungkus") {
			$jenis_obat = "<strike>Tablet</strike> / <strike>Kapsul</strike> / Bungkus";
		}
							$content .= "<td colspan='2'>" . $jenis_obat . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Malam</td>";
							$content .= "<td colspan='1'>";
								$content .= "<table border='1' class='etiket_content'><tr><td width='30px' align='center'>" . $data->tablet_jumlah_konsumsi_malam . "</td></tr></table>";
							$content .= "</td>";
							$content .= "<td colspan='2'>&nbsp;</td>";
						$content .= "</tr>";
		$waktu_konsumsi = "";
		if ($data->tablet_waktu_konsumsi == "sebelum") {
			$waktu_konsumsi = "sebelum / <strike>saat</strike> / <strike>sesudah</strike> makan";
		} else if ($data->tablet_waktu_konsumsi == "saat") {
			$waktu_konsumsi = "<strike>sebelum</strike> / saat / <strike>sesudah</strike> makan";
		} else if ($data->tablet_waktu_konsumsi == "sesudah") {
			$waktu_konsumsi = "<strike>sebelum</strike> / <strike>saat</strike> / sesudah makan";
		}
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>" . $waktu_konsumsi . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>" . ArrayAdapter::format("unslug", $data->tablet_cara_konsumsi) . "</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function getEtiketKosonganContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4'>..... x sehari ..... Tablet / Kapsul / Bungkus</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>$nbsp;</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function getEtiketInjeksiContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'><b>SERAHKAN KE DOKTER</b></td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function getEtiketSyrupDropContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
		$jenis_obat = "";
		if ($data->syrup_drop_satuan_konsumsi == "ml") {
			$jenis_obat = "ml / <strike>Sendok Teh</strike> / <strike>Sendok Makan</strike>";
		} else if ($data->syrup_drop_satuan_konsumsi == "sendok_teh") {
			$jenis_obat = "<strike>ml</strike> / Sendok Teh / <strike>Sendok Makan</strike>";
		} else if ($data->syrup_drop_satuan_konsumsi == "sendok_makan") {
			$jenis_obat = "<strike>ml</strike> / <strike>Sendok Teh</strike> / Sendok Makan";
		}
						$content .= "<tr>";
							$content .= "<td colspan='4'>" . $data->syrup_drop_jumlah_konsumsi_sehari . " x sehari " . $data->syrup_drop_jumlah_konsumsi . " " . $jenis_obat . "</td>";
						$content .= "</tr>";
		$waktu_konsumsi = "";
		if ($data->syrup_drop_waktu_konsumsi == "sebelum") {
			$waktu_konsumsi = "sebelum / <strike>di antara</strike> / <strike>sesudah</strike> makan";
		} else if ($data->syrup_drop_waktu_konsumsi == "di antara") {
			$waktu_konsumsi = "<strike>sebelum</strike> / di antara / <strike>sesudah</strike> makan";
		} else if ($data->syrup_drop_waktu_konsumsi == "sesudah") {
			$waktu_konsumsi = "<strike>sebelum</strike> / <strike>di antara</strike> / sesudah makan";
		}
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>" . $waktu_konsumsi . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>" . ArrayAdapter::format("unslug", $data->syrup_drop_cara_konsumsi) . "</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function getEtiketObatLuarContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4'>" . $data->obat_luar_jumlah_konsumsi_sehari . " x sehari</td>";
						$content .= "</tr>";
		$cara_pakai = "";
		if ($data->obat_luar_cara_konsumsi == "oleskan") {
			$cara_pakai = "Oleskan / <strike>Masukkan Anus</strike> / <strike>Semprot</strike> / <strike>Tetes</strike>";
		} else if ($data->obat_luar_cara_konsumsi == "masukkan_anus") {
			$cara_pakai = "<strike>Oleskan</strike> / Masukkan Anus / <strike>Semprot</strike> / <strike>Tetes</strike>";
		} else if ($data->obat_luar_cara_konsumsi == "semprot") {
			$cara_pakai = "<strike>Oleskan</strike> / <strike>Masukkan Anus</strike> / Semprot / <strike>Tetes</strike>";
		} else if ($data->obat_luar_cara_konsumsi == "tetes") {
			$cara_pakai = "<strike>Oleskan</strike> / <strike>Masukkan Anus</strike> / <strike>Semprot</strike> / Tetes";
		}
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'>" . $cara_pakai . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
		if ($data->obat_luar_simpan_dalam_lemari_pendingin) {
							$content .= "<td colspan='4' align='center'>Simpan dalam Lemari Pendingin</td>";
		}
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'><b>OBAT LUAR</b></td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function getEtiketRacikanContent($data) {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$content = "<table border='1' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<table class='etiket_content' border='0'>";
						$content .= "<tr>";
							$content .= "<td width='100%'>";
								$content .= "<center><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . "</b>";
								$content .= "<br />" . $alamat_entitas . "</center>";
							$content .= "</td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td colspan='2'>No. " . $data->nomor_resep . "</td>";
							$content .= "<td colspan='2' align='right'>Tgl. " . ArrayAdapter::format("date d-m-Y", $data->tanggal) . "</td>"; 
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='3'>: " . substr(strtoupper($data->nama_pasien), 0, 21) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4' align='center'><b>" . $data->nama_obat . "</b></td>";
						$content .= "</tr>";
						$content .= "<tr>";
		$satuan_konsumsi = "";
		if ($data->racikan_satuan_konsumsi == "tablet") {
			$satuan_konsumsi = "Tablet / <strike>Kapsul</strike> / <strike>Bungkus</strike>";
		} else if ($data->racikan_satuan_konsumsi == "capsul") {
			$satuan_konsumsi = "<strike>Tablet</strike> / Kapsul / <strike>Bungkus</strike>";
		} else if ($data->racikan_satuan_konsumsi == "bungkus") {
			$satuan_konsumsi = "<strike>Tablet</strike> / <strike>Kapsul</strike> / Bungkus";
		}
							$content .= "<td colspan='4' align='center'>" . $data->racikan_jumlah_konsumsi_sehari . " x sehari " . $data->racikan_jumlah_konsumsi . " " . $satuan_konsumsi . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4'><u><b><i>Komposisi</i></b></u></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='4'>" . $data->racikan_komposisi . "</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
}
?>