<?php 
	global $db;
	
	if (isset($_POST['from']) && isset($_POST['to'])) {
		$from = $_POST['from'];
		$to = $_POST['to'];
		$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		$rekap_rows = $dbtable->get_result("
			SELECT id_dokter, nama_dokter, SUM(				
				IF(
					t_diskon = 'nominal',
					(jumlah * harga) - ((diskon / (total + diskon)) * (jumlah * harga)),
					(jumlah * harga) - ((diskon / 100) * (jumlah * harga))
				)
			) AS 'total'
			FROM (
				SELECT id_dokter, nama_dokter, nama_obat, nama_jenis_obat, produsen, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon, bpjs, total
				FROM (
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.bpjs, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0
					UNION ALL
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.bpjs, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0
				) v_rekap
				WHERE tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
				GROUP BY id_dokter, id_obat, produsen, satuan, harga, diskon, t_diskon, bpjs, total
				ORDER BY nama_dokter, nama_obat, nama_jenis_obat ASC
			) v_rekap
			GROUP BY id_dokter
			ORDER BY nama_dokter ASC
		");
		$data = array();
		foreach($rekap_rows as $rr) {
			$rekap_data = array();
			$rekap_data['id_karyawan'] = $rr->id_dokter;
			$rekap_data['nama_karyawan'] = $rr->nama_dokter;
			$rekap_data['total'] = $rr->total;
			$bagian_dokter = ($rr->total * 2.5) / 100;
			$bagian_rs = $rr->total - $bagian_dokter;
			$rekap_data['bagian_rs'] = $bagian_rs;
			$rekap_data['bagian_dokter'] = $bagian_dokter;
			$data[] = $rekap_data;
		}
		echo json_encode($data);
	}
?>