<?php
require_once("smis-base/smis-include-duplicate.php");

class ReturPenjualanBebasDBResponder extends DuplicateResponder {
	public function command($command) {
		if ($command != "print_retur") {
			return parent::command($command);
		}
		$pack = null;
		if ($command == "print_retur") {
			$id['id'] = $_POST['id'];
			$data['tercetak'] = 1;
			$this->dbtable->update($data, $id);
			$pack = new ResponsePackage();
			$content = $this->print_retur();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}
		return $pack->getPackage();
	}
	public function print_retur() {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$id = $_POST['id'];
		$data = $this->dbtable->get_row("SELECT smis_ap_irja_retur_penjualan_resep.id, smis_ap_irja_penjualan_resep.id AS 'id_penjualan_resep', smis_ap_irja_retur_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.uri, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_retur_penjualan_resep.persentase_retur
										 FROM smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
										 WHERE smis_ap_irja_retur_penjualan_resep.id = '" . $id . "'");
		$obat_jadi_sql = "
			SELECT smis_ap_irja_stok_obat.nama_obat AS 'nama', smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_dretur_penjualan_resep.harga, smis_ap_irja_dretur_penjualan_resep.subtotal
			FROM smis_ap_irja_dretur_penjualan_resep LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_dretur_penjualan_resep.id_stok_obat = smis_ap_irja_stok_obat.id
			WHERE smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND id_retur_penjualan_resep = '" . $id . "'
		";
		$obat_jadi_data = $this->dbtable->get_result($obat_jadi_sql);
		$content = "<table border='0' width='100%' cellpadding='10' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content' >";
						$content .= "<tr>";
							$content .= "<td colspan='5' align='center' style='font-size: 13px !important;'><b><u>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . " - RETUR PENJUALAN BEBAS</u></b></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='5'></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>No. Retur</td>";
							$content .= "<td colspan='1'>: " .  ArrayAdapter::format("only-digit8", $data->id) . "</td>";
							$content .= "<td colspan='1' class='tpadding'>No. Penjualan</td>";
							$content .= "<td colspan='2'>: " .  ArrayAdapter::format("only-digit8", $data->id_penjualan_resep) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Tgl. Retur</td>"; 
							$content .= "<td colspan='4'>: " . ArrayAdapter::format("date d-m-Y H:i", $data->tanggal) . "</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='1' class='etiket_content'>";
					$content .= "<tr align='center'>";
						$content .= "<td colspan='1'>No.</td>";
						$content .= "<td colspan='1'>Obat</td>";
						$content .= "<td colspan='1'>Jumlah</td>";
						$content .= "<td colspan='1'>Harga Satuan</td>";
						$content .= "<td colspan='1'>Subtotal</td>";
					$content .= "</tr>";
					$no_barang = 1;
					$total = 0;
					foreach($obat_jadi_data as $ojd) {
						$content .= "<tr>";
							$content .= "<td colspan='1'>" . $no_barang++ . "</td>";
							$content .= "<td colspan='1'>" . $ojd->nama . "</td>";
							$content .= "<td colspan='1'>" . $ojd->jumlah . " " . $ojd->satuan . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ojd->harga) . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ojd->subtotal) . "</td>";
						$content .= "</tr>";
						$total += $ojd->subtotal;
					}
					$content .= "<tr>";
						$content .= "<td colspan='4' align='right'>Total</td>";
						$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $total) . "</td>";
					$content .= "</tr>";
					$content .= "<tr>";
						$content .= "<td colspan='4' align='right'>Diskon</td>";
						$v_diskon = 0;
						if ($data->t_diskon == "persen" || $data->t_diskon == "gratis") {
							$v_diskon = ($total * $data->diskon) / 100;
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $v_diskon) . "</td>";
						} else {
							$v_diskon = ($total * $data->diskon) / $data->total;
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $v_diskon) . "</td>";
						}
					$content .= "</tr>";
					$content .= "<tr>";
						$content .= "<td colspan='4' align='right'>Total Setelah Diskon</td>";
						$total = $total - $v_diskon;
						$content .= "<td colspan='1'>" . ArrayAdapter::format("money Rp.", $total) . "</td>";
					$content .= "</tr>";
					$content .= "<tr>";
						$potongan = 100 - $data->persentase_retur;
						$v_potongan = ($total * $potongan) / 100;
						$content .= "<td colspan='4' align='right'>Potongan Retur (" . $potongan . " %)</td>";
						$content .= "<td colspan='1'>" . ArrayAdapter::format("money Rp.", $v_potongan) . "</td>";
					$content .= "</tr>";
					$content .= "<tr>";
						$potongan = 100 - $data->persentase_retur;
						$content .= "<td colspan='4' align='right'>Uang Kembali</td>";
						$content .= "<td colspan='1'>" . ArrayAdapter::format("money Rp.", $total - $v_potongan) . "</td>";
					$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td colspan='5'>";
					$content .= "<table border='0' align='center' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td align='center'>PENERIMA,</td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td align='center'>PETUGAS APOTEK,</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td align='center'>(_____________________)</td>";
							$content .= "<td>&Tab;</td>";
							global $user;
							$content .= "<td align='center'>" . $user->getNameOnly() . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function save() {
		$header_data = $this->postToArray();
		$id['id'] = $_POST['id'];
		if ($id['id'] == 0 || $id['id'] == "") {
			//do insert header here:
			$header_data['persentase_retur'] = "100";
			$header_data['tanggal'] = date("Y-m-d H:i:s");
			$result = $this->dbtable->insert($header_data);
			if (isset($_POST['id_penjualan_resep'])) {
				$penjualan_penjualan_bebas_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penjualan_resep");
				$resep_data = array();
				$resep_data['diretur'] = "1";
				$resep_id['id'] = $_POST['id_penjualan_resep'];
				$penjualan_penjualan_bebas_dbtable->update($resep_data, $resep_id);
			}
			$id['id'] = $this->dbtable->get_inserted_id();
			$success['type'] = "insert";
			if (isset($_POST['detail'])) {
				//do insert detail here:
				$dretur_penjualan_bebas_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_dretur_penjualan_resep");
				$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_obat");
				$detail = $_POST['detail'];
				foreach($detail as $d) {
					$dretur_data = array();
					$dretur_data['id_retur_penjualan_resep'] = $id['id'];
					$dretur_data['id_stok_obat'] = $d['id_stok_obat'];
					$dretur_data['jumlah'] = $d['jumlah'];
					$dretur_data['harga'] = $d['harga'];
					$dretur_data['subtotal'] = $d['jumlah'] * $d['harga'];
					$dretur_data['autonomous'] = "[".$this->autonomous."]";
			        $dretur_data['duplicate'] = 0;
			        $dretur_data['time_updated'] = date("Y-m-d H:i:s");
			        $dretur_data['origin_updated'] = $this->autonomous;
					$dretur_penjualan_bebas_dbtable->insert($dretur_data);
					$stok_row = $stok_obat_dbtable->get_row("
						SELECT id, sisa
						FROM smis_ap_irja_stok_obat
						WHERE id = '" . $d['id_stok_obat'] . "'
					");
					$stok_data = array();
					$stok_data['sisa'] = $stok_row->sisa + $d['jumlah'];
					$stok_data['autonomous'] = "[".$this->autonomous."]";
					$stok_data['duplicate'] = 0;
					$stok_data['time_updated'] = date("Y-m-d H:i:s");
					$stok_id['id'] = $d['id_stok_obat'];
					$stok_obat_dbtable->update($stok_data, $stok_id);
					//logging riwayat stok:
					$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
					$data_riwayat = array();
					$data_riwayat['tanggal'] = date("Y-m-d");
					$data_riwayat['id_stok_obat'] = $d['id_stok_obat'];
					$data_riwayat['jumlah_masuk'] = $d['jumlah'];
					$data_riwayat['sisa'] = $stok_row->sisa + $d['jumlah'];
					$data_riwayat['keterangan'] = "Stok Retur Penjualan Bebas (" . ArrayAdapter::format("only-digit8", $_POST['id_penjualan_resep']) . ")";
					global $user;
					$data_riwayat['nama_user'] = $user->getName();
					$data_riwayat['autonomous'] = "[".$this->autonomous."]";
			        $data_riwayat['duplicate'] = 0;
			        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
			        $data_riwayat['origin_updated'] = $this->autonomous;
					$riwayat_dbtable->insert($data_riwayat);
				}
			}
		} else {
			//do update header here:
			$result = $this->dbtable->update($header_data, $id);
			$success['type'] = "update";
			if (isset($_POST['dibatalkan']) && $_POST['dibatalkan'] == 1) {
				$header_row = $this->dbtable->get_row("
					SELECT *
					FROM smis_ap_irja_retur_penjualan_resep
					WHERE id = '" . $id['id'] . "'
				");
				$penjualan_penjualan_bebas_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penjualan_resep");
				$resep_data = array();
				$resep_data['diretur'] = "0";
				$resep_id['id'] = $header_row->id_penjualan_resep;
				$penjualan_penjualan_bebas_dbtable->update($resep_data, $resep_id);
				$detail_rows = $this->dbtable->get_result("
					SELECT *
					FROM smis_ap_irja_dretur_penjualan_resep
					WHERE id_retur_penjualan_resep = '" . $id['id'] . "' AND prop NOT LIKE 'del'
				");
				$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_obat");
				foreach($detail_rows as $dr) {
					$stok_row = $stok_obat_dbtable->get_row("
						SELECT id, sisa
						FROM smis_ap_irja_stok_obat
						WHERE id = '" . $dr->id_stok_obat . "'
					");
					$stok_data = array();
					$stok_data['sisa'] = $stok_row->sisa - $dr->jumlah;
					$stok_data['autonomous'] = "[".$this->autonomous."]";
					$stok_data['duplicate'] = 0;
					$stok_data['time_updated'] = date("Y-m-d H:i:s");
					$stok_id['id'] = $dr->id_stok_obat;
					$stok_obat_dbtable->update($stok_data, $stok_id);
					//logging riwayat stok:
					$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
					$data_riwayat = array();
					$data_riwayat['tanggal'] = date("Y-m-d");
					$data_riwayat['id_stok_obat'] = $dr->id_stok_obat;
					$data_riwayat['jumlah_keluar'] = $dr->jumlah;
					$data_riwayat['sisa'] = $stok_row->sisa - $dr->jumlah;
					$data_riwayat['keterangan'] = "Pembatalan Retur Penjualan Bebas (" . ArrayAdapter::format("only-digit8", $id['id']) . ")";
					global $user;
					$data_riwayat['nama_user'] = $user->getName();
					$data_riwayat['autonomous'] = "[".$this->autonomous."]";
			        $data_riwayat['duplicate'] = 0;
			        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
			        $data_riwayat['origin_updated'] = $this->autonomous;
					$riwayat_dbtable->insert($data_riwayat);
				}
			}
		}
		$success['id'] = $id['id'];
		$success['success'] = 1;
		if ($result === false) $success['success'] = 0;
		return $success;
	}
	public function edit() {
		$id = $_POST['id'];
		$data['header'] = $this->dbtable->get_row("
			SELECT smis_ap_irja_retur_penjualan_resep.*, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien
			FROM smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
			WHERE smis_ap_irja_retur_penjualan_resep.id = '" . $id . "'
		");
		$detail_rows = $this->dbtable->get_result("
			SELECT smis_ap_irja_dretur_penjualan_resep.*, smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			FROM smis_ap_irja_dretur_penjualan_resep LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_dretur_penjualan_resep.id_stok_obat = smis_ap_irja_stok_obat.id
			WHERE smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep = '" . $id . "' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del'
		");
		$detail_list = "";
		$row_id = 0;
		foreach($detail_rows as $dr) {
			if ($dr->jumlah > 0) {
				$detail_list .= "<tr id='detail_" . $row_id . "'>" .
									"<td id='detail_" . $row_id . "_id' style='display: none;'>" . $dr->id . "</td>" .
									"<td id='detail_" . $row_id . "_id_stok_obat' style='display: none;'>" . $dr->id_stok_obat . "</td>" .
									"<td id='detail_" . $row_id . "_id_obat' style='display: none;'>" . $dr->id_obat . "</td>" .
									"<td id='detail_" . $row_id . "_nama_jenis_obat' style='display: none;'>" . $dr->nama_jenis_obat . "</td>" .
									"<td id='detail_" . $row_id . "_harga' style='display: none;'>" . $dr->harga . "</td>" .
									"<td id='detail_" . $row_id . "_jumlah_retur' style='display: none;'>" . $dr->jumlah . "</td>" .
									"<td id='detail_" . $row_id . "_satuan' style='display: none;'>" . $dr->satuan . "</td>" .
									"<td id='detail_" . $row_id . "_konversi' style='display: none;'>" . $dr->konversi . "</td>" .
									"<td id='detail_" . $row_id . "_satuan_konversi' style='display: none;'>" . $dr->satuan_konversi . "</td>" .
									"<td id='detail_" . $row_id . "_nama_obat'>" . $dr->nama_obat . "</td>" .
									"<td id='detail_" . $row_id . "_f_harga'>" . "Rp. " . number_format($dr->harga, 2, ",", ".") . "</td>" .
									"<td id='detail_" . $row_id . "_f_jumlah'>" . $dr->jumlah . " " . $dr->satuan . "</td>" .
									"<td></td>" .
								"</tr>";
				$row_id++;
			}
		}
		$data['detail_list'] = $detail_list;
		return $data;
	}
}
?>