<?php
require_once("smis-libs-class/Locker.php");
require_once("smis-base/smis-include-duplicate.php");
require_once("apotek/locker/PenjualanResepLocker.php");
	
class PenjualanResepLuarDBResponder extends DuplicateResponder {
	protected $message_failure;
	
	public function command($command) {
		if ($command != "print_prescription" && $command!="save") {
			return parent::command($command);
		}	
		$pack = null;
		if($command=="save"){
			global $user;
			$locker=new PenjualanResepLocker($this->dbtable->get_db(), $user, "penjualan-resep-apotek");
			$locker->setVariable($this);
			$pack = new ResponsePackage();
			$content=$locker->execute();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			
			if($content['success']==1){
				$pack->setAlertVisible(true);
				$pack->setAlertContent("Data Saved", "Your Data Had Been Saved", ResponsePackage::$TIPE_INFO);
			}else{
				$pack->setAlertVisible(false);
			}
		}else if ($command == "print_prescription") {
			$pack = new ResponsePackage();
			$content = $this->print_prescription();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}
		return $pack->getPackage();
	}
	public function addMessage($msg,$hidden_tbl_name=""){
		$this->message_failure.="<li data-stable='".$hidden_tbl_name."' >".$msg."</li>";
	}
	public function getMessage(){
		return "<ul>".$this->message_failure."</ul>";
	}
	public function print_prescription() {
		$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
		$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
		$id = $_POST['id'];
		$data = $this->dbtable->get_row("
			SELECT *
		    FROM smis_ap_irja_penjualan_resep
			WHERE id = '" . $id . "'
		");
		$obat_jadi_sql = "
			SELECT nama_obat AS 'nama', jumlah, satuan, harga, subtotal, embalase, tusla, 0 AS 'biaya_racik', 'obat_jadi' AS 'label'
			FROM smis_ap_irja_penjualan_obat_jadi
			WHERE prop NOT LIKE 'del' AND id_penjualan_resep = '" . $id . "'
		";
		$obat_jadi_data = $this->dbtable->get_result($obat_jadi_sql);
		$obat_racik_sql = "
			SELECT id, nama AS 'nama', jumlah, 'Racikan' AS 'satuan', harga, embalase, tusla, biaya_racik, subtotal, 'obat_racikan' AS 'label'
			FROM smis_ap_irja_penjualan_obat_racikan
			WHERE prop NOT LIKE 'del' AND id_penjualan_resep = '" . $id . "'
		";
		$obat_racik_data = $this->dbtable->get_result($obat_racik_sql);
		$content = "<table border='0' width='100%' cellpadding='3' class='etiket_header'>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='0' class='etiket_content' >";
						$content .= "<tr>";
							$content .= "<td colspan='5' align='center' style='font-size: 14px !important;'><b>APOTEK " . ArrayAdapter::format("unslug", $nama_entitas) . " - RESEP (NON-KIUP)</b></td>";
						$content .= "</tr>";
					$content .= "</div></table>";
					$content .= "<div align='center'><table border='0' class='etiket_content' >";
						$content .= "<tr>";
							$content .= "<td colspan='1'>No. Penjualan</td>";
							$content .= "<td colspan='1'>: " .  ArrayAdapter::format("only-digit8", $data->id) . "</td>";
							$content .= "<td colspan='1' class='tpadding'>No. Resep</td>";
							$content .= "<td colspan='2'>: " .  $data->nomor_resep . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Tgl. Resep</td>"; 
							$content .= "<td colspan='1'>: " . ArrayAdapter::format("date d-m-Y H:i", $data->tanggal) . "</td>"; 
							$content .= "<td colspan='1' class='tpadding'>Nama Dokter</td>";
							$content .= "<td colspan='2'>: " . substr(strtoupper($data->nama_dokter), 0, 30) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Nama Pasien</td>";
							$content .= "<td colspan='1'>: " . substr(strtoupper($data->nama_pasien), 0, 30) . "</td>";
							$content .= "<td colspan='1' class='tpadding'>Alamat Pasien</td>";
							$content .= "<td colspan='2'>: " . substr(strtoupper($data->alamat_pasien), 0, 30) . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td colspan='1'>Jns. Pasien</td>";
							$jenis_pasien = ArrayAdapter::format("unslug", $data->jenis) . " - ";
							if ($data->uri == 1) {
								$jenis_pasien .= "RAWAT INAP";
							} else {
								$jenis_pasien .= "RAWAT JALAN";
							}
							$content .= "<td colspan='4'>: " . $jenis_pasien . "</td>";
						$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
			$content .= "<tr>";
				$content .= "<td>";
					$content .= "<div align='center'><table border='1' class='etiket_content'>";
					$content .= "<tr align='center'>";
						$content .= "<td colspan='1'>No.</td>";
						$content .= "<td colspan='1'>Obat</td>";
						$content .= "<td colspan='1'>Jumlah</td>";
						$content .= "<td colspan='1'>Harga Satuan</td>";
						$content .= "<td colspan='1'>Jasa Pelyanan</td>";
						$content .= "<td colspan='1'>Subtotal</td>";
					$content .= "</tr>";
					$no_barang = 1;
					$total = 0;
					foreach($obat_jadi_data as $ojd) {
						$content .= "<tr>";
							$content .= "<td colspan='1'>" . $no_barang++ . "</td>";
							$content .= "<td colspan='1'>" . $ojd->nama . "</td>";
							$content .= "<td colspan='1'>" . $ojd->jumlah . " " . $ojd->satuan . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ojd->harga) . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ojd->embalase + $ojd->tusla) . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ojd->subtotal) . "</td>";
						$content .= "</tr>";
						$total += $ojd->subtotal;
					}
					foreach($obat_racik_data as $ord) {
						$content .= "<tr>";
							$content .= "<td colspan='1'>" . $no_barang++ . "</td>";
							$content .= "<td colspan='1'>" . ArrayAdapter::format("unslug", $ord->nama) . "</td>";
							$content .= "<td colspan='1'>" . $ord->jumlah . " " . $ord->satuan . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ord->harga) . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ord->embalase + $ord->tusla + $ord->biaya_racik) . "</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $ord->subtotal) . "</td>";
						$content .= "</tr>";
						$total += $ord->subtotal;
						//detail racikan:
						$bahan_racik_data = $this->dbtable->get_result("
							SELECT *
							FROM smis_ap_irja_bahan_pakai_obat_racikan
							WHERE id_penjualan_obat_racikan = '" . $ord->id . "'
						");
						$bahan_no = 'a';
						foreach($bahan_racik_data as $brd) {
							$content .= "<tr style='font-size: 12px !important;'>";
								$content .= "<td colspan='1'></td>";
								$content .= "<td colspan='1'>" . $bahan_no++ . ". " . $brd->nama_obat . "</td>";
								$content .= "<td colspan='1'>" . $brd->jumlah . " " . $brd->satuan . "</td>";
								$content .= "<td colspan='3' align='right'></td>";
							$content .= "</tr>";
						}
					}
					$content .= "<tr>";
						$content .= "<td colspan='5' align='right'>Jasa Resep</td>";
						$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $data->embalase + $data->tusla + $data->biaya_racik) . "</td>";
					$content .= "</tr>";
					$total += $data->embalase + $data->tusla + $data->biaya_racik;
					$content .= "<tr>";
						$content .= "<td colspan='5' align='right'>Total</td>";
						$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $total) . "</td>";
					$content .= "</tr>";
					$content .= "<tr>";
					if ($data->diskon > 0) {
						if ($data->t_diskon == "persen" || $data->t_diskon == "gratis") {
							$v_diskon = ($total * $data->diskon) / 100;
							$content .= "<td colspan='5' align='right'>Diskon (" . $data->diskon . " %)</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $v_diskon) . "</td>";
						} else {
							$content .= "<td colspan='5' align='right'>Diskon</td>";
							$content .= "<td colspan='1' align='right'>" . ArrayAdapter::format("money Rp.", $data->diskon) . "</td>";
						}
					}
					$content .= "</tr>";
					$content .= "<tr>";
						$content .= "<td colspan='5' align='right'>Tagihan</td>";
						$content .= "<td colspan='1'>" . ArrayAdapter::format("money Rp.", $data->total) . "</td>";
					$content .= "</tr>";
					loadLibrary("smis-libs-function-math");
					$content .= "<tr>";
						$content .= "<td colspan='1' align='right'>Terbilang</td>";
						$content .= "<td colspan='11'>" . numbertell($data->total) . " Rupiah </td>";
					$content .= "</tr>";
					$content .= "</table></div>";
				$content .= "</td>";
			$content .= "</tr>";
		if ($data->uri == false) {
			$content .= "</tr>";
				$content .= "<td colspan='6'><i>* Sudah termasuk PPn (10 %)</i></td>";
			$content .= "<tr>";
		}
			$content .= "<tr>";
				$content .= "<td colspan='6'>";
					$content .= "<table border='0' align='center' class='etiket_content'>";
						$content .= "<tr>";
							$content .= "<td align='center'>PENERIMA,</td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td align='center'>PETUGAS APOTEK,</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
							$content .= "<td>&Tab;</td>";
							$content .= "<td></td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td align='center'>(_____________________)</td>";
							$content .= "<td>&Tab;</td>";
							global $user;
							$content .= "<td align='center'>" . $user->getNameOnly() . "</td>";
						$content .= "</tr>";
						$content .= "<tr>";
							$content .= "<td></td>";
						$content .= "</tr>";
					$content .= "</table>";
				$content .= "</td>";
			$content .= "</tr>";
		$content .= "</table>";
		return $content;
	}
	public function batalDetailResep($id){
		$header = $this->dbtable->select($id);
		$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_obat");
		$stok_pakai_obat_jadi_rows = $this->dbtable->get_result("
			SELECT smis_ap_irja_stok_pakai_obat_jadi.*
			FROM smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id
			WHERE smis_ap_irja_stok_pakai_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = '" . $id['id'] . "'
		");
		foreach($stok_pakai_obat_jadi_rows as $spojr) {
			$stok_obat_row = $stok_obat_dbtable->get_row("
				SELECT *
				FROM smis_ap_irja_stok_obat
				WHERE id = '" . $spojr->id_stok_obat . "'
			");
			$stok_obat_data = array();
			$stok_obat_data['sisa'] = $stok_obat_row->sisa + $spojr->jumlah;
			$stok_obat_id['id'] = $stok_obat_row->id;
			$result=$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);
			if($result<1){
				$this->addMessage(" Obat <strong>".$stok_obat_row->nama_obat." </strong> Gagal Dibatalkan");
				return false;
			}
			
			//logging riwayat stok:
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
			$data_riwayat = array();
			$data_riwayat['tanggal'] = date("Y-m-d");
			$data_riwayat['id_stok_obat'] = $stok_obat_row->id;
			$data_riwayat['jumlah_masuk'] = $spojr->jumlah;
			$data_riwayat['sisa'] = $stok_obat_row->sisa + $spojr->jumlah;
			$keterangan = "Nomor: " . ArrayAdapter::format("digit8", $id['id']) . "; Jenis: Obat Jadi; Pasien: (" . ArrayAdapter::format("only-digit8", $header->nrm_pasien) . ") " . $header->nama_pasien . "; Alamat: " . $header->alamat_pasien . ";";
			$data_riwayat['keterangan'] = "Stok Batal Digunakan Penjualan Resep: " . $keterangan;
			global $user;
			$data_riwayat['nama_user'] = $user->getName();
			$data_riwayat['autonomous'] = "[".$this->autonomous."]";
	        $data_riwayat['duplicate'] = 0;
	        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
	        $data_riwayat['origin_updated'] = $this->autonomous;
			$result=$riwayat_dbtable->insert($data_riwayat);
			if($result===false){
				$this->addMessage(" Obat <strong>".$stok_obat_row->nama_obat." </strong> Gagal Dicatat di Riwayat");
				return false;
			}
		}
		
		$stok_pakai_bahan_rows = $this->dbtable->get_result("
			SELECT smis_ap_irja_stok_pakai_bahan.*
			FROM (smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id
			WHERE smis_ap_irja_stok_pakai_bahan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = '" . $id['id'] . "'
		");
		foreach($stok_pakai_bahan_rows as $spbr) {
			$stok_obat_row = $stok_obat_dbtable->get_row("
				SELECT *
				FROM smis_ap_irja_stok_obat
				WHERE id = '" . $spbr->id_stok_obat . "'
			");
			$stok_obat_data = array();
			$stok_obat_data['sisa'] = $stok_obat_row->sisa + $spbr->jumlah;
			$stok_obat_data['autonomous'] = "[".$this->autonomous."]";
			$stok_obat_data['duplicate'] = 0;
			$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
			$stok_obat_id['id'] = $stok_obat_row->id;
			$result=$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);
			if($result<1){
				$this->addMessage("Bahan <strong>".$stok_obat_row->nama_obat." </strong> Gagal Dibatalkan");
				return false;
			}
			//logging riwayat stok:
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
			$data_riwayat = array();
			$data_riwayat['tanggal'] = date("Y-m-d");
			$data_riwayat['id_stok_obat'] = $stok_obat_row->id;
			$data_riwayat['jumlah_masuk'] = $spbr->jumlah;
			$data_riwayat['sisa'] = $stok_obat_row->sisa + $spbr->jumlah;
			$keterangan = "Nomor: " . ArrayAdapter::format("digit8", $id['id']) . "; Jenis: Racikan; Pasien: (" . ArrayAdapter::format("only-digit8", $header->nrm_pasien) . ") " . $header->nama_pasien . "; Alamat: " . $header->alamat_pasien . ";";
			$data_riwayat['keterangan'] = "Stok Batal Digunakan Penjualan Resep: " . $keterangan;
			global $user;
			$data_riwayat['nama_user'] = $user->getName();
			$data_riwayat['autonomous'] = "[".$this->autonomous."]";
	        $data_riwayat['duplicate'] = 0;
	        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
	        $data_riwayat['origin_updated'] = $this->autonomous;
			$result=$riwayat_dbtable->insert($data_riwayat);
			if($result===false){
				$this->addMessage("Bahan <strong>".$stok_obat_row->nama_obat." </strong> Gagal Gagal Dicatat di Riwayat");
				return false;
			}
		}
		return true;
	}
	public function saveDetailResep($id){
		$success=true;
		//do insert detail resep here:
		$penjualan_obat_jadi_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penjualan_obat_jadi");
		$penjualan_obat_racikan_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penjualan_obat_racikan");
		$bahan_pakai_obat_racikan_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_bahan_pakai_obat_racikan");
		$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_obat");
		$stok_pakai_obat_jadi_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_pakai_obat_jadi");
		$stok_pakai_bahan_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_stok_pakai_bahan");
		$detail_resep = $_POST['detail_resep'];
		foreach($detail_resep as $dresep) {
			if ($dresep['tipe'] == "obat_jadi") {
				//do insert obat jadi here:
				$obat_jadi_data = array();
				$obat_jadi_data['id_penjualan_resep'] = $id['id'];
				$obat_jadi_data['id_obat'] = $dresep['id_obat'];
				$obat_jadi_data['kode_obat'] = $dresep['kode_obat'];
				$obat_jadi_data['nama_obat'] = $dresep['nama_obat'];
				$obat_jadi_data['nama_jenis_obat'] = $dresep['nama_jenis_obat'];
				$obat_jadi_data['jumlah'] = $dresep['jumlah'];
				$obat_jadi_data['satuan'] = $dresep['satuan'];
				$obat_jadi_data['konversi'] = $dresep['konversi'];
				$obat_jadi_data['satuan_konversi'] = $dresep['satuan_konversi'];
				$obat_jadi_data['harga'] = $dresep['harga'];
				$obat_jadi_data['embalase'] = $dresep['embalase'];
				$obat_jadi_data['tusla'] = $dresep['tusla'];
				$obat_jadi_data['subtotal'] = $dresep['subtotal'];
				$obat_jadi_data['aturan_pakai'] = $dresep['aturan_pakai'];
				$obat_jadi_data['pos'] = $dresep['pos'];
				$obat_jadi_data['autonomous'] = "[".$this->autonomous."]";
		        $obat_jadi_data['duplicate'] = 0;
		        $obat_jadi_data['time_updated'] = date("Y-m-d H:i:s");
		        $obat_jadi_data['origin_updated'] = $this->autonomous;
				$result=$penjualan_obat_jadi_dbtable->insert($obat_jadi_data);
				
				if($result===false){
					$success=false;
					$this->addMessage(" Obat <strong>".$dresep['nama_obat']." </strong> Gagal Masuk Resep");
					continue;
				}
				
				$id_penjualan_obat_jadi = $penjualan_obat_jadi_dbtable->get_inserted_id();
				//do insert stok pakai obat jadi and update stok obat here:
				$stok_obat_query = "
					SELECT smis_ap_irja_stok_obat.id, smis_ap_irja_stok_obat.sisa
					FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
					WHERE smis_ap_irja_stok_obat.id_obat = '" . $dresep['id_obat'] . "' 
					  AND smis_ap_irja_stok_obat.satuan = '" . $dresep['satuan'] . "' 
					  AND smis_ap_irja_stok_obat.konversi = '" . $dresep['konversi'] . "' 
					  AND smis_ap_irja_stok_obat.satuan_konversi = '" . $dresep['satuan_konversi'] . "'
					  AND smis_ap_irja_stok_obat.sisa > 0
					  AND smis_ap_irja_obat_masuk.status = 'sudah'
					ORDER BY smis_ap_irja_stok_obat.tanggal_exp ASC
				";
				$stok_obat_rows = $stok_obat_dbtable->get_result($stok_obat_query);
				$jumlah = $dresep['jumlah'] - $dresep['jumlah_lama'];//kalau-kalau update
				foreach($stok_obat_rows as $sor) {
					$sisa_stok = 0;
					$jumlah_stok_pakai = 0;
					if ($sor->sisa >= $jumlah) {
						$sisa_stok = $sor->sisa - $jumlah;
						$jumlah_stok_pakai = $jumlah;
						$jumlah = 0;
					} else {
						$sisa_stok = 0;
						$jumlah_stok_pakai = $sor->sisa;
						$jumlah = $jumlah - $sor->sisa;
					}
					//do update stok obat here:
					$stok_obat_data = array();
					$stok_obat_data['sisa'] = $sisa_stok;
					$stok_obat_data['autonomous'] = "[".$this->autonomous."]";
					$stok_obat_data['duplicate'] = 0;
					$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
					$stok_obat_id['id'] = $sor->id;
					$keberhasilan_mengambil_stok=$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);
					if($keberhasilan_mengambil_stok==0){
						$success=false;
						$this->addMessage(" Stok <strong>".$dresep['nama_obat']." </strong> Gagal diambil ");
						continue;
					}
					
					//logging riwayat stok:
					$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
					$data_riwayat = array();
					$data_riwayat['tanggal'] = date("Y-m-d");
					$data_riwayat['id_stok_obat'] = $sor->id;
					$data_riwayat['jumlah_keluar'] = $jumlah_stok_pakai;
					$data_riwayat['sisa'] = $sisa_stok;
					$keterangan = "Nomor: " . ArrayAdapter::format("digit8", $id['id']) . "; Jenis: Obat Jadi; Pasien: " . $_POST['nama_pasien'] . "; Alamat: " . $_POST['alamat_pasien'] . ";";
					$data_riwayat['keterangan'] = "Stok Digunakan Penjualan Resep Luar: " . $keterangan;
					global $user;
					$data_riwayat['nama_user'] = $user->getName();
					$data_riwayat['autonomous'] = "[".$this->autonomous."]";
			        $data_riwayat['duplicate'] = 0;
			        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
			        $data_riwayat['origin_updated'] = $this->autonomous;
					$result=$riwayat_dbtable->insert($data_riwayat);
					if($result===false){
						$success=false;
						$this->addMessage(" Riwayat <strong>".$dresep['nama_obat']." </strong> Gagal dicatat");
						continue;
					}
					
					//do insert stok pakai obat jadi here:
					$stok_pakai_obat_jadi_data = array();
					$stok_pakai_obat_jadi_data['id_penjualan_obat_jadi'] = $id_penjualan_obat_jadi;
					$stok_pakai_obat_jadi_data['id_stok_obat'] = $sor->id;
					$stok_pakai_obat_jadi_data['jumlah'] = $jumlah_stok_pakai;
					$stok_pakai_obat_jadi_data['autonomous'] = "[".$this->autonomous."]";
			        $stok_pakai_obat_jadi_data['duplicate'] = 0;
			        $stok_pakai_obat_jadi_data['time_updated'] = date("Y-m-d H:i:s");
			        $stok_pakai_obat_jadi_data['origin_updated'] = $this->autonomous;
					$result=$stok_pakai_obat_jadi_dbtable->insert($stok_pakai_obat_jadi_data);
					if($result===false){
						$success=false;
						$this->addMessage(" Obat <strong>".$dresep['nama_obat']." </strong> Gagal Disimpan di Riwayat Pemakaian Obat Jadi","Pakai Obat Jadi");
						continue;
					}
					if ($jumlah == 0) break;
				}
				if($jumlah>0) {
					$success=false;
					$this->addMessage(" Stok untuk Obat Jadi pada <strong>".$dresep['nama_obat']." </strong> Kurang ".$jumlah." ".$dresep['satuan']);
				}
			} else if ($dresep['tipe'] == "obat_racikan") {
				//do insert obat racikan header here:
				$obat_racikan_data = array();
				$obat_racikan_data['id_penjualan_resep'] = $id['id'];
				$obat_racikan_data['nama'] = $dresep['nama'];
				$obat_racikan_data['jumlah'] = $dresep['jumlah'];
				$obat_racikan_data['harga'] = $dresep['harga'];
				$obat_racikan_data['embalase'] = $dresep['total_embalase'];
				$obat_racikan_data['tusla'] = $dresep['total_tusla'];
				$obat_racikan_data['biaya_racik'] = $dresep['biaya_racik'];
				$obat_racikan_data['subtotal'] = $dresep['subtotal'];
				$obat_racikan_data['aturan_pakai'] = $dresep['aturan_pakai'];
				$obat_racikan_data['id_apoteker'] = $dresep['id_apoteker'];
				$obat_racikan_data['nama_apoteker'] = $dresep['nama_apoteker'];
				$obat_racikan_data['pos'] = $dresep['pos'];
				$obat_racikan_data['autonomous'] = "[".$this->autonomous."]";
		        $obat_racikan_data['duplicate'] = 0;
		        $obat_racikan_data['time_updated'] = date("Y-m-d H:i:s");
		        $obat_racikan_data['origin_updated'] = $this->autonomous;
				$result=$penjualan_obat_racikan_dbtable->insert($obat_racikan_data);
				if($result===false){
					$success=false;
					$this->addMessage(" Racikan  <strong>". $dresep['nama']." </strong> Gagal Masuk Resep");
					continue;
				}
				$id_penjualan_obat_racikan = $penjualan_obat_racikan_dbtable->get_inserted_id();
				if (isset($dresep['detail_racikan'])) {
					//do insert detail racikan here:
					$detail_racikan = $dresep['detail_racikan'];
					foreach($detail_racikan as $dracikan) {
						$bahan_data = array();
						$bahan_data['id_penjualan_obat_racikan'] = $id_penjualan_obat_racikan;
						$bahan_data['id_obat'] = $dracikan['id_obat'];
						$bahan_data['kode_obat'] = $dracikan['kode_obat'];
						$bahan_data['nama_obat'] = $dracikan['nama_obat'];
						$bahan_data['nama_jenis_obat'] = $dracikan['nama_jenis_obat'];
						$bahan_data['jumlah'] = $dracikan['jumlah'];
						$bahan_data['satuan'] = $dracikan['satuan'];
						$bahan_data['konversi'] = $dracikan['konversi'];
						$bahan_data['satuan_konversi'] = $dracikan['satuan_konversi'];
						$bahan_data['harga'] = $dracikan['harga'];
						$bahan_data['embalase'] = $dracikan['embalase'];
						$bahan_data['tusla'] = $dracikan['tusla'];
						$bahan_data['autonomous'] = "[".$this->autonomous."]";
				        $bahan_data['duplicate'] = 0;
				        $bahan_data['time_updated'] = date("Y-m-d H:i:s");
				        $bahan_data['origin_updated'] = $this->autonomous;
						$result=$bahan_pakai_obat_racikan_dbtable->insert($bahan_data);
						if($result===false){
							$success=false;
							$this->addMessage(" Racikan ".$dresep['nama']." pada  <strong>". $dracikan['nama_obat']." </strong> Gagal Masuk Resep");
							continue;
						}
						$id_bahan = $bahan_pakai_obat_racikan_dbtable->get_inserted_id();
						//do insert stok pakai bahan and update stok obat here:
						$stok_obat_query = "
							SELECT smis_ap_irja_stok_obat.id, smis_ap_irja_stok_obat.sisa
							FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
							WHERE smis_ap_irja_stok_obat.id_obat = '" . $dracikan['id_obat'] . "' 
							  AND smis_ap_irja_stok_obat.satuan = '" . $dracikan['satuan'] . "' 
							  AND smis_ap_irja_stok_obat.konversi = '" . $dracikan['konversi'] . "' 
							  AND smis_ap_irja_stok_obat.satuan_konversi = '" . $dracikan['satuan_konversi'] . "'
							  AND smis_ap_irja_stok_obat.sisa > 0
							  AND smis_ap_irja_obat_masuk.status = 'sudah'
							ORDER BY smis_ap_irja_stok_obat.tanggal_exp ASC
						";
						$stok_obat_rows = $stok_obat_dbtable->get_result($stok_obat_query);
						$jumlah = $dracikan['jumlah'];
						foreach($stok_obat_rows as $sor) {
							$sisa_stok = 0;
							$jumlah_stok_pakai = 0;
							if ($sor->sisa >= $jumlah) {
								$sisa_stok = $sor->sisa - $jumlah;
								$jumlah_stok_pakai = $jumlah;
								$jumlah = 0;
							} else {
								$sisa_stok = 0;
								$jumlah_stok_pakai = $sor->sisa;
								$jumlah = $jumlah - $sor->sisa;
							}
							//do update stok obat here:
							$stok_obat_data = array();
							$stok_obat_data['sisa'] = $sisa_stok;
							$stok_obat_data['autonomous'] = "[".$this->autonomous."]";
							$stok_obat_data['duplicate'] = 0;
							$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
							$stok_obat_id['id'] = $sor->id;
							$keberhasilan_mengambil_stok=$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);
							if($keberhasilan_mengambil_stok==0){
								$success=false;
								$this->addMessage(" Stok Racikan ".$dresep['nama']." pada <strong>".$dracikan['nama_obat']." </strong> Gagal diambil ");
								continue;
							}
							//logging riwayat stok:
							$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
							$data_riwayat = array();
							$data_riwayat['tanggal'] = date("Y-m-d");
							$data_riwayat['id_stok_obat'] = $sor->id;
							$data_riwayat['jumlah_keluar'] = $jumlah_stok_pakai;
							$data_riwayat['sisa'] = $sisa_stok;
							$keterangan = "Nomor: " . ArrayAdapter::format("digit8", $id['id']) . "; Jenis: Obat Racikan; Pasien: " . $_POST['nama_pasien'] . "; Alamat: " . $_POST['alamat_pasien'] . ";";
							$data_riwayat['keterangan'] = "Stok Digunakan Penjualan Resep Luar: " . $keterangan;
							$data_riwayat['autonomous'] = "[".$this->autonomous."]";
					        $data_riwayat['duplicate'] = 0;
					        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
					        $data_riwayat['origin_updated'] = $this->autonomous;
							global $user;
							$data_riwayat['nama_user'] = $user->getName();
							$result=$riwayat_dbtable->insert($data_riwayat);
							if($result===false){
								$success=false;
								$this->addMessage(" Riwayat Racikan ".$dresep['nama']." <strong>".$dracikan['nama_obat']." </strong> Gagal dicatat ");
								continue;
							}	
							//do insert stok pakai bahan here:
							$stok_pakai_bahan_data = array();
							$stok_pakai_bahan_data['id_bahan'] = $id_bahan;
							$stok_pakai_bahan_data['id_stok_obat'] = $sor->id;
							$stok_pakai_bahan_data['jumlah'] = $jumlah_stok_pakai;
							$stok_pakai_bahan_data['autonomous'] = "[".$this->autonomous."]";
					        $stok_pakai_bahan_data['duplicate'] = 0;
					        $stok_pakai_bahan_data['time_updated'] = date("Y-m-d H:i:s");
					        $stok_pakai_bahan_data['origin_updated'] = $this->autonomous;
							$stok_pakai_bahan_dbtable->insert($stok_pakai_bahan_data);
							if($result===false){
								$success=false;
								$this->addMessage(" Racikan ".$dresep['nama']." pada Bahan <strong>".$dracikan['nama_obat']." </strong> Gagal Disimpan di Riwayat Pemakaian Bahan","Pakai Bahan");
								continue;
							}
							if ($jumlah == 0) break;
						}
						if($jumlah > 0) {
							$success=false;
							$this->addMessage(" Stok untuk Racikan  ".$dresep['nama']."  pada <strong>".$dracikan['nama_obat']." </strong> Tidak Cukup Kurang ".$jumlah." ".$dracikan['satuan']);
						}
					}
				}
			}
		}
		return $success;
	}
	public function save() {
		$header_data = $this->postToArray();
		$id['id'] = $_POST['id'];
		$berhasil=false;
		$db=$this->dbtable->get_db();
		$db->set_autocommit(false);
		$db->begin_transaction();
		if ($id['id'] == 0 || $id['id'] == "") {
			//do insert header here:
			$header_data['tipe'] = "resep_luar";
			$tahun = date("Y");
			if (!isset($_POST['nomor_resep'])) {
				$nomor = getSettings($this->dbtable->get_db(), "R-" . $tahun, "0") + 1;
				setSettings($this->dbtable->get_db(), "R-" . $tahun, $nomor);
				$header_data['nomor_resep'] = "R-" . $tahun . "." . $nomor;
			}
			$header_data['tanggal'] = date("Y-m-d H:i:s");
			$result = $this->dbtable->insert($header_data);	
			if ($result===false) {
				$berhasil = false;
				$this->addMessage(" Resep Gagal Disimpan");
			} else {
				$id['id'] = $this->dbtable->get_inserted_id();
				$success['type'] = "insert";
				if (isset($_POST['detail_resep'])) {
					$berhasil=$this->saveDetailResep($id);
				}
			}
		} else {
			//do update header here:
			$result = $this->dbtable->update($header_data, $id);
			if ($result===false){
				$berhasil=false;
				$this->addMessage(" Pembatalan Resep Gagal");
			} else {
				$success['type'] = "update";
			}
			if (isset($_POST['dibatalkan']) && $_POST['dibatalkan'] == 1) {
				$berhasil=$this->batalDetailResep($id);
			}
		}
		if ($berhasil) $db->commit();
		else $db->rollback();
		$db->set_autocommit(true);
		$success['id'] = $id['id'];
		$success['success'] = 1;
		$success['message'] = $this->getMessage();
		if ($berhasil === false) $success['success'] = 0;
		return $success;
	}
	public function edit() {
		$id = $_POST['id'];
		$data['header'] = $this->dbtable->get_row("
			SELECT *
			FROM smis_ap_irja_penjualan_resep
			WHERE id = '" . $id . "'
		");
		$dresep_num = 0;
		$racikan_num = 0;
		$dracikan_num = 0;
		$bahan_num = 0;
		$pos = 0;
		$dresep_list = "";
		$bahan_racikan_list = "";
		$obat_jadi_row = $this->dbtable->get_row("
			SELECT COUNT(*) AS 'jumlah'
			FROM smis_ap_irja_penjualan_obat_jadi
			WHERE id_penjualan_resep = '" .  $id . "' AND prop NOT LIKE 'del'
		");
		$obat_jadi_rows = $this->dbtable->get_result("
			SELECT *
			FROM smis_ap_irja_penjualan_obat_jadi
			WHERE id_penjualan_resep = '" .  $id . "' AND prop NOT LIKE 'del'
		");
		$obat_racikan_row = $this->dbtable->get_row("
			SELECT COUNT(*) AS 'jumlah'
			FROM smis_ap_irja_penjualan_obat_racikan
			WHERE id_penjualan_resep = '" . $id . "' AND prop NOT LIKE 'del'
		");
		$obat_racikan_rows = $this->dbtable->get_result("
			SELECT *
			FROM smis_ap_irja_penjualan_obat_racikan
			WHERE id_penjualan_resep = '" . $id . "' AND prop NOT LIKE 'del'
		");
		$jumlah_item = $obat_jadi_row->jumlah + $obat_racikan_row->jumlah;
		$no = 1;
		while ($jumlah_item > 0) {
			$found = false;
			//iterate obat jadi:
			if (!$found) {
				foreach($obat_jadi_rows as $obat_jadi) {
					if ($obat_jadi->pos == $pos) {
						$dresep_action = "";
						if (!$_POST['readonly']) {
							$dresep_action = "<div class='btn-group noprint'>" .
												"<a href='#' onclick='dresep.edit_obat_jadi(" . $dresep_num . ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" .
													"<i class='icon-edit icon-white'></i>" .
												"</a>" .
												"<a href='#' onclick='dresep.delete(" . $dresep_num . ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" .
													"<i class='icon-remove icon-white'></i>" .
												"</a>" .
											 "</div>";
						}
						$dresep_list .= "<tr id='dresep_" . $dresep_num . "'>" .
											"<td id='dresep_" . $dresep_num . "_id' style='display: none;'>" . $obat_jadi->id . "</td>" .
											"<td id='dresep_" . $dresep_num . "_tipe' style='display: none;'>obat_jadi</td>" .
											"<td id='dresep_" . $dresep_num . "_id_obat' style='display: none;'>" . $obat_jadi->id_obat . "</td>" .
											"<td id='dresep_" . $dresep_num . "_kode_obat' style='display: none;'>" . $obat_jadi->kode_obat . "</td>" .
											"<td id='dresep_" . $dresep_num . "_nama_jenis_obat' style='display: none;'>" . $obat_jadi->nama_jenis_obat . "</td>" .
											"<td id='dresep_" . $dresep_num . "_jumlah' style='display: none;'>" . $obat_jadi->jumlah . "</td>" .
											"<td id='dresep_" . $dresep_num . "_jumlah_lama' style='display: none;'>" . $obat_jadi->jumlah . "</td>" .
											"<td id='dresep_" . $dresep_num . "_satuan' style='display: none;'>" . $obat_jadi->satuan . "</td>" .
											"<td id='dresep_" . $dresep_num . "_konversi' style='display: none;'>" . $obat_jadi->konversi . "</td>" .
											"<td id='dresep_" . $dresep_num . "_satuan_konversi' style='display: none;'>" . $obat_jadi->satuan_konversi . "</td>" .
											"<td id='dresep_" . $dresep_num . "_nomor'>" . $no++ . "</td>" .
											"<td id='dresep_" . $dresep_num . "_nama_obat'>" . $obat_jadi->nama_obat . "</td>" .
											"<td id='dresep_" . $dresep_num . "_f_jumlah'>" . $obat_jadi->jumlah . " " . $obat_jadi->satuan . "</td>" .
											"<td id='dresep_" . $dresep_num . "_harga'>" . "Rp. " . number_format($obat_jadi->harga, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_embalase'>" . "Rp. " . number_format($obat_jadi->embalase, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_tuslah'>" . "Rp. " . number_format($obat_jadi->tusla, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_biaya_racik'>" . "Rp. 0,00</td>" .
											"<td id='dresep_" . $dresep_num . "_subtotal'>" . "Rp. " . number_format($obat_jadi->subtotal, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_aturan_pakai'>" . $obat_jadi->aturan_pakai . "</td>" .
											"<td id='dresep_" . $dresep_num . "_apoteker'>-</td>" .
											"<td>" .
												$dresep_action .
											"</td>" .
										"</tr>";
						$dresep_num++;
						$found = true;
						break;
					}
				}
			}
			if (!$found) {
				//iterate obat racikan:
				foreach($obat_racikan_rows as $obat_racikan) {
					if ($obat_racikan->pos == $pos) {
						$bahan_rows = $this->dbtable->get_result("
										SELECT *
										FROM smis_ap_irja_bahan_pakai_obat_racikan
										WHERE id_penjualan_obat_racikan = '" . $obat_racikan->id . "'
									");
						foreach($bahan_rows as $bahan) {
							$bahan_racikan_list .= "<tr id=bahan_" . $bahan_num . ">" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_id'>" . $bahan->id . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_id_bahan'>" . $bahan->id_obat . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_kode'>" . $bahan->kode_obat . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_nama'>" . $bahan->nama_obat . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_nama_jenis_bahan'>" . $bahan->nama_jenis_obat . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_jumlah'>" . $bahan->jumlah . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_jumlah_lama'>" . $bahan->jumlah . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_satuan'>" . $bahan->satuan . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_konversi'>" . $bahan->konversi . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_satuan_konversi'>" . $bahan->satuan_konversi . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_harga'>" . "Rp. " . number_format($bahan->harga, 2, ",", ".") . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_embalase'>" . "Rp. " . number_format($bahan->embalase, 2, ",", ".") . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_tuslah'>" . "Rp. " . number_format($bahan->tusla, 2, ",", ".") . "</td>" .
														"<td style='display: none;' id='bahan_" . $bahan_num . "_label'>racikan_" . $racikan_num . "</td>" .
												   "</tr>";
							$bahan_num++;
						}
						$dresep_action = "";
						if (!$_POST['readonly']) {
							$dresep_action = "<div class='btn-group noprint'>" .
												  "<a href='#' onclick='dresep.edit_obat_racikan(" . $dresep_num . "," . $racikan_num . ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" .
													  "<i class='icon-edit icon-white'></i>" .
												  "</a>" .
												  "<a href='#' onclick='dresep.delete(" . $dresep_num . ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" .
													  "<i class='icon-remove icon-white'></i>" .
												  "</a>" .
											  "</div>";
						} else {
							$dresep_action = "<div class='btn-group noprint'>" .
												 "<a href='#' onclick='dresep.view_obat_racikan(" . $dresep_num . "," . $racikan_num . ")' data-content='Ubah' data-toggle='popover' class='input btn btn-success'>" .
													"<i class='icon-eye-open icon-white'></i>" .
												 "</a>" .
											 "</div>";
						}
						$dresep_list .= "<tr id='dresep_" . $dresep_num . "'>" .
											"<td id='dresep_" . $dresep_num . "_id' style='display: none;'>" . $obat_racikan->id . "</td>" .
											"<td id='dresep_" . $dresep_num . "_tipe' style='display: none;'>obat_racikan</td>" .
											"<td id='dresep_" . $dresep_num . "_label' style='display: none;'>racikan_" . $racikan_num . "</td>" .
											"<td id='dresep_" . $dresep_num . "_id_apoteker' style='display: none;'>" . $obat_racikan->id_apoteker . "</td>" .
											"<td id='dresep_" . $dresep_num . "_jumlah' style='display: none;'>" . $obat_racikan->jumlah . "</td>" .
											"<td id='dresep_" . $dresep_num . "_nomor'>" . $no++ . "</td>" .
											"<td id='dresep_" . $dresep_num . "_nama_racikan'>" . $obat_racikan->nama . "</td>" .
											"<td id='dresep_" . $dresep_num . "_f_jumlah'>" . $obat_racikan->jumlah . " Racikan</td>" .
											"<td id='dresep_" . $dresep_num . "_f_harga'>" . "Rp. " . number_format($obat_racikan->harga, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_embalase'>" . "Rp. " . number_format($obat_racikan->embalase, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_tuslah'>" . "Rp. " . number_format($obat_racikan->tusla, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_biaya_racik'>" . "Rp. " . number_format($obat_racikan->biaya_racik, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_subtotal'>" . "Rp. " . number_format($obat_racikan->subtotal, 2, ",", ".") . "</td>" .
											"<td id='dresep_" . $dresep_num . "_aturan_pakai'>" . $obat_racikan->aturan_pakai . "</td>" . 
											"<td id='dresep_" . $dresep_num . "_apoteker'>" . $obat_racikan->nama_apoteker . "</td>" .
											"<td>" .
												$dresep_action .
											"</td>" .
										"</tr>";
						$dresep_num++;
						$racikan_num++;
						$found = true;
						break;
					}
				}
			}
			if ($found) {
				$jumlah_item -= 1;
			}
			$pos += 1;
		}
		$data['dresep_num'] = $dresep_num;
		$data['racikan_num'] = $racikan_num;
		$data['dracikan_num'] = $dracikan_num;
		$data['bahan_num'] = $bahan_num;
		$data['dresep_list'] = $dresep_list;
		$data['bahan_racikan_list'] = $bahan_racikan_list;
		return $data;
	}
}
?>