<?php
	global $db;
	require_once("apotek/kelas/DepoFarmasiInventory.php");

	$table = new Table(
		array("No.", "Kode", "Nama", "Jenis", "Jumlah", "Satuan"),
		"Apotek : Rekonsiliasi Stok Obat",
		null,
		true
	);
	$table->setName("rekonsiliasi_stok_obat");
	$table->setAddButtonEnable(false);
	$table->setReloadButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setDelButtonEnable(false);

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_stock_by_date") {
			$tanggal_to = $_POST['tanggal_pilihan'];
			$id_obat = $_POST['id_obat'];
			$satuan = $_POST['satuan'];
			$satuan_konversi = $_POST['satuan'];

			// Mendapatkan Saldo Akhir:
			$saldo_sekarang = DepoFarmasiInventory::getCurrentStock($db, $id_obat, $satuan, 1, $satuan_konversi);
			$jumlah_masuk_temp = DepoFarmasiInventory::getStockIn($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + DepoFarmasiInventory::getPenyesuaianStokPositif($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d"));
			$jumlah_keluar_temp = DepoFarmasiInventory::getStockOut($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + DepoFarmasiInventory::getPenyesuaianStokNegatif($db, $id_obat, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d"));
			$saldo_akhir = $saldo_sekarang - $jumlah_masuk_temp + $jumlah_keluar_temp;
			echo json_encode(
				array(
					"saldo_akhir" => $saldo_akhir
				)
			);
			return;
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("Kode", "kode_obat");
		$adapter->add("Nama", "nama_obat");
		$adapter->add("Jenis", "nama_jenis_obat");
		$adapter->add("Jumlah", "jumlah", "number");
		$adapter->add("Satuan", "satuan");

		$dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
		$filter = "";
		if (isset($_POST['kriteria']))
			$filter = " AND (a.kode_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%') ";
		$query_value = "
			SELECT a.id_obat AS 'id', a.kode_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) AS 'jumlah', a.satuan
			FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
			WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' AND a.konversi = '1' AND a.satuan = a.satuan_konversi " . $filter . "
			GROUP BY a.id_obat, a.satuan
			ORDER BY a.nama_obat, a.kode_obat ASC
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				" . $query_value . "
			) v
		";
		$dbtable->setPreferredQuery(true, $query_value, $query_count);
		class RekonsiliasiStokObatDBResponder extends DBResponder {
			public function save() {
				$id_obat = $_POST['id_obat'];
				$sisa = $_POST['sisa'];
				$jumlah = $_POST['jumlah'];
				$selisih = $jumlah - $sisa;
				$satuan = $_POST['satuan'];
				$keterangan = $_POST['keterangan'];
				
				if ($selisih > 0) {
					$stok_row = $this->dbtable->get_row("
						SELECT a.*
						FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
						WHERE a.id_obat = '" . $id_obat . "' AND satuan = '" . $satuan. "' AND konversi = '1' AND satuan_konversi = '" . $satuan . "' AND a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
						ORDER BY a.id DESC
						LIMIT 0, 1
					");
					$jumlah_lama = $stok_row->sisa;
					$jumlah_baru = $stok_row->sisa + $selisih;
					$stok_data = array(
						"sisa"	=> $stok_row->sisa + $selisih
					);
					$stok_id = array(
						"id"	=> $stok_row->id
					);
					$this->dbtable->update($stok_data, $stok_id);

					$penyesuaian_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penyesuaian_stok_obat");
					global $user;
					$penyesuaian_data = array(
						"id_stok_obat"  => $stok_row->id,
						"tanggal"		=> date("Y-m-d"),
						"jumlah_lama"	=> $jumlah_lama,
						"jumlah_baru"	=> $jumlah_baru,
						"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan . ".",
						"nama_user"		=> $user->getName()
					);
					$penyesuaian_dbtable->insert($penyesuaian_data);

					$riwayat_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
					$riwayat_data = array(
						"tanggal"		=> date("Y-m-d"),
						"id_stok_obat"	=> $stok_row->id,
						"jumlah_masuk"	=> $selisih,
						"jumlah_keluar"	=> 0,
						"sisa"			=> ($stok_row->sisa + $selisih),
						"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan,
						"nama_user"		=> $user->getName()
					);
					$riwayat_stok_dbtable->insert($riwayat_data);

					// $sisa_row = $this->dbtable->get_row("
					// 	SELECT SUM(a.sisa) AS 'sisa'
					// 	FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
					// 	WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_row->id_obat . "' AND a.satuan = '" . $stok_row->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
					// ");
					// $kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_kartu_stok_obat");
					// $kartu_stok_data = array(
					// 	"f_id"				=> 0,
					// 	"no_bon"			=> "-",
					// 	"unit"				=> "Rekonsiliasi Stok : " . $keterangan,
					// 	"id_obat"			=> $stok_row->id_obat,
					// 	"kode_obat"			=> $stok_row->kode_obat,
					// 	"nama_obat"			=> $stok_row->nama_obat,
					// 	"nama_jenis_obat"	=> $stok_row->nama_jenis_obat,
					// 	"tanggal"			=> date("Y-m-d"),
					// 	"masuk"				=> $selisih,
					// 	"keluar"			=> 0,
					// 	"sisa"				=> $sisa_row->sisa
					// );
					// $kartu_stok_dbtable->insert($kartu_stok_data);
				} else if ($selisih < 0) {
					$stok_rows = $this->dbtable->get_result("
						SELECT a.*
						FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
						WHERE a.id_obat = '" . $id_obat . "' AND satuan = '" . $satuan. "' AND konversi = '1' AND satuan_konversi = '" . $satuan . "' AND a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' AND a.sisa > 0
					");
					$info_selisih = $selisih;
					foreach ($stok_rows as $stok_row) {
						$sisa_stok = $stok_row->sisa;
						if ($sisa_stok + $selisih >= 0) {
							$jumlah_lama = $sisa_stok;
							$sisa_stok = $sisa_stok + $selisih;
							$jumlah_baru = $sisa_stok;
							$stok_data = array(
								"sisa"	=> $sisa_stok
							);
							$stok_id = array(
								"id"	=> $stok_row->id
							);
							$this->dbtable->update($stok_data, $stok_id);

							$penyesuaian_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penyesuaian_stok_obat");
							global $user;
							$penyesuaian_data = array(
								"id_stok_obat"  => $stok_row->id,
								"tanggal"		=> date("Y-m-d"),
								"jumlah_lama"	=> $jumlah_lama,
								"jumlah_baru"	=> $jumlah_baru,
								"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan . ".",
								"nama_user"		=> $user->getName()
							);
							$penyesuaian_dbtable->insert($penyesuaian_data);

							$riwayat_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
							$riwayat_data = array(
								"tanggal"		=> date("Y-m-d"),
								"id_stok_obat"	=> $stok_row->id,
								"jumlah_masuk"	=> 0,
								"jumlah_keluar"	=> abs($selisih),
								"sisa"			=> $sisa_stok,
								"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan,
								"nama_user"		=> $user->getName()
							);
							$riwayat_stok_dbtable->insert($riwayat_data);
							$selisih = 0;
						} else {
							$jumlah_lama = $sisa_stok;
							$jumlah_baru = 0;
							$jumlah_keluar = $sisa_stok;
							$selisih = $selisih + $sisa_stok;
							$sisa_stok = 0;
							$stok_data = array(
								"sisa"	=> $sisa_stok
							);
							$stok_id = array(
								"id"	=> $stok_row->id
							);
							$this->dbtable->update($stok_data, $stok_id);

							$penyesuaian_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_penyesuaian_stok_obat");
							global $user;
							$penyesuaian_data = array(
								"id_stok_obat"  => $stok_row->id,
								"tanggal"		=> date("Y-m-d"),
								"jumlah_lama"	=> $jumlah_lama,
								"jumlah_baru"	=> $jumlah_baru,
								"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan . ".",
								"nama_user"		=> $user->getName()
							);
							$penyesuaian_dbtable->insert($penyesuaian_data);
							
							$riwayat_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_riwayat_stok_obat");
							$riwayat_data = array(
								"tanggal"		=> date("Y-m-d"),
								"id_stok_obat"	=> $stok_row->id,
								"jumlah_masuk"	=> 0,
								"jumlah_keluar"	=> $jumlah_keluar,
								"sisa"			=> $sisa_stok,
								"keterangan"	=> "Rekonsiliasi Stok : " . $keterangan,
								"nama_user"		=> $user->getName()
							);
							$riwayat_stok_dbtable->insert($riwayat_data);
						}
						if ($selisih == 0)
							break;
					}
					// $sisa_row = $this->dbtable->get_row("
					// 	SELECT SUM(a.sisa) AS 'sisa'
					// 	FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
					// 	WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_rows[0]->id_obat . "' AND a.satuan = '" . $stok_rows[0]->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
					// ");
					// $kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_ap_irja_kartu_stok_obat");
					// $kartu_stok_data = array(
					// 	"f_id"				=> 0,
					// 	"no_bon"			=> "-",
					// 	"unit"				=> "Rekonsiliasi Stok : " . $keterangan,
					// 	"id_obat"			=> $stok_rows[0]->id_obat,
					// 	"kode_obat"			=> $stok_rows[0]->kode_obat,
					// 	"nama_obat"			=> $stok_rows[0]->nama_obat,
					// 	"nama_jenis_obat"	=> $stok_rows[0]->nama_jenis_obat,
					// 	"tanggal"			=> date("Y-m-d"),
					// 	"masuk"				=> $info_selisih >= 0 ? $info_selisih : 0,
					// 	"keluar"			=> $info_selisih < 0 ? (-1) * $info_selisih : 0,
					// 	"sisa"				=> $sisa_row->sisa
					// );
					// $kartu_stok_dbtable->insert($kartu_stok_data);
				}
				$success['id'] = $id_obat;
				$success['success'] = 1;
				$success['data'] = $stok_row;
				return $success;
			}
			public function edit() {
				$id = $_POST['id'];
				$row = $this->dbtable->get_row("
					SELECT a.id_obat AS 'id', a.kode_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.sisa) AS 'jumlah', a.satuan
					FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
					WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status = 'sudah' AND a.konversi = '1' AND a.satuan = a.satuan_konversi AND a.id_obat = '" . $id . "'
				");
				$data = array(
					"header"	=> $row
				);
				return $data;
			}
		}
		$dbresponder = new RekonsiliasiStokObatDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("rekonsiliasi_stok_obat_add_form", "smis_form_container", "rekonsiliasi_stok_obat");
	$modal->setTitle("Rekonsiliasi Stok Obat");
	$id_obat_hidden = new Hidden("rekonsiliasi_stok_obat_id_obat", "rekonsiliasi_stok_obat_id_obat", "");
	$modal->addElement("", $id_obat_hidden);
	$kode_text = new Text("rekonsiliasi_stok_obat_kode_obat", "rekonsiliasi_stok_obat_kode_obat", "");
	$kode_text->setAtribute("disabled='disabled'");
	$modal->addElement("Kode Obat", $kode_text);
	$nama_text = new Text("rekonsiliasi_stok_obat_nama_obat", "rekonsiliasi_stok_obat_nama_obat", "");
	$nama_text->setAtribute("disabled='disabled'");
	$modal->addElement("Nama Obat", $nama_text);
	$jenis_text = new Text("rekonsiliasi_stok_obat_jenis_obat", "rekonsiliasi_stok_obat_jenis_obat", "");
	$jenis_text->setAtribute("disabled='disabled'");
	$modal->addElement("Jenis Obat", $jenis_text);
	$sisa_text = new Text("rekonsiliasi_stok_obat_sisa", "rekonsiliasi_stok_obat_sisa", "");
	$sisa_text->setAtribute("disabled='disabled'");
	$modal->addElement("Jml. Sekarang", $sisa_text);
	$tanggal_lalu_text = new Text("rekonsiliasi_stok_obat_tanggal", "rekonsiliasi_stok_obat_tanggal", "");
	$tanggal_lalu_text->setClass("mydate");
	$tanggal_lalu_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$modal->addElement("Tgl. Telusur", $tanggal_lalu_text);
	$stok_lalu_text = new Text("rekonsiliasi_stok_obat_stok_lalu", "rekonsiliasi_stok_obat_stok_lalu", "");
	$stok_lalu_text->setClass("smis-one-option-input");
	$stok_lalu_text->setAtribute("disabled='disabled'");
	$stok_lalu_button = new Button("", "", "Reload");
	$stok_lalu_button->setClass("btn-inverse");
	$stok_lalu_button->setIcon("fa fa-refresh");
	$stok_lalu_button->setIsButton(Button::$ICONIC);
	$stok_lalu_button->setAction("rekonsiliasi_stok_obat.updateStokTelusur()");
	$stok_lalu_input_group = new InputGroup("");
	$stok_lalu_input_group->addComponent($stok_lalu_text);
	$stok_lalu_input_group->addComponent($stok_lalu_button);
	$modal->addElement("Stok Telusur", $stok_lalu_input_group);
	$jumlah_lalu_text = new Text("rekonsiliasi_stok_obat_jumlah_lalu", "rekonsiliasi_stok_obat_jumlah_lalu", "");
	$modal->addElement("Jml. Telusur", $jumlah_lalu_text);
	$selisih_text = new Text("rekonsiliasi_stok_obat_selisih", "rekonsiliasi_stok_obat_selisih", "");
	$selisih_text->setAtribute("disabled='disabled'");
	$modal->addElement("Selisih", $selisih_text);
	$jumlah_hidden = new Hidden("rekonsiliasi_stok_obat_jumlah", "rekonsiliasi_stok_obat_jumlah", "");
	$modal->addElement("", $jumlah_hidden);
	$satuan_text = new Text("rekonsiliasi_stok_obat_satuan", "rekonsiliasi_stok_obat_satuan", "");
	$satuan_text->setAtribute("disabled='disabled'");
	$modal->addElement("Satuan", $satuan_text);
	$keterangan_textarea = new TextArea("rekonsiliasi_stok_obat_keterangan", "rekonsiliasi_stok_obat_keterangan", "");
	$keterangan_textarea->setLine("2");
	$modal->addElement("Keterangan", $keterangan_textarea);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$save_button->setAction("rekonsiliasi_stok_obat.save()");
	$modal->addFooter($save_button);

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function RekonsiliasiStokObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	RekonsiliasiStokObatAction.prototype.constructor = RekonsiliasiStokObatAction;
	RekonsiliasiStokObatAction.prototype = new TableAction();
	RekonsiliasiStokObatAction.prototype.getSaveData = function() {
		var data = TableAction.prototype.getSaveData.call(this);
		data['id_obat'] = $("#rekonsiliasi_stok_obat_id_obat").val();
		data['sisa'] = $("#rekonsiliasi_stok_obat_sisa").val();
		data['jumlah'] = $("#rekonsiliasi_stok_obat_jumlah").val();
		data['satuan'] = $("#rekonsiliasi_stok_obat_satuan").val();
		data['keterangan'] = $("#rekonsiliasi_stok_obat_keterangan").val();
		return data;
	};
	RekonsiliasiStokObatAction.prototype.edit = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				$("#rekonsiliasi_stok_obat_id_obat").val(id);
				$("#rekonsiliasi_stok_obat_kode_obat").val(json.header.kode_obat);
				$("#rekonsiliasi_stok_obat_nama_obat").val(json.header.nama_obat);
				$("#rekonsiliasi_stok_obat_jenis_obat").val(json.header.nama_jenis_obat);
				$("#rekonsiliasi_stok_obat_sisa").val(json.header.jumlah);
				$("#rekonsiliasi_stok_obat_tanggal").val("");
				$("#rekonsiliasi_stok_obat_stok_lalu").val("");
				$("#rekonsiliasi_stok_obat_jumlah_lalu").val("");
				$("#rekonsiliasi_stok_obat_jumlah").val(json.header.jumlah);
				$("#rekonsiliasi_stok_obat_satuan").val(json.header.satuan);
				$("#rekonsiliasi_stok_obat_keterangan").val("");
				$("#rekonsiliasi_stok_obat_add_form").smodal("show");
			}
		);
	};
	RekonsiliasiStokObatAction.prototype.updateStokTelusur = function() {
		if ($("#rekonsiliasi_stok_obat_tanggal").val() == "") {
			$("#rekonsiliasi_stok_obat_stok_lalu").val("0");
			return;
		}
		var data = this.getRegulerData();
		data['command'] = "get_stock_by_date";
		data['tanggal_pilihan'] = $("#rekonsiliasi_stok_obat_tanggal").val();
		data['id_obat'] = $("#rekonsiliasi_stok_obat_id_obat").val();
		data['satuan'] = $("#rekonsiliasi_stok_obat_satuan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#rekonsiliasi_stok_obat_stok_lalu").val(json.saldo_akhir);
			}
		);
	};

	var rekonsiliasi_stok_obat;
	$(document).ready(function() {
		$(".mydate").datepicker();
		rekonsiliasi_stok_obat = new RekonsiliasiStokObatAction(
			"rekonsiliasi_stok_obat",
			"apotek",
			"rekonsiliasi_stok_obat",
			new Array("")
		);
		rekonsiliasi_stok_obat.view();
		$("#rekonsiliasi_stok_obat_jumlah_lalu").on("keyup", function() {
			var stok_sekarang = $("#rekonsiliasi_stok_obat_sisa").val();
			var stok_lalu = $("#rekonsiliasi_stok_obat_stok_lalu").val();
			var jumlah_lalu = $("#rekonsiliasi_stok_obat_jumlah_lalu").val();
			var selisih = parseFloat(jumlah_lalu) - parseFloat(stok_lalu);
			var rekonsiliasi = parseFloat(stok_sekarang) + parseFloat(selisih);
			$("#rekonsiliasi_stok_obat_selisih").val(selisih);
			$("#rekonsiliasi_stok_obat_jumlah").val(rekonsiliasi);
			var keterangan = "Stock Opname tanggal " + $("#rekonsiliasi_stok_obat_tanggal").val() + " selisih " + parseFloat(selisih).formatMoney("0", ".", ",");
			$("#rekonsiliasi_stok_obat_keterangan").val(keterangan);
		});
	});
</script>