<?php 
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("apotek/table/PenjualanResepTable.php");
	require_once("apotek/adapter/PenjualanResepLuarAdapter.php");
	require_once("apotek/adapter/ObatAdapter.php");
	require_once("apotek/adapter/BahanAdapter.php");
	require_once("apotek/responder/PenjualanResepLuarDBResponder.php");
	require_once("apotek/responder/DokterServiceResponder.php");
	require_once("apotek/responder/ObatDBResponder.php");
	require_once("apotek/responder/ApotekerServiceResponder.php");
	require_once("apotek/responder/BahanDBResponder.php");
	require_once("apotek/responder/SisaDBResponder.php");
	require_once("apotek/table/DResepTable.php");
	require_once("apotek/table/DObatRacikanTable.php");
	require_once("apotek/table/BahanRacikanTable.php");
	
	$resep_table = new PenjualanResepTable(
		array("No. Penjualan", "No. Resep", "Tanggal/Jam", "Dokter", "Pasien", "Alamat", "Kat. Pasien", "Jns. Pasien", "Edukasi"),
		"Apotek : Penjualan Obat - Resep (Non-KIUP)",
		null,
		true
	);
	$resep_table->setName("resep");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == "resep") {
		if (isset($_POST['command'])) {
			$resep_adapter = new PenjualanResepLuarAdapter();
			$columns = array("id", "nomor_resep", "tanggal", "nama_dokter", "nama_pasien", "alamat_pasien", "uri", "jenis", "markup", "embalase", "tusla", "biaya_racik", "total", "edukasi", "dibatalkan", "diskon", "t_diskon", "keterangan_batal");
			$resep_dbtable = new DBTable(
				$db,
				"smis_ap_irja_penjualan_resep",
				$columns
			);
			$resep_dbtable->addCustomKriteria(" tipe ", " ='resep_luar' ");
			$resep_dbtable->setOrder(" id DESC ");
			$resep_dbresponder = new PenjualanResepLuarDBResponder(
				$resep_dbtable,
				$resep_table,
				$resep_adapter
			);
			$data = $resep_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		return;
	}
	
	//dokter service consumer:
	$dokter_table = new Table(
		array("Nama", "Jabatan"),
		"",
		null,
		true
	);
	$dokter_table->setName("dokter");
	$dokter_table->setModel(Table::$SELECT);
	$dokter_adapter = new SimpleAdapter();
	$dokter_adapter->add("Nama", "nama");
	$dokter_adapter->add("Jabatan", "nama_jabatan");
	$dokter_service_responder = new DokterServiceResponder(
		$db, 
		$dokter_table, 
		$dokter_adapter,
		"employee"
	);
	
	//get obat chooser:
	$obat_table = new Table(array("Kode", "Obat", "Jenis", "Stok"));
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatAdapter();
	$obat_dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
	$obat_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT v_stok.*, v_harga.hna, v_harga.markup
		FROM (
			SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
			FROM (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
			) v_obat
			GROUP BY id_obat
		) v_stok LEFT JOIN (
			SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
			WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
			GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
		) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT v_stok.*, v_harga.hna, v_harga.markup
			FROM (
				SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
				FROM (
					SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
					FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
					WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
					GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
				) v_obat
				GROUP BY id_obat
			) v_stok LEFT JOIN (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
		) v_obat
	";
	$obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$obat_dbresponder = new ObatDBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);
	
	//get sisa, hna, dan markup by id obat, satuan, konversi, satuan_konversi:
	$sisa_table = new Table(array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi"));
	$sisa_table->setName("sisa");
	$sisa_adapter = new SimpleAdapter();
	$sisa_adapter->add("id_obat", "id_obat");
	$sisa_adapter->add("sisa", "sisa");
	$sisa_adapter->add("satuan", "satuan");
	$sisa_adapter->add("konversi", "konversi");
	$sisa_adapter->add("satuan_konversi", "satuan_konversi");
	$columns = array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi");
	$sisa_dbtable = new DBTable(
		$db,
		"smis_ap_irja_stok_obat",
		$columns
	);
	$sisa_dbresponder = new SisaDBResponder(
		$sisa_dbtable,
		$sisa_table,
		$sisa_adapter
	);
	
	//apoteker service consumer:
	$apoteker_table = new Table(array("NIP", "Nama", "Jabatan"));
	$apoteker_table->setName("apoteker");
	$apoteker_table->setModel(Table::$SELECT);
	$apoteker_adapter = new SimpleAdapter();
	$apoteker_adapter->add("NIP", "nip");
	$apoteker_adapter->add("Nama", "nama");
	$apoteker_adapter->add("Jabatan", "nama_jabatan");
	$apoteker_service_responder = new ApotekerServiceResponder(
		$db,
		$apoteker_table,
		$apoteker_adapter,
		"employee"
	);
	
	//bahan chooser:
	$bahan_table = new Table(array("Kode", "Bahan", "Jenis", "Stok"));
	$bahan_table->setName("bahan");
	$bahan_table->setModel(Table::$SELECT);
	$bahan_adapter = new BahanAdapter();
	$bahan_dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
	$bahan_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT v_stok.*, v_harga.hna, v_harga.markup
		FROM (
			SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
			FROM (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
			) v_obat
			GROUP BY id_obat
		) v_stok LEFT JOIN (
			SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
			WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
			GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
		) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT v_stok.*, v_harga.hna, v_harga.markup
			FROM (
				SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
				FROM (
					SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
					FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
					WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
					GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
				) v_obat
				GROUP BY id_obat
			) v_stok LEFT JOIN (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
		) v_obat
	";
	$bahan_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$bahan_dbresponder = new BahanDBResponder(
		$bahan_dbtable,
		$bahan_table,
		$bahan_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("dokter", $dokter_service_responder);
	$super_command->addResponder("obat", $obat_dbresponder);
	$super_command->addResponder("sisa", $sisa_dbresponder);
	$super_command->addResponder("apoteker", $apoteker_service_responder);
	$super_command->addResponder("bahan", $bahan_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$resep_modal = new Modal("resep_add_form", "smis_form_container", "resep");
	$resep_modal->setTitle("Data Penjualan Resep Luar");
	$resep_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("resep_id", "resep_id", "");
	$resep_modal->addElement("", $id_hidden);
	$noresep_text = new Text("resep_nomor", "resep_nomor", "");
	$noresep_text->addAtribute("autofocus");
	$resep_modal->addElement("Nomor", $noresep_text);
	$pasien_text = new Text("resep_nama_pasien", "resep_nama_pasien", "");
	$resep_modal->addElement("Pasien", $pasien_text);
	$alamat_text = new Text("resep_alamat_pasien", "resep_alamat_pasien", "");
	$resep_modal->addElement("Alamat Pasien", $alamat_text);
	$uri_hidden = new Hidden("resep_uri", "resep_uri", "0");
	$resep_modal->addElement("", $uri_hidden);
	$jenis_text = new Text("resep_jenis", "resep_jenis", "umum");
	$jenis_text->setAtribute("disabled='disabled'");
	$resep_modal->addElement("Jns. Pasien", $jenis_text);
	$markup_hidden = new Hidden("resep_markup", "resep_markup", "0.25");
	$resep_modal->addElement("", $markup_hidden);
	$id_dokter_hidden = new Hidden("resep_id_dokter", "resep_id_dokter", "");
	$resep_modal->addElement("", $id_dokter_hidden);
	$nama_dokter_hidden = new Hidden("resep_name_dokter", "resep_name_dokter", "");
	$resep_modal->addElement("", $nama_dokter_hidden);
	$dokter_button = new Button("", "", "Pilih");
	$dokter_button->setClass("btn-info");
	$dokter_button->setIsButton(Button::$ICONIC);
	$dokter_button->setIcon("icon-white ".Button::$icon_list_alt);
	$dokter_button->setAction("dokter.chooser('dokter', 'dokter_button', 'dokter', dokter)");
	$dokter_button->setAtribute("id='dokter_browse'");
	$dokter_text = new Text("resep_nama_dokter", "resep_nama_dokter", "");
	$dokter_text->setClass("smis-one-option-input");
	$dokter_input_group = new InputGroup("");
	$dokter_input_group->addComponent($dokter_text);
	$dokter_input_group->addComponent($dokter_button);
	$resep_modal->addElement("Dokter", $dokter_input_group);
	$diskon_text = new Text("resep_diskon", "resep_diskon", "0,00");
	$diskon_text->setTypical("money");
	$diskon_text->setAtribute(" data-thousands=\".\" data-decimal=\",\"  data-precision=\"2\"  " );
	$resep_modal->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	$t_diskon_option->add("Persen (%)", "persen", "1");
	$t_diskon_option->add("Nominal (Rp)", "nominal");
	$t_diskon_option->add("Paket Tindakan (100 %)", "gratis");
	$t_diskon_select = new Select("resep_t_diskon", "resep_t_diskon", $t_diskon_option->getContent());
	$resep_modal->addElement("Tipe Diskon", $t_diskon_select);
	$total_text = new Text("resep_total", "resep_total", "");
	$total_text->setTypical("money");
	$total_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$resep_modal->addElement("Total", $total_text);
	$dresep_table = new DResepTable(array("No.", "Nama", "Jumlah", "Harga", "Embalase", "Tuslah", "Biaya Racik", "Subtotal", "Aturan Pakai", "Apoteker"));
	$dresep_table->setName("dresep");
	$dresep_table->setFooterVisible(false);
	$resep_modal->addBody("dresep_table", $dresep_table);
	$resep_button = new Button("", "", "Simpan");
	$resep_button->setClass("btn-success");
	$resep_button->setIcon("fa fa-floppy-o");
	$resep_button->setIsButton(Button::$ICONIC);
	$resep_button->setAtribute("id='resep_save'");
	$resep_modal->addFooter($resep_button);
	$resep_button = new Button("", "", "OK");
	$resep_button->setClass("btn-success");
	$resep_button->setAtribute("id='resep_ok'");
	$resep_button->setAction("$($(this).data('target')).smodal('hide')");
	$resep_modal->addFooter($resep_button);
	$tombol='<a href="#" class="input btn btn-info" ><i class="icon-white icon-list-alt"></i></a>';
	$resep_modal->addHTML("
		<div class='alert alert-block alert-inverse' id='help_resep'>
			<h4>Tips</h4>
			<ul>
				<li>Tombol <kbd>Tab</kbd> : Berpindah Cepat ke Isian Berikutnya (dari Kiri ke Kanan)</li>
				<li>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " pada Isian Dokter / Tombol <kbd>F8</kbd> : Menentukan Nama Dokter</li>
				<li>Tombol <kbd>&uarr;</kbd> / <kbd>&darr;</kbd> : Memilih <strong>Persen (%) / Nominal (Rp) / Paket Tindakan (100 %)</strong> pada Isian <strong>Tipe Diskon</strong></li>
				<li>Tombol <kbd>F3</kbd> : Tombol Cepat Menambahkan Obat Jadi Baru</li>
				<li>Tombol <kbd>F4</kbd> : Tombol Cepat Menambahkan Obat Racikan Baru</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Cepat Menyimpan Data Resep, Pastikan Semua Obat/Racikan dan Informasi Kepala Resep Sudah Lengkap.</li>
			<ul>
		</div>
	", "after");
				
	//obat jadi modal:
	$obat_jadi_modal = new Modal("obat_jadi_add_form", "smis_form_container", "obat_jadi");
	$obat_jadi_modal->setTitle("Data Obat Jadi");
	$embalase_hidden = new Hidden("obat_jadi_embalase", "obat_jadi_embalase", "");
	$obat_jadi_modal->addElement("", $embalase_hidden);
	$tuslah_hidden = new Hidden("obat_jadi_tuslah", "obat_jadi_tuslah", "");
	$obat_jadi_modal->addElement("", $tuslah_hidden);
	$id_hidden = new Hidden("obat_jadi_id", "obat_jadi_id", "");
	$obat_jadi_modal->addElement("", $id_hidden);
	$id_obat_hidden = new Hidden("obat_jadi_id_obat", "obat_jadi_id_obat", "");
	$obat_jadi_modal->addElement("", $id_obat_hidden);
	$obat_button = new Button("", "", "Pilih");
	$obat_button->setClass("btn-info");
	$obat_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat)");
	$obat_button->setIcon("icon-white icon-list-alt");
	$obat_button->setIsButton(Button::$ICONIC);
	$obat_button->setAtribute("id='obat_jadi_browse'");
	$nama_obat_text = new Text("obat_jadi_nama_obat", "obat_jadi_nama_obat", "");
	$nama_obat_text->setClass("smis-one-option-input");
	$nama_obat_text->addAtribute("autofocus");
	$nama_obat_input_group = new InputGroup("");
	$nama_obat_input_group->addComponent($nama_obat_text);
	$nama_obat_input_group->addComponent($obat_button);
	$obat_jadi_modal->addElement("Obat", $nama_obat_input_group);
	$kode_obat_hidden = new Hidden("obat_jadi_kode_obat", "obat_jadi_kode_obat", "");
	$obat_jadi_modal->addElement("", $kode_obat_hidden);
	$name_obat_hidden = new Hidden("obat_jadi_name_obat", "obat_jadi_name_obat", "");
	$obat_jadi_modal->addElement("", $name_obat_hidden);
	$nama_jenis_obat_hidden = new Hidden("obat_jadi_nama_jenis_obat", "obat_jadi_nama_jenis_obat", "");
	$obat_jadi_modal->addElement("", $nama_jenis_obat_hidden);
	$satuan_select = new Select("obat_jadi_satuan", "obat_jadi_satuan", "");
	$obat_jadi_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("obat_jadi_konversi", "obat_jadi_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("obat_jadi_satuan_konversi", "obat_jadi_satuan_konversi", "");
	$obat_jadi_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("obat_jadi_stok", "obat_jadi_stok", "");
	$obat_jadi_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("obat_jadi_f_stok", "obat_jadi_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("obat_jadi_jumlah_lama", "obat_jadi_jumlah_lama", "");
	$obat_jadi_modal->addElement("", $jumlah_lama_hidden);
	$hna_text = new Text("obat_jadi_hna", "obat_jadi_hna", "");
	$hna_text->setTypical("money");
	$hna_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$obat_jadi_modal->addElement("HNA + PPn", $hna_text);
	$jumlah_text = new Text("obat_jadi_jumlah", "obat_jadi_jumlah", "");
	$obat_jadi_modal->addElement("Jumlah", $jumlah_text);
	$aturan_pakai_text = new Text("obat_jadi_aturan_pakai", "obat_jadi_aturan_pakai", "");
	$obat_jadi_modal->addElement("Aturan Pakai", $aturan_pakai_text);
	$obat_jadi_button = new Button("", "", "Simpan");
	$obat_jadi_button->setClass("btn-success");
	$obat_jadi_button->setAtribute("id='obat_jadi_save'");
	$obat_jadi_button->setIcon("fa fa-floppy-o");
	$obat_jadi_button->setIsButton(Button::$ICONIC);
	$obat_jadi_modal->addFooter($obat_jadi_button);
	$obat_jadi_modal->addHTML("
		<div class='alert alert-block alert-inverse'>
			<h4>Tips</h4>
			<ul>
				<li><small>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F2</kbd> : Menentukan Nama Obat</small></li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Resep</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Menyimpan Bahan</li>
			</ul>
		</div>
	", "before");
	
	//obat racikan modal:
	$obat_racikan_modal = new Modal("obat_racikan_add_form", "smis_form_container", "obat_racikan");
	$obat_racikan_modal->setTitle("Data Obat Racikan");
	$obat_racikan_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("obat_racikan_id", "obat_racikan_id", "");
	$obat_racikan_modal->addElement("", $id_hidden);
	$nama_text = new Text("obat_racikan_nama", "obat_racikan_nama", "");
	$nama_text->addAtribute("autofocus");
	$obat_racikan_modal->addElement("Nama Racikan", $nama_text);
	$id_apoteker_hidden = new Hidden("obat_racikan_id_apoteker", "obat_racikan_id_apoteker", "");
	$obat_racikan_modal->addElement("", $id_apoteker_hidden);
	$nama_apoteker_hidden = new Hidden("obat_racikan_name_apoteker", "obat_racikan_name_apoteker", "");
	$obat_racikan_modal->addElement("", $nama_apoteker_hidden);
	$apoteker_button = new Button("", "", "Pilih");
	$apoteker_button->setClass("btn-info");
	$apoteker_button->setIsButton(Button::$ICONIC);
	$apoteker_button->setIcon("icon-white ".Button::$icon_list_alt);
	$apoteker_button->setAction("apoteker.chooser('apoteker', 'apoteker_button', 'apoteker', apoteker)");
	$apoteker_button->setAtribute("id='apoteker_browse'");
	$apoteker_text = new Text("obat_racikan_nama_apoteker", "obat_racikan_nama_apoteker", "");
	$apoteker_text->setClass("smis-one-option-input");
	$apoteker_input_group = new InputGroup("");
	$apoteker_input_group->addComponent($apoteker_text);
	$apoteker_input_group->addComponent($apoteker_button);
	$obat_racikan_modal->addElement("Apoteker", $apoteker_input_group);
	$aturan_pakai_text = new Text("obat_racikan_aturan_pakai", "obat_racikan_aturan_pakai", "");
	$obat_racikan_modal->addElement("Aturan Pakai", $aturan_pakai_text);
	$biaya_racik_text = new Text("obat_racikan_biaya_racik", "obat_racikan_biaya_racik", "");
	$biaya_racik_text->setAtribute("disabled='disabled'");
	$obat_racikan_modal->addElement("Biaya Racik", $biaya_racik_text);
	$dracikan_table = new DObatRacikanTable(
		array("Bahan", "Harga", "Jumlah", "Embalase", "Tuslah", "Subtotal")
	);
	$dracikan_table->setName("dracikan");
	$dracikan_table->setFooterVisible(false);
	$obat_racikan_modal->addBody("dracikan_table", $dracikan_table);
	$obat_racikan_button = new Button("", "", "Simpan");
	$obat_racikan_button->setClass("btn-success");
	$obat_racikan_button->setIcon("fa fa-floppy-o");
	$obat_racikan_button->setIsButton(Button::$ICONIC);
	$obat_racikan_button->setAtribute("id='racikan_save'");
	$obat_racikan_modal->addFooter($obat_racikan_button);
	$obat_racikan_button = new Button("", "", "OK");
	$obat_racikan_button->setClass("btn-success");
	$obat_racikan_button->setAtribute("id='racikan_ok'");
	$obat_racikan_button->setAction("$($(this).data('target')).smodal('hide')");
	$obat_racikan_modal->addFooter($obat_racikan_button);
	$obat_racikan_modal->addHTML("
		<div class='alert alert-block alert-inverse' id='help_racikan'>
			<h4>Tips</h4>
			<ul>
				<li>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F7</kbd> : Menentukan Nama Apoteker</li>
				<li>Tombol <kbd>F2</kbd> : Tombol Cepat Menambahkan Bahan Baru dari Obat Racikan</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Cepat Menyimpan Obat Racikan</li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Resep</li>
			</ul>
		</div>
	", "after");
	
	//bahan modal:
	$bahan_modal = new Modal("bahan_add_form", "smis_form_container", "bahan");
	$bahan_modal->setTitle("Data Bahan");
	$id_hidden = new Hidden("bahan_id", "bahan_id", "");
	$bahan_modal->addElement("", $id_hidden);
	$id_bahan_hidden = new Hidden("bahan_id_bahan", "bahan_id_bahan", "");
	$bahan_modal->addElement("", $id_bahan_hidden);
	$bahan_button = new Button("", "", "Pilih");
	$bahan_button->setClass("btn-info");
	$bahan_button->setAction("bahan.chooser('bahan', 'bahan_button', 'bahan', bahan)");
	$bahan_button->setIcon("icon-white icon-list-alt");
	$bahan_button->setIsButton(Button::$ICONIC);
	$bahan_button->setAtribute("id='bahan_browse'");
	$nama_bahan_text = new Text("bahan_nama_bahan", "bahan_nama_bahan", "");
	$nama_bahan_text->addAtribute("autofocus");
	$nama_bahan_text->setClass("smis-one-option-input");
	$nama_bahan_input_group = new InputGroup("");
	$nama_bahan_input_group->addComponent($nama_bahan_text);
	$nama_bahan_input_group->addComponent($bahan_button);
	$bahan_modal->addElement("Bahan", $nama_bahan_input_group);
	$kode_bahan_hidden = new Hidden("bahan_kode_bahan", "bahan_kode_bahan", "");
	$bahan_modal->addElement("", $kode_bahan_hidden);
	$name_bahan_hidden = new Hidden("bahan_name_bahan", "bahan_name_bahan", "");
	$bahan_modal->addElement("", $name_bahan_hidden);
	$nama_jenis_bahan_hidden = new Hidden("bahan_nama_jenis_bahan", "bahan_nama_jenis_bahan", "");
	$bahan_modal->addElement("", $nama_jenis_bahan_hidden);
	$satuan_select = new Select("bahan_satuan", "bahan_satuan", "");
	$bahan_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("bahan_konversi", "bahan_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$bahan_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("bahan_satuan_konversi", "bahan_satuan_konversi", "");
	$bahan_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("bahan_stok", "bahan_stok", "");
	$bahan_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("bahan_f_stok", "bahan_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$bahan_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("bahan_jumlah_lama", "bahan_jumlah_lama", "");
	$bahan_modal->addElement("", $jumlah_lama_hidden);
	$hna_text = new Text("bahan_hna", "bahan_hna", "");
	$hna_text->setTypical("money");
	$hna_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$bahan_modal->addElement("HNA + PPn", $hna_text);
	$embalase_hidden = new Hidden("bahan_embalase", "bahan_embalase", "");
	$bahan_modal->addElement("", $embalase_hidden);
	$tuslah_hidden = new Hidden("bahan_tuslah", "bahan_tuslah", "");
	$bahan_modal->addElement("", $tuslah_hidden);
	$jumlah_text = new Text("bahan_jumlah", "bahan_jumlah", "");
	$bahan_modal->addElement("Jumlah", $jumlah_text);
	$bahan_button = new Button("", "", "Simpan");
	$bahan_button->setClass("btn-success");
	$bahan_button->setIcon("fa fa-floppy-o");
	$bahan_button->setIsButton(Button::$ICONIC);
	$bahan_button->setAtribute("id='bahan_save'");
	$bahan_modal->addFooter($bahan_button);
	$bahan_modal->addHTML("
		<div class='alert alert-block alert-inverse'>
			<h4>Tips</h4>
			<ul>
				<li><small>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / <kbd>F2</kbd> : Menentukan Nama Bahan</small></li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Obat Racikan</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Menyimpan Bahan</li>
			</ul>
		</div>
	","before");
	
	//invi-table bahan racikan:
	$bahan_racikan_table = new BahanRacikanTable(array("ID", "IDO", "Nama", "Jumlah", "Satuan", "Konversi", "Satuan Konversi", "Harga", "Label"));
	$bahan_racikan_table->setAction(false);
	$bahan_racikan_table->setName("bahan_racikan");
	
	echo "<div class='alert alert-block alert-inverse'>" .
			 "<h4>Tips</h4>" .
			 "Tombol <kbd>F2</kbd> : Menampilkan Formulir Penjualan Resep Baru" .
		 "</div>";
	echo $bahan_modal->getHtml();
	echo $obat_racikan_modal->getHtml();
	echo $obat_jadi_modal->getHtml();
	echo $resep_modal->getHtml();
	echo $resep_table->getHtml();
	echo $bahan_racikan_table->getHtml();
	
	echo addCSS("apotek/css/penjualan_resep.css", false);
	echo addJS("smis-base-js/smis-base-shortcut.js", false);
	echo addJS("apotek/js/penjualan_resep_luar_action.js", false);
	echo addJS("apotek/js/dpenjualan_resep_action.js", false);
	echo addJS("apotek/js/obat_action.js", false);
	echo addJS("apotek/js/apoteker_action.js", false);
	echo addJS("apotek/js/bahan_action.js", false);
	echo addJS("apotek/js/dokter_action.js", false);
	echo addJS("apotek/js/penjualan_resep_luar.js", false);
	echo addJS("framework/smis/js/table_action.js");
?>