<?php
	global $db;
	require_once("apotek/table/PenjualanBebasTable.php");
	require_once("apotek/adapter/PenjualanBebasAdapter.php");
	require_once("apotek/adapter/ObatAdapter.php");
	require_once("apotek/responder/PenjualanBebasDBResponder.php");
	require_once("smis-libs-class/Locker.php");
	require_once("apotek/locker/PenjualanResepLocker.php");
	require_once("apotek/responder/ObatDBResponder.php");
	require_once("apotek/responder/SisaDBResponder.php");
	require_once("apotek/table/DPenjualanBebasTable.php");
	
	$penjualan_bebas_table = new PenjualanBebasTable(
		array("No. Penjualan", "No. Resep", "Tanggal/Jam"),
		"Apotek : Penjualan Umum Bebas"
	);
	$penjualan_bebas_table->setName("penjualan_bebas");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == "penjualan_bebas") {
		if (isset($_POST['command'])) {
			$penjualan_bebas_adapter = new PenjualanBebasAdapter();
			$columns = array("id", "tanggal", "nomor_resep", "markup", "total", "dibatalkan", "diskon", "t_diskon", "keterangan_batal");
			$penjualan_bebas_dbtable = new DBTable(
				$db,
				"smis_ap_irja_penjualan_resep",
				$columns
			);
			$penjualan_bebas_dbtable->addCustomKriteria(" tipe ", " ='bebas' ");
			$penjualan_bebas_dbtable->setOrder(" id DESC ");				
			$penjualan_bebas_dbresponder = new PenjualanBebasDBResponder(
				$penjualan_bebas_dbtable,
				$penjualan_bebas_table,
				$penjualan_bebas_adapter
			);
			$data = $penjualan_bebas_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		return;
	}
	
	//get obat chooser:
	$obat_table = new Table(array("Kode", "Obat", "Jenis", "Stok"));
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatAdapter();
	$obat_dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
	$obat_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT v_stok.*, v_harga.hna, v_harga.markup
		FROM (
			SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
			FROM (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
			) v_obat
			GROUP BY id_obat
		) v_stok LEFT JOIN (
			SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
			WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
			GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
		) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT v_stok.*, v_harga.hna, v_harga.markup
			FROM (
				SELECT id_obat AS 'id', kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok', satuan, konversi, satuan_konversi
				FROM (
					SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, CASE smis_ap_irja_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
					FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
					WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
					GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.label
				) v_obat
				GROUP BY id_obat
			) v_stok LEFT JOIN (
				SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.kode_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat,  MAX(smis_ap_irja_stok_obat.hna) AS 'hna', '0' AS 'markup', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah' " . $filter . "
				GROUP BY smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi
			) v_harga ON v_stok.id = v_harga.id_obat AND v_stok.satuan = v_harga.satuan AND v_stok.konversi = v_harga.konversi AND v_stok.satuan_konversi = v_harga.satuan_konversi
		) v_obat
	";
	$obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$obat_dbresponder = new ObatDBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);
	
	//get sisa, hna, dan markup by id obat, satuan, konversi, satuan_konversi:
	$sisa_table = new Table(array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi"));
	$sisa_table->setName("sisa");
	$sisa_adapter = new SimpleAdapter();
	$sisa_adapter->add("id_obat", "id_obat");
	$sisa_adapter->add("sisa", "sisa");
	$sisa_adapter->add("satuan", "satuan");
	$sisa_adapter->add("konversi", "konversi");
	$sisa_adapter->add("satuan_konversi", "satuan_konversi");
	$columns = array("id_obat", "sisa", "satuan", "konversi", "satuan_konversi");
	$sisa_dbtable = new DBTable(
		$db,
		"smis_ap_irja_stok_obat",
		$columns
	);
	$sisa_dbresponder = new SisaDBResponder(
		$sisa_dbtable,
		$sisa_table,
		$sisa_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("obat", $obat_dbresponder);
	$super_command->addResponder("sisa", $sisa_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$penjualan_bebas_modal = new Modal("penjualan_bebas_add_form", "smis_form_container", "penjualan_bebas");
	$penjualan_bebas_modal->setTitle("Data Penjualan Umum Bebas");
	$penjualan_bebas_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("penjualan_bebas_id", "penjualan_bebas_id", "");
	$penjualan_bebas_modal->addElement("", $id_hidden);
	$nomor_text = new Text("penjualan_bebas_nomor", "penjualan_bebas_nomor", "");
	$nomor_text->addAtribute("autofocus");
	$penjualan_bebas_modal->addElement("Nomor", $nomor_text);
	$markup_hidden = new Hidden("penjualan_bebas_markup", "penjualan_bebas_markup", "");
	$penjualan_bebas_modal->addElement("", $markup_hidden);
	$diskon_text = new Text("penjualan_bebas_diskon", "penjualan_bebas_diskon", "0,00");
	$diskon_text->setTypical("money");
	$diskon_text->setAtribute(" data-thousands=\".\" data-decimal=\",\"  data-precision=\"2\" " );
	$penjualan_bebas_modal->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	$t_diskon_option->add("Persen (%)", "persen", "1");
	$t_diskon_option->add("Nominal (Rp)", "nominal");
	$t_diskon_option->add("Gratis (100 %)", "gratis");
	$t_diskon_select = new Select("penjualan_bebas_t_diskon", "penjualan_bebas_t_diskon", $t_diskon_option->getContent());
	$penjualan_bebas_modal->addElement("Tipe Diskon", $t_diskon_select);
	$total_text = new Text("penjualan_bebas_total", "penjualan_bebas_total", "");
	$total_text->setTypical("money");
	$total_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$penjualan_bebas_modal->addElement("Total", $total_text);
	$dpenjualan_bebas_table = new DPenjualanBebasTable(array("No.", "Nama", "Jumlah", "Harga", "Embalase", "Tuslah", "Subtotal", "Apoteker"));
	$dpenjualan_bebas_table->setName("dpenjualan_bebas");
	$dpenjualan_bebas_table->setFooterVisible(false);
	$penjualan_bebas_modal->addBody("dpenjualan_bebas_table", $dpenjualan_bebas_table);
	$penjualan_bebas_button = new Button("", "", "Simpan");
	$penjualan_bebas_button->setClass("btn-success");
	$penjualan_bebas_button->setIcon("fa fa-floppy-o");
	$penjualan_bebas_button->setIsButton(Button::$ICONIC);
	$penjualan_bebas_button->setAtribute("id='penjualan_bebas_save'");
	$penjualan_bebas_modal->addFooter($penjualan_bebas_button);
	$penjualan_bebas_button = new Button("", "", "OK");
	$penjualan_bebas_button->setClass("btn-success");
	$penjualan_bebas_button->setAtribute("id='penjualan_bebas_ok'");
	$penjualan_bebas_button->setAction("$($(this).data('target')).smodal('hide')");
	$penjualan_bebas_modal->addFooter($penjualan_bebas_button);
	$tombol='<a href="#" class="input btn btn-info" ><i class="icon-white icon-list-alt"></i></a>';
	$penjualan_bebas_modal->addHTML("
		<div class='alert alert-block alert-inverse' id='help_bebas'>
			<h4>Tips</h4>
			<ul>
				<li>Tombol <kbd>Tab</kbd> : Berpindah Cepat ke Isian Berikutnya (dari Kiri ke Kanan)</li>
				<li>Tombol <kbd>&uarr;</kbd> / <kbd>&darr;</kbd> : Memilih <strong>Persen (%) / Nominal (Rp) / Gratis (100 %)</strong> pada Isian <strong>Tipe Diskon</strong></li>
				<li>Tombol <kbd>F3</kbd> : Tombol Cepat Menambahkan Obat Jadi Baru</li>
				<li>Tombol <kbd>F6</kbd> : Tombol Cepat Menyimpan Data Penjualan Bebas, Pastikan Semua Obat/Racikan dan Informasi Kepala Transaksi Sudah Lengkap.</li>
			<ul>
		</div>
	", "after");
	
	//obat jadi modal:
	$obat_jadi_modal = new Modal("obat_jadi_add_form", "smis_form_container", "obat_jadi");
	$obat_jadi_modal->setTitle("Data Obat Jadi");
	$embalase_hidden = new Hidden("obat_jadi_embalase", "obat_jadi_embalase", "");
	$obat_jadi_modal->addElement("", $embalase_hidden);
	$tuslah_hidden = new Hidden("obat_jadi_tuslah", "obat_jadi_tuslah", "");
	$obat_jadi_modal->addElement("", $tuslah_hidden);
	$id_hidden = new Hidden("obat_jadi_id", "obat_jadi_id", "");
	$obat_jadi_modal->addElement("", $id_hidden);
	$id_obat_hidden = new Hidden("obat_jadi_id_obat", "obat_jadi_id_obat", "");
	$obat_jadi_modal->addElement("", $id_obat_hidden);
	$obat_button = new Button("", "", "Pilih");
	$obat_button->setClass("btn-info");
	$obat_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat)");
	$obat_button->setIcon("icon-white icon-list-alt");
	$obat_button->setIsButton(Button::$ICONIC);
	$obat_button->setAtribute("id='obat_jadi_browse'");
	$nama_obat_text = new Text("obat_jadi_nama_obat", "obat_jadi_nama_obat", "");
	$nama_obat_text->setClass("smis-one-option-input");
	$nama_obat_text->addAtribute("autofocus");
	$nama_obat_input_group = new InputGroup("");
	$nama_obat_input_group->addComponent($nama_obat_text);
	$nama_obat_input_group->addComponent($obat_button);
	$obat_jadi_modal->addElement("Obat", $nama_obat_input_group);
	$kode_obat_hidden = new Hidden("obat_jadi_kode_obat", "obat_jadi_kode_obat", "");
	$obat_jadi_modal->addElement("", $kode_obat_hidden);
	$name_obat_hidden = new Hidden("obat_jadi_name_obat", "obat_jadi_name_obat", "");
	$obat_jadi_modal->addElement("", $name_obat_hidden);
	$nama_jenis_obat_hidden = new Hidden("obat_jadi_nama_jenis_obat", "obat_jadi_nama_jenis_obat", "");
	$obat_jadi_modal->addElement("", $nama_jenis_obat_hidden);
	$satuan_select = new Select("obat_jadi_satuan", "obat_jadi_satuan", "");
	$obat_jadi_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("obat_jadi_konversi", "obat_jadi_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("obat_jadi_satuan_konversi", "obat_jadi_satuan_konversi", "");
	$obat_jadi_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("obat_jadi_stok", "obat_jadi_stok", "");
	$obat_jadi_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("obat_jadi_f_stok", "obat_jadi_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$obat_jadi_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("obat_jadi_jumlah_lama", "obat_jadi_jumlah_lama", "");
	$obat_jadi_modal->addElement("", $jumlah_lama_hidden);
	$hna_text = new Text("obat_jadi_hna", "obat_jadi_hna", "");
	$hna_text->setTypical("money");
	$hna_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"  disabled='disabled'" );
	$obat_jadi_modal->addElement("HNA + PPn", $hna_text);
	$jumlah_text = new Text("obat_jadi_jumlah", "obat_jadi_jumlah", "");
	$obat_jadi_modal->addElement("Jumlah", $jumlah_text);
	$obat_jadi_button = new Button("", "", "Simpan");
	$obat_jadi_button->setClass("btn-success");
	$obat_jadi_button->setAtribute("id='obat_jadi_save'");
	$obat_jadi_button->setIcon("fa fa-floppy-o");
	$obat_jadi_button->setIsButton(Button::$ICONIC);
	$obat_jadi_modal->addFooter($obat_jadi_button);
	$obat_jadi_modal->addHTML("
		<div class='alert alert-block alert-inverse'>
			<h4>Tips</h4>
			<ul>
				<li><small>Ketik Min. <strong>3 Karakter</strong> / Tombol " . $tombol . " / Tombol <kbd>F2</kbd> : Menentukan Nama Obat</small></li>
				<li>Tombol <kbd>Esc</kbd> : Tombol Cepat Kembali ke Formulir Penjualan Bebas</li>
			</ul>
		</div>
	", "before");
	
	echo "<div class='alert alert-block alert-inverse'>" .
			 "<h4>Tips</h4>" .
			 "Kombinasi Tombol <kbd>F2</kbd> : Menampilkan Formulir Penjualan Bebas Baru" .
		 "</div>";
	echo $obat_jadi_modal->getHtml();
	echo $penjualan_bebas_modal->getHtml();
	echo $penjualan_bebas_table->getHtml();
	
	echo addCSS("apotek/css/penjualan_bebas.css",false);
	echo addJS("apotek/js/penjualan_bebas_action.js",false);
	echo addJS("apotek/js/dpenjualan_bebas_action.js",false);
	echo addJS("apotek/js/obat_action.js",false);
	echo addJS("apotek/js/penjualan_bebas.js",false);
	echo addJS("smis-base-js/smis-base-shortcut.js",false);
	echo addJS("framework/smis/js/table_action.js");
?>