<?php
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$table = new Table(
		array("No.", "Slug", "Jenis Pasien", "Margin Jual"),
		"Apotek : Margin Penjualan Obat Per Jenis Pasien",
		null,
		true
	);
	$table->setName("margin_jual_per_jenis_pasien");

	if (isset($_POST['command'])) {
		$dbtable = new DBTable($db, "smis_ap_irja_margin_jenis_pasien");
		if ($_POST['command'] == "check_exist") {
			$slug = $_POST['slug'];
			$row = $dbtable->get_row("
				SELECT COUNT(*) AS 'jumlah' 
				FROM smis_ap_irja_margin_jenis_pasien
				WHERE slug = '" . $slug . "'
			");
			$is_exist = "0";
			if ($row != null)
				if ($row->jumlah > 0)
					$is_exist = "1";
			$data = array(
				"is_exist"	=> $is_exist
			);
			echo json_encode($data);
			return;
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("Slug", "slug");
		$adapter->add("Jenis Pasien", "nama");
		$adapter->add("Margin Jual", "margin");
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("margin_jual_per_jenis_pasien_add_form", "smis_form_container", "margin_jual_per_jenis_pasien");
	$modal->setTitle("Data Margin Jual - Jenis Pasien");
	$id_hidden = new Hidden("margin_jual_per_jenis_pasien_id", "margin_jual_per_jenis_pasien_id", "");
	$modal->addElement("", $id_hidden);
	$consumer_service = new ServiceConsumer(
		$db, 
		"get_jenis_patient",
		null,
		"registration" 
	);
	$content = $consumer_service->execute()->getContent();
	$jenis_pasien_option = new OptionBuilder();
	foreach($content as $c){
		$jenis_pasien_option->add($c['name'], $c['value']);
	}
	$jenis_pasien_select = new Select("margin_jual_per_jenis_pasien_slug", "margin_jual_per_jenis_pasien_slug", $jenis_pasien_option->getContent());
	$modal->addElement("Jns. Pasien", $jenis_pasien_select);
	$margin_text = new Text("margin_jual_per_jenis_pasien_margin", "margin_jual_per_jenis_pasien_margin", "");
	$modal->addElement("Margin Jual", $margin_text);
	$button = new Button("", "", "Simpan");
	$button->setClass("btn-success");
	$button->setIcon("fa fa-floppy-o");
	$button->setIsButton(Button::$ICONIC);
	$button->setAction("margin_jual_per_jenis_pasien.save()");
	$modal->addFooter($button);	

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function MarginJualPerJenisPasienAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	MarginJualPerJenisPasienAction.prototype.constructor = MarginJualPerJenisPasienAction;
	MarginJualPerJenisPasienAction.prototype = new TableAction();
	MarginJualPerJenisPasienAction.prototype.getSaveData = function() {
		var data = TableAction.prototype.getSaveData.call(this);
		data['id'] = $("#margin_jual_per_jenis_pasien_id").val();
		data['slug'] = $("#margin_jual_per_jenis_pasien_slug").val();
		data['nama'] = $("#margin_jual_per_jenis_pasien_slug option:selected").text();
		data['margin'] = $("#margin_jual_per_jenis_pasien_margin").val();
		return data;
	};
	MarginJualPerJenisPasienAction.prototype.cekSave = function() {
		var valid = true;
		var message = "";
		var cdata = this.getRegulerData();
		cdata['command'] = "check_exist";
		cdata['slug'] = $("#margin_jual_per_jenis_pasien_slug").val();
		$(".error_field").removeAttr("error_field");
		$.ajax({
			url		: "",
			type	: "POST",
			async	: false,
			data 	: cdata,
			success : function (response) {
				var id = $("#margin_jual_per_jenis_pasien_id").val();
				if (id == "" || id == 0) {
					var json = JSON.parse(response);
					if (json == null) {
						message += "Pengecekan eksistensi jenis pasien gagal<br/>";
						valid = "false";
					} else if (json.is_exist == "1") {
						message += "Pengaturan <b>Jenis Pasien</b> tersebut sudah ada<br/>";
						$("#margin_jual_per_jenis_pasien_slug").focus();
						valid = false;
					}
				}
				var margin = $("#margin_jual_per_jenis_pasien_margin").val();
				if (margin == "") {
					message += "<b>Margin</b> tidak boleh kosong<br/>";
					$("#margin_jual_per_jenis_pasien_margin").focus();
					valid = false;	
				}
				if (!valid) {
					$("#modal_alert_margin_jual_per_jenis_pasien_add_form").html("<div class='alert alert-block alert-info'><h4>Pemberitahuan</h4>" + message + "</div>");
				}
			}
		});
		return valid;
	};

	var margin_jual_per_jenis_pasien;
	$(document).ready(function() {
		margin_jual_per_jenis_pasien = new MarginJualPerJenisPasienAction(
			"margin_jual_per_jenis_pasien",
			"apotek",
			"margin_jual_per_jenis_pasien",
			new Array("id", "slug", "nama", "margin")
		);
		margin_jual_per_jenis_pasien.view();
	});
</script>