<?php 
	global $db;
	
	$laporan_form = new Form("lrpt_form", "", "Apotek : Laporan Retur Penjualan Resep Per Rentang Waktu");
	$tanggal_from_text = new Text("lrpt_tanggal_from", "lrpt_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrpt_tanggal_to", "lrpt_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrpt.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lrpt.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lrpt_table = new Table(
		array("Dokter", "No. Resep", "Obat", "Jenis Obat", "Jumlah", "Satuan", "H. Jual Satuan", "Diskon (%)", "Pot. Retur (%)", "H. Retur Satuan", "Pot. Bonus"),
		"",
		null,
		true
	);
	$lrpt_table->setName("lrpt");
	$lrpt_table->setAction(false);
	
	if (isset($_POST['command'])) {
		class LRPTAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Dokter'] = $row->nama_dokter;
				$array['No. Resep'] = $row->nomor_resep;
				$array['Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$hja_satuan = $row->harga - ($row->diskon_persen * $row->harga / 100);
				$array['H. Jual Satuan'] = self::format("money Rp. ", $hja_satuan);
				$array['Diskon (%)'] = self::format("money", $row->diskon_persen);
				$array['Pot. Retur (%)'] = self::format("money", 100 - $row->persentase_retur);
				$harga_retur_satuan = $hja_satuan * $row->persentase_retur / 100;
				$array['H. Retur Satuan'] = self::format("money Rp. ", $harga_retur_satuan);
				$potongan_bonus = 0;
				if ($row->nama_jenis_obat == "TABLET" || $row->nama_jenis_obat == "INJEKSI") {
					$dasar_potongan_bonus_per_obat = 0.7 * ((($hja_satuan * $row->jumlah) / (100 + $row->markup * 100) * 100) / 110 * 100);
					$potongan_bonus = (-1) * round(75 * $dasar_potongan_bonus_per_obat / 1000);
				}
				$array['Pot. Bonus'] = self::format("money Rp. ", $potongan_bonus);
				return $array;
			}
		}
		$lrpt_adapter = new LRPTAdapter();		
		$lrpt_dbtable = new DBTable($db, "smis_ap_irja_retur_penjualan_resep");
		if (isset($_POST['command']) == "list") {
			$filter = "AND smis_ap_irja_retur_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_retur_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "'";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (smis_ap_irja_penjualan_resep.nama_dokter LIKE '%" . $_POST['kriteria'] . "%' OR smis_ap_irja_penjualan_resep.nomor_resep LIKE '%" . $_POST['kriteria'] . "%' OR smis_ap_irja_stok_obat.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR smis_ap_irja_stok_obat.nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR smis_ap_irja_stok_obat.satuan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nomor_resep, IF (
						smis_ap_irja_penjualan_resep.t_diskon = 'nominal',
						smis_ap_irja_penjualan_resep.diskon * 100 / (smis_ap_irja_penjualan_resep.total + smis_ap_irja_penjualan_resep.diskon),
						smis_ap_irja_penjualan_resep.diskon
					) AS diskon_persen, smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_dretur_penjualan_resep.harga, smis_ap_irja_retur_penjualan_resep.persentase_retur
					FROM ((smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_dretur_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id = smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_dretur_penjualan_resep.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_retur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.tipe = 'resep' " . $filter . "
					ORDER BY smis_ap_irja_penjualan_resep.nama_dokter, CONVERT(SUBSTRING_INDEX(smis_ap_irja_penjualan_resep.nomor_resep,'.',-1),UNSIGNED INTEGER), smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan
				) v_laporan
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					SELECT smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nomor_resep, IF (
						smis_ap_irja_penjualan_resep.t_diskon = 'nominal',
						smis_ap_irja_penjualan_resep.diskon * 100 / (smis_ap_irja_penjualan_resep.total + smis_ap_irja_penjualan_resep.diskon),
						smis_ap_irja_penjualan_resep.diskon
					) AS diskon_persen, smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_dretur_penjualan_resep.harga, smis_ap_irja_retur_penjualan_resep.persentase_retur
					FROM ((smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_dretur_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id = smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_dretur_penjualan_resep.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_retur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.tipe = 'resep' " . $filter . "
					ORDER BY smis_ap_irja_penjualan_resep.nama_dokter, CONVERT(SUBSTRING_INDEX(smis_ap_irja_penjualan_resep.nomor_resep,'.',-1),UNSIGNED INTEGER), smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan
				) v_laporan
			";
			$lrpt_dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		class LRPTDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nomor_resep, IF (
							smis_ap_irja_penjualan_resep.t_diskon = 'nominal',
							smis_ap_irja_penjualan_resep.diskon * 100 / (smis_ap_irja_penjualan_resep.total + smis_ap_irja_penjualan_resep.diskon),
							smis_ap_irja_penjualan_resep.diskon
						) AS diskon_persen, smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_dretur_penjualan_resep.harga, smis_ap_irja_retur_penjualan_resep.persentase_retur
						FROM ((smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_dretur_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id = smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_dretur_penjualan_resep.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_retur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.tipe = 'resep' AND smis_ap_irja_retur_penjualan_resep.tanggal >= '" . $from . "' AND smis_ap_irja_retur_penjualan_resep.tanggal <= '" . $to . "'
						ORDER BY smis_ap_irja_penjualan_resep.nama_dokter, CONVERT(SUBSTRING_INDEX(smis_ap_irja_penjualan_resep.nomor_resep,'.',-1),UNSIGNED INTEGER), smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_dretur_penjualan_resep.jumlah, smis_ap_irja_stok_obat.satuan
					) v_laporan
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN RETUR PENJUALAN RESEP PER RENTANG WAKTU Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Dokter</th>
										<th>No. Resep</th>
										<th>Obat</th>
										<th>Jenis Obat</th>
										<th>Jumlah</th>
										<th>H. Jual Satuan</th>
										<th>Diskon (%)</th>
										<th>Pot. Retur (%)</th>
										<th>H. Retur Satuan</th>
										<th>Subtotal H. Retur</th>
										<th>Pot. Bonus<sup>*</sup></th>
									</tr>";
				$total_pb = 0;
				$total_h_retur = 0;
				$no = 1;
				$is_nomdisc_exist = false;
				if (count($data) > 0) {
					foreach($data as $d) {
						$nama_dokter = $d->nama_dokter;
						$no_resep = $d->nomor_resep;
						$nama_obat = $d->nama_obat;
						$jenis_obat = $d->nama_jenis_obat;
						$jumlah = $d->jumlah . " " . $d->satuan;
						$f_diskon = ArrayAdapter::format("money", $d->diskon_persen);
						$hja_satuan = $d->harga - ($d->harga * $d->diskon_persen / 100);
						$f_hja_satuan = ArrayAdapter::format("money Rp. ", $hja_satuan);
						$f_potongan_retur = ArrayAdapter::format("money", 100 - $d->persentase_retur);
						$harga_retur_satuan = $hja_satuan * $d->persentase_retur / 100;
						$f_harga_retur_satuan = ArrayAdapter::format("money Rp. ", $harga_retur_satuan);
						$subtotal_harga_retur = ArrayAdapter::format("money Rp. ", $harga_retur_satuan * $d->jumlah);
						$potongan_bonus = 0;
						if ($d->nama_jenis_obat == "TABLET" || $d->nama_jenis_obat == "INJEKSI") {
							$dasar_potongan_bonus_per_obat = 0.7 * ((($hja_satuan * $d->jumlah) / (100 + $d->markup * 100) * 100) / 110 * 100);
							$potongan_bonus = (-1) * round(75 * $dasar_potongan_bonus_per_obat / 1000);
						}
						$f_potongan_bonus = ArrayAdapter::format("money Rp. ", $potongan_bonus);
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $nama_dokter . "</td>
											<td>" . $no_resep . "</td>
											<td>" . $nama_obat . "</td>
											<td>" . $jenis_obat . "</td>
											<td>" . $jumlah . "</td>
											<td>" . $f_hja_satuan . "</td>
											<td>" . $f_diskon . "</td>
											<td>" . $f_potongan_retur . "</td>
											<td>" . $f_harga_retur_satuan . "</td>
											<td>" . $subtotal_harga_retur . "</td>
											<td>" . $f_potongan_bonus . "</td>
										</tr>";
						$total_pb += ($potongan_bonus);
						$total_h_retur += ($harga_retur_satuan * $d->jumlah);
					}
				} else {
					$print_data .= "<tr>
										<td colspan='12' align='center'><i>Tidak terdapat data retur penjualan</i></td>
									</tr>";
				}
				$print_data .= "<tr>
									<td colspan='10' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total_h_retur) . "</b></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total_pb) . "</b></td>
								</tr>";
				$print_data .= "</table>";
				if ($is_nomdisc_exist) {
					$print_data .= "<i>*) nilai asli diskon merupakan nominal (Rp.) dan telah dikonversi ke dalam persentase (%)</i></br>";
				}
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lrpt_dbresponder = new LRPTDBResponder(
			$lrpt_dbtable,
			$lrpt_table,
			$lrpt_adapter
		);
		$data = $lrpt_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lrpt_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LRPTAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPTAction.prototype.constructor = LRPTAction;
	LRPTAction.prototype = new TableAction();
	LRPTAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lrpt_tanggal_from").val();
		data['tanggal_to'] = $("#lrpt_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LRPTAction.prototype.print = function() {
		if ($("#lrpt_tanggal_from").val() == "" || $("#lrpt_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['from'] = $("#lrpt_tanggal_from").val();
		data['to'] = $("#lrpt_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	var lrpt;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		lrpt = new LRPTAction(
			"lrpt",
			"apotek",
			"laporan_retur_penjualan_resep_per_rentang_waktu",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>