<?php
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
	require_once ("apotek/responder/DokterServiceResponder.php");
	
	$laporan_form = new Form("lrpd_form", "", "Apotek : Laporan Resep Per Dokter");
	$id_dokter_hidden = new Hidden("lrpd_id_dokter", "lpod_id_dokter", "");
	$laporan_form->addElement("", $id_dokter_hidden);
	$dokter_button = new Button("", "", "Pilih");
	$dokter_button->setClass("btn-info");
	$dokter_button->setAction("dokter_lrpd.chooser('dokter_lrpd', 'dokter_lrpd_button', 'dokter_lrpd', dokter_lrpd)");
	$dokter_button->setIcon("icon-white icon-list-alt");
	$dokter_button->setIsButton(Button::$ICONIC);
	$dokter_button->setAtribute("id='dokter_lrpd_browse'");
	$dokter_text = new Text("lrpd_nama_dokter", "lrpd_nama_dokter", "");
	$dokter_text->setClass("smis-one-option-input");
	$dokter_text->setAtribute("disabled='disabled'");
	$dokter_input_group = new InputGroup("");
	$dokter_input_group->addComponent($dokter_text);
	$dokter_input_group->addComponent($dokter_button);
	$laporan_form->addElement("Dokter", $dokter_input_group);
	$tanggal_from_text = new Text("lrpd_tanggal_from", "lrpd_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrpd_tanggal_to", "lrpd_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$potongan_text = new Text("lrpd_potongan", "lrpd_potongan", "");
	$potongan_text->setTypical("money");
	$potongan_text->setAtribute(" data-thousands=\".\" data-decimal=\",\"  data-precision=\"2\"  " );
	$laporan_form->addElement("Potongan (%)", $potongan_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrpd.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lrpd.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lrpd_table = new Table(
		array("No.", "Tanggal/No. Resep", "Pasien", "Biaya Obat", "Potongan", "Biaya Obat - Potongan"),
		"",
		null,
		true
	);
	$lrpd_table->setName("lrpd");
	$lrpd_table->setAction(false);
	
	//dokter chooser:
	$dokter_lrpd_table = new Table(	array("NIP", "Nama", "Jabatan")	);
	$dokter_lrpd_table->setName("dokter_lrpd");
	$dokter_lrpd_table->setModel(Table::$SELECT);
	$dokter_lrpd_adapter = new SimpleAdapter();
	$dokter_lrpd_adapter->add("NIP", "nip");
	$dokter_lrpd_adapter->add("Nama", "nama");
	$dokter_lrpd_adapter->add("Jabatan", "nama_jabatan");
	$dokter_lrpd_service_responder = new DokterServiceResponder(
		$db, 
		$dokter_lrpd_table, 
		$dokter_lrpd_adapter,
		"employee"
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("dokter_lrpd", $dokter_lrpd_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		$lrpd_adapter = new SummaryAdapter(true, "No.");
		$lrpd_adapter->addFixValue("Pasien", "<strong>Total</strong>");
		$lrpd_adapter->addSummary("Biaya Obat", "biaya_obat", "money Rp. ");
		$lrpd_adapter->addSummary("Potongan", "potongan", "money Rp. ");
		$lrpd_adapter->addSummary("Biaya Obat - Potongan", "bop", "money Rp. ");
		$lrpd_adapter->add("Tanggal/No. Resep", "tanggal_no_resep");
		$lrpd_adapter->add("Pasien", "nama_pasien");
		$lrpd_adapter->add("Biaya Obat", "biaya_obat", "money Rp. ");
		$lrpd_adapter->add("Potongan", "potongan", "money Rp. ");
		$lrpd_adapter->add("Biaya Obat - Potongan", "bop", "money Rp. ");
		$lrpd_dbtable = new DBTable(
			$db,
			"smis_ap_irja_penjualan_resep"
		);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter .= " AND (nama_pasien LIKE '%" . $_POST['kriteria'] . "%')";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT CONCAT(tanggal, '/', nomor_resep) AS 'tanggal_no_resep', nama_pasien, total AS 'biaya_obat', total * " . $_POST['potongan'] . " / 100 AS 'potongan', total * (100 - " . $_POST['potongan'] . ") / 100 AS 'bop'
				FROM smis_ap_irja_penjualan_resep
				WHERE prop NOT LIKE 'del' AND dibatalkan = '0' AND tanggal >= '" . $_POST['tanggal_from'] ." 00:00' AND tanggal <= '" . $_POST['tanggal_to'] . " 23:59' AND id_dokter = '" . $_POST['id_dokter'] . "' " . $filter . "
			) v
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT CONCAT(tanggal, '/', nomor_resep) AS 'tanggal_no_resep', nama_pasien, total AS 'biaya_obat', total * " . $_POST['potongan'] . " / 100 AS 'potongan', total * (100 - " . $_POST['potongan'] . ") / 100 AS 'bop'
				FROM smis_ap_irja_penjualan_resep
				WHERE prop NOT LIKE 'del' AND dibatalkan = '0' AND tanggal >= '" . $_POST['tanggal_from'] ." 00:00' AND tanggal <= '" . $_POST['tanggal_to'] . " 23:59' AND id_dokter = '" . $_POST['id_dokter'] . "' " . $filter . "
			) v
		";
		$lrpd_dbtable->setPreferredQuery(true, $query_value, $query_count);
		class LaporanResepPerDokterDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan")
					return parent::command($command);
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['tanggal_from'];
				$to = $_POST['tanggal_to'];
				$potongan = $_POST['potongan'];
				$id_dokter = $_POST['id_dokter'];
				$nama_dokter = $_POST['nama_dokter'];
				$data = $this->dbtable->get_result("
					SELECT CONCAT(tanggal, '/', nomor_resep) AS 'tanggal_no_resep', nama_pasien, total AS 'biaya_obat', total * " . $potongan . " / 100 AS 'potongan', total * (100 - " . $potongan . ") / 100 AS 'bop'
					FROM smis_ap_irja_penjualan_resep
					WHERE prop NOT LIKE 'del' AND dibatalkan = '0' AND tanggal >= '" . $from ." 00:00' AND tanggal <= '" . $to . " 23:59' AND id_dokter = '" . $id_dokter . "'
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN RESEP PER DOKTER</strong></center><br/>";
				$print_data .= "<table border='0'>
									<tr>
										<td>Dokter</td>
										<td>:</td>
										<td>" . $nama_dokter . "</td>
									</tr>
									<tr>
										<td>Potongan</td>
										<td>:</td>
										<td>" . $potongan . " %</td>
									</tr>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from) . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to) . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>";
					$print_data .= "<tr>";
						$print_data .= "<th>No.</th>";
						$print_data .= "<th>Tanggal/No. Resep</th>";
						$print_data .= "<th>Pasien</th>";
						$print_data .= "<th>Biaya Obat</th>";
						$print_data .= "<th>Potongan</th>";
						$print_data .= "<th>Biaya Obat - Potongan</th>";
					$print_data .= "</tr>";
				$no = 1;
				$total_biaya_obat = 0;
				$total_potongan = 0;
				$total_bop = 0;
				if (count($data) > 0) {
					foreach($data as $d) {
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->tanggal_no_resep . "</td>
											<td>" . $d->nama_pasien . "</td>
											<td>" . ArrayAdapter::format("money Rp. ", $d->biaya_obat) . "</td>
											<td>" . ArrayAdapter::format("money Rp. ", $d->potongan) . "</td>
											<td>" . ArrayAdapter::format("money Rp. ", $d->bop) . "</td>
										</tr>";
						$total_biaya_obat += $d->biaya_obat;
						$total_potongan += $d->potongan;
						$total_bop += $d->bop;
					}
				} else {
					$print_data .= "<tr>
										<td colspan='6' align='center'><i>Tidak terdapat data</i></td>
									</tr>";
				}
					$print_data .= "<tr>";
						$print_data .= "<td colspan='3'><strong><center>T O T A L</center></strong></td>";
						$print_data .= "<td>" . ArrayAdapter::format("money Rp. ", $total_biaya_obat) . "</td>";
						$print_data .= "<td>" . ArrayAdapter::format("money Rp. ", $total_potongan) . "</td>";
						$print_data .= "<td>" . ArrayAdapter::format("money Rp. ", $total_bop) . "</td>";
					$print_data .= "</tr>";
				$print_data .= "</table>";
				return $print_data;
			}
		}
		$lrpd_dbresponder = new LaporanResepPerDokterDBResponder(
			$lrpd_dbtable,
			$lrpd_table,
			$lrpd_adapter
		);
		$data = $lrpd_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lrpd_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script>
	function LRPDAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPDAction.prototype.constructor = LRPDAction;
	LRPDAction.prototype = new TableAction();
	LRPDAction.prototype.getViewData = function() {
		var data = TableAction.prototype.getViewData.call(this);
		data['id_dokter'] = $("#lrpd_id_dokter").val();
		data['tanggal_from'] = $("#lrpd_tanggal_from").val();
		data['tanggal_to'] = $("#lrpd_tanggal_to").val();
		var potongan = $("#lrpd_potongan").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		data['potongan'] = potongan;
		return data;
	};
	LRPDAction.prototype.print = function() {
		if ($("#lrpd_tanggal_from").val() == "" || $("#lrpd_tanggal_to").val() == "" || $("#lrpd_id_dokter").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['id_dokter'] = $("#lrpd_id_dokter").val();
		data['nama_dokter'] = $("#lrpd_nama_dokter").val();
		var potongan = $("#lrpd_potongan").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		data['potongan'] = potongan;
		data['tanggal_from'] = $("#lrpd_tanggal_from").val();
		data['tanggal_to'] = $("#lrpd_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	function DokterLRPDAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DokterLRPDAction.prototype.constructor = DokterLRPDAction;
	DokterLRPDAction.prototype = new TableAction();
	DokterLRPDAction.prototype.selected = function(json) {
		$("#lrpd_id_dokter").val(json.id);
		$("#lrpd_nama_dokter").val(json.nama);
	};
	
	var lrpd;
	var dokter_lrpd;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$('.mydate').datepicker();
		dokter_lrpd = new DokterLRPDAction(
			"dokter_lrpd",
			"apotek",
			"laporan_resep_per_dokter",
			new Array()
		);
		dokter_lrpd.setSuperCommand("dokter_lrpd");
		var lrpd_columns = new Array("potongan");
		lrpd = new LRPDAction(
			"lrpd",
			"apotek",
			"laporan_resep_per_dokter",
			lrpd_columns
		);
	});
</script>