<?php
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");

	$form = new Form("", "", "Apotek : Laporan Rekap Penjualan Resep");
	$tanggal_from_text = new Text("rpr_tanggal_from", "rpr_tanggal_from", date("Y-m-d 00:00"));
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("rpr_tanggal_to", "rpr_tanggal_to", date("Y-m-d H:i"));
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Akhir", $tanggal_to_text);
	$consumer_service = new ServiceConsumer(
		$db, 
		"get_jenis_patient",
		null,
		"registration" 
	);
	$content = $consumer_service->execute()->getContent();
	$jenis_pasien_option = new OptionBuilder();
	$jenis_pasien_option->add("Semua", "%%", 1);
	foreach($content as $c){
		$jenis_pasien_option->add($c['name'], $c['value']);
	}
	$jenis_pasien_select = new Select("rpr_jenis_pasien", "rpr_jenis_pasien", $jenis_pasien_option->getContent());
	$form->addElement("Jenis Pasien", $jenis_pasien_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("rpr.view()");
	$download_button = new Button("", "", "Eksport XLS");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='rpr_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$form->addElement("", $btn_group);

	$table = new Table(
		array("No.", "No. Trans.", "No. Resep", "Tanggal/Jam", "Dokter", "No. Reg.", "No. RM", "Pasien", "Alamat", "Jenis", "IRNA/IRJA", "Unit", "Total (Rp.)"),
		"",
		null,
		true
	);
	$table->setName("rpr");
	$table->setAction(false);
	$table->setFooterVisible(false);

	if (isset($_POST['command'])) {
		$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		if ($_POST['command'] == "get_jumlah") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$row = $dbtable->get_row("
				SELECT COUNT(*) AS 'jumlah'
				FROM smis_ap_irja_penjualan_resep
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND dibatalkan = '0' AND prop NOT LIKE 'del' AND dibatalkan = '0' AND jenis LIKE '" . $jenis_pasien . "'
			");
			$data = array(
				"jumlah"	=> $row->jumlah
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$num = $_POST['num'];
			$row = $dbtable->get_row("
				SELECT *
				FROM smis_ap_irja_penjualan_resep
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND dibatalkan = '0' AND prop NOT LIKE 'del' AND dibatalkan = '0' AND jenis LIKE '" . $jenis_pasien . "'
				LIMIT " . $num . ", 1
			");
			$html = "";
			if ($row != null) {
				$uri = $row->uri == 1 ? "RAWAT INAP" : "RAWAT JALAN";
				$html = "
					<tr>
						<td id='rpr_nomor'></td>
						<td id='rpr_id'><small>" . ArrayAdapter::format("only-digit8", $row->id) . "</small></td>
						<td id='rpr_no_resep'><small>" . $row->nomor_resep . "</small></td>
						<td id='rpr_tanggal'><small>" . ArrayAdapter::format("date d-m-Y, H:i:s", $row->tanggal) . "</small></td>
						<td id='rpr_nama_dokter'><small>" . $row->nama_dokter . "</small></td>
						<td id='rpr_noreg_pasien'><small>" . ArrayAdapter::format("only-digit8", $row->noreg_pasien) . "</small></td>
						<td id='rpr_nrm_pasien'><small>" . ArrayAdapter::format("only-digit6", $row->nrm_pasien) . "</small></td>
						<td id='rpr_nama_pasien'><small>" . $row->nama_pasien . "</small></td>
						<td id='rpr_alamat_pasien'><small>" . $row->alamat_pasien . "</small></td>
						<td id='rpr_jenis'><small>" . ArrayAdapter::format("unslug", $row->jenis) . "</small></td>
						<td id='rpr_uri'><small>" . $uri . "</small></td>
						<td id='rpr_unit'><small>" . ArrayAdapter::format("unslug", $row->ruangan) . "</small></td>
						<td id='rpr_total' style='display: none;'>" . $row->total . "</td>
						<td id='rpr_f_total'><small><div align='right'>" . ArrayAdapter::format("only-money", $row->total) . "</div></small></td>
					</tr>
				";
			}
			$data = array(
				"nomor_transaksi"	=> ArrayAdapter::format("only-digit8", $row->id),
				"nomor_resep"		=> $row->nomor_resep,
				"nama_pasien"		=> $row->nama_pasien,
				"nama_dokter"		=> $row->nama_dokter,
				"html"				=> $html
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			ini_set("memory_limit", "256M");
			set_time_limit(0);
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("apotek/templates/template_rekap_penjualan_resep_1.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("REKAP PENJUALAN RESEP");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "APOTEK " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "PERIODE : " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_to));
			$data = json_decode($_POST['d_data']);
			$objWorksheet->getStyle("N9")->getNumberFormat()->setFormatCode("#,##0.00");
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, $_POST['num_rows'] - 2);
			$start_row_num = 7;
			$end_row_num = 7;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor_transaksi);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor_resep);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->tanggal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_dokter);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->noreg_pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nrm_pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->alamat_pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jenis);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->uri);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->unit);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->total);
				$objWorksheet->getStyle("N" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=A_REKAP_PENJUALAN_RESEP_DEPO_IRJA_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}
	$loading_bar = new LoadingBar("rpr_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("rpr.cancel()");
	$loading_modal = new Modal("rpr_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $form->getHtml();
	echo "<div id='table_content'>";
	echo $table->getHtml();
	echo "</div>";
	echo "<div id='rpr_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function RPRAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	RPRAction.prototype.constructor = RPRAction;
	RPRAction.prototype = new TableAction();
	RPRAction.prototype.getRegulerData = function() {
		var data = TableAction.prototype.getRegulerData.call(this);
		data['tanggal_from'] = $("#rpr_tanggal_from").val();
		data['tanggal_to'] = $("#rpr_tanggal_to").val();
		data['jenis_pasien'] = $("#rpr_jenis_pasien").val();
		return data;
	};
	RPRAction.prototype.view = function() {
		if ($("#rpr_tanggal_from").val() == "" || $("#rpr_tanggal_to").val() == "")
			return;
		var self = this;
		FINISHED = false;
		$("#rpr_info").empty();
		$("#table_rpr tfoot").remove();
		$("#rpr_list").empty();
		$("#rpr_loading_bar").sload("true", "Harap ditunggu...", 0);
		$("#rpr_loading_modal").smodal("show");
		var data = this.getRegulerData();
		data['command'] = "get_jumlah";
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				self.fillHtml(0, json.jumlah);
			}
		);
	};
	RPRAction.prototype.fillHtml = function(num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize();
			} else {
				$("#rpr_loading_modal").smodal("hide");
				$("#rpr_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#rpr_export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info";
		data['num'] = num;
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				console.log(json);
				$("tbody#rpr_list").append(
					json.html
				);
				$("#rpr_loading_bar").sload("true", json.nomor_transaksi + " - " + json.nomor_resep + " - " + json.nama_dokter + " - " + json.nama_pasien + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtml(num + 1, limit);
			}
		);
	};
	RPRAction.prototype.finalize = function() {
		var num_rows = $("tbody#rpr_list tr").length;
		var t_total = 0;
		for (var i = 0; i < num_rows; i++) {
			$("tbody#rpr_list tr:eq(" + i + ") td#rpr_nomor").html("<small>" + (i + 1) + "</small>");
			var total = parseFloat($("tbody#rpr_list tr:eq(" + i + ") td#rpr_total").text());
			t_total += total;
		}
		$("#table_rpr").append(
			"<tfoot>" +
				"<tr>" +
					"<td colspan='12'><small><strong><center>T O T A L</center></strong></small></td>" +
					"<td><small><div align='right'><strong>" + t_total.formatMoney("2", ".", ",") + "</strong></div></small></td>" +
				"</tr>" +
			"</tfoot>"
		);
		$("#rpr_loading_modal").smodal("hide");
		$("#rpr_info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#rpr_export_button").removeAttr("onclick");
		$("#rpr_export_button").attr("onclick", "rpr.export_xls()");
	};
	RPRAction.prototype.cancel = function() {
		FINISHED = true;
	};
	RPRAction.prototype.export_xls = function() {
		showLoading();
		var num_rows = $("#rpr_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_nomor").text();
			var nomor_transaksi = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_id").text();
			var nomor_resep = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_nomor_resep").text();
			var tanggal = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_tanggal").text();
			var nama_dokter = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_nama_dokter").text();
			var noreg_pasien = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_noreg_pasien").text();
			var nrm_pasien = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_nrm_pasien").text();
			var nama_pasien = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_nama_pasien").text();
			var alamat_pasien = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_alamat_pasien").text();
			var jenis = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_jenis").text();
			var uri = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_uri").text();
			var unit = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_unit").text();
			var total = $("tbody#rpr_list tr:eq(" + i + ") td#rpr_total").text();
			d_data[i] = {
				"nomor" 			: nomor,
				"nomor_transaksi"	: nomor_transaksi,
				"nomor_resep"		: nomor_resep,
				"tanggal"			: tanggal,
				"nama_dokter"		: nama_dokter,
				"noreg_pasien"		: noreg_pasien,
				"nrm_pasien"		: nrm_pasien,
				"nama_pasien"		: nama_pasien,
				"alamat_pasien"		: alamat_pasien,
				"jenis"				: jenis,
				"uri"				: uri,
				"unit"				: unit,
				"total"				: total
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#rpr_tanggal_from").val();
		data['tanggal_to'] = $("#rpr_tanggal_to").val();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		postForm(data);
		dismissLoading();
	};

	var rpr;
	var FINISHED;
	$(document).ready(function() {
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
		rpr = new RPRAction(
			"rpr",
			"apotek",
			"laporan_rekap_penjualan_resep",
			new Array()
		);
		$("#rpr_list").append(
			"<tr id='temp'>" +
				"<td colspan='13'><strong><small><center>DATA PENJUALAN RESEP BELUM DIPROSES</center></small></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>