<?php 
	global $db;
	
	$laporan_form = new Form("lprpo_form", "", "Apotek : Laporan Penjualan Resep Per Obat");
	$id_obat_hidden = new Hidden("lprpo_id_obat", "lprpo_id_obat", "");
	$laporan_form->addElement("", $id_obat_hidden);
	$obat_button = new Button("", "", "Pilih");
	$obat_button->setClass("btn-info");
	$obat_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat)");
	$obat_button->setIcon("icon-white icon-list-alt");
	$obat_button->setIsButton(Button::$ICONIC);
	$obat_button->setAtribute("id='obat_browse'");
	$obat_text = new Text("lprpo_nama_obat", "lprpo_nama_obat", "");
	$obat_text->setClass("smis-one-option-input");
	$obat_text->setAtribute("disabled='disabled'");
	$obat_input_group = new InputGroup("");
	$obat_input_group->addComponent($obat_text);
	$obat_input_group->addComponent($obat_button);
	$laporan_form->addElement("Nama Obat", $obat_input_group);
	$tanggal_from_text = new Text("lprpo_tanggal_from", "lprpo_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lprpo_tanggal_to", "lprpo_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lprpo.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lprpo.print()");
	$export_button = new Button("", "", "Eksport XLS");
	$export_button->setClass("btn-info");
	$export_button->setIcon("fa fa-download");
	$export_button->setIsButton(Button::$ICONIC);
	$export_button->setAction("lprpo.export_xls()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$btn_group->addButton($export_button);
	$laporan_form->addElement("", $btn_group);
	
	$lprpo_table = new Table(
		array("No.", "Tanggal/Jam", "No. Penjualan", "No. Resep", "Dokter", "Pasien", "Jumlah", "Satuan", "Harga Satuan", "Keterangan"),
		"",
		null,
		true
	);
	$lprpo_table->setName("lprpo");
	$lprpo_table->setAction(false);
	$lprpo_table->setFooterVisible(false);
	
	//chooser obat:
	$obat_table = new Table(
		array("ID Obat", "Nama Obat"),
		"",
		null,
		true
	);
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new SimpleAdapter();
	$obat_adapter->add("ID Obat", "id", "digit8");
	$obat_adapter->add("Nama Obat", "nama_obat");
	$obat_dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
	$obat_dbtable->setViewForSelect(true);
	$filter = "1";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (id_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT id_obat AS 'id', nama_obat
		FROM (
			SELECT DISTINCT id_obat, nama_obat
			FROM smis_ap_irja_stok_obat
			WHERE prop NOT LIKE 'del'
		) v_obat
		WHERE " . $filter . "
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_obat
	";
	$obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
	class ObatDBResponder extends DBResponder {
		public function edit() {
			$id = $_POST['id'];
			$row = $this->dbtable->get_row("
				SELECT DISTINCT id_obat, nama_obat
				FROM smis_ap_irja_stok_obat
				WHERE prop NOT LIKE 'del' AND id_obat = '" . $id . "'
			");
			$data['id'] = $row->id_obat;
			$data['nama_obat'] = $row->nama_obat;
			return $data;
		}
	}
	$obat_dbresponder = new ObatDBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("obat", $obat_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$id_obat = $_POST['id_obat'];
			$nama_obat = $_POST['nama_obat'];
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("apotek/templates/template_penjualan_resep_per_obat.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("PENJUALAN RESEP PER OBAT");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "APOTEK " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "OBAT : " . $nama_obat . " (" . $id_obat . ")");
			$objWorksheet->setCellValue("B4", "PERIODE : " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_to));
			$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
			$data = $dbtable->get_result("
				SELECT *
				FROM (
					SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga AS 'hja', smis_ap_irja_penjualan_obat_jadi.subtotal AS 'total_hja', 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM smis_ap_irja_penjualan_obat_jadi LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_penjualan_obat_jadi.id_obat = '" . $_POST['id_obat'] . "'
					UNION ALL
					SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga AS 'hja', smis_ap_irja_bahan_pakai_obat_racikan.harga * smis_ap_irja_bahan_pakai_obat_racikan.jumlah AS 'total_hja', CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM (smis_ap_irja_bahan_pakai_obat_racikan LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_bahan_pakai_obat_racikan.id_obat = '" . $_POST['id_obat'] . "'
				) v_lprpo
			");
			if (count($data) - 2 > 0)
				$objWorksheet->insertNewRowBefore(9, count($data) - 2);
			$start_row_num = 8;
			$end_row_num = 8;
			$row_num = $start_row_num;
			$nomor = 1;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $nomor++);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, ArrayAdapter::format("date d-m-Y H:i", $d->tanggal));
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor_resep);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_dokter);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_pasien);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->hja);
				$v_diskon = $d->diskon;
				if ($d->t_diskon == "nominal") {
					$v_diskon = ($d->diskon / $d->total) * 100;
					$v_diskon = round($v_diskon, 2);
				}
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $v_diskon);
				$harga_total = $d->total_hja - (($v_diskon / 100) * $d->total_hja);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $harga_total);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->keterangan);
				$objWorksheet->getStyle("H" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("I" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("J" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("K" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=PENJUALAN_RESEP_PER_OBAT_apotek_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		$lprpo_adapter = new SummaryAdapter(true, "No.");
		$lprpo_adapter->addSummary("Jumlah", "jumlah", "number");
		$lprpo_adapter->addFixValue("Pasien", "<strong>Total</strong>");
		$lprpo_adapter->add("Tanggal/Jam", "tanggal", "date d-m-Y, H:i");
		$lprpo_adapter->add("No. Penjualan", "id", "digit8");
		$lprpo_adapter->add("No. Resep", "nomor_resep");
		$lprpo_adapter->add("Dokter", "nama_dokter");
		$lprpo_adapter->add("Pasien", "nama_pasien");
		$lprpo_adapter->add("Jumlah", "jumlah", "number");
		$lprpo_adapter->add("Satuan", "satuan");
		$lprpo_adapter->add("Harga Satuan", "hja", "money Rp.");
		$lprpo_adapter->add("Keterangan", "keterangan");
		$lprpo_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		if (isset($_POST['command']) == "list") {
			$filter = "1";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (id LIKE '%" . $_POST['kriteria'] . "%' OR nomor_resep LIKE '%" . $_POST['kriteria'] . "%' OR nama_dokter LIKE '%" . $_POST['kriteria'] . "%' OR nama_pasien LIKE '%" . $_POST['kriteria'] . "%' OR keterangan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga AS 'hja', smis_ap_irja_penjualan_obat_jadi.subtotal AS 'total_hja', 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM smis_ap_irja_penjualan_obat_jadi LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_penjualan_obat_jadi.id_obat = '" . $_POST['id_obat'] . "'
					UNION ALL
					SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga AS 'hja', smis_ap_irja_bahan_pakai_obat_racikan.harga * smis_ap_irja_bahan_pakai_obat_racikan.jumlah AS 'total_hja', CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
					FROM (smis_ap_irja_bahan_pakai_obat_racikan LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_bahan_pakai_obat_racikan.id_obat = '" . $_POST['id_obat'] . "'
				) v_lprpo
				WHERE " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					" . $query_value . "
				) v_lprpo
			";
			$lprpo_dbtable->setPreferredQuery(true, $query_value, $query_count);
			$lprpo_dbtable->setShowAll(true);
		}
		class LPRPODBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['tanggal_from'];
				$to = $_POST['tanggal_to'];
				$id_obat = $_POST['id_obat'];
				$nama_obat = $_POST['nama_obat'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga AS 'hja', smis_ap_irja_penjualan_obat_jadi.subtotal AS 'total_hja', 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM smis_ap_irja_penjualan_obat_jadi LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_penjualan_obat_jadi.id_obat = '" . $_POST['id_obat'] . "'
						UNION ALL
						SELECT smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.nama_pasien, smis_ap_irja_penjualan_resep.noreg_pasien, smis_ap_irja_penjualan_resep.nrm_pasien, smis_ap_irja_penjualan_resep.alamat_pasien, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga AS 'hja', smis_ap_irja_bahan_pakai_obat_racikan.harga * smis_ap_irja_bahan_pakai_obat_racikan.jumlah AS 'total_hja', CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM (smis_ap_irja_bahan_pakai_obat_racikan LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['tanggal_to'] . "' AND smis_ap_irja_bahan_pakai_obat_racikan.id_obat = '" . $_POST['id_obat'] . "'
					) v_lprpo
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PENJUALAN RESEP PER OBAT</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Nama Obat</td>
										<td>:</td>
										<td>" . $nama_obat . "</td>
									</tr>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>Tgl./Jam</th>
										<th>No. Penj.</th>
										<th>No. Resep</th>
										<th>Dokter</th>
										<th>Pasien</th>
										<th>Jumlah</th>
										<th>Satuan</th>
										<th>Hrg. Satuan</th>
										<th>Disk. (%)</th>
										<th>Hrg. Total</th>
									</tr>";
				$total_h = 0;
				$total_j = 0;
				$is_nomdisc_exist = false;
				if (count($data) > 0) {
					foreach($data as $d) {
						$tanggal_part = explode(" ", $d->tanggal);
						$time_part = explode(":", $tanggal_part[1]);
						$f_diskon = ArrayAdapter::format("only-money", $d->diskon);
						$v_diskon = $d->diskon;
						if ($d->t_diskon == "nominal") {
							$v_diskon = ($d->diskon / $d->total) * 100;
							$v_diskon = round($v_diskon, 2);
							$f_diskon = ArrayAdapter::format("only-money", $v_diskon) . "<sup>*</sup>";
							$is_nomdisc_exist = true;
						}
						$harga_total = $d->total_hja - (($v_diskon / 100) * $d->total_hja);
						$print_data .= "<tr>
											<td>" . ArrayAdapter::format("date d M Y", $tanggal_part[0]) . ", " . $time_part[0] . ":" . $time_part[1] . "</td>
											<td>" . ArrayAdapter::format("digit8", $d->id) . "</td>
											<td>" . $d->nomor_resep . "</td>
											<td>" . $d->nama_dokter . "</td>
											<td>" . $d->nama_pasien . " (NRM: " . $d->nrm_pasien . ", No. Reg: " . $d->noreg_pasien . ")</td>
											<td>" . $d->jumlah . "</td>
											<td>" . $d->satuan . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $d->hja) . "</td>
											<td>" . $f_diskon . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $harga_total) . "</td>
										</tr>";
						$total_h += ($harga_total);
						$total_j += ($d->jumlah);
					}
				} else {
					$print_data .= "<tr>
										<td colspan='10' align='center'><i>Tidak terdapat data penjualan</i></td>
									</tr>";
				}
				$print_data .= "<tr>
									<td colspan='5' align='center'><b>T O T A L</b></td>
									<td><b>" . $total_j . "</b></td>
									<td></td>
									<td></td>
									<td></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total_h) . "</b></td>
								</tr>";
				$print_data .= "</table>";
				if ($is_nomdisc_exist) {
					$print_data .= "<i>*) nilai asli diskon merupakan nominal (Rp.) dan telah dikonversi ke dalam persentase (%)</i></br>";
				}
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lprpo_dbresponder = new LPRPODBResponder(
			$lprpo_dbtable,
			$lprpo_table,
			$lprpo_adapter
		);
		$data = $lprpo_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lprpo_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function ObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	ObatAction.prototype.constructor = ObatAction;
	ObatAction.prototype = new TableAction();
	ObatAction.prototype.selected = function(json) {
		$("#lprpo_id_obat").val(json.id);
		$("#lprpo_nama_obat").val(json.nama_obat);
	};
	
	function LPRPOAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPRPOAction.prototype.constructor = LPRPOAction;
	LPRPOAction.prototype = new TableAction();
	LPRPOAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lprpo_tanggal_from").val();
		data['tanggal_to'] = $("#lprpo_tanggal_to").val();
		data['id_obat'] = $("#lprpo_id_obat").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LPRPOAction.prototype.print = function() {
		if ($("#lprpo_tanggal_from").val() == "" || $("#lprpo_tanggal_to").val() == "" || $("#lprpo_id_obat").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['tanggal_from'] = $("#lprpo_tanggal_from").val();
		data['tanggal_to'] = $("#lprpo_tanggal_to").val();
		data['id_obat'] = $("#lprpo_id_obat").val();
		data['nama_obat'] = $("#lprpo_nama_obat").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	LPRPOAction.prototype.export_xls = function() {
		if ($("#lprpo_tanggal_from").val() == "" || $("#lprpo_tanggal_to").val() == "" || $("#lprpo_id_obat").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#lprpo_tanggal_from").val();
		data['tanggal_to'] = $("#lprpo_tanggal_to").val();
		data['id_obat'] = $("#lprpo_id_obat").val();
		data['nama_obat'] = $("#lprpo_nama_obat").val();
		postForm(data);
	};
	
	var obat;
	var lprpo;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		obat = new ObatAction(
			"obat",
			"apotek",
			"laporan_penjualan_resep_per_obat",
			new Array()
		);
		obat.setSuperCommand("obat");
		lprpo = new LPRPOAction(
			"lprpo",
			"apotek",
			"laporan_penjualan_resep_per_obat",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>