<?php 
	global $db;
	
	$laporan_form = new Form("lpt_form", "", "Apotek : Laporan Penjualan Per Rentang Waktu");
	$tanggal_from_text = new Text("lpt_tanggal_from", "lpt_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpt_tanggal_to", "lpt_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lpt.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lpt.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lpt_table = new Table(
		array("Obat", "Jenis Obat", "Jumlah", "Satuan", "Harga Satuan", "Disk. (%)", "Harga Total"),
		"",
		null,
		true
	);
	$lpt_table->setName("lpt");
	$lpt_table->setAction(false);
	
	if (isset($_POST['command'])) {
		class LPTAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$array['Harga Satuan'] = self::format("money Rp.", $row->harga);
				$f_diskon = self::format("only-money", $row->diskon);
				$v_diskon = $row->diskon;
				if ($row->t_diskon == "nominal") {
					$v_diskon = ($row->diskon / $row->total) * 100;
					$v_diskon = round($v_diskon, 2);
					$f_diskon = self::format("only-money", $v_diskon) . "<sup>*</sup>";
				}
				$array['Disk. (%)'] = $f_diskon;
				$harga_total = $row->jumlah * $row->harga - (($v_diskon / 100) * $row->jumlah * $row->harga);
				$array['Harga Total'] = self::format("money Rp.", $harga_total);
				return $array;
			}
		}
		$lpt_adapter = new LPTAdapter();		
		$lpt_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		if (isset($_POST['command']) == "list") {
			$filter = "tanggal >= '" . $_POST['tanggal_from'] . "' AND tanggal <= '" . $_POST['tanggal_to'] . "'";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%' OR keterangan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
					FROM (
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
						FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
						UNION ALL
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
						FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0
					) v_lpt
					WHERE " . $filter . "
					GROUP BY id_obat, satuan, harga, diskon, t_diskon
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
					FROM (
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
						FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
						UNION ALL
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
						FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0
					) v_lpt
					WHERE " . $filter . "
					GROUP BY id_obat, satuan, harga, diskon, t_diskon
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$lpt_dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		class LPTDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
						FROM (
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
							FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
							UNION ALL
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
							FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0
						) v_lpt
						WHERE tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
						GROUP BY id_obat, satuan, harga, diskon, t_diskon
						ORDER BY nama_obat, nama_jenis_obat ASC
					) v_laporan
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PENJUALAN PER RENTANG WAKTU Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Obat</th>
										<th>Jenis</th>
										<th>Jumlah</th>
										<th>Hrg. Satuan</th>
										<th>Disk. (%)</th>
										<th>Hrg. Total</th>
									</tr>";
				$total = 0;
				$no = 1;
				$is_nomdisc_exist = false;
				if (count($data) > 0) {
					foreach($data as $d) {
						$tanggal_part = explode(" ", $d->tanggal);
						$time_part = explode(":", $tanggal_part[1]);
						$f_diskon = ArrayAdapter::format("only-money", $d->diskon);
						$v_diskon = $d->diskon;
						if ($d->t_diskon == "nominal") {
							$v_diskon = ($d->diskon / $d->total) * 100;
							$v_diskon = round($v_diskon, 2);
							$f_diskon = ArrayAdapter::format("only-money", $v_diskon) . "<sup>*</sup>";
							$is_nomdisc_exist = true;
						}
						$harga_total = $d->jumlah * $d->harga - (($v_diskon / 100) * $d->jumlah * $d->harga);
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->nama_obat . "</td>
											<td>" . $d->nama_jenis_obat . "</td>
											<td>" . $d->jumlah . " " . $d->satuan . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $d->harga) . "</td>
											<td>" . $f_diskon . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $harga_total) . "</td>
										</tr>";
						$total += ($harga_total);
					}
				} else {
					$print_data .= "<tr>
										<td colspan='7' align='center'><i>Tidak terdapat data penjualan</i></td>
									</tr>";
				}
				$print_data .= "<tr>
									<td colspan='6' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total) . "</b></td>
								</tr>";
				$print_data .= "</table>";
				if ($is_nomdisc_exist) {
					$print_data .= "<i>*) nilai asli diskon merupakan nominal (Rp.) dan telah dikonversi ke dalam persentase (%)</i></br>";
				}
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lpt_dbresponder = new LPTDBResponder(
			$lpt_dbtable,
			$lpt_table,
			$lpt_adapter
		);
		$data = $lpt_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lpt_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LPTAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPTAction.prototype.constructor = LPTAction;
	LPTAction.prototype = new TableAction();
	LPTAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lpt_tanggal_from").val();
		data['tanggal_to'] = $("#lpt_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LPTAction.prototype.print = function() {
		if ($("#lpt_tanggal_from").val() == "" || $("#lpt_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['from'] = $("#lpt_tanggal_from").val();
		data['to'] = $("#lpt_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	var lpt;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		lpt = new LPTAction(
			"lpt",
			"apotek",
			"laporan_penjualan_per_rentang_waktu",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>