<?php 
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("apotek/responder/DokterServiceResponder.php");
	
	$laporan_form = new Form("lpodj_form", "", "Apotek : Laporan Penjualan Per Dokter - Jenis Obat");
	$id_dokter_hidden = new Hidden("lpodj_id_dokter", "lpodj_id_dokter", "");
	$laporan_form->addElement("", $id_dokter_hidden);
	$dokter_button = new Button("", "", "Pilih");
	$dokter_button->setClass("btn-info");
	$dokter_button->setAction("dokter_lpodj.chooser('dokter_lpodj', 'dokter_lpodj_button', 'dokter_lpodj', dokter_lpodj)");
	$dokter_button->setIcon("icon-white icon-list-alt");
	$dokter_button->setIsButton(Button::$ICONIC);
	$dokter_button->setAtribute("id='dokter_lpodj_browse'");
	$dokter_text = new Text("lpodj_nama_dokter", "lpodj_nama_dokter", "");
	$dokter_text->setClass("smis-one-option-input");
	$dokter_text->setAtribute("disabled='disabled'");
	$dokter_input_group = new InputGroup("");
	$dokter_input_group->addComponent($dokter_text);
	$dokter_input_group->addComponent($dokter_button);
	$laporan_form->addElement("Dokter", $dokter_input_group);
	$jenis_button = new Button("", "", "Pilih");
	$jenis_button->setClass("btn-info");
	$jenis_button->setAction("jenis.chooser('jenis', 'jenis_button', 'jenis', jenis)");
	$jenis_button->setIcon("icon-white icon-list-alt");
	$jenis_button->setIsButton(Button::$ICONIC);
	$jenis_button->setAtribute("id='jenis_browse'");
	$jenis_text = new Text("lpodj_jenis", "lpodj_jenis", "");
	$jenis_text->setClass("smis-one-option-input");
	$jenis_text->setAtribute("disabled='disabled'");
	$jenis_input_group = new InputGroup("");
	$jenis_input_group->addComponent($jenis_text);
	$jenis_input_group->addComponent($jenis_button);
	$laporan_form->addElement("Jenis Obat", $jenis_input_group);
	$tanggal_from_text = new Text("lpodj_tanggal_from", "lpodj_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpodj_tanggal_to", "lpodj_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lpodj.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lpodj.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lpodj_table = new Table(
		array("Obat", "Jenis Obat", "Produsen", "Jumlah", "Satuan", "Harga Satuan", "Disk. (%)", "Harga Total"),
		"",
		null,
		true
	);
	$lpodj_table->setName("lpodj");
	$lpodj_table->setAction(false);
	
	//dokter chooser:
	$dokter_table = new Table(	array("NIP", "Nama", "Jabatan")	);
	$dokter_table->setName("dokter_lpodj");
	$dokter_table->setModel(Table::$SELECT);
	$dokter_adapter = new SimpleAdapter();
	$dokter_adapter->add("NIP", "nip");
	$dokter_adapter->add("Nama", "nama");
	$dokter_adapter->add("Jabatan", "nama_jabatan");
	$dokter_service_responder = new DokterServiceResponder(
		$db, 
		$dokter_table, 
		$dokter_adapter,
		"employee"
	);
	
	//chooser jenis:
	$jenis_table = new Table(
		array("Jenis Obat"),
		"",
		null,
		true
	);
	$jenis_table->setName("jenis");
	$jenis_table->setModel(Table::$SELECT);
	$jenis_adapter = new SimpleAdapter();
	$jenis_adapter->add("Jenis Obat", "nama_jenis_obat");
	$jenis_dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
	$jenis_dbtable->setViewForSelect(true);
	$filter = "1";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT nama_jenis_obat AS 'id', nama_jenis_obat
		FROM (
			SELECT DISTINCT nama_jenis_obat
			FROM smis_ap_irja_stok_obat
			WHERE prop NOT LIKE 'del'
			ORDER BY nama_jenis_obat ASC
		) v_jenis
		WHERE " . $filter . "
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT DISTINCT nama_jenis_obat
			FROM smis_ap_irja_stok_obat
			WHERE prop NOT LIKE 'del'
			ORDER BY nama_jenis_obat ASC
		) v_jenis
		WHERE " . $filter . "
	";
	$jenis_dbtable->setPreferredQuery(true, $query_value, $query_count);
	class JenisDBResponder extends DBResponder {
		public function edit() {
			$id = $_POST['id'];
			return $id;
		}
	}
	$jenis_dbresponder = new JenisDBResponder(
		$jenis_dbtable,
		$jenis_table,
		$jenis_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("dokter_lpodj", $dokter_service_responder);
	$super_command->addResponder("jenis", $jenis_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		class LPODJAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Produsen'] = $row->produsen;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$array['Harga Satuan'] = self::format("money Rp.", $row->harga);
				$f_diskon = self::format("only-money", $row->diskon);
				$v_diskon = $row->diskon;
				if ($row->t_diskon == "nominal") {
					$v_diskon = ($row->diskon / $row->total) * 100;
					$v_diskon = round($v_diskon, 2);
					$f_diskon = self::format("only-money", $v_diskon) . "<sup>*</sup>";
				}
				$array['Disk. (%)'] = $f_diskon;
				$harga_total = $row->jumlah * $row->harga - (($v_diskon / 100) * $row->jumlah * $row->harga);
				$array['Harga Total'] = self::format("money Rp.", $harga_total);
				return $array;
			}
		}
		$lpodj_adapter = new LPODJAdapter();		
		$lpodj_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		if (isset($_POST['command']) == "list") {
			$filter = "tanggal >= '" . $_POST['tanggal_from'] . "' AND tanggal <= '" . $_POST['tanggal_to'] . "' AND id_dokter = '" . $_POST['id_dokter'] . "' AND nama_jenis_obat = '" . $_POST['jenis'] . "'";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT nama_obat, nama_jenis_obat, produsen, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
					FROM (
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0
						UNION ALL
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0
					) v_lpodp
					WHERE " . $filter . "
					GROUP BY id_obat, produsen, satuan, harga, diskon, t_diskon
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					SELECT nama_obat, nama_jenis_obat, produsen, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
					FROM (
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0
						UNION ALL
						SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
						FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0
					) v_lpodp
					WHERE " . $filter . "
					GROUP BY id_obat, produsen, satuan, harga, diskon, t_diskon
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$lpodj_dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		class LPODJDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$id_dokter = $_POST['id_dokter'];
				$nama_dokter = $_POST['nama_dokter'];
				$jenis = $_POST['jenis'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT nama_obat, nama_jenis_obat, produsen, SUM(jumlah) AS 'jumlah', satuan, harga, diskon, t_diskon
						FROM (
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
							FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0
							UNION ALL
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.id_dokter, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_stok_obat.produsen, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan', smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_resep.total
							FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0
						) v_lpodp
						WHERE tanggal >= '" . $from . "' AND tanggal <= '" . $to . "' AND id_dokter = '" . $id_dokter . "' AND nama_jenis_obat = '" . $jenis . "'
						GROUP BY id_obat, produsen, satuan, harga, diskon, t_diskon
						ORDER BY nama_obat, nama_jenis_obat ASC
					) v_laporan
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PENJUALAN PER DOKTER - JENIS OBAT Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Dokter</td>
										<td>:</td>
										<td>" . $nama_dokter . "</td>
									</tr>
									<tr>
										<td>Jenis Obat</td>
										<td>:</td>
										<td>" . $jenis . "</td>
									</tr>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Obat</th>
										<th>Jenis</th>
										<th>Produsen</th>
										<th>Jumlah</th>
										<th>Satuan</th>
										<th>Hrg. Satuan</th>
										<th>Disk. (%)</th>
										<th>Hrg. Total</th>
									</tr>";
				$total = 0;
				$no = 1;
				$is_nomdisc_exist = false;
				if (count($data) > 0) {
					foreach($data as $d) {
						$tanggal_part = explode(" ", $d->tanggal);
						$time_part = explode(":", $tanggal_part[1]);
						$f_diskon = ArrayAdapter::format("only-money", $d->diskon);
						$v_diskon = $d->diskon;
						if ($d->t_diskon == "nominal") {
							$v_diskon = ($d->diskon / $d->total) * 100;
							$v_diskon = round($v_diskon, 2);
							$f_diskon = ArrayAdapter::format("only-money", $v_diskon) . "<sup>*</sup>";
							$is_nomdisc_exist = true;
						}
						$harga_total = $d->jumlah * $d->harga - (($v_diskon / 100) * $d->jumlah * $d->harga);
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->nama_obat . "</td>
											<td>" . $d->nama_jenis_obat . "</td>
											<td>" . $d->produsen . "</td>
											<td>" . $d->jumlah . "</td>
											<td>" . $d->satuan . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $d->harga) . "</td>
											<td>" . $f_diskon . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $harga_total) . "</td>
										</tr>";
						$total += $harga_total;
					}
				} else {
					$print_data .= "<tr>
										<td colspan='9' align='center'><i>Tidak terdapat data penjualan</i></td>
									</tr>";
				}
				$print_data .= "<tr>
									<td colspan='8' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total) . "</b></td>
								</tr>";
				$print_data .= "</table>";
				if ($is_nomdisc_exist) {
					$print_data .= "<i>*) nilai asli diskon merupakan nominal (Rp.) dan telah dikonversi ke dalam persentase (%)</i></br>";
				}
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lpodj_dbresponder = new LPODJDBResponder(
			$lpodj_dbtable,
			$lpodj_table,
			$lpodj_adapter
		);
		$data = $lpodj_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lpodj_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LPODJAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPODJAction.prototype.constructor = LPODJAction;
	LPODJAction.prototype = new TableAction();
	LPODJAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lpodj_tanggal_from").val();
		data['tanggal_to'] = $("#lpodj_tanggal_to").val();
		data['id_dokter'] = $("#lpodj_id_dokter").val();
		data['jenis'] = $("#lpodj_jenis").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LPODJAction.prototype.print = function() {
		if ($("#lpodj_tanggal_from").val() == "" || $("#lpodj_tanggal_to").val() == "" || $("#lpodj_id_dokter").val() == "" || $("#lpodj_jenis").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['id_dokter'] = $("#lpodj_id_dokter").val();
		data['nama_dokter'] = $("#lpodj_nama_dokter").val();
		data['jenis'] = $("#lpodj_jenis").val();
		data['from'] = $("#lpodj_tanggal_from").val();
		data['to'] = $("#lpodj_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	function DokterLPODJAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DokterLPODJAction.prototype.constructor = DokterLPODJAction;
	DokterLPODJAction.prototype = new TableAction();
	DokterLPODJAction.prototype.selected = function(json) {
		$("#lpodj_id_dokter").val(json.id);
		$("#lpodj_nama_dokter").val(json.nama);
	};
	
	function JenisAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	JenisAction.prototype.constructor = JenisAction;
	JenisAction.prototype = new TableAction();
	JenisAction.prototype.selected = function(json) {
		$("#lpodj_jenis").val(json);
	};
	
	var lpodj;
	var dokter_lpodj;
	var jenis;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		dokter_lpodj = new DokterLPODJAction(
			"dokter_lpodj",
			"apotek",
			"laporan_penjualan_obat_per_dokter_jenis",
			new Array()
		);
		dokter_lpodj.setSuperCommand("dokter_lpodj");
		jenis = new JenisAction(
			"jenis",
			"apotek",
			"laporan_penjualan_obat_per_dokter_jenis",
			new Array()
		);
		jenis.setSuperCommand("jenis");
		lpodj = new LPODJAction(
			"lpodj",
			"apotek",
			"laporan_penjualan_obat_per_dokter_jenis",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>