<?php 
	global $db;
	
	$laporan_form = new Form("lpnpb_form", "", "Apotek : Laporan Penjualan Obat Narkotika Per Obat");
	$id_obat_hidden = new Hidden("lpnpb_id_obat", "lpnpb_id_obat", "");
	$laporan_form->addElement("", $id_obat_hidden);
	$obat_button = new Button("", "", "Pilih");
	$obat_button->setClass("btn-info");
	$obat_button->setAction("obat_narkotika.chooser('obat_narkotika', 'obat_narkotika_button', 'obat_narkotika', obat_narkotika)");
	$obat_button->setIcon("icon-white icon-list-alt");
	$obat_button->setIsButton(Button::$ICONIC);
	$obat_button->setAtribute("id='obat_browse'");
	$obat_text = new Text("lpnpb_nama_obat", "lpnpb_nama_obat", "");
	$obat_text->setClass("smis-one-option-input");
	$obat_text->setAtribute("disabled='disabled'");
	$obat_input_group = new InputGroup("");
	$obat_input_group->addComponent($obat_text);
	$obat_input_group->addComponent($obat_button);
	$laporan_form->addElement("Nama Obat", $obat_input_group);
	$tanggal_from_text = new Text("lpnpb_tanggal_from", "lpnpb_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpnpb_tanggal_to", "lpnpb_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lpnpb.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lpnpb.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lpnpb_table = new Table(
		array("Obat", "Jenis Obat", "Jumlah", "Satuan", "Nomor Resep", "Dokter"),
		"",
		null,
		true
	);
	$lpnpb_table->setName("lpnpb");
	$lpnpb_table->setAction(false);
	
	//chooser obat narkotika:
	$obat_narkotika_table = new Table(
		array("Nama Obat", "Jenis Obat"),
		"",
		null,
		true
	);
	$obat_narkotika_table->setName("obat_narkotika");
	$obat_narkotika_table->setModel(Table::$SELECT);
	$obat_narkotika_adapter = new SimpleAdapter();
	$obat_narkotika_adapter->add("Nama Obat", "nama_obat");
	$obat_narkotika_adapter->add("Jenis Obat", "nama_jenis_obat");
	$obat_narkotika_dbtable = new DBTable($db, "smis_ap_irja_daftar_obat_narkotik");
	$obat_narkotika_dbtable->setOrder(" nama_obat, nama_jenis_obat ASC ");
	$obat_narkotika_dbtable->setViewForSelect(true);
	$obat_narkotika_dbresponder = new DBResponder(
		$obat_narkotika_dbtable,
		$obat_narkotika_table,
		$obat_narkotika_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("obat_narkotika", $obat_narkotika_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		class LPNPBAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$harga_total = $row->jumlah * $row->harga - (($v_diskon / 100) * $row->jumlah * $row->harga);
				$array['Nomor Resep'] = $row->nomor_resep;
				$array['Dokter'] = $row->nama_dokter;
				return $array;
			}
		}
		$lpnpb_adapter = new LPNPBAdapter();		
		$lpnpb_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		$filter = "id_obat = '" . $_POST['id_obat'] . "' AND tanggal >= '" . $_POST['tanggal_from'] . "' AND tanggal <= '" . $_POST['tanggal_to'] . "'";
		if (isset($_POST['kriteria'])) {
			$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%') ";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, nomor_resep, nama_dokter
				FROM (
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
					FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
					UNION ALL
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
					FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0				) v_lpt
				WHERE " . $filter . "
				GROUP BY id_obat, satuan, nomor_resep
				ORDER BY CONVERT(SUBSTRING_INDEX(nomor_resep,'.',-1),UNSIGNED INTEGER), nama_obat, nama_jenis_obat ASC
			) v_laporan
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, nomor_resep, nama_dokter
				FROM (
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
					FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
					UNION ALL
					SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
					FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
					WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0
				) v_lpt
				WHERE " . $filter . "
				GROUP BY id_obat, satuan, nomor_resep
				ORDER BY CONVERT(SUBSTRING_INDEX(nomor_resep,'.',-1),UNSIGNED INTEGER), nama_obat, nama_jenis_obat ASC
			) v_laporan
		";
		$lpnpb_dbtable->setPreferredQuery(true, $query_value, $query_count);
		class LPNDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$id_obat = $_POST['id_obat'];
				$nama_obat = $_POST['nama_obat'];
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, nomor_resep, nama_dokter
						FROM (
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_penjualan_obat_jadi.id_obat, smis_ap_irja_penjualan_obat_jadi.nama_obat, smis_ap_irja_penjualan_obat_jadi.nama_jenis_obat, smis_ap_irja_penjualan_obat_jadi.jumlah, smis_ap_irja_penjualan_obat_jadi.satuan, smis_ap_irja_penjualan_obat_jadi.harga, 'OBAT JADI' AS 'keterangan'
							FROM smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_penjualan_obat_jadi.jumlah > 0
							UNION ALL
							SELECT smis_ap_irja_penjualan_resep.id, smis_ap_irja_penjualan_resep.nomor_resep, smis_ap_irja_penjualan_resep.nama_dokter, smis_ap_irja_penjualan_resep.tanggal, smis_ap_irja_penjualan_resep.tipe, smis_ap_irja_penjualan_resep.total, smis_ap_irja_penjualan_resep.diskon, smis_ap_irja_penjualan_resep.t_diskon, smis_ap_irja_bahan_pakai_obat_racikan.id_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_obat, smis_ap_irja_bahan_pakai_obat_racikan.nama_jenis_obat, smis_ap_irja_bahan_pakai_obat_racikan.jumlah, smis_ap_irja_bahan_pakai_obat_racikan.satuan, smis_ap_irja_bahan_pakai_obat_racikan.harga, CONCAT('BAHAN RACIKAN ', smis_ap_irja_penjualan_obat_racikan.nama) AS 'keterangan'
							FROM (smis_ap_irja_penjualan_resep LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_penjualan_resep.id = smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_penjualan_obat_racikan.id = smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan
							WHERE smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_bahan_pakai_obat_racikan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_bahan_pakai_obat_racikan.jumlah > 0
						) v_lpt
						WHERE id_obat = '" . $id_obat . "' AND tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
						GROUP BY id_obat, satuan, nomor_resep
						ORDER BY CONVERT(SUBSTRING_INDEX(nomor_resep,'.',-1),UNSIGNED INTEGER), nama_obat, nama_jenis_obat ASC
					) v_laporan
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PENJUALAN OBAT NARKOTIKA (" . ArrayAdapter::format("unslug", $nama_obat) . ") Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Obat</td>
										<td>:</td>
										<td>" . $nama_obat . "</td>
									</tr>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Obat</th>
										<th>Jenis</th>
										<th>Jumlah</th>
										<th>Nomor Resep</th>
										<th>Dokter</th>
									</tr>";
				$no = 1;
				if (count($data) > 0) {
					foreach($data as $d) {
						$tanggal_part = explode(" ", $d->tanggal);
						$time_part = explode(":", $tanggal_part[1]);
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->nama_obat . "</td>
											<td>" . $d->nama_jenis_obat . "</td>
											<td>" . $d->jumlah . " " . $d->satuan . "</td>
											<td>" . $d->nomor_resep . "</td>
											<td>" . $d->nama_dokter . "</td>
										</tr>";
					}
				} else {
					$print_data .= "<tr>
										<td colspan='6' align='center'><i>Tidak terdapat data penjualan</i></td>
									</tr>";
				}
				$print_data .= "</table>";
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lpnpb_dbresponder = new LPNDBResponder(
			$lpnpb_dbtable,
			$lpnpb_table,
			$lpnpb_adapter
		);
		$data = $lpnpb_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lpnpb_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LPNAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPNAction.prototype.constructor = LPNAction;
	LPNAction.prototype = new TableAction();
	LPNAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['id_obat'] = $("#lpnpb_id_obat").val();
		data['tanggal_from'] = $("#lpnpb_tanggal_from").val();
		data['tanggal_to'] = $("#lpnpb_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LPNAction.prototype.print = function() {
		if ($("#lpnpb_id_obat").val() == "" || $("#lpnpb_tanggal_from").val() == "" || $("#lpnpb_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['id_obat'] = $("#lpnpb_id_obat").val();
		data['nama_obat'] = $("#lpnpb_nama_obat").val();
		data['from'] = $("#lpnpb_tanggal_from").val();
		data['to'] = $("#lpnpb_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	function ObatNarkotikaAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	ObatNarkotikaAction.prototype.constructor = ObatNarkotikaAction;
	ObatNarkotikaAction.prototype = new TableAction();
	ObatNarkotikaAction.prototype.selected = function(json) {
		$("#lpnpb_id_obat").val(json.id_obat);
		$("#lpnpb_nama_obat").val(json.nama_obat);
	};
	
	var lpnpb;
	var obat_narkotika;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
		obat_narkotika = new ObatNarkotikaAction(
			"obat_narkotika",
			"apotek",
			"laporan_penjualan_obat_narkotika_per_obat",
			new Array()
		);
		obat_narkotika.setSuperCommand("obat_narkotika");
		lpnpb = new LPNAction(
			"lpnpb",
			"apotek",
			"laporan_penjualan_obat_narkotika_per_obat",
			new Array()
		)
	});
</script>