<?php 
	global $db;
	
	$laporan_form = new Form("lpa_form", "", "Apotek : Laporan Pendapatan");
	$tanggal_from_text = new Text("lpa_tanggal_from", "lpa_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpa_tanggal_to", "lpa_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lpa.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lpa.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	if (isset($_POST['command'])) {
		$lpa_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		class LPADBResponder extends DBResponder {
			public function command($command) {
				$pack = new ResponsePackage();
				if ($command == "view_rekap") {
					$content = $this->view_rekap();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				} else if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT COUNT(*) AS 'jumlah', SUM(total) AS 'total', tipe
					FROM smis_ap_irja_penjualan_resep
					WHERE prop NOT LIKE 'del' AND dibatalkan = '0' AND tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
					GROUP BY tipe
					UNION ALL
					SELECT COUNT(*) AS 'jumlah', (-1) * SUM((smis_ap_irja_dretur_penjualan_resep.subtotal * smis_ap_irja_retur_penjualan_resep.persentase_retur) / 100) AS 'total', 'retur' AS 'tipe'
					FROM smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_dretur_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id = smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep
					WHERE smis_ap_irja_retur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_retur_penjualan_resep.dibatalkan = '0' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_retur_penjualan_resep.tanggal >= '" . $from . "' AND smis_ap_irja_retur_penjualan_resep.tanggal <= '" . $to . "'
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PENDAPATAN Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table width='100%' border='1'>
									<tr>
										<th colspan='2'>Pendapatan</th>
									</tr>";
				$total = 0;
				foreach($data as $d) {
					$print_data .= "<tr>
									   <td>" . ArrayAdapter::format("unslug", $d->tipe) . "</td>
									   <td>" . ArrayAdapter::format("money Rp.", $d->total) . "</td>
								    </tr>";
					if ($d->tipe != "retur") {
						$info_detail .= "<tr>
										     <td>JUMLAH PENJUALAN " . ArrayAdapter::format("unslug", $d->tipe) . "</td>
										     <td>" . ArrayAdapter::format("number", $d->jumlah) . "</td>
									     </tr>";
						$jumlah_resep += $d->jumlah;
					} else
						$jumlah_retur = $d->jumlah;
					$total += $d->total;
				}
				$info_detail .= "<tr class='info'>
									 <td><strong>TOTAL PENJUALAN</strong></td>
									 <td><strong>" . ArrayAdapter::format("number", $jumlah_resep) . "</strong></td>
								 </tr>";
				$info_detail .= "<tr class='info'>
									 <td><strong>TOTAL RETUR</strong></td>
									 <td><strong>" . ArrayAdapter::format("number", $jumlah_retur) . "<strong></td>
								 </tr>";
				$print_data .= "<tr class='info'>
								   <td><strong>TOTAL</strong></td>
								   <td><strong>" . ArrayAdapter::format("money Rp.", $total) . "</strong></td>
							    </tr>";
				$print_data .= "</table><br/>";
				$print_data .= "<table width='100%' border='1'>";
				$print_data .= "<tr>
									<th colspan='2'>Lain-Lain</th>
								</tr>";
				$print_data .= $info_detail;
				$print_data .= "</table><br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
			
			public function view_rekap() {
				$from = $_POST['tanggal_from'];
				$to = $_POST['tanggal_to'];
				$data = $this->dbtable->get_result("
					SELECT COUNT(*) AS 'jumlah', SUM(total) AS 'total', tipe
					FROM smis_ap_irja_penjualan_resep
					WHERE prop NOT LIKE 'del' AND dibatalkan = '0' AND tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
					GROUP BY tipe
					UNION ALL
					SELECT COUNT(*) AS 'jumlah', (-1) * SUM((smis_ap_irja_dretur_penjualan_resep.subtotal * smis_ap_irja_retur_penjualan_resep.persentase_retur) / 100) AS 'total', 'retur' AS 'tipe'
					FROM smis_ap_irja_retur_penjualan_resep LEFT JOIN smis_ap_irja_dretur_penjualan_resep ON smis_ap_irja_retur_penjualan_resep.id = smis_ap_irja_dretur_penjualan_resep.id_retur_penjualan_resep
					WHERE smis_ap_irja_retur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_retur_penjualan_resep.dibatalkan = '0' AND smis_ap_irja_dretur_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_retur_penjualan_resep.tanggal >= '" . $from . "' AND smis_ap_irja_retur_penjualan_resep.tanggal <= '" . $to . "'
				");
				$pendapatan_header = "<tr class='inverse lpa_header_normal'>
										  <th colspan='2'>Pendapatan</th>
									  </tr>";
 				$info_header = "<tr class='inverse lpa_header_normal'>
								   <th colspan='2'>Lain-Lain</th>
							    </tr>";
				$pendapatan_detail = "";
				$info_detail = "";
				$total = 0;
				$jumlah_resep = 0;
				$jumlah_retur = 0;
				foreach($data as $d) {
					$pendapatan_detail .= "<tr>
											   <td>" . ArrayAdapter::format("unslug", $d->tipe) . "</td>
											   <td>" . ArrayAdapter::format("money Rp.", $d->total) . "</td>
     									   </tr>";
					if ($d->tipe != "retur") {
						$info_detail .= "<tr>
										     <td>JUMLAH PENJUALAN " . ArrayAdapter::format("unslug", $d->tipe) . "</td>
										     <td>" . ArrayAdapter::format("number", $d->jumlah) . "</td>
									     </tr>";
						$jumlah_resep += $d->jumlah;
					} else
						$jumlah_retur = $d->jumlah;
					$total += $d->total;
				}
				$info_detail .= "<tr class='info'>
									 <td><strong>TOTAL PENJUALAN</strong></td>
									 <td><strong>" . ArrayAdapter::format("number", $jumlah_resep) . "</strong></td>
								 </tr>";
				$info_detail .= "<tr class='info'>
									 <td><strong>TOTAL RETUR</strong></td>
									 <td><strong>" . ArrayAdapter::format("number", $jumlah_retur) . "<strong></td>
								 </tr>";
				$pendapatan_footer = "<tr class='info'>
										  <td><strong>TOTAL</strong></td>
										  <td><strong>" . ArrayAdapter::format("money Rp.", $total) . "</strong></td>
								      </tr>";
				$json['pendapatan_header'] = $pendapatan_header;
				$json['pendapatan_detail'] = $pendapatan_detail;
				$json['pendapatan_footer'] = $pendapatan_footer;
				$json['info_header'] = $info_header;
				$json['info_detail'] = $info_detail;
				return $json;
			}
		}
		$lpa_dbresponder = new LPADBResponder(
			$lpa_dbtable,
			new Table(array(), ""),
			new SimpleAdapter()
		);
		$data = $lpa_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
		echo "<table id='pendapatan_table' class='table table-bordered table-striped table-condensed'>" . 
			      "<caption></caption>" .
				  "<thead id='pendapatan_header'></thead>" .
				  "<tbody id='pendapatan_list'></tbody>" .
				  "<tbody id='pendapatan_footer'></tbody>" .
			 "</table>";
	echo "</div>";
	echo "<div id='table_content'>";
		echo "<table id='info_table' class='table table-bordered table-striped table-condensed'>" . 
			      "<caption></caption>" .
				  "<thead id='info_header'></thead>" .
				  "<tbody id='info_list'></tbody>" .
			 "</table>";
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LPAAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPAAction.prototype.constructor = LPAAction;
	LPAAction.prototype = new TableAction();
	LPAAction.prototype.view = function() {
		if ($("#lpa_tanggal_from").val() == "" || $("#lpa_tanggal_to").val() == "")
			return;
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "view_rekap";
		data['tanggal_from'] = $("#lpa_tanggal_from").val();
		data['tanggal_to'] = $("#lpa_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#pendapatan_header").html(json.pendapatan_header);
				$("#pendapatan_list").html(json.pendapatan_detail);
				$("#pendapatan_footer").html(json.pendapatan_footer);
				$("#info_header").html(json.info_header);
				$("#info_list").html(json.info_detail);
				dismissLoading();
			}
		);
	};
	LPAAction.prototype.print = function() {
		if ($("#lpa_tanggal_from").val() == "" || $("#lpa_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['from'] = $("#lpa_tanggal_from").val();
		data['to'] = $("#lpa_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	var lpa;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		lpa = new LPAAction(
			"lpa",
			"apotek",
			"laporan_pendapatan",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>