<?php 
	global $db;
	
	$laporan_form = new Form("lospt_form", "", "Apotek : Laporan Pembelian Sito Per Rentang Waktu");
	$tanggal_from_text = new Text("lospt_tanggal_from", "lospt_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lospt_tanggal_to", "lospt_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lospt.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lospt.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lospt_table = new Table(
		array("Obat", "Jenis Obat", "Jumlah", "Satuan", "Harga Satuan", "Subtotal"),
		"",
		null,
		true
	);
	$lospt_table->setName("lospt");
	$lospt_table->setAction(false);
	
	if (isset($_POST['command'])) {
		class LOSPTAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$array['Harga Satuan'] = self::format("money Rp.", $row->hna);
				$harga_total = $row->jumlah * $row->hna;
				$array['Subtotal'] = self::format("money Rp.", $harga_total);
				return $array;
			}
		}
		$lospt_adapter = new LOSPTAdapter();		
		$lospt_dbtable = new DBTable($db, "smis_ap_irja_obat_sito_masuk");
		if (isset($_POST['command']) == "list") {
			$filter = "tanggal >= '" . $_POST['tanggal_from'] . "' AND tanggal <= '" . $_POST['tanggal_to'] . "'";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, hna
					FROM (
						SELECT smis_ap_irja_obat_sito_masuk.tanggal, smis_ap_irja_stok_obat.*
						FROM smis_ap_irja_obat_sito_masuk, smis_ap_irja_stok_obat
						WHERE smis_ap_irja_obat_sito_masuk.prop NOT LIKE 'del' AND smis_ap_irja_obat_sito_masuk.dibatalkan = 0 AND (-1) * smis_ap_irja_obat_sito_masuk.id = smis_ap_irja_stok_obat.id_vendor
					) v_lospt
					WHERE " . $filter . "
					GROUP BY id_obat, satuan, hna
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, hna
					FROM (
						SELECT smis_ap_irja_obat_sito_masuk.tanggal, smis_ap_irja_stok_obat.*
						FROM smis_ap_irja_obat_sito_masuk, smis_ap_irja_stok_obat
						WHERE smis_ap_irja_obat_sito_masuk.prop NOT LIKE 'del' AND smis_ap_irja_obat_sito_masuk.dibatalkan = 0 AND (-1) * smis_ap_irja_obat_sito_masuk.id = smis_ap_irja_stok_obat.id_vendor
					) v_lospt
					WHERE " . $filter . "
					GROUP BY id_obat, satuan, hna
					ORDER BY nama_obat, nama_jenis_obat ASC
				) v_laporan
			";
			$lospt_dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		class LOSPTDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, hna
						FROM (
							SELECT smis_ap_irja_obat_sito_masuk.tanggal, smis_ap_irja_stok_obat.*
							FROM smis_ap_irja_obat_sito_masuk, smis_ap_irja_stok_obat
							WHERE smis_ap_irja_obat_sito_masuk.prop NOT LIKE 'del' AND smis_ap_irja_obat_sito_masuk.dibatalkan = 0 AND (-1) * smis_ap_irja_obat_sito_masuk.id = smis_ap_irja_stok_obat.id_vendor
						) v_lospt
						WHERE tanggal >= '" . $from . "' AND tanggal <= '" . $to . "'
						GROUP BY id_obat, satuan, hna
						ORDER BY nama_obat, nama_jenis_obat ASC
					) v_laporan
				");
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN PEMBELIAN SITO PER RENTANG WAKTU Apotek</strong></center><br/>";
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Obat</th>
										<th>Jenis</th>
										<th>Jumlah</th>
										<th>Hrg. Satuan</th>
										<th>Total</th>
									</tr>";
				$total = 0;
				$no = 1;
				if (count($data) > 0) {
					foreach($data as $d) {
						$tanggal_part = explode(" ", $d->tanggal);
						$time_part = explode(":", $tanggal_part[1]);
						$harga_total = $d->jumlah * $d->hna;
						$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->nama_obat . "</td>
											<td>" . $d->nama_jenis_obat . "</td>
											<td>" . $d->jumlah . " " . $d->satuan . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $d->hna) . "</td>
											<td>" . ArrayAdapter::format("money Rp.", $harga_total) . "</td>
										</tr>";
						$total += ($harga_total);
					}
				} else {
					$print_data .= "<tr>
										<td colspan='6' align='center'><i>Tidak terdapat data pembelian sito</i></td>
									</tr>";
				}
				$print_data .= "<tr>
									<td colspan='5' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("money Rp.", $total) . "</b></td>
								</tr>";
				$print_data .= "</table>";
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$lospt_dbresponder = new LOSPTDBResponder(
			$lospt_dbtable,
			$lospt_table,
			$lospt_adapter
		);
		$data = $lospt_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lospt_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function LOSPTAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LOSPTAction.prototype.constructor = LOSPTAction;
	LOSPTAction.prototype = new TableAction();
	LOSPTAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lospt_tanggal_from").val();
		data['tanggal_to'] = $("#lospt_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LOSPTAction.prototype.print = function() {
		if ($("#lospt_tanggal_from").val() == "" || $("#lospt_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['from'] = $("#lospt_tanggal_from").val();
		data['to'] = $("#lospt_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	var lospt;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		lospt = new LOSPTAction(
			"lospt",
			"apotek",
			"laporan_pembelian_obat_sito",
			new Array()
		)
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
	});
</script>