<?php 
	global $db;
	
	$form = new Form("llpo_form", "", "Apotek : Laporan Laju Penjualan Obat");
	$tanggal_from_text = new Text("llpo_tanggal_from", "llpo_tanggal_from", "");
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("llpo_tanggal_to", "llpo_tanggal_to", "");
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("llpo.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("llpo.print()");
	$export_button = new Button("", "", "Eksport XLS");
	$export_button->setClass("btn-info");
	$export_button->setIcon("fa fa-download");
	$export_button->setIsButton(Button::$ICONIC);
	$export_button->setAction("llpo.export_xls()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$btn_group->addButton($export_button);
	$form->addElement("", $btn_group);
	
	$llpo_table = new Table(
		array("ID Obat", "Nama Obat", "Jenis Obat", "Jumlah", "Satuan", "Produsen", "Distributor"),
		"",
		null,
		true
	);
	$llpo_table->setName("llpo");
	$llpo_table->setAction(false);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$tanggal_from = $_POST['from'];
			$tanggal_to = $_POST['to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("apotek/templates/template_laju_penjualan_obat.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("LAJU PENJUALAN");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "APOTEK " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "PERIODE : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));
			$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
			$data = $dbtable->get_result("
				SELECT *
				FROM (
					SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, produsen, vendor
					FROM (
						SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
						FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_stok_pakai_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $tanggal_from . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $tanggal_to . "'
						UNION ALL
						SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi,  smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
						FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
						WHERE smis_ap_irja_stok_pakai_bahan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $tanggal_from . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $tanggal_to . "'
					) v_llpo
					GROUP BY id_obat, nama_obat, nama_jenis_obat, satuan, konversi, satuan_konversi, produsen, vendor
				) v_llpo
				ORDER BY jumlah DESC
			");
			if (count($data) - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, count($data) - 2);
			$start_row_num = 7;
			$end_row_num = 7;
			$row_num = $start_row_num;
			$nomor = 1;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $nomor++);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id_obat);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_obat);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->satuan);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->produsen);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->vendor);
				$objWorksheet->getStyle("E" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$row_num++;
				$end_row_num++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=LAJU_PENJUALAN_apotek_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		class LLPOAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = "";
				$array['ID Obat'] = ArrayAdapter::format("digit6", $row->id_obat);
				$array['Nama Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$array['Produsen'] = $row->produsen;
				$array['Vendor'] = $row->vendor;
				return $array;
			}
		}
		$llpo_adapter = new LLPOAdapter();		
		$llpo_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		$filter = "1";
		if (isset($_POST['kriteria'])) {
			$filter .= " AND (id_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%' OR produsen LIKE '%" . $_POST['kriteria'] . "%' OR vendor LIKE '%" . $_POST['kriteria'] . "%') ";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, produsen, vendor
				FROM (
					SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
					FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_stok_pakai_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['to'] . "'
					UNION ALL
					SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi,  smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
					FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
					WHERE smis_ap_irja_stok_pakai_bahan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $_POST['from'] . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $_POST['to'] . "'
				) v_llpo
				GROUP BY id_obat, nama_obat, nama_jenis_obat, satuan, konversi, satuan_konversi, produsen, vendor
			) v_llpo
			WHERE " . $filter . "
			ORDER BY jumlah DESC
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				" . $query_value . "
			) v_llpo
		";
		$llpo_dbtable->setPreferredQuery(true, $query_value, $query_count);
		class LLPODBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan") {
					return parent::command($command);
				}
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$from = $_POST['from'];
				$to = $_POST['to'];
				$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT id_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan, produsen, vendor
						FROM (
							SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_obat_jadi.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
							FROM ((smis_ap_irja_stok_pakai_obat_jadi LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_obat_jadi.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_penjualan_obat_jadi ON smis_ap_irja_stok_pakai_obat_jadi.id_penjualan_obat_jadi = smis_ap_irja_penjualan_obat_jadi.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_jadi.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
							WHERE smis_ap_irja_stok_pakai_obat_jadi.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_obat_jadi.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $from . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $to . "'
							UNION ALL
							SELECT smis_ap_irja_stok_obat.id_obat, smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, smis_ap_irja_stok_pakai_bahan.jumlah, smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi,  smis_ap_irja_stok_obat.produsen, smis_ap_irja_stok_obat.nama_vendor AS 'vendor'
							FROM (((smis_ap_irja_stok_pakai_bahan LEFT JOIN smis_ap_irja_stok_obat ON smis_ap_irja_stok_pakai_bahan.id_stok_obat = smis_ap_irja_stok_obat.id) LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan ON smis_ap_irja_stok_pakai_bahan.id_bahan = smis_ap_irja_bahan_pakai_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_obat_racikan ON smis_ap_irja_bahan_pakai_obat_racikan.id_penjualan_obat_racikan = smis_ap_irja_penjualan_obat_racikan.id) LEFT JOIN smis_ap_irja_penjualan_resep ON smis_ap_irja_penjualan_obat_racikan.id_penjualan_resep = smis_ap_irja_penjualan_resep.id
							WHERE smis_ap_irja_stok_pakai_bahan.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.prop NOT LIKE 'del' AND smis_ap_irja_penjualan_resep.dibatalkan = 0 AND smis_ap_irja_stok_pakai_bahan.jumlah > 0 AND smis_ap_irja_penjualan_resep.tanggal >= '" . $from . "' AND smis_ap_irja_penjualan_resep.tanggal <= '" . $to . "'
						) v_llpo
						GROUP BY id_obat, nama_obat, nama_jenis_obat, satuan, konversi, satuan_konversi, produsen, vendor
					) v_llpo
					ORDER BY jumlah DESC
				");
				$from_part = explode(" ", $from);
				$to_part = explode(" ", $to);
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN LAJU PENJUALAN OBAT APOTEK</strong></center><br/>";
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $from_part[0]) . ", " . $from_part[1] . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $to_part[0]) . ", " . $to_part[1] . "</td>
									</tr>
								</table>";
				$print_data .= "<table border='1'>
									<tr>
										<th>ID Obat</th>
										<th>Nama Obat</th>
										<th>Jenis Obat</th>
										<th>Jumlah</th>
										<th>Satuan</th>
										<th>Produsen</th>
										<th>Vendor</th>
									</tr>";
				if (count($data) > 0) {
					foreach($data as $d) {
						$print_data .= "<tr>
											<td>" . ArrayAdapter::format("digit6", $d->id_obat) . "</td>
											<td>" . $d->nama_obat . "</td>
											<td>" . $d->nama_jenis_obat . "</td>
											<td>" . $d->jumlah . "</td>
											<td>" . $d->satuan . "</td>
											<td>" . $d->produsen . "</td>
											<td>" . $d->vendor . "</td>
										</tr>";
					}
				} else {
					$print_data .= "<tr>
										<td colspan='7' align='center'><i>Tidak terdapat data laju penjualan</i></td>
									</tr>";
				}
				$print_data .= "</table><br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		$llpo_dbresponder = new LLPODBResponder(
			$llpo_dbtable,
			$llpo_table,
			$llpo_adapter
		);
		$data = $llpo_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $form->getHtml();
	echo $llpo_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function LLPOAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LLPOAction.prototype.constructor = LLPOAction;
	LLPOAction.prototype = new TableAction();
	LLPOAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['from'] = $("#llpo_tanggal_from").val();
		data['to'] = $("#llpo_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LLPOAction.prototype.print = function() {
		if ($("#llpo_tanggal_from").val() == "" || $("#llpo_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['from'] = $("#llpo_tanggal_from").val();
		data['to'] = $("#llpo_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	LLPOAction.prototype.export_xls = function() {
		if ($("#llpo_tanggal_from").val() == "" || $("#llpo_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['from'] = $("#llpo_tanggal_from").val();
		data['to'] = $("#llpo_tanggal_to").val();
		postForm(data);
	};
	
	var llpo;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		llpo = new LLPOAction(
			"llpo",
			"apotek",
			"laporan_laju_penjualan_obat",
			new Array()
		)
	});
</script>