<?php
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");

	$form = new Form("", "", "Apotek : Laporan Bagi Hasil Resep");
	$tanggal_from_text = new Text("bhr_tanggal_from", "bhr_tanggal_from", date("Y-m-d 00:00"));
	$tanggal_from_text->setClass("mydatetime");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("bhr_tanggal_to", "bhr_tanggal_to", date("Y-m-d H:i"));
	$tanggal_to_text->setClass("mydatetime");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd hh:ii'");
	$form->addElement("Waktu Akhir", $tanggal_to_text);
	$consumer_service = new ServiceConsumer(
		$db, 
		"get_jenis_patient",
		null,
		"registration" 
	);
	$content = $consumer_service->execute()->getContent();
	$jenis_pasien_option = new OptionBuilder();
	$jenis_pasien_option->add("Semua", "%%", 1);
	foreach($content as $c){
		$jenis_pasien_option->add($c['name'], $c['value']);
	}
	$jenis_pasien_select = new Select("bhr_jenis_pasien", "bhr_jenis_pasien", $jenis_pasien_option->getContent());
	$form->addElement("Jenis Pasien", $jenis_pasien_select);
	$ruangan_option = new OptionBuilder();
	$ruangan_option->add("Semua", "%%", 1);
	$ruangan_dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
	$ruangan_rows = $ruangan_dbtable->get_result("
		SELECT DISTINCT ruangan
		FROM smis_ap_irja_penjualan_resep
		WHERE prop NOT LIKE 'del'
	");
	if ($ruangan_rows != null) {
		foreach ($ruangan_rows as $rr)
			if ($rr->ruangan != "")
				$ruangan_option->add(ArrayAdapter::format("unslug", $rr->ruangan), $rr->ruangan);
			else
				$ruangan_option->add("TANPA RUANGAN", $rr->ruangan);
	}
	$ruangan_select = new Select("bhr_ruangan", "bhr_ruangan", $ruangan_option->getContent());
	$form->addElement("Ruangan", $ruangan_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("bhr.view()");
	$download_button = new Button("", "", "Eksport XLS");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='bhr_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$form->addElement("", $btn_group);

	$table = new Table(
		array("No.", "Tanggal", "ID Transaksi", "Jenis Transaksi", "Lokasi", "Ruangan", "No. Resep", "Dokter", "Total", "Laba", "Jasa Farmasi", "Jasa Dokter", "Jasa Paramedis", "Jasa Direksi", "Jasa Kolektif"),
		"",
		null,
		true
	);
	$table->setName("bhr");
	$table->setAction(false);
	$table->setFooterVisible(false);

	if (isset($_POST['command'])) {
		$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
		if ($_POST['command'] == "get_jumlah") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$ruangan = $_POST['ruangan'];
			$row = $dbtable->get_row("
				SELECT COUNT(*) AS 'jumlah'
				FROM smis_ap_irja_penjualan_resep
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND dibatalkan = '0' AND prop NOT LIKE 'del' AND dibatalkan = '0' AND jenis LIKE '" . $jenis_pasien . "' AND ruangan LIKE '" . $ruangan . "'
			");
			$data = array(
				"jumlah"	=> $row->jumlah
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$ruangan = $_POST['ruangan'];
			$num = $_POST['num'];
			$is_first_row = true;
			$row = $dbtable->get_row("
				SELECT *
				FROM smis_ap_irja_penjualan_resep
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND dibatalkan = '0' AND prop NOT LIKE 'del' AND dibatalkan = '0' AND jenis LIKE '" . $jenis_pasien . "' AND ruangan LIKE '" . $ruangan . "'
				LIMIT " . $num . ", 1
			");
			$total_tagihan = $row->total;
			$html = "";
			$total = $_POST['total'];
			$total_profit = $_POST['total_profit'];
			$total_jasa_farmasi = $_POST['total_jasa_farmasi'];
			$total_jasa_dokter = $_POST['total_jasa_dokter'];
			$total_jasa_paramedis = $_POST['total_jasa_paramedis'];
			$total_jasa_direksi = $_POST['total_jasa_direksi'];
			$total_jasa_kolektif = $_POST['total_jasa_kolektif'];
			if ($row != null) {
				$total_local = 0;
				$profit_local = 0;
				$jasa_farmasi_local = 0;
				$jasa_dokter_local = 0;
				$jasa_paramedis_local = 0;
				$jasa_direksi_local = 0;
				$jasa_kolektif_local = 0;
				// obat jadi :
				$obat_jadi_rows = $dbtable->get_result("
					SELECT *
					FROM smis_ap_irja_penjualan_obat_jadi
					WHERE id_penjualan_resep = '" . $row->id . "' AND prop NOT LIKE 'del'
				");
				if ($obat_jadi_rows != null) {
					foreach ($obat_jadi_rows as $obat_jadi_row) {
						$diskon = $row->diskon;
						$t_diskon = $row->t_diskon;
						if ($t_diskon == "nominal") {
							$diskon = $obat_jadi_row->harga / $total_tagihan * $diskon;
						} else {
							$diskon = $obat_jadi_row->harga * $diskon / 100;
						}
						$subtotal = ($obat_jadi_row->harga - $diskon) * $obat_jadi_row->jumlah;
						$profit = $subtotal - $subtotal / 1.2;
						$jaspel = 0.4 * $profit;
						$rs = 0.6 * $profit;
						$jasa_fungsional = 0.7 * $jaspel;
						$jasa_administrasi = 0.3 * $jaspel;
						$jasa_farmasi = 0.5 * $jasa_fungsional;
						$jasa_dokter = 0.3 * $jasa_fungsional;
						$jasa_perawat = 0.2 * $jasa_fungsional;
						$jasa_direksi = 0.2 * $jasa_administrasi;
						$jasa_kolektif = 0.8 * $jasa_administrasi;
						$total += $subtotal;
						$total_local += $subtotal;
						$total_profit += $profit;
						$profit_local += $profit;
						$total_jasa_farmasi += $jasa_farmasi;
						$jasa_farmasi_local += $jasa_farmasi;
						$total_jasa_dokter += $jasa_dokter;
						$jasa_dokter_local += $jasa_dokter;
						$total_jasa_paramedis += $jasa_perawat;
						$jasa_paramedis_local += $jasa_perawat;
						$total_jasa_direksi += $jasa_direksi;
						$jasa_direksi_local += $jasa_direksi;
						$total_jasa_kolektif += $jasa_kolektif;
						$jasa_kolektif_local += $jasa_kolektif;
					}
				}
				// bahan racikan :
				$bahan_racikan_rows = $dbtable->get_result("
					SELECT b.*
					FROM smis_ap_irja_penjualan_obat_racikan a LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan b ON a.id = b.id_penjualan_obat_racikan
					WHERE a.id_penjualan_resep = '" . $row->id . "' AND a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del'
				");
				if ($bahan_racikan_rows != null) {
					foreach ($bahan_racikan_rows as $bahan_racikan_row) {
						$diskon = $row->diskon;
						$t_diskon = $row->t_diskon;
						if ($t_diskon == "nominal") {
							$diskon = $bahan_racikan_row->harga / $total_tagihan * $diskon;
						} else {
							$diskon = $bahan_racikan_row->harga * $diskon / 100;
						}
						$subtotal = ($bahan_racikan_row->harga - $diskon) * $bahan_racikan_row->jumlah;
						$profit = $subtotal - $subtotal / 1.2;
						$jaspel = 0.4 * $profit;
						$rs = 0.6 * $profit;
						$jasa_fungsional = 0.7 * $jaspel;
						$jasa_administrasi = 0.3 * $jaspel;
						$jasa_farmasi = 0.5 * $jasa_fungsional;
						$jasa_dokter = 0.3 * $jasa_fungsional;
						$jasa_perawat = 0.2 * $jasa_fungsional;
						$jasa_direksi = 0.2 * $jasa_administrasi;
						$jasa_kolektif = 0.8 * $jasa_administrasi;
						$total += $subtotal;
						$total_local += $subtotal;
						$total_profit += $profit;
						$profit_local += $profit;
						$total_jasa_farmasi += $jasa_farmasi;
						$jasa_farmasi_local += $jasa_farmasi;
						$total_jasa_dokter += $jasa_dokter;
						$jasa_dokter_local += $jasa_dokter;
						$total_jasa_paramedis += $jasa_perawat;
						$total_jasa_paramedis += $jasa_perawat;
						$total_jasa_direksi += $jasa_direksi;
						$jasa_direksi_local += $jasa_direksi;
						$total_jasa_kolektif += $jasa_kolektif;
						$jasa_kolektif_local += $jasa_kolektif;
					}
				}
				$html = "
					<tr>
						<td id='bhr_nomor'></td>
						<td id='bhr_tanggal'><small>" . ArrayAdapter::format("date d-m-Y, H:i", $row->tanggal) . "</small></td>
						<td id='bhr_id'><small>" . ArrayAdapter::format("only-digit6", $row->id) . "</small></td>
						<td id='bhr_jenis'><small>PENJUALAN</small></td>
						<td id='bhr_lokasi'><small>DEPO FARMASI IRJA</small></td>
						<td id='bhr_ruangan'><small>" . ArrayAdapter::format("unslug", $row->ruangan) . "</small></td>
						<td id='bhr_no_resep'><small>" . $row->nomor_resep . "</small></td>
						<td id='bhr_nama_dokter'><small>" . strtoupper($row->nama_dokter) . "</small></td>
						<td id='bhr_subtotal' style='display: none;'>" . $total_local . "</td>
						<td id='bhr_f_subtotal'><small>" . ArrayAdapter::format("money", $total_local) . "</small></td>
						<td id='bhr_profit' style='display: none;'>" . $profit_local . "</td>
						<td id='bhr_f_profit'><small>" . ArrayAdapter::format("money", $profit_local) . "</small></td>
						<td id='bhr_jasa_farmasi' style='display: none;'>" . $jasa_farmasi_local . "</td>
						<td id='bhr_f_jasa_farmasi'><small>" . ArrayAdapter::format("money", $jasa_farmasi_local) . "</small></td>
						<td id='bhr_jasa_dokter' style='display: none;'>" . $jasa_dokter_local . "</td>
						<td id='bhr_f_jasa_dokter'><small>" . ArrayAdapter::format("money", $jasa_dokter_local) . "</small></td>
						<td id='bhr_jasa_paramedis' style='display: none;'>" . $jasa_paramedis_local . "</td>
						<td id='bhr_f_jasa_paramedis'><small>" . ArrayAdapter::format("money", $jasa_paramedis_local) . "</small></td>
						<td id='bhr_jasa_direksi' style='display: none;'>" . $jasa_direksi_local . "</td>
						<td id='bhr_f_jasa_direksi'><small>" . ArrayAdapter::format("money", $jasa_direksi_local) . "</small></td>
						<td id='bhr_jasa_kolektif' style='display: none;'>" . $jasa_kolektif_local . "</td>
						<td id='bhr_f_jasa_kolektif'>" . ArrayAdapter::format("money", $jasa_kolektif_local) . "</td>
					</tr>
				";
			}
			$data = array(
				"nomor_transaksi"		=> ArrayAdapter::format("only-digit8", $row->id),
				"nomor_resep"			=> $row->nomor_resep,
				"nama_pasien"			=> strtoupper($row->nama_pasien),
				"nama_dokter"			=> strtoupper($row->nama_dokter),
				"total"					=> $total,
				"total_profit"			=> $total_profit,
				"t_jaspel_farmasi"		=> $total_jasa_farmasi,
				"t_jaspel_dokter"		=> $total_jasa_dokter,
				"t_jaspel_paramedis"	=> $total_jasa_paramedis,
				"t_jaspel_direksi"		=> $total_jasa_direksi,
				"t_jaspel_kolektif"		=> $total_jasa_kolektif,
				"html"					=> $html
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_jumlah_retur") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$ruangan = $_POST['ruangan'];
			$row = $dbtable->get_row("
				SELECT COUNT(a.id) AS 'jumlah'
				FROM smis_ap_irja_retur_penjualan_resep a LEFT JOIN smis_ap_irja_penjualan_resep b ON a.id_penjualan_resep = b.id
				WHERE a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.dibatalkan = '0' AND a.prop NOT LIKE 'del' AND b.jenis LIKE '" . $jenis_pasien . "' AND b.ruangan LIKE '" . $ruangan . "'
			");
			$data = array(
				"jumlah"	=> $row->jumlah
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_retur") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_pasien = $_POST['jenis_pasien'];
			$ruangan = $_POST['ruangan'];
			$num = $_POST['num'];
			$is_first_row = true;
			$row = $dbtable->get_row("
				SELECT a.id AS 'id_retur', a.tanggal AS 'tanggal_retur', a.persentase_retur, b.*
				FROM smis_ap_irja_retur_penjualan_resep a LEFT JOIN smis_ap_irja_penjualan_resep b ON a.id_penjualan_resep = b.id
				WHERE a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.dibatalkan = '0' AND a.prop NOT LIKE 'del' AND b.jenis LIKE '" . $jenis_pasien . "' AND b.ruangan LIKE '" . $ruangan . "'
				LIMIT " . $num . ", 1
			");
			$total_tagihan = $row->total;
			$html = "";
			$total = $_POST['total'];
			$total_profit = $_POST['total_profit'];
			$total_jasa_farmasi = $_POST['total_jasa_farmasi'];
			$total_jasa_dokter = $_POST['total_jasa_dokter'];
			$total_jasa_paramedis = $_POST['total_jasa_paramedis'];
			$total_jasa_direksi = $_POST['total_jasa_direksi'];
			$total_jasa_kolektif = $_POST['total_jasa_kolektif'];
			if ($row != null) {
				$total_local = 0;
				$profit_local = 0;
				$jasa_farmasi_local = 0;
				$jasa_dokter_local = 0;
				$jasa_paramedis_local = 0;
				$jasa_direksi_local = 0;
				$jasa_kolektif_local = 0;
				// detail retur :
				$obat_jadi_rows = $dbtable->get_result("
					SELECT b.id_obat, b.nama_obat, a.*
					FROM smis_ap_irja_dretur_penjualan_resep a LEFT JOIN smis_ap_irja_stok_obat b ON a.id_stok_obat = b.id
					WHERE a.id_retur_penjualan_resep = '" . $row->id_retur . "' AND a.prop NOT LIKE 'del'
				");
				if ($obat_jadi_rows != null) {
					foreach ($obat_jadi_rows as $obat_jadi_row) {
						$diskon = $row->diskon;
						$t_diskon = $row->t_diskon;
						if ($t_diskon == "nominal") {
							$diskon = $obat_jadi_row->harga / $total_tagihan * $diskon;
						} else {
							$diskon = $obat_jadi_row->harga * $diskon / 100;
						}
						$subtotal = ($obat_jadi_row->harga - $diskon) * $obat_jadi_row->jumlah * $row->persentase_retur / 100 * (-1);
						$profit = $subtotal - $subtotal / 1.2;
						$jaspel = 0.4 * $profit;
						$rs = 0.6 * $profit;
						$jasa_fungsional = 0.7 * $jaspel;
						$jasa_administrasi = 0.3 * $jaspel;
						$jasa_farmasi = 0.5 * $jasa_fungsional;
						$jasa_dokter = 0.3 * $jasa_fungsional;
						$jasa_perawat = 0.2 * $jasa_fungsional;
						$jasa_direksi = 0.2 * $jasa_administrasi;
						$jasa_kolektif = 0.8 * $jasa_administrasi;
						$total += $subtotal;
						$total_local += $subtotal;
						$total_profit += $profit;
						$profit_local += $profit;
						$total_jasa_farmasi += $jasa_farmasi;
						$jasa_farmasi_local += $jasa_farmasi;
						$total_jasa_dokter += $jasa_dokter;
						$jasa_dokter_local += $jasa_dokter;
						$total_jasa_paramedis += $jasa_perawat;
						$jasa_paramedis_local += $jasa_perawat;
						$total_jasa_direksi += $jasa_direksi;
						$jasa_direksi_local += $jasa_direksi;
						$total_jasa_kolektif += $jasa_kolektif;
						$jasa_kolektif_local += $jasa_kolektif;
					}
				}
				$html = "
					<tr>
						<td id='bhr_nomor'></td>
						<td id='bhr_tanggal'><small>" . ArrayAdapter::format("date d-m-Y, H:i", $row->tanggal_retur) . "</small></td>
						<td id='bhr_id'><small>" . ArrayAdapter::format("only-digit6", $row->id_retur) . "</small></td>
						<td id='bhr_jenis'><small>RETUR</small></td>
						<td id='bhr_lokasi'><small>DEPO FARMASI IRJA</small></td>
						<td id='bhr_ruangan'><small>" . ArrayAdapter::format("unslug", $row->ruangan) . "</small></td>
						<td id='bhr_no_resep'><small>" . $row->nomor_resep . "</small></td>
						<td id='bhr_nama_dokter'><small>" . strtoupper($row->nama_dokter) . "</small></td>
						<td id='bhr_subtotal' style='display: none;'>" . $total_local . "</td>
						<td id='bhr_f_subtotal'><small>" . ArrayAdapter::format("money", $total_local) . "</small></td>
						<td id='bhr_profit' style='display: none;'>" . $profit_local . "</td>
						<td id='bhr_f_profit'><small>" . ArrayAdapter::format("money", $profit_local) . "</small></td>
						<td id='bhr_jasa_farmasi' style='display: none;'>" . $jasa_farmasi_local . "</td>
						<td id='bhr_f_jasa_farmasi'><small>" . ArrayAdapter::format("money", $jasa_farmasi_local) . "</small></td>
						<td id='bhr_jasa_dokter' style='display: none;'>" . $jasa_dokter_local . "</td>
						<td id='bhr_f_jasa_dokter'><small>" . ArrayAdapter::format("money", $jasa_dokter_local) . "</small></td>
						<td id='bhr_jasa_paramedis' style='display: none;'>" . $jasa_paramedis_local . "</td>
						<td id='bhr_f_jasa_paramedis'><small>" . ArrayAdapter::format("money", $jasa_paramedis_local) . "</small></td>
						<td id='bhr_jasa_direksi' style='display: none;'>" . $jasa_direksi_local . "</td>
						<td id='bhr_f_jasa_direksi'><small>" . ArrayAdapter::format("money", $jasa_direksi_local) . "</small></td>
						<td id='bhr_jasa_kolektif' style='display: none;'>" . $jasa_kolektif_local . "</td>
						<td id='bhr_f_jasa_kolektif'><small>" . ArrayAdapter::format("money", $jasa_kolektif_local) . "</small></td>
					</tr>
				";
			}
			$data = array(
				"nomor_transaksi"		=> ArrayAdapter::format("only-digit8", $row->id_retur),
				"nomor_resep"			=> $row->nomor_resep,
				"nama_pasien"			=> strtoupper($row->nama_pasien),
				"nama_dokter"			=> strtoupper($row->nama_dokter),
				"total"					=> $total,
				"total_profit"			=> $total_profit,
				"t_jaspel_farmasi"		=> $total_jasa_farmasi,
				"t_jaspel_dokter"		=> $total_jasa_dokter,
				"t_jaspel_paramedis"	=> $total_jasa_paramedis,
				"t_jaspel_direksi"		=> $total_jasa_direksi,
				"t_jaspel_kolektif"		=> $total_jasa_kolektif,
				"html"					=> $html
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			ini_set("memory_limit", "1024M");
			set_time_limit(0);
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$ruangan = $_POST['ruangan'];
			if ($ruangan == "")
				$ruangan = "TANPA RUANGAN";
			else if ($ruangan == "%%")
				$ruangan = "SEMUA";
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("apotek/templates/template_bagi_hasil_resep.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("BAGI HASIL RESEP");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("APOTEK " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "PERIODE : " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y, H:i", $tanggal_to));
			$objWorksheet->setCellValue("B4", "RUANGAN : " . ArrayAdapter::format("unslug", $ruangan));
			$data = json_decode($_POST['d_data']);
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(9, $_POST['num_rows'] - 2);
			$start_row_num = 8;
			$end_row_num = 8;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->tanggal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jenis);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->lokasi);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->ruangan);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->no_resep);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_dokter);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->subtotal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->profit);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jasa_farmasi);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jasa_dokter);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jasa_paramedis);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jasa_direksi);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jasa_kolektif);
				$objWorksheet->getStyle("J" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("K" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("L" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("M" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("N" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("O" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("P" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			ob_end_clean();
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=BAGI_HASIL_RESEP_DEPO_IRJA_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd_Hi", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}
	$loading_bar = new LoadingBar("bhr_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("bhr.cancel()");
	$loading_modal = new Modal("bhr_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $form->getHtml();
	echo "<div id='table_content'>";
	echo $table->getHtml();
	echo "</div>";
	echo "<div id='bhr_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function BHRAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	BHRAction.prototype.constructor = BHRAction;
	BHRAction.prototype = new TableAction();
	BHRAction.prototype.getRegulerData = function() {
		var data = TableAction.prototype.getRegulerData.call(this);
		data['tanggal_from'] = $("#bhr_tanggal_from").val();
		data['tanggal_to'] = $("#bhr_tanggal_to").val();
		data['jenis_pasien'] = $("#bhr_jenis_pasien").val();
		data['ruangan'] = $("#bhr_ruangan").val();
		return data;
	};
	BHRAction.prototype.view = function() {
		if ($("#bhr_tanggal_from").val() == "" || $("#bhr_tanggal_to").val() == "")
			return;
		var self = this;
		FINISHED = false;
		$("#bhr_info").empty();
		$("#table_bhr tfoot").remove();
		$("#bhr_list").empty();
		$("#bhr_loading_bar").sload("true", "LOADING TRANSAKSI PENJUALAN RESEP..", 0);
		$("#bhr_loading_modal").smodal("show");
		var data = this.getRegulerData();
		data['command'] = "get_jumlah";
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				self.fillHtml(0, 0, 0, 0, 0, 0, 0, 0, json.jumlah);
			}
		);
	};
	BHRAction.prototype.fillHtml = function(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif, num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.view_retur(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif);
			} else {
				$("#bhr_loading_modal").smodal("hide");
				$("#bhr_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#bhr_export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info";
		data['num'] = num;
		data['total'] = total;
		data['total_profit'] = total_profit;
		data['total_jasa_farmasi'] = total_jasa_farmasi;
		data['total_jasa_dokter'] = total_jasa_dokter;
		data['total_jasa_paramedis'] = total_jasa_paramedis;
		data['total_jasa_direksi'] = total_jasa_direksi;
		data['total_jasa_kolektif'] = total_jasa_kolektif;
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("tbody#bhr_list").append(
					json.html
				);
				$("#bhr_loading_bar").sload("true", "PENJUALAN : " + json.nomor_transaksi + " - " + json.nomor_resep + " - " + json.nama_dokter + " - " + json.nama_pasien + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtml(json.total, json.total_profit, json.t_jaspel_farmasi, json.t_jaspel_dokter, json.t_jaspel_paramedis, json.t_jaspel_direksi, json.t_jaspel_kolektif, num + 1, limit);
			}
		);
	};
	BHRAction.prototype.view_retur = function(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif) {
		var self = this;
		$("#bhr_loading_bar").sload("true", "LOADING TRANSAKSI RETUR PENJUALAN RESEP..", 0);
		var data = this.getRegulerData();
		data['command'] = "get_jumlah_retur";
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				self.fillHtmlRetur(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif, 0, json.jumlah);
			}
		);
	}
	BHRAction.prototype.fillHtmlRetur = function(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif, num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif);
			} else {
				$("#bhr_loading_modal").smodal("hide");
				$("#bhr_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#bhr_export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info_retur";
		data['num'] = num;
		data['total'] = total;
		data['total_profit'] = total_profit;
		data['total_jasa_farmasi'] = total_jasa_farmasi;
		data['total_jasa_dokter'] = total_jasa_dokter;
		data['total_jasa_paramedis'] = total_jasa_paramedis;
		data['total_jasa_direksi'] = total_jasa_direksi;
		data['total_jasa_kolektif'] = total_jasa_kolektif;
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				console.log(json);
				$("tbody#bhr_list").append(
					json.html
				);
				$("#bhr_loading_bar").sload("true", "RETUR : " + json.nomor_transaksi + " - " + json.nomor_resep + " - " + json.nama_dokter + " - " + json.nama_pasien + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtmlRetur(json.total, json.total_profit, json.t_jaspel_farmasi, json.t_jaspel_dokter, json.t_jaspel_paramedis, json.t_jaspel_direksi, json.t_jaspel_kolektif, num + 1, limit);
			}
		);
	};
	BHRAction.prototype.finalize = function(total, total_profit, total_jasa_farmasi, total_jasa_dokter, total_jasa_paramedis, total_jasa_direksi, total_jasa_kolektif) {
		var num_rows = $("#bhr_list tr").length;
		for (var i = 0; i < num_rows; i++)
			$("#bhr_list tr:eq(" + i + ") td#bhr_nomor").html("<small>" + (i + 1) + "</small>");
		$("#bhr_list").append(
			"<tr>" +
				"<td colspan='8'><center><strong><small>T O T A L</small></strong></center></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_profit).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_jasa_farmasi).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_jasa_dokter).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_jasa_paramedis).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_jasa_direksi).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
				"<td><div align='right'><strong><small>" + parseFloat(total_jasa_kolektif).formatMoney("2", ".", ",") + "</small></strong></div></td>" +
			"</tr>"
		);
		$("#bhr_loading_modal").smodal("hide");
		$("#bhr_info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#bhr_export_button").removeAttr("onclick");
		$("#bhr_export_button").attr("onclick", "bhr.export_xls()");
	};
	BHRAction.prototype.cancel = function() {
		FINISHED = true;
	};
	BHRAction.prototype.export_xls = function() {
		showLoading();
		var num_rows = $("#bhr_list").children("tr").length - 1;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_nomor").text();
			var tanggal = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_tanggal").text();
			var id = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_id").text();
			var jenis = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jenis").text();
			var lokasi = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_lokasi").text();
			var ruangan = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_ruangan").text();
			var no_resep = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_no_resep").text();
			var nama_dokter = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_nama_dokter").text();
			var subtotal = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_subtotal").text();
			var profit = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_profit").text();
			var jasa_farmasi = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jasa_farmasi").text();
			var jasa_dokter = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jasa_dokter").text();
			var jasa_paramedis = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jasa_paramedis").text();
			var jasa_direksi = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jasa_direksi").text();
			var jasa_kolektif = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_jasa_kolektif").text();

			var subtotal = $("tbody#bhr_list tr:eq(" + i + ") td#bhr_subtotal").text();
			d_data[i] = {
				"nomor" 		: nomor,
				"tanggal" 		: tanggal,
				"id" 			: id,
				"jenis"			: jenis,
				"lokasi" 		: lokasi,
				"ruangan"		: ruangan,
				"no_resep"		: no_resep,
				"nama_dokter"	: nama_dokter,
				"subtotal"		: subtotal,
				"profit"		: profit,
				"jasa_farmasi"	: jasa_farmasi,
				"jasa_dokter"	: jasa_dokter,
				"jasa_paramedis": jasa_paramedis,
				"jasa_direksi"	: jasa_direksi,
				"jasa_kolektif"	: jasa_kolektif
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#bhr_tanggal_from").val();
		data['tanggal_to'] = $("#bhr_tanggal_to").val();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		postForm(data);
		dismissLoading();
	};

	var bhr;
	var FINISHED;
	$(document).ready(function() {
		$('.mydatetime').datetimepicker({ 
			minuteStep: 1
		});
		bhr = new BHRAction(
			"bhr",
			"apotek",
			"laporan_bagi_hasil_resep",
			new Array()
		);
		$("#bhr_list").append(
			"<tr id='temp'>" +
				"<td colspan='16'><strong><small><center>DATA BAGI HASIL RESEP BELUM DIPROSES</center></small></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>