<?php
	global $db;
	
	$laporan_form = new Form("lan_form", "", "Apotek : Laporan Antal");
	$tanggal_from_text = new Text("lan_tanggal_from", "lan_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lan_tanggal_to", "lan_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lan.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("icon-white icon-print");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAction("lan.print()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lan_table = new Table(
		array("No.", "Tanggal", "Jml. Resep PTP Aktif", "Jml. Item PTP Aktif", "Jml. Resep Pens. PTP", "Jml. Item Pens. PTP", "Jml. Resep Non-PTP", "Jml. Item Non-PTP", "Jml. Resep Umum", "Jml. Item Umum", "Jml. Resep BPJS", "Jml. Item BPJS"),
		"",
		null,
		true
	);
	$lan_table->setName("lan");
	$lan_table->setAction(false);
	$lan_table->setHeaderVisible(false);
	$lan_table->addHeader("after", "
		<tr class='inverse'>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center>No.</center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center>Tanggal</center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center>PTP Aktif</center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center>Pens. PTP</center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center>Non-PTP</center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center>Umum</center>
			</th>
			<th colspan='2' style='vertical-align: middle !important;'>
				<center>BPJS</center>
			</th></th>
		</tr>
		<tr class='inverse'>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Resep</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Item</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Resep</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Item</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Resep</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Item</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Resep</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Item</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Resep</center>
			</th>
			<th colspan='1' style='vertical-align: middle !important;'>
				<center>Jml. Item</center>
			</th>
		</tr>
	");
	
	if (isset($_POST['command'])) {
		$lan_adapter = new SummaryAdapter(true, "No.");
		$lan_adapter->addFixValue("Tanggal", "<strong>Total</strong>");
		$lan_adapter->addSummary("Jml. Resep PTP Aktif", "jml_resep_ptpaktif","number");
		$lan_adapter->addSummary("Jml. Item PTP Aktif", "jml_item_ptpaktif","number");
		$lan_adapter->addSummary("Jml. Resep Pens. PTP", "jml_resep_pensptp","number");
		$lan_adapter->addSummary("Jml. Item Pens. PTP", "jml_item_pensptp","number");
		$lan_adapter->addSummary("Jml. Resep Non-PTP", "jml_resep_nonptp","number");
		$lan_adapter->addSummary("Jml. Item Non-PTP", "jml_item_nonptp","number");
		$lan_adapter->addSummary("Jml. Resep Umum", "jml_resep_umum","number");
		$lan_adapter->addSummary("Jml. Item Umum", "jml_item_umum","number");
		$lan_adapter->addSummary("Jml. Resep BPJS", "jml_resep_bpjs","number");
		$lan_adapter->addSummary("Jml. Item BPJS", "jml_item_bpjs","number");
		$lan_adapter->add("Tanggal", "tanggal", "date d-m-Y");
		$lan_adapter->add("Jml. Resep PTP Aktif", "jml_resep_ptpaktif", "number");
		$lan_adapter->add("Jml. Item PTP Aktif", "jml_item_ptpaktif", "number");
		$lan_adapter->add("Jml. Resep Pens. PTP", "jml_resep_pensptp", "number");
		$lan_adapter->add("Jml. Item Pens. PTP", "jml_item_pensptp", "number");
		$lan_adapter->add("Jml. Resep Non-PTP", "jml_resep_nonptp", "number");
		$lan_adapter->add("Jml. Item Non-PTP", "jml_item_nonptp", "number");
		$lan_adapter->add("Jml. Resep Umum", "jml_resep_umum", "number");
		$lan_adapter->add("Jml. Item Umum", "jml_item_umum", "number");
		$lan_adapter->add("Jml. Resep BPJS", "jml_resep_bpjs", "number");
		$lan_adapter->add("Jml. Item BPJS", "jml_item_bpjs", "number");
		$lan_dbtable = new DBTable(
			$db,
			"smis_ap_irja_penjualan_resep"
		);
				
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = "WHERE tanggal LIKE '%" . $_POST['kriteria'] . "%'";
		}
		
		$query_value = "
			SELECT tanggal, 
				sum(resep_ptpaktif) AS jml_resep_ptpaktif, 
				sum(item_ptpaktif) AS jml_item_ptpaktif, 
				sum(resep_pensptp) AS jml_resep_pensptp, 
				sum(item_pensptp) AS jml_item_pensptp, 
				sum(resep_umum) AS jml_resep_umum, 
				sum(item_umum) AS jml_item_umum, 
				sum(resep_rekanan) AS jml_resep_nonptp, 
				sum(item_rekanan) AS jml_item_nonptp, 
				sum(resep_bpjs) AS jml_resep_bpjs, 
				sum(item_bpjs) AS jml_item_bpjs
			FROM (
				SELECT jenis, tanggal,
					IF(jenis='ptpnaktif', COUNT(DISTINCT id), 0) AS resep_ptpaktif, 
					IF(jenis='ptpnaktif', COUNT(DISTINCT obat), 0) AS item_ptpaktif,
					IF(jenis='pensiunan_ptpn', COUNT(DISTINCT id), 0) AS resep_pensptp, 
					IF(jenis='pensiunan_ptpn', COUNT(DISTINCT obat), 0) AS item_pensptp,
					IF(jenis='umum',COUNT(DISTINCT id),0) AS resep_umum, 
					IF(jenis='umum', COUNT(DISTINCT obat), 0) AS item_umum, 
					IF(jenis='rekanan', COUNT(DISTINCT id), 0) AS resep_rekanan, 
					IF(jenis='rekanan', COUNT(DISTINCT obat), 0) AS item_rekanan, 
					IF(jenis='bpjs', COUNT(DISTINCT id), 0) AS resep_bpjs, 
					IF(jenis='bpjs', COUNT(DISTINCT obat), 0) AS item_bpjs
				FROM (
					SELECT r.id, r.jenis, DATE(r.tanggal) AS tanggal, oj.id_obat AS obat
					FROM smis_ap_irja_penjualan_resep r
						LEFT JOIN smis_ap_irja_penjualan_obat_jadi oj ON r.id = oj.id_penjualan_resep	
					WHERE r.prop != 'del' AND oj.prop != 'del' AND r.dibatalkan = 0
					UNION
					SELECT r.id, r.jenis, DATE(r.tanggal), bpor.id_obat
					FROM smis_ap_irja_penjualan_resep r
						LEFT JOIN smis_ap_irja_penjualan_obat_racikan por ON r.id = por.id_penjualan_resep
						LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan bpor ON por.id = bpor.id_penjualan_obat_racikan
					WHERE r.prop != 'del' AND por.prop != 'del' AND r.dibatalkan = 0
				) AS temp1
				WHERE tanggal BETWEEN '". $_POST['tanggal_from'] ."' AND '". $_POST['tanggal_to'] ."'
				GROUP BY tanggal, jenis
			) AS temp2 "
			. $filter .
			" GROUP BY tanggal";
		$query_count = "SELECT COUNT(*) FROM (" . $query_value . ") t";
		
		$lan_dbtable->setPreferredQuery(true, $query_value, $query_count);
		
		class LANDBResponder extends DBResponder {
			public function command($command) {
				if ($command != "print_laporan")
					return parent::command($command);
				$pack = new ResponsePackage();
				if ($command == "print_laporan") {
					$content = $this->print_report();
					$pack->setContent($content);
					$pack->setStatus(ResponsePackage::$STATUS_OK);
				}
				return $pack->getPackage();
			}
			public function print_report() {
				$nama_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_title", "");
				$alamat_entitas = getSettings($this->dbtable->get_db(), "smis_autonomous_address", "");
				$query_value = "
					SELECT tanggal, 
						sum(resep_ptpaktif) AS jml_resep_ptpaktif, 
						sum(item_ptpaktif) AS jml_item_ptpaktif, 
						sum(resep_pensptp) AS jml_resep_pensptp, 
						sum(item_pensptp) AS jml_item_pensptp, 
						sum(resep_umum) AS jml_resep_umum, 
						sum(item_umum) AS jml_item_umum, 
						sum(resep_rekanan) AS jml_resep_nonptp, 
						sum(item_rekanan) AS jml_item_nonptp, 
						sum(resep_bpjs) AS jml_resep_bpjs, 
						sum(item_bpjs) AS jml_item_bpjs
					FROM (
						SELECT jenis, tanggal,
							IF(jenis='ptpnaktif', COUNT(DISTINCT id), 0) AS resep_ptpaktif, 
							IF(jenis='ptpnaktif', COUNT(DISTINCT obat), 0) AS item_ptpaktif,
							IF(jenis='pensiunan_ptpn', COUNT(DISTINCT id), 0) AS resep_pensptp, 
							IF(jenis='pensiunan_ptpn', COUNT(DISTINCT obat), 0) AS item_pensptp,
							IF(jenis='umum',COUNT(DISTINCT id),0) AS resep_umum, 
							IF(jenis='umum', COUNT(DISTINCT obat), 0) AS item_umum, 
							IF(jenis='rekanan', COUNT(DISTINCT id), 0) AS resep_rekanan, 
							IF(jenis='rekanan', COUNT(DISTINCT obat), 0) AS item_rekanan, 
							IF(jenis='bpjs', COUNT(DISTINCT id), 0) AS resep_bpjs, 
							IF(jenis='bpjs', COUNT(DISTINCT obat), 0) AS item_bpjs
						FROM (
							SELECT r.id, r.jenis, DATE(r.tanggal) AS tanggal, oj.id_obat AS obat
							FROM smis_ap_irja_penjualan_resep r
								LEFT JOIN smis_ap_irja_penjualan_obat_jadi oj ON r.id = oj.id_penjualan_resep	
							WHERE r.prop != 'del' AND oj.prop != 'del' AND r.dibatalkan = 0
							UNION
							SELECT r.id, r.jenis, DATE(r.tanggal), bpor.id_obat
							FROM smis_ap_irja_penjualan_resep r
								LEFT JOIN smis_ap_irja_penjualan_obat_racikan por ON r.id = por.id_penjualan_resep
								LEFT JOIN smis_ap_irja_bahan_pakai_obat_racikan bpor ON por.id = bpor.id_penjualan_obat_racikan
							WHERE r.prop != 'del' AND por.prop != 'del' AND r.dibatalkan = 0
						) AS temp1
						WHERE tanggal BETWEEN '". $_POST['tanggal_from'] ."' AND '". $_POST['tanggal_to'] ."'
						GROUP BY tanggal, jenis
					) AS temp2 "
					. $filter .
					" GROUP BY tanggal";
				
				$data = $this->dbtable->get_result($query_value);
				
				$print_data = "";
				$print_data .= "<center><strong>LAPORAN ANTAL</strong></center><br/>";
				$print_data .= "<table border='0'>
									<tr>
										<td>Dari</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $_POST['tanggal_from']) . "</td>
									</tr>
									<tr>
										<td>Sampai</td>
										<td>:</td>
										<td>" . ArrayAdapter::format("date d M Y", $_POST['tanggal_to']) . "</td>
									</tr>
								</table><br/>";
				$print_data .= "<table border='1'>
									<tr>
										<th rowspan='2' style='vertical-align: middle !important;'>
											<center>No.</center>
										</th>
										<th rowspan='2' style='vertical-align: middle !important;'>
											<center>Tanggal</center>
										</th>
										<th colspan='2' style='vertical-align: middle !important;'>
											<center>PTP Aktif</center>
										</th>
										<th colspan='2' style='vertical-align: middle !important;'>
											<center>Pens. PTP</center>
										</th>
										<th colspan='2' style='vertical-align: middle !important;'>
											<center>Non-PTP</center>
										</th>
										<th colspan='2' style='vertical-align: middle !important;'>
											<center>Umum</center>
										</th>
										<th colspan='2' style='vertical-align: middle !important;'>
											<center>BPJS</center>
										</th></th>
									</tr>
									<tr>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Resep</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Item</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Resep</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Item</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Resep</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Item</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Resep</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Item</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Resep</center>
										</th>
										<th colspan='1' style='vertical-align: middle !important;'>
											<center>Jml. Item</center>
										</th>
									</tr>";
				$no = 1;
				$total_resep_ptp_aktif = 0;
				$total_item_ptp_aktif = 0;
				$total_resep_pens_ptp = 0;
				$total_item_pens_ptp = 0;
				$total_resep_nonptp = 0;
				$total_item_nonptp = 0;
				$total_resep_umum = 0;
				$total_item_umum = 0;
				$total_resep_bpjs = 0;
				$total_item_bpjs = 0;
				if (count($data) > 0) {
					foreach($data as $d) {
						$print_data .= "<tr>
											<td>" . ArrayAdapter::format("number", $no++) . "</td>
											<td>" . ArrayAdapter::format("date d-m-Y", $d->tanggal) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_resep_ptpaktif) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_item_ptpaktif) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_resep_pensptp) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_item_pensptp) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_resep_nonptp) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_item_nonptp) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_resep_umum) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_item_umum) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_resep_bpjs) . "</td>
											<td>" . ArrayAdapter::format("number", $d->jml_item_bpjs) . "</td>
										</tr>";
						$total_resep_ptp_aktif += ($d->jml_resep_ptpaktif);
						$total_item_ptp_aktif += ($d->jml_item_ptpaktif);
						$total_resep_pens_ptp += ($d->jml_resep_pensptp);
						$total_item_pens_ptp += ($d->jml_item_pensptp);
						$total_resep_nonptp += ($d->jml_resep_nonptp);
						$total_item_nonptp += ($d->jml_item_nonptp);
						$total_resep_umum += ($d->jml_resep_umum);
						$total_item_umum += ($d->jml_item_umum);
						$total_resep_bpjs += ($d->jml_resep_bpjs);
						$total_item_bpjs += ($d->jml_item_bpjs);
					}
				} else {
					$print_data .= "<tr>
										<td colspan='12' align='center'><i>Tidak terdapat data</i></td>
									</tr>";
				}
					$print_data .= "<tr>
										<td colspan='2' align='center'><b>T O T A L</b></td>
										<td>" . ArrayAdapter::format("number", $total_resep_ptp_aktif) . "</td>
										<td>" . ArrayAdapter::format("number", $total_item_ptp_aktif) . "</td>
										<td>" . ArrayAdapter::format("number", $total_resep_pens_ptp) . "</td>
										<td>" . ArrayAdapter::format("number", $total_item_pens_ptp) . "</td>
										<td>" . ArrayAdapter::format("number", $total_resep_nonptp) . "</td>
										<td>" . ArrayAdapter::format("number", $total_item_nonptp) . "</td>
										<td>" . ArrayAdapter::format("number", $total_resep_umum) . "</td>
										<td>" . ArrayAdapter::format("number", $total_item_umum) . "</td>
										<td>" . ArrayAdapter::format("number", $total_resep_bpjs) . "</td>
										<td>" . ArrayAdapter::format("number", $total_item_bpjs) . "</td>
									</tr>";
				$print_data .= "</table>";
				$print_data .= "<br/>";
				global $user;
				$print_data .= "<table border='0' align='center'>
									<tr>
										<td align='center'>" . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									</tr>
									<tr>
										<td align='center'>PETUGAS APOTEK</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
				return $print_data;
			}
		}
		
		$lan_dbresponder = new LANDBResponder(
			$lan_dbtable,
			$lan_table,
			$lan_adapter
		);
		$data = $lan_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lan_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LANAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LANAction.prototype.constructor = LANAction;
	LANAction.prototype = new TableAction();
	LANAction.prototype.getViewData = function() {
		var data = TableAction.prototype.getViewData.call(this);
		data['tanggal_from'] = $("#lan_tanggal_from").val();
		data['tanggal_to'] = $("#lan_tanggal_to").val();
		return data;
	};
	LANAction.prototype.print = function() {
		if ($("#lan_tanggal_from").val() == "" || $("#lan_tanggal_to").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "print_laporan";
		data['tanggal_from'] = $("#lan_tanggal_from").val();
		data['tanggal_to'] = $("#lan_tanggal_to").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};
	
	var lan;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$('.mydate').datepicker();
		lan = new LANAction(
			"lan",
			"apotek",
			"laporan_antal",
			new Array()
		);
	});
</script>
