<?php
	require_once("smis-base/smis-include-service-consumer.php");

	class DepoFarmasiInventory {
		public static function getCurrentStock($db, $id_obat, $satuan, $konversi, $satuan_konversi) {
			$dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
			$row = $dbtable->get_row("
				SELECT SUM(a.sisa) AS 'jumlah'
				FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
				WHERE b.status = 'sudah' AND a.prop NOT LIKE 'del' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "'
			");
			return $row->jumlah;
		}

		public static function getStockValue($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_to) {
			$params = array(
				"id_obat" 		=> $id_obat,
				"tanggal_to"	=> $tanggal_to
			);
			$consumer_service = new ServiceConsumer(
				$db,
				"get_last_hpp_until",
				$params,
				"gudang_farmasi"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$hpp_terakhir = 0;
			if ($content != null)
				$hpp_terakhir = $content[0];
			return $hpp_terakhir;
		}

		public static function getStockIn($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
			$jumlah = 0;
			// penerimaan mutasi:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM smis_ap_irja_stok_obat a LEFT JOIN smis_ap_irja_obat_masuk b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del'  AND b.status = 'sudah' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "'  AND b.tanggal >= '" . $tanggal_from . "' AND b.tanggal <= '" . $tanggal_to . "' AND b.id > 0
			");
			$jumlah += $row->jumlah;
			// retur penjualan resep:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(b.jumlah) IS NULL THEN 0 ELSE SUM(b.jumlah) END AS 'jumlah'
				FROM (smis_ap_irja_retur_penjualan_resep a LEFT JOIN smis_ap_irja_dretur_penjualan_resep b ON a.id = b.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat c ON b.id_stok_obat = c.id
				WHERE a.prop NOT LIKE 'del' AND a.dibatalkan = '0' AND c.id_obat = '" . $id_obat . "' AND c.satuan = '" . $satuan . "' AND c.konversi = '" . $konversi . "' AND c.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// pembatalan obat jadi:
			// $row = $dbtable->get_row("
			// 	SELECT SUM(a.jumlah) AS 'jumlah'
			// 	FROM smis_ap_irja_penjualan_obat_jadi a LEFT JOIN smis_ap_irja_penjualan_resep b ON a.id_penjualan_resep = b.id
			// 	WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.dibatalkan = '1' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND b.tanggal >= '" . $tanggal_from . " 00:00' AND b.tanggal <= '" . $tanggal_to . " 23:59'
			// ");
			// $jumlah += $row->jumlah;
			// pembatalan racikan:
			// $row = $dbtable->get_row("
			// 	SELECT SUM(a.jumlah) AS 'jumlah'
			// 	FROM (smis_ap_irja_bahan_pakai_obat_racikan a LEFT JOIN smis_ap_irja_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) LEFT JOIN smis_ap_irja_penjualan_resep c ON b.id_penjualan_resep = c.id
			// 	WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND c.dibatalkan = '1' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND c.tanggal >= '" . $tanggal_from . " 00:00' AND c.tanggal <= '" . $tanggal_to . " 23:59'
			// ");
			// $jumlah += $row->jumlah;
			// penyesuaian stok positif:
			// $penyesuaian_positif = this->getPenyesuaianStokPositif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to);
			// $jumlah += $penyesuaian_positif;
			return $jumlah;
		}

		public static function getStockOut($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
			$jumlah = 0;
			// penjualan obat jadi:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM smis_ap_irja_penjualan_obat_jadi a LEFT JOIN smis_ap_irja_penjualan_resep b ON a.id_penjualan_resep = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND b.tanggal >= '" . $tanggal_from . " 00:00' AND b.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// penjualan racikan:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM (smis_ap_irja_bahan_pakai_obat_racikan a LEFT JOIN smis_ap_irja_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) LEFT JOIN smis_ap_irja_penjualan_resep c ON b.id_penjualan_resep = c.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND c.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND c.tanggal >= '" . $tanggal_from . " 00:00' AND c.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// retur gudang:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM smis_ap_irja_retur_obat a LEFT JOIN smis_ap_irja_stok_obat b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND b.satuan = '" . $satuan . "' AND b.konversi = '" . $konversi . "' AND b.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// mutasi antar depo keluar:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(jumlah) IS NULL THEN 0 ELSE SUM(jumlah) END AS 'jumlah'
				FROM smis_ap_irja_mutasi_depo_keluar
				WHERE prop NOT LIKE 'del' AND status NOT LIKE 'dibatalkan' AND id_obat = '" . $id_obat . "' AND satuan = '" . $satuan . "' AND konversi = '" . $konversi . "' AND satuan_konversi = '" . $satuan_konversi . "' AND waktu >= '" . $tanggal_from . "' AND waktu <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// pembatalan retur penjualan resep:
			// $row = $dbtable->get_row("
			// 	SELECT SUM(b.jumlah) AS 'jumlah'
			// 	FROM (smis_ap_irja_retur_penjualan_resep a LEFT JOIN smis_ap_irja_dretur_penjualan_resep b ON a.id = b.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat c ON b.id_stok_obat = c.id
			// 	WHERE a.prop NOT LIKE 'del' AND a.dibatalkan = '1' AND c.id_obat = '" . $id_obat . "' AND c.satuan = '" . $satuan . "' AND c.konversi = '" . $konversi . "' AND c.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59'
			// ");
			// $jumlah += $row->jumlah;
			// penyesuaian stok negatif:
			// $penyesuaian_negatif = this->getPenyesuaianStokNegatif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to);
			// $jumlah += $penyesuaian_negatif;
			return $jumlah;
		}

		public static function getSoldOut($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_ap_irja_penjualan_resep");
			// penjualan obat jadi:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM smis_ap_irja_penjualan_obat_jadi a LEFT JOIN smis_ap_irja_penjualan_resep b ON a.id_penjualan_resep = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND b.tanggal >= '" . $tanggal_from . " 00:00' AND b.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// penjualan racikan:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah) IS NULL THEN 0 ELSE SUM(a.jumlah) END AS 'jumlah'
				FROM (smis_ap_irja_bahan_pakai_obat_racikan a LEFT JOIN smis_ap_irja_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) LEFT JOIN smis_ap_irja_penjualan_resep c ON b.id_penjualan_resep = c.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND c.dibatalkan = '0' AND a.id_obat = '" . $id_obat . "' AND a.satuan = '" . $satuan . "' AND a.konversi = '" . $konversi . "' AND a.satuan_konversi = '" . $satuan_konversi . "' AND c.tanggal >= '" . $tanggal_from . " 00:00' AND c.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah += $row->jumlah;
			// retur penjualan resep:
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(b.jumlah) IS NULL THEN 0 ELSE SUM(b.jumlah) END AS 'jumlah'
				FROM (smis_ap_irja_retur_penjualan_resep a LEFT JOIN smis_ap_irja_dretur_penjualan_resep b ON a.id = b.id_retur_penjualan_resep) LEFT JOIN smis_ap_irja_stok_obat c ON b.id_stok_obat = c.id
				WHERE a.prop NOT LIKE 'del' AND a.dibatalkan = '0' AND c.id_obat = '" . $id_obat . "' AND c.satuan = '" . $satuan . "' AND c.konversi = '" . $konversi . "' AND c.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . " 00:00' AND a.tanggal <= '" . $tanggal_to . " 23:59'
			");
			$jumlah -= $row->jumlah;
			return $jumlah;
		}

		public static function getPenyesuaianStokPositif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_ap_irja_penyesuaian_stok_obat");
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah_baru - a.jumlah_lama) IS NULL THEN 0 ELSE SUM(a.jumlah_baru - a.jumlah_lama) END AS 'jumlah'
				FROM smis_ap_irja_penyesuaian_stok_obat a LEFT JOIN smis_ap_irja_stok_obat b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND b.satuan = '" . $satuan . "' AND b.konversi = '" . $konversi . "' AND b.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru >= a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}

		public static function getPenyesuaianStokNegatif($db, $id_obat, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_ap_irja_penyesuaian_stok_obat");
			$row = $dbtable->get_row("
				SELECT CASE WHEN SUM(a.jumlah_lama - a.jumlah_baru) IS NULL THEN 0 ELSE SUM(a.jumlah_lama - a.jumlah_baru) END AS 'jumlah'
				FROM smis_ap_irja_penyesuaian_stok_obat a LEFT JOIN smis_ap_irja_stok_obat b ON a.id_stok_obat = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_obat = '" . $id_obat . "' AND b.satuan = '" . $satuan . "' AND b.konversi = '" . $konversi . "' AND b.satuan_konversi = '" . $satuan_konversi . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru < a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}
	}
?>