function ObatSitoMasukAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
ObatSitoMasukAction.prototype.constructor = ObatSitoMasukAction;
ObatSitoMasukAction.prototype = new TableAction();
ObatSitoMasukAction.prototype.refresh_number = function() {
	var no = 1;
	var nor_dresep = $("tbody#dobat_sito_masuk_list").children("tr").length;
	for(var i = 0; i < nor_dresep; i++) {
		var dr_prefix = $("tbody#dobat_sito_masuk_list").children("tr").eq(i).prop("id");
		$("#" + dr_prefix + "_nomor").html(no++);
	}
};
ObatSitoMasukAction.prototype.show_add_form = function() {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	$("#obat_sito_masuk_id").val("");
	$("#obat_sito_masuk_nama_vendor").val("");
	$("#obat_sito_masuk_alamat_vendor").val("");
	$("#obat_sito_masuk_keterangan").val("");
	$("#obat_sito_masuk_keterangan").removeAttr("disabled");
	$("tbody#dobat_sito_masuk_list").html("");
	row_num = 0;
	$("#obat_add").show();
	$("#obat_sito_masuk_save").show();
	$("#obat_sito_masuk_ok").hide();
	$(".error_field").removeClass("error_field");
	$("#modal_alert_obat_sito_masuk_add_form").html("");
	$("#obat_sito_masuk_add_form").smodal("show");
	$(".btn").removeAttr("disabled");
};
ObatSitoMasukAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	var nama_vendor = $("#obat_sito_masuk_nama_vendor").val();
	var alamat_vendor = $("#obat_sito_masuk_alamat_vendor").val();
	var keterangan = $("#obat_sito_masuk_keterangan").val();
	var num_rows = $("tbody#dobat_sito_masuk_list").children("tr").length;;
	$(".error_field").removeClass("error_field");
	if (nama_vendor == "") {
		valid = false;
		invalid_msg += "</br><strong>Nama Vendor</strong> tidak boleh kosong";
		$("#obat_sito_masuk_nama_vendor").addClass("error_field");
		$("#obat_sito_masuk_nama_vendor").focus();
	}
	if (alamat_vendor == "") {
		valid = false;
		invalid_msg += "</br><strong>Alamat Vendor</strong> tidak boleh kosong";
		$("#obat_sito_masuk_alamat_vendor").addClass("error_field");
		$("#obat_sito_masuk_alamat_vendor").focus();
	}
	if (keterangan == "") {
		valid = false;
		invalid_msg += "</br><strong>Keterangan</strong> tidak boleh kosong";
		$("#obat_sito_masuk_keterangan").addClass("error_field");
		$("#obat_sito_masuk_keterangan").focus();
	}
	if (num_rows == 0) {
		valid = false;
		invalid_msg += "</br><strong>Daftar Obat Sito</strong> tidak boleh kosong";
	}
	if (!valid) {
		$("#modal_alert_obat_sito_masuk_add_form").html(
			"<div class='alert alert-block alert-danger'>" +
				"<h4>Peringatan</h4>" +
				invalid_msg +
			"</div>"
		);
	}
	return valid;
};
ObatSitoMasukAction.prototype.save = function() {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	if (!this.validate()) {
		$(".btn").removeAttr("disabled");
		return;
	}
	showLoading();
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = "";
	data['nama_vendor'] = $("#obat_sito_masuk_nama_vendor").val();
	data['alamat_vendor'] = $("#obat_sito_masuk_alamat_vendor").val();
	data['keterangan'] = $("#obat_sito_masuk_keterangan").val();
	var detail = {};
	var nor =  $("tbody#dobat_sito_masuk_list").children("tr").length;
	for(var i = 0; i < nor; i++) {
		var dr_prefix = $("tbody#dobat_sito_masuk_list").children("tr").eq(i).prop("id");
		var id_obat = $("#" + dr_prefix + "_id_obat").text();
		var kode_obat = $("#" + dr_prefix + "_kode_obat").text();
		var nama_obat = $("#" + dr_prefix + "_nama_obat").text();
		var nama_jenis_obat = $("#" + dr_prefix + "_nama_jenis_obat").text();
		var formularium = $("#" + dr_prefix + "_formularium").text();
		var generik = $("#" + dr_prefix + "_generik").text();
		var berlogo = $("#" + dr_prefix + "_berlogo").text();
		var jumlah = $("#" + dr_prefix + "_jumlah").text();
		var satuan = $("#" + dr_prefix + "_satuan").text();
		var konversi = $("#" + dr_prefix + "_konversi").text();
		var satuan_konversi = $("#" + dr_prefix + "_satuan_konversi").text();
		var v_hna = parseFloat($("#" + dr_prefix + "_hna").text().replace(/[^0-9-,]/g, '').replace(",", "."));
		var produsen = $("#" + dr_prefix + "_produsen").text();
		var tanggal_exp = $("#" + dr_prefix + "_tanggal_exp").text();
		var d_data = {};
		d_data['id_obat'] = id_obat;
		d_data['kode_obat'] = kode_obat;
		d_data['formularium'] = formularium;
		d_data['generik'] = generik;
		d_data['berlogo'] = berlogo;
		d_data['nama_obat'] = nama_obat;
		d_data['nama_jenis_obat'] = nama_jenis_obat;
		d_data['hna'] = v_hna;
		d_data['jumlah'] = jumlah;
		d_data['satuan'] = satuan;
		d_data['konversi'] = konversi;
		d_data['satuan_konversi'] = satuan_konversi;
		d_data['produsen'] = produsen;
		d_data['tanggal_exp'] = tanggal_exp;
		detail[i] = d_data;
	}
	data['detail'] = detail;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);				
			if (json == null) {
				return;
			} else {
				$("#obat_sito_masuk_add_form").smodal("hide");
				self.view();
			}
			dismissLoading();
			$(".btn").removeAttr("disabled");
		}
	);
};
ObatSitoMasukAction.prototype.detail = function(id) {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) return;
			$("#obat_sito_masuk_nama_vendor").val(json.header.nama_vendor);
			$("#obat_sito_masuk_alamat_vendor").val(json.header.alamat_vendor);
			$("#obat_sito_masuk_keterangan").val(json.header.keterangan);
			$("#obat_sito_masuk_keterangan").removeAttr("disabled");
			$("#obat_sito_masuk_keterangan").attr("disabled", "disabled");
			$("tbody#dobat_sito_masuk_list").html(json.detail);
			$("#obat_add").hide();
			$("#obat_sito_masuk_save").hide();
			$("#obat_sito_masuk_ok").show();
			$(".error_field").removeClass("error_field");
			$("#modal_alert_obat_sito_masuk_add_form").html("");
			$("#obat_sito_masuk_add_form").smodal("show");
			$(".btn").removeAttr("disabled");
		}
	);
};
ObatSitoMasukAction.prototype.cancel = function(id) {
	var self = this;
	bootbox.prompt(
		"Alasan Pembataln Sito",
		function(result) {
			if (result !== null && result !== "") {
				if ($(".btn").attr("disabled") == "disabled")
					return;
				$(".btn").removeAttr("disabled");
				$(".btn").attr("disabled", "disabled");
				showLoading();
				var data = self.getRegulerData();
				data['command'] = "save";
				data['id'] = id;
				data['dibatalkan'] = 1;
				data['keterangan_batal'] = result;
				$.post(
					"",
					data,
					function(response) {
						var json = getContent(response);
						if (json == null) return;
						self.view();
						dismissLoading();
						$(".btn").removeAttr("disabled");
					}
				);
			} else if (result !== null && result == ""){
				self.cancel(id);
			}
		}
	);
};
ObatSitoMasukAction.prototype.view_cancel_info = function(id) {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	var data = this.getRegulerData();
	data['id'] = id;
	data['command'] = "edit";
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) return;
			dismissLoading();
			if (json.header.keterangan_batal != "null")
				bootbox.alert("<b>Keterangan Pembatalan</b><br/>" + json.header.keterangan_batal);
			else
				bootbox.alert("<b>Keterangan Pembatalan</b><br/>&nbsp;");
			$(".btn").removeAttr("disabled");
		}
	);
};