function DObatSitoMasukAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
DObatSitoMasukAction.prototype.constructor = DObatSitoMasukAction;
DObatSitoMasukAction.prototype = new TableAction();
DObatSitoMasukAction.prototype.show_add_form = function() {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	$("#dobat_sito_masuk_id").val("");
	$("#dobat_sito_masuk_id_obat").val("");
	$("#dobat_sito_masuk_kode_obat").val("");
	$("#dobat_sito_masuk_formularium").val("");
	$("#dobat_sito_masuk_berlogo").val("");
	$("#dobat_sito_masuk_generik").val("");
	$("#dobat_sito_masuk_nama_obat").val("");
	$("#dobat_sito_masuk_nama_jenis_obat").val("");
	$("#dobat_sito_masuk_hna").val("");
	$("#dobat_sito_masuk_jumlah").val("");
	$("#dobat_sito_masuk_satuan").val("");
	$("#dobat_sito_masuk_konversi").val("");
	$("#dobat_sito_masuk_satuan_konversi").val("");
	$("#dobat_sito_masuk_produsen").val("");
	$("#dobat_sito_masuk_tanggal_exp").val("");
	$("#dobat_sito_masuk_save").removeAttr("onclick");
	$("#dobat_sito_masuk_save").attr("onclick", "dobat_sito_masuk.save()");
	$(".error_field").removeClass("error_field");
	$("#modal_alert_dobat_sito_masuk_add_form").html("");
	$("#dobat_sito_masuk_add_form").smodal("show");
	$(".btn").removeAttr("disabled");
};
DObatSitoMasukAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	var nama_obat = $("#dobat_sito_masuk_nama_obat").val();
	var hna = $("#dobat_sito_masuk_hna").val();
	var jumlah = $("#dobat_sito_masuk_jumlah").val();
	var satuan = $("#dobat_sito_masuk_satuan").val();
	var konversi = $("#dobat_sito_masuk_konversi").val();
	var satuan_konversi = $("#dobat_sito_masuk_satuan_konversi").val();
	var produsen = $("#dobat_sito_masuk_produsen").val();
	$(".error_field").removeClass("error_field");
	if (nama_obat == "") {
		valid = false;
		invalid_msg += "</br><strong>Nama Obat</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_nama_obat").addClass("error_field");
		$("#dobat_sito_masuk_nama_obat").focus();
	}
	if (hna == "") {
		valid = false;
		invalid_msg += "</br><strong>H. Netto</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_hna").addClass("error_field");
	} else {
		var v_hna = parseFloat(hna.replace(/[^0-9-,]/g, '').replace(",", "."));
		if (v_hna == 0) {
			valid = false;
			invalid_msg += "</br><strong>Harga Satuan</strong> tidak boleh 0 (nol)";
			$("#dobat_sito_masuk_hna").addClass("error_field");
		}
	}
	if (jumlah == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_jumlah").addClass("error_field");
		$("#dobat_sito_masuk_jumlah").focus();
	} else if (!is_numeric(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9)";
		$("#dobat_sito_masuk_jumlah").addClass("error_field");
		$("#dobat_sito_masuk_jumlah").focus();
	}
	if (satuan == "") {
		valid = false;
		invalid_msg += "</br><strong>Satuan</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_satuan").addClass("error_field");
		$("#dobat_sito_masuk_satuan").focus();
	}
	if (konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_konversi").addClass("error_field");
		$("#dobat_sito_masuk_konversi").focus();
	} else if (!is_numeric(konversi)) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> seharusnya numerik (0-9)";
		$("#dobat_sito_masuk_konversi").addClass("error_field");
		$("#dobat_sito_masuk_konversi").focus();
	}
	if (satuan_konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Satuan Konversi</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_satuan_konversi").addClass("error_field");
		$("#dobat_sito_masuk_satuan_konversi").focus();
	}	
	if (produsen == "") {
		valid = false;
		invalid_msg += "</br><strong>Produsen</strong> tidak boleh kosong";
		$("#dobat_sito_masuk_produsen").addClass("error_field");
		$("#dobat_sito_masuk_produsen").focus();
	}	
	if (!valid) {
		$("#modal_alert_dobat_sito_masuk_add_form").html(
			"<div class='alert alert-block alert-danger'>" +
				"<h4>Peringatan</h4>" +
				invalid_msg +
			"</div>"
		);
	}
	return valid;
};
DObatSitoMasukAction.prototype.save = function() {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	if (!this.validate()) {
		$(".btn").removeAttr("disabled");
		return;
	}
	var id = $("#dobat_sito_masuk_id").val();
	var id_obat = $("#dobat_sito_masuk_id_obat").val();
	var kode_obat = $("#dobat_sito_masuk_kode_obat").val();
	var formularium = $("#dobat_sito_masuk_formularium").val();
	var generik = $("#dobat_sito_masuk_generik").val();
	var berlogo = $("#dobat_sito_masuk_berlogo").val();
	var nama_obat = $("#dobat_sito_masuk_nama_obat").val();
	var nama_jenis_obat = $("#dobat_sito_masuk_nama_jenis_obat").val();
	var hna = $("#dobat_sito_masuk_hna").val();
	var jumlah = $("#dobat_sito_masuk_jumlah").val();
	var satuan = $("#dobat_sito_masuk_satuan").val();
	var konversi = $("#dobat_sito_masuk_konversi").val();
	var satuan_konversi = $("#dobat_sito_masuk_satuan_konversi").val();
	var produsen = $("#dobat_sito_masuk_produsen").val();
	var tanggal_exp = $("#dobat_sito_masuk_tanggal_exp").val();
	$("tbody#dobat_sito_masuk_list").append(
		"<tr id='dobat_sito_masuk_" + row_num + "'>" +
			"<td id='dobat_sito_masuk_" + row_num + "_id' style='display: none;'>" + id + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_id_obat' style='display: none;'>" + id_obat + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_kode_obat' style='display: none;'>" + kode_obat + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_formularium' style='display: none;'>" + formularium + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_generik' style='display: none;'>" + generik + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_berlogo' style='display: none;'>" + berlogo + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_jumlah' style='display: none;'>" + jumlah + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_satuan' style='display: none;'>" + satuan + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_konversi' style='display: none;'>" + konversi + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_satuan_konversi' style='display: none;'>" + satuan_konversi + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_produsen' style='display: none;'>" + produsen + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_tanggal_exp' style='display: none;'>" + tanggal_exp + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_nomor'></td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_nama_obat'>" + nama_obat + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_nama_jenis_obat'>" + nama_jenis_obat + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_hna'>" + hna + "</td>" +
			"<td id='dobat_sito_masuk_" + row_num + "_f_jumlah'>" + jumlah + " " + satuan + "</td>" +
			"<td>" +
				"<div class='btn-group noprint'>" +
					"<a href='#' onclick='dobat_sito_masuk.edit(" + row_num + ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" + 
						"<i class='icon-edit icon-white'></i>" +
					"</a>" +
					"<a href='#' onclick='dobat_sito_masuk.delete(" + row_num + ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" + 
						"<i class='icon-remove icon-white'></i>" + 
					"</a>" +
				"</div>" +
			"</td>" +
		"</tr>"
	);
	row_num++;
	obat_sito_masuk.refresh_number();
	$("#dobat_sito_masuk_add_form").smodal("hide");
	$(".btn").removeAttr("disabled");
};
DObatSitoMasukAction.prototype.edit = function(r_num) {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	var id = $("#dobat_sito_masuk_" + r_num + "_id").text();
	var id_obat = $("#dobat_sito_masuk_" + r_num + "_id_obat").text();
	var kode_obat = $("#dobat_sito_masuk_" + r_num + "_kode_obat").text();
	var formularium = $("#dobat_sito_masuk_" + r_num + "_formularium").text();
	var berlogo = $("#dobat_sito_masuk_" + r_num + "_berlogo").text();
	var generik = $("#dobat_sito_masuk_" + r_num + "_generik").text();
	var nama_obat = $("#dobat_sito_masuk_" + r_num + "_nama_obat").text();
	var nama_jenis_obat = $("#dobat_sito_masuk_" + r_num + "_nama_jenis_obat").text();
	var hna = $("#dobat_sito_masuk_" + r_num + "_hna").text();
	var jumlah = $("#dobat_sito_masuk_" + r_num + "_jumlah").text();
	var satuan = $("#dobat_sito_masuk_" + r_num + "_satuan").text();
	var konversi = $("#dobat_sito_masuk_" + r_num + "_konversi").text();
	var satuan_konversi = $("#dobat_sito_masuk_" + r_num + "_satuan_konversi").text();
	var produsen = $("#dobat_sito_masuk_" + r_num + "_produsen").text();
	var tanggal_exp = $("#dobat_sito_masuk_" + r_num + "_tanggal_exp").text();
	$("#dobat_sito_masuk_id").val(id);
	$("#dobat_sito_masuk_id_obat").val(id_obat);
	$("#dobat_sito_masuk_kode_obat").val(kode_obat);
	$("#dobat_sito_masuk_formularium").val(formularium);
	$("#dobat_sito_masuk_generik").val(generik);
	$("#dobat_sito_masuk_berlogo").val(berlogo);
	$("#dobat_sito_masuk_nama_obat").val(nama_obat);
	$("#dobat_sito_masuk_nama_jenis_obat").val(nama_jenis_obat);
	$("#dobat_sito_masuk_hna").val(hna);
	$("#dobat_sito_masuk_jumlah").val(jumlah);
	$("#dobat_sito_masuk_satuan").val(satuan);
	$("#dobat_sito_masuk_konversi").val(konversi);
	$("#dobat_sito_masuk_satuan_konversi").val(satuan_konversi);
	$("#dobat_sito_masuk_produsen").val(produsen);
	$("#dobat_sito_masuk_tanggal_exp").val(tanggal_exp);
	$("#dobat_sito_masuk_save").removeAttr("onclick");
	$("#dobat_sito_masuk_save").attr("onclick", "dobat_sito_masuk.update(" + r_num + ")");
	$("#dobat_sito_masuk_add_form").smodal("show");
	$(".btn").removeAttr("disabled");
};
DObatSitoMasukAction.prototype.update = function(r_num) {
	if ($(".btn").attr("disabled") == "disabled")
		return;
	$(".btn").removeAttr("disabled");
	$(".btn").attr("disabled", "disabled");
	if (!this.validate()) {
		$(".btn").removeAttr("disabled");
		return;
	}
	var id_obat = $("#dobat_sito_masuk_id_obat").val();
	var kode_obat = $("#dobat_sito_masuk_kode_obat").val();
	var formularium = $("#dobat_sito_masuk_formularium").val();
	var generik = $("#dobat_sito_masuk_generik").val();
	var berlogo = $("#dobat_sito_masuk_berlogo").val();
	var nama_obat = $("#dobat_sito_masuk_nama_obat").val();
	var nama_jenis_obat = $("#dobat_sito_masuk_nama_jenis_obat").val();
	var hna = $("#dobat_sito_masuk_hna").val();
	var jumlah = $("#dobat_sito_masuk_jumlah").val();
	var satuan = $("#dobat_sito_masuk_satuan").val();
	var konversi = $("#dobat_sito_masuk_konversi").val();
	var satuan_konversi = $("#dobat_sito_masuk_satuan_konversi").val();
	var produsen = $("#dobat_sito_masuk_produsen").val();
	var tanggal_exp = $("#dobat_sito_masuk_tanggal_exp").val();
	$("#dobat_sito_masuk_" + r_num + "_id_obat").html(id_obat);
	$("#dobat_sito_masuk_" + r_num + "_kode_obat").html(kode_obat);
	$("#dobat_sito_masuk_" + r_num + "_formularium").html(formularium);
	$("#dobat_sito_masuk_" + r_num + "_generik").html(generik);
	$("#dobat_sito_masuk_" + r_num + "_berlogo").html(berlogo);
	$("#dobat_sito_masuk_" + r_num + "_nama_obat").html(nama_obat);
	$("#dobat_sito_masuk_" + r_num + "_nama_jenis_obat").html(nama_jenis_obat);
	$("#dobat_sito_masuk_" + r_num + "_hna").html(hna);
	$("#dobat_sito_masuk_" + r_num + "_jumlah").html(jumlah);
	$("#dobat_sito_masuk_" + r_num + "_satuan").html(satuan);
	$("#dobat_sito_masuk_" + r_num + "_konversi").html(konversi);
	$("#dobat_sito_masuk_" + r_num + "_satuan_konversi").html(satuan_konversi);
	$("#dobat_sito_masuk_" + r_num + "_produsen").html(produsen);
	$("#dobat_sito_masuk_" + r_num + "_tanggal_exp").html(tanggal_exp);
	$("#dobat_sito_masuk_" + r_num + "_f_jumlah").html(jumlah + " " + satuan);
	$("#dobat_sito_masuk_add_form").smodal("hide");
	$(".btn").removeAttr("disabled");
};
DObatSitoMasukAction.prototype.delete = function(r_num) {
	var id = $("#dobat_sito_masuk_" + r_num + "_id").text();
	if (id.length == 0) {
		$("#dobat_sito_masuk_" + r_num).remove();
	} else {
		$("#dobat_sito_masuk_" + r_num).attr("style", "display: none;");
		$("#dobat_sito_masuk_" + r_num).attr("class", "deleted");
	}
	obat_sito_masuk.refresh_number();
};