<?php 
	$instansi_l_table = new Table(
		array("Nomor", "Nama", "Alamat", "No. Telp.", "Margin Penjualan"),
		"Apotek : Daftar Instansi Lain",
		null,
		true
	);
	$instansi_l_table->setName("instansi_l");
	if (isset($_POST['command'])) {
		class ApotekLainAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = $row->id;
				$array['Nomor'] = self::format("digit8", $row->id);
				$array['Nama'] = $row->nama;
				$array['Alamat'] = $row->alamat;
				$array['No. Telp.'] = $row->telpon;
				$array['Margin Penjualan'] = $row->margin_jual . " %";
				return $array;
			}
		}
		$instansi_l_adapter = new ApotekLainAdapter();
		$columns = array("id", "nama", "alamat", "telpon", "margin_jual");
		$instansi_l_dbtable = new DBTable(
			$db,
			"smis_ap_irja_instansi_lain",
			$columns
		);
		$instansi_l_dbtable->setOrder(" id DESC ");
		$instansi_l_dbresponder = new DBResponder(
			$instansi_l_dbtable,
			$instansi_l_table,
			$instansi_l_adapter
		);
		$data = $instansi_l_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	$instansi_l_modal_columns = array("id", "nama", "alamat", "telpon", "margin_jual");
	$instansi_l_modal_names = array("", "Nama", "Alamat", "No. Telp.", "");
	$instansi_l_modal_values = array("", "", "", "", "20");
	$instansi_l_modal_types = array("hidden", "text", "textarea", "text", "hidden");
	$instansi_l_modal_emptiness = array("y", "n", "n", "n", "n");
	$instansi_l_table->setModal(
		$instansi_l_modal_columns,
		$instansi_l_modal_types,
		$instansi_l_modal_names,
		$instansi_l_modal_values,
		$instansi_l_modal_emptiness
	);
	$instansi_l_modal = $instansi_l_table->getModal();
	$instansi_l_modal->setTitle("Instansi Lain");
	
	echo $instansi_l_modal->getHtml();
	echo $instansi_l_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function InstansiLainAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	InstansiLainAction.prototype.constructor = InstansiLainAction;
	InstansiLainAction.prototype = new TableAction();
	InstansiLainAction.prototype.cekSave = function() {
		$(".error_field").removeClass("error_field");
		$("#modal_alert_instansi_l_add_form").html("");
		var result = TableAction.prototype.cekSave.call(this);
		var margin_jual = $("#instansi_l_margin_jual").val();
		console.log(margin_jual);
		if (!is_numeric(margin_jual)) {
			var error_statement = "<strong>Margin Jual</strong> seharunsya numerik (0-9)";
			if (result === false)
				$("#modal_alert_instansi_l_add_form div").html(
					$("#modal_alert_instansi_lain_l_add_form div").html() + "<br/>" + 
					error_statement
				);
			else {
				$("#modal_alert_instansi_l_add_form").html(
					"<div class='alert alert-block alert-info'>" +
						"<h4>Pemberitahuan</h4> <br>" +
						error_statement +
					"</div>"
				);
			}
			$("#instansi_l_margin_jual").addClass("error_field");
			result = false;
		}
		return result;
	};
	
	var instansi_l;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		var instansi_l_columns = new Array("id", "nama", "alamat", "telpon", "margin_jual");
		instansi_l = new InstansiLainAction(
			"instansi_l",
			"apotek",
			"instansi_lain",
			instansi_l_columns
		);
		instansi_l.view();
	});
</script>