<?php
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("apotek/adapter/DaftarOKTAdapter.php");
	require_once("apotek/adapter/ObatPRAdapter.php");
	
	$daftar_okt_table = new Table(
		array("Kode", "Nama Obat", "Jenis Obat"),
		"Depo Faramsi : Daftar OKT",
		null,
		true
	);
	$daftar_okt_table->setName("daftar_okt");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == 'daftar_okt') {
		if (isset($_POST['command'])) {
			$daftar_okt_adapter = new DaftarOKTAdapter();
			$daftar_okt_dbtable = new DBTable($db, "smis_ap_irja_daftar_okt");
			$daftar_okt_dbresponder = new DBResponder(
				$daftar_okt_dbtable,
				$daftar_okt_table,
				$daftar_okt_adapter
			);
			$data =  $daftar_okt_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
	}
	
	// obat chooser:
	$obat_table = new Table(array("Kode", "Obat", "Jenis"));
	$obat_table->setName("dokt_obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatPRAdapter();
	$obat_service_responder = new ServiceResponder(	$db, $obat_table, $obat_adapter, "get_daftar_barang_m");
	
	$super_command = new SuperCommand();
	$super_command->addResponder("dokt_obat", $obat_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$daftar_okt_table->addModal("id", "hidden", "", "");
	$daftar_okt_table->addModal("id_obat", "hidden", "", "");
	$daftar_okt_table->addModal("kode_obat", "hidden", "", "");
	$daftar_okt_table->addModal("nama_obat", "chooser-daftar_okt-dokt_obat", "Nama Obat", "", "", "y", true);
	$daftar_okt_table->addModal("nama_jenis_obat", "text", "Jenis Obat", "", "", "y", true);
	
	$modal = $daftar_okt_table->getModal();
	$modal->setTitle("Data OKT");
	
	echo $modal->getHtml();
	echo $daftar_okt_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function DOKTObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DOKTObatAction.prototype.constructor = DOKTObatAction;
	DOKTObatAction.prototype = new TableAction();
	DOKTObatAction.prototype.selected = function(json) {
		$("#daftar_okt_id_obat").val(json.id);
		$("#daftar_okt_kode_obat").val(json.kode);
		$("#daftar_okt_nama_obat").val(json.nama);
		$("#daftar_okt_nama_jenis_obat").val(json.nama_jenis_barang);
	};

	var daftar_okt;
	var dokt_obat;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		dokt_obat = new DOKTObatAction(
			"dokt_obat",
			"apotek",
			"daftar_okt",
			new Array()
		);
		dokt_obat.setSuperCommand("dokt_obat");
		var daftar_okt_columns = new Array("id", "id_obat", "nama_obat", "nama_jenis_obat");
		daftar_okt = new TableAction(
			"daftar_okt",
			"apotek",
			"daftar_okt",
			daftar_okt_columns
		);
		daftar_okt.setSuperCommand("daftar_okt");
		daftar_okt.view();
	});
</script>